package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.FileHash;
import odata.msgraph.client.beta.complex.MalwareState;
import odata.msgraph.client.beta.complex.SecurityVendorInformation;
import odata.msgraph.client.beta.complex.VulnerabilityState;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.CountRestrictions</b>
 * <p>
 * Countable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.FilterRestrictions</b>
 * <p>
 * Filterable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.SelectRestrictions</b>
 * <p>
 * Selectable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.SkipSupported</b>
 * <p>
 * true
 * <p>
 * <b>Org.OData.Capabilities.V1.SortRestrictions</b>
 * <p>
 * Sortable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.TopSupported</b>
 * <p>
 * true
 */@JsonPropertyOrder({
    "@odata.type", 
    "activityGroupNames", 
    "azureSubscriptionId", 
    "azureTenantId", 
    "certificateThumbprint", 
    "extensions", 
    "fileType", 
    "firstSeenDateTime", 
    "hashes", 
    "lastSeenDateTime", 
    "malwareStates", 
    "names", 
    "riskScore", 
    "size", 
    "tags", 
    "vendorInformation", 
    "vulnerabilityStates"})
@JsonInclude(Include.NON_NULL)
public class FileSecurityProfile extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.fileSecurityProfile";
    }

    @JsonProperty("activityGroupNames")
    protected List<String> activityGroupNames;

    @JsonProperty("activityGroupNames@nextLink")
    protected String activityGroupNamesNextLink;

    @JsonProperty("azureSubscriptionId")
    protected String azureSubscriptionId;

    @JsonProperty("azureTenantId")
    protected String azureTenantId;

    @JsonProperty("certificateThumbprint")
    protected String certificateThumbprint;

    @JsonProperty("extensions")
    protected List<String> extensions;

    @JsonProperty("extensions@nextLink")
    protected String extensionsNextLink;

    @JsonProperty("fileType")
    protected String fileType;

    @JsonProperty("firstSeenDateTime")
    protected OffsetDateTime firstSeenDateTime;

    @JsonProperty("hashes")
    protected List<FileHash> hashes;

    @JsonProperty("hashes@nextLink")
    protected String hashesNextLink;

    @JsonProperty("lastSeenDateTime")
    protected OffsetDateTime lastSeenDateTime;

    @JsonProperty("malwareStates")
    protected List<MalwareState> malwareStates;

    @JsonProperty("malwareStates@nextLink")
    protected String malwareStatesNextLink;

    @JsonProperty("names")
    protected List<String> names;

    @JsonProperty("names@nextLink")
    protected String namesNextLink;

    @JsonProperty("riskScore")
    protected String riskScore;

    @JsonProperty("size")
    protected Long size;

    @JsonProperty("tags")
    protected List<String> tags;

    @JsonProperty("tags@nextLink")
    protected String tagsNextLink;

    @JsonProperty("vendorInformation")
    protected SecurityVendorInformation vendorInformation;

    @JsonProperty("vulnerabilityStates")
    protected List<VulnerabilityState> vulnerabilityStates;

    @JsonProperty("vulnerabilityStates@nextLink")
    protected String vulnerabilityStatesNextLink;

    protected FileSecurityProfile() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderFileSecurityProfile() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<String> activityGroupNames;
        private String activityGroupNamesNextLink;
        private String azureSubscriptionId;
        private String azureTenantId;
        private String certificateThumbprint;
        private List<String> extensions;
        private String extensionsNextLink;
        private String fileType;
        private OffsetDateTime firstSeenDateTime;
        private List<FileHash> hashes;
        private String hashesNextLink;
        private OffsetDateTime lastSeenDateTime;
        private List<MalwareState> malwareStates;
        private String malwareStatesNextLink;
        private List<String> names;
        private String namesNextLink;
        private String riskScore;
        private Long size;
        private List<String> tags;
        private String tagsNextLink;
        private SecurityVendorInformation vendorInformation;
        private List<VulnerabilityState> vulnerabilityStates;
        private String vulnerabilityStatesNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder activityGroupNames(List<String> activityGroupNames) {
            this.activityGroupNames = activityGroupNames;
            this.changedFields = changedFields.add("activityGroupNames");
            return this;
        }

        public Builder activityGroupNames(String... activityGroupNames) {
            return activityGroupNames(Arrays.asList(activityGroupNames));
        }

        public Builder activityGroupNamesNextLink(String activityGroupNamesNextLink) {
            this.activityGroupNamesNextLink = activityGroupNamesNextLink;
            this.changedFields = changedFields.add("activityGroupNames");
            return this;
        }

        public Builder azureSubscriptionId(String azureSubscriptionId) {
            this.azureSubscriptionId = azureSubscriptionId;
            this.changedFields = changedFields.add("azureSubscriptionId");
            return this;
        }

        public Builder azureTenantId(String azureTenantId) {
            this.azureTenantId = azureTenantId;
            this.changedFields = changedFields.add("azureTenantId");
            return this;
        }

        public Builder certificateThumbprint(String certificateThumbprint) {
            this.certificateThumbprint = certificateThumbprint;
            this.changedFields = changedFields.add("certificateThumbprint");
            return this;
        }

        public Builder extensions(List<String> extensions) {
            this.extensions = extensions;
            this.changedFields = changedFields.add("extensions");
            return this;
        }

        public Builder extensions(String... extensions) {
            return extensions(Arrays.asList(extensions));
        }

        public Builder extensionsNextLink(String extensionsNextLink) {
            this.extensionsNextLink = extensionsNextLink;
            this.changedFields = changedFields.add("extensions");
            return this;
        }

        public Builder fileType(String fileType) {
            this.fileType = fileType;
            this.changedFields = changedFields.add("fileType");
            return this;
        }

        public Builder firstSeenDateTime(OffsetDateTime firstSeenDateTime) {
            this.firstSeenDateTime = firstSeenDateTime;
            this.changedFields = changedFields.add("firstSeenDateTime");
            return this;
        }

        public Builder hashes(List<FileHash> hashes) {
            this.hashes = hashes;
            this.changedFields = changedFields.add("hashes");
            return this;
        }

        public Builder hashes(FileHash... hashes) {
            return hashes(Arrays.asList(hashes));
        }

        public Builder hashesNextLink(String hashesNextLink) {
            this.hashesNextLink = hashesNextLink;
            this.changedFields = changedFields.add("hashes");
            return this;
        }

        public Builder lastSeenDateTime(OffsetDateTime lastSeenDateTime) {
            this.lastSeenDateTime = lastSeenDateTime;
            this.changedFields = changedFields.add("lastSeenDateTime");
            return this;
        }

        public Builder malwareStates(List<MalwareState> malwareStates) {
            this.malwareStates = malwareStates;
            this.changedFields = changedFields.add("malwareStates");
            return this;
        }

        public Builder malwareStates(MalwareState... malwareStates) {
            return malwareStates(Arrays.asList(malwareStates));
        }

        public Builder malwareStatesNextLink(String malwareStatesNextLink) {
            this.malwareStatesNextLink = malwareStatesNextLink;
            this.changedFields = changedFields.add("malwareStates");
            return this;
        }

        public Builder names(List<String> names) {
            this.names = names;
            this.changedFields = changedFields.add("names");
            return this;
        }

        public Builder names(String... names) {
            return names(Arrays.asList(names));
        }

        public Builder namesNextLink(String namesNextLink) {
            this.namesNextLink = namesNextLink;
            this.changedFields = changedFields.add("names");
            return this;
        }

        public Builder riskScore(String riskScore) {
            this.riskScore = riskScore;
            this.changedFields = changedFields.add("riskScore");
            return this;
        }

        public Builder size(Long size) {
            this.size = size;
            this.changedFields = changedFields.add("size");
            return this;
        }

        public Builder tags(List<String> tags) {
            this.tags = tags;
            this.changedFields = changedFields.add("tags");
            return this;
        }

        public Builder tags(String... tags) {
            return tags(Arrays.asList(tags));
        }

        public Builder tagsNextLink(String tagsNextLink) {
            this.tagsNextLink = tagsNextLink;
            this.changedFields = changedFields.add("tags");
            return this;
        }

        public Builder vendorInformation(SecurityVendorInformation vendorInformation) {
            this.vendorInformation = vendorInformation;
            this.changedFields = changedFields.add("vendorInformation");
            return this;
        }

        public Builder vulnerabilityStates(List<VulnerabilityState> vulnerabilityStates) {
            this.vulnerabilityStates = vulnerabilityStates;
            this.changedFields = changedFields.add("vulnerabilityStates");
            return this;
        }

        public Builder vulnerabilityStates(VulnerabilityState... vulnerabilityStates) {
            return vulnerabilityStates(Arrays.asList(vulnerabilityStates));
        }

        public Builder vulnerabilityStatesNextLink(String vulnerabilityStatesNextLink) {
            this.vulnerabilityStatesNextLink = vulnerabilityStatesNextLink;
            this.changedFields = changedFields.add("vulnerabilityStates");
            return this;
        }

        public FileSecurityProfile build() {
            FileSecurityProfile _x = new FileSecurityProfile();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.fileSecurityProfile";
            _x.id = id;
            _x.activityGroupNames = activityGroupNames;
            _x.activityGroupNamesNextLink = activityGroupNamesNextLink;
            _x.azureSubscriptionId = azureSubscriptionId;
            _x.azureTenantId = azureTenantId;
            _x.certificateThumbprint = certificateThumbprint;
            _x.extensions = extensions;
            _x.extensionsNextLink = extensionsNextLink;
            _x.fileType = fileType;
            _x.firstSeenDateTime = firstSeenDateTime;
            _x.hashes = hashes;
            _x.hashesNextLink = hashesNextLink;
            _x.lastSeenDateTime = lastSeenDateTime;
            _x.malwareStates = malwareStates;
            _x.malwareStatesNextLink = malwareStatesNextLink;
            _x.names = names;
            _x.namesNextLink = namesNextLink;
            _x.riskScore = riskScore;
            _x.size = size;
            _x.tags = tags;
            _x.tagsNextLink = tagsNextLink;
            _x.vendorInformation = vendorInformation;
            _x.vulnerabilityStates = vulnerabilityStates;
            _x.vulnerabilityStatesNextLink = vulnerabilityStatesNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="activityGroupNames")
    @JsonIgnore
    public CollectionPage<String> getActivityGroupNames() {
        return new CollectionPage<String>(contextPath, String.class, this.activityGroupNames, Optional.ofNullable(activityGroupNamesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public FileSecurityProfile withActivityGroupNames(List<String> activityGroupNames) {
        FileSecurityProfile _x = _copy();
        _x.changedFields = changedFields.add("activityGroupNames");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.fileSecurityProfile");
        _x.activityGroupNames = activityGroupNames;
        return _x;
    }

    @Property(name="activityGroupNames")
    @JsonIgnore
    public CollectionPage<String> getActivityGroupNames(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.activityGroupNames, Optional.ofNullable(activityGroupNamesNextLink), Collections.emptyList(), options);
    }

    @Property(name="azureSubscriptionId")
    @JsonIgnore
    public Optional<String> getAzureSubscriptionId() {
        return Optional.ofNullable(azureSubscriptionId);
    }

    public FileSecurityProfile withAzureSubscriptionId(String azureSubscriptionId) {
        FileSecurityProfile _x = _copy();
        _x.changedFields = changedFields.add("azureSubscriptionId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.fileSecurityProfile");
        _x.azureSubscriptionId = azureSubscriptionId;
        return _x;
    }

    @Property(name="azureTenantId")
    @JsonIgnore
    public Optional<String> getAzureTenantId() {
        return Optional.ofNullable(azureTenantId);
    }

    public FileSecurityProfile withAzureTenantId(String azureTenantId) {
        FileSecurityProfile _x = _copy();
        _x.changedFields = changedFields.add("azureTenantId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.fileSecurityProfile");
        _x.azureTenantId = azureTenantId;
        return _x;
    }

    @Property(name="certificateThumbprint")
    @JsonIgnore
    public Optional<String> getCertificateThumbprint() {
        return Optional.ofNullable(certificateThumbprint);
    }

    public FileSecurityProfile withCertificateThumbprint(String certificateThumbprint) {
        FileSecurityProfile _x = _copy();
        _x.changedFields = changedFields.add("certificateThumbprint");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.fileSecurityProfile");
        _x.certificateThumbprint = certificateThumbprint;
        return _x;
    }

    @Property(name="extensions")
    @JsonIgnore
    public CollectionPage<String> getExtensions() {
        return new CollectionPage<String>(contextPath, String.class, this.extensions, Optional.ofNullable(extensionsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public FileSecurityProfile withExtensions(List<String> extensions) {
        FileSecurityProfile _x = _copy();
        _x.changedFields = changedFields.add("extensions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.fileSecurityProfile");
        _x.extensions = extensions;
        return _x;
    }

    @Property(name="extensions")
    @JsonIgnore
    public CollectionPage<String> getExtensions(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.extensions, Optional.ofNullable(extensionsNextLink), Collections.emptyList(), options);
    }

    @Property(name="fileType")
    @JsonIgnore
    public Optional<String> getFileType() {
        return Optional.ofNullable(fileType);
    }

    public FileSecurityProfile withFileType(String fileType) {
        FileSecurityProfile _x = _copy();
        _x.changedFields = changedFields.add("fileType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.fileSecurityProfile");
        _x.fileType = fileType;
        return _x;
    }

    @Property(name="firstSeenDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getFirstSeenDateTime() {
        return Optional.ofNullable(firstSeenDateTime);
    }

    public FileSecurityProfile withFirstSeenDateTime(OffsetDateTime firstSeenDateTime) {
        FileSecurityProfile _x = _copy();
        _x.changedFields = changedFields.add("firstSeenDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.fileSecurityProfile");
        _x.firstSeenDateTime = firstSeenDateTime;
        return _x;
    }

    @Property(name="hashes")
    @JsonIgnore
    public CollectionPage<FileHash> getHashes() {
        return new CollectionPage<FileHash>(contextPath, FileHash.class, this.hashes, Optional.ofNullable(hashesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public FileSecurityProfile withHashes(List<FileHash> hashes) {
        FileSecurityProfile _x = _copy();
        _x.changedFields = changedFields.add("hashes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.fileSecurityProfile");
        _x.hashes = hashes;
        return _x;
    }

    @Property(name="hashes")
    @JsonIgnore
    public CollectionPage<FileHash> getHashes(HttpRequestOptions options) {
        return new CollectionPage<FileHash>(contextPath, FileHash.class, this.hashes, Optional.ofNullable(hashesNextLink), Collections.emptyList(), options);
    }

    @Property(name="lastSeenDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastSeenDateTime() {
        return Optional.ofNullable(lastSeenDateTime);
    }

    public FileSecurityProfile withLastSeenDateTime(OffsetDateTime lastSeenDateTime) {
        FileSecurityProfile _x = _copy();
        _x.changedFields = changedFields.add("lastSeenDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.fileSecurityProfile");
        _x.lastSeenDateTime = lastSeenDateTime;
        return _x;
    }

    @Property(name="malwareStates")
    @JsonIgnore
    public CollectionPage<MalwareState> getMalwareStates() {
        return new CollectionPage<MalwareState>(contextPath, MalwareState.class, this.malwareStates, Optional.ofNullable(malwareStatesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public FileSecurityProfile withMalwareStates(List<MalwareState> malwareStates) {
        FileSecurityProfile _x = _copy();
        _x.changedFields = changedFields.add("malwareStates");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.fileSecurityProfile");
        _x.malwareStates = malwareStates;
        return _x;
    }

    @Property(name="malwareStates")
    @JsonIgnore
    public CollectionPage<MalwareState> getMalwareStates(HttpRequestOptions options) {
        return new CollectionPage<MalwareState>(contextPath, MalwareState.class, this.malwareStates, Optional.ofNullable(malwareStatesNextLink), Collections.emptyList(), options);
    }

    @Property(name="names")
    @JsonIgnore
    public CollectionPage<String> getNames() {
        return new CollectionPage<String>(contextPath, String.class, this.names, Optional.ofNullable(namesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public FileSecurityProfile withNames(List<String> names) {
        FileSecurityProfile _x = _copy();
        _x.changedFields = changedFields.add("names");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.fileSecurityProfile");
        _x.names = names;
        return _x;
    }

    @Property(name="names")
    @JsonIgnore
    public CollectionPage<String> getNames(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.names, Optional.ofNullable(namesNextLink), Collections.emptyList(), options);
    }

    @Property(name="riskScore")
    @JsonIgnore
    public Optional<String> getRiskScore() {
        return Optional.ofNullable(riskScore);
    }

    public FileSecurityProfile withRiskScore(String riskScore) {
        FileSecurityProfile _x = _copy();
        _x.changedFields = changedFields.add("riskScore");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.fileSecurityProfile");
        _x.riskScore = riskScore;
        return _x;
    }

    @Property(name="size")
    @JsonIgnore
    public Optional<Long> getSize() {
        return Optional.ofNullable(size);
    }

    public FileSecurityProfile withSize(Long size) {
        FileSecurityProfile _x = _copy();
        _x.changedFields = changedFields.add("size");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.fileSecurityProfile");
        _x.size = size;
        return _x;
    }

    @Property(name="tags")
    @JsonIgnore
    public CollectionPage<String> getTags() {
        return new CollectionPage<String>(contextPath, String.class, this.tags, Optional.ofNullable(tagsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public FileSecurityProfile withTags(List<String> tags) {
        FileSecurityProfile _x = _copy();
        _x.changedFields = changedFields.add("tags");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.fileSecurityProfile");
        _x.tags = tags;
        return _x;
    }

    @Property(name="tags")
    @JsonIgnore
    public CollectionPage<String> getTags(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.tags, Optional.ofNullable(tagsNextLink), Collections.emptyList(), options);
    }

    @Property(name="vendorInformation")
    @JsonIgnore
    public Optional<SecurityVendorInformation> getVendorInformation() {
        return Optional.ofNullable(vendorInformation);
    }

    public FileSecurityProfile withVendorInformation(SecurityVendorInformation vendorInformation) {
        FileSecurityProfile _x = _copy();
        _x.changedFields = changedFields.add("vendorInformation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.fileSecurityProfile");
        _x.vendorInformation = vendorInformation;
        return _x;
    }

    @Property(name="vulnerabilityStates")
    @JsonIgnore
    public CollectionPage<VulnerabilityState> getVulnerabilityStates() {
        return new CollectionPage<VulnerabilityState>(contextPath, VulnerabilityState.class, this.vulnerabilityStates, Optional.ofNullable(vulnerabilityStatesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public FileSecurityProfile withVulnerabilityStates(List<VulnerabilityState> vulnerabilityStates) {
        FileSecurityProfile _x = _copy();
        _x.changedFields = changedFields.add("vulnerabilityStates");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.fileSecurityProfile");
        _x.vulnerabilityStates = vulnerabilityStates;
        return _x;
    }

    @Property(name="vulnerabilityStates")
    @JsonIgnore
    public CollectionPage<VulnerabilityState> getVulnerabilityStates(HttpRequestOptions options) {
        return new CollectionPage<VulnerabilityState>(contextPath, VulnerabilityState.class, this.vulnerabilityStates, Optional.ofNullable(vulnerabilityStatesNextLink), Collections.emptyList(), options);
    }

    public FileSecurityProfile withUnmappedField(String name, Object value) {
        FileSecurityProfile _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public FileSecurityProfile patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        FileSecurityProfile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public FileSecurityProfile put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        FileSecurityProfile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private FileSecurityProfile _copy() {
        FileSecurityProfile _x = new FileSecurityProfile();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.activityGroupNames = activityGroupNames;
        _x.azureSubscriptionId = azureSubscriptionId;
        _x.azureTenantId = azureTenantId;
        _x.certificateThumbprint = certificateThumbprint;
        _x.extensions = extensions;
        _x.fileType = fileType;
        _x.firstSeenDateTime = firstSeenDateTime;
        _x.hashes = hashes;
        _x.lastSeenDateTime = lastSeenDateTime;
        _x.malwareStates = malwareStates;
        _x.names = names;
        _x.riskScore = riskScore;
        _x.size = size;
        _x.tags = tags;
        _x.vendorInformation = vendorInformation;
        _x.vulnerabilityStates = vulnerabilityStates;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("FileSecurityProfile[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("activityGroupNames=");
        b.append(this.activityGroupNames);
        b.append(", ");
        b.append("azureSubscriptionId=");
        b.append(this.azureSubscriptionId);
        b.append(", ");
        b.append("azureTenantId=");
        b.append(this.azureTenantId);
        b.append(", ");
        b.append("certificateThumbprint=");
        b.append(this.certificateThumbprint);
        b.append(", ");
        b.append("extensions=");
        b.append(this.extensions);
        b.append(", ");
        b.append("fileType=");
        b.append(this.fileType);
        b.append(", ");
        b.append("firstSeenDateTime=");
        b.append(this.firstSeenDateTime);
        b.append(", ");
        b.append("hashes=");
        b.append(this.hashes);
        b.append(", ");
        b.append("lastSeenDateTime=");
        b.append(this.lastSeenDateTime);
        b.append(", ");
        b.append("malwareStates=");
        b.append(this.malwareStates);
        b.append(", ");
        b.append("names=");
        b.append(this.names);
        b.append(", ");
        b.append("riskScore=");
        b.append(this.riskScore);
        b.append(", ");
        b.append("size=");
        b.append(this.size);
        b.append(", ");
        b.append("tags=");
        b.append(this.tags);
        b.append(", ");
        b.append("vendorInformation=");
        b.append(this.vendorInformation);
        b.append(", ");
        b.append("vulnerabilityStates=");
        b.append(this.vulnerabilityStates);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
