package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.Fido2KeyRestrictions;
import odata.msgraph.client.beta.entity.collection.request.AuthenticationMethodTargetCollectionRequest;
import odata.msgraph.client.beta.enums.AuthenticationMethodState;

@JsonPropertyOrder({
    "@odata.type", 
    "isAttestationEnforced", 
    "isSelfServiceRegistrationAllowed", 
    "keyRestrictions", 
    "includeTargets"})
@JsonInclude(Include.NON_NULL)
public class Fido2AuthenticationMethodConfiguration extends AuthenticationMethodConfiguration implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.fido2AuthenticationMethodConfiguration";
    }

    @JsonProperty("isAttestationEnforced")
    protected Boolean isAttestationEnforced;

    @JsonProperty("isSelfServiceRegistrationAllowed")
    protected Boolean isSelfServiceRegistrationAllowed;

    @JsonProperty("keyRestrictions")
    protected Fido2KeyRestrictions keyRestrictions;

    @JsonProperty("includeTargets")
    protected List<AuthenticationMethodTarget> includeTargets;

    protected Fido2AuthenticationMethodConfiguration() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderFido2AuthenticationMethodConfiguration() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private AuthenticationMethodState state;
        private Boolean isAttestationEnforced;
        private Boolean isSelfServiceRegistrationAllowed;
        private Fido2KeyRestrictions keyRestrictions;
        private List<AuthenticationMethodTarget> includeTargets;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder state(AuthenticationMethodState state) {
            this.state = state;
            this.changedFields = changedFields.add("state");
            return this;
        }

        public Builder isAttestationEnforced(Boolean isAttestationEnforced) {
            this.isAttestationEnforced = isAttestationEnforced;
            this.changedFields = changedFields.add("isAttestationEnforced");
            return this;
        }

        public Builder isSelfServiceRegistrationAllowed(Boolean isSelfServiceRegistrationAllowed) {
            this.isSelfServiceRegistrationAllowed = isSelfServiceRegistrationAllowed;
            this.changedFields = changedFields.add("isSelfServiceRegistrationAllowed");
            return this;
        }

        public Builder keyRestrictions(Fido2KeyRestrictions keyRestrictions) {
            this.keyRestrictions = keyRestrictions;
            this.changedFields = changedFields.add("keyRestrictions");
            return this;
        }

        public Builder includeTargets(List<AuthenticationMethodTarget> includeTargets) {
            this.includeTargets = includeTargets;
            this.changedFields = changedFields.add("includeTargets");
            return this;
        }

        public Builder includeTargets(AuthenticationMethodTarget... includeTargets) {
            return includeTargets(Arrays.asList(includeTargets));
        }

        public Fido2AuthenticationMethodConfiguration build() {
            Fido2AuthenticationMethodConfiguration _x = new Fido2AuthenticationMethodConfiguration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.fido2AuthenticationMethodConfiguration";
            _x.id = id;
            _x.state = state;
            _x.isAttestationEnforced = isAttestationEnforced;
            _x.isSelfServiceRegistrationAllowed = isSelfServiceRegistrationAllowed;
            _x.keyRestrictions = keyRestrictions;
            _x.includeTargets = includeTargets;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="isAttestationEnforced")
    @JsonIgnore
    public Optional<Boolean> getIsAttestationEnforced() {
        return Optional.ofNullable(isAttestationEnforced);
    }

    public Fido2AuthenticationMethodConfiguration withIsAttestationEnforced(Boolean isAttestationEnforced) {
        Fido2AuthenticationMethodConfiguration _x = _copy();
        _x.changedFields = changedFields.add("isAttestationEnforced");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.fido2AuthenticationMethodConfiguration");
        _x.isAttestationEnforced = isAttestationEnforced;
        return _x;
    }

    @Property(name="isSelfServiceRegistrationAllowed")
    @JsonIgnore
    public Optional<Boolean> getIsSelfServiceRegistrationAllowed() {
        return Optional.ofNullable(isSelfServiceRegistrationAllowed);
    }

    public Fido2AuthenticationMethodConfiguration withIsSelfServiceRegistrationAllowed(Boolean isSelfServiceRegistrationAllowed) {
        Fido2AuthenticationMethodConfiguration _x = _copy();
        _x.changedFields = changedFields.add("isSelfServiceRegistrationAllowed");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.fido2AuthenticationMethodConfiguration");
        _x.isSelfServiceRegistrationAllowed = isSelfServiceRegistrationAllowed;
        return _x;
    }

    @Property(name="keyRestrictions")
    @JsonIgnore
    public Optional<Fido2KeyRestrictions> getKeyRestrictions() {
        return Optional.ofNullable(keyRestrictions);
    }

    public Fido2AuthenticationMethodConfiguration withKeyRestrictions(Fido2KeyRestrictions keyRestrictions) {
        Fido2AuthenticationMethodConfiguration _x = _copy();
        _x.changedFields = changedFields.add("keyRestrictions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.fido2AuthenticationMethodConfiguration");
        _x.keyRestrictions = keyRestrictions;
        return _x;
    }

    public Fido2AuthenticationMethodConfiguration withUnmappedField(String name, Object value) {
        Fido2AuthenticationMethodConfiguration _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="includeTargets")
    @JsonIgnore
    public AuthenticationMethodTargetCollectionRequest getIncludeTargets() {
        return new AuthenticationMethodTargetCollectionRequest(
                        contextPath.addSegment("includeTargets"), Optional.ofNullable(includeTargets));
    }

    public Fido2AuthenticationMethodConfiguration withIncludeTargets(List<AuthenticationMethodTarget> includeTargets) {
        Fido2AuthenticationMethodConfiguration _x = _copy();
        _x.changedFields = changedFields.add("includeTargets");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.fido2AuthenticationMethodConfiguration");
        _x.includeTargets = includeTargets;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Fido2AuthenticationMethodConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Fido2AuthenticationMethodConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Fido2AuthenticationMethodConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Fido2AuthenticationMethodConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Fido2AuthenticationMethodConfiguration _copy() {
        Fido2AuthenticationMethodConfiguration _x = new Fido2AuthenticationMethodConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.state = state;
        _x.isAttestationEnforced = isAttestationEnforced;
        _x.isSelfServiceRegistrationAllowed = isSelfServiceRegistrationAllowed;
        _x.keyRestrictions = keyRestrictions;
        _x.includeTargets = includeTargets;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Fido2AuthenticationMethodConfiguration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("state=");
        b.append(this.state);
        b.append(", ");
        b.append("isAttestationEnforced=");
        b.append(this.isAttestationEnforced);
        b.append(", ");
        b.append("isSelfServiceRegistrationAllowed=");
        b.append(this.isSelfServiceRegistrationAllowed);
        b.append(", ");
        b.append("keyRestrictions=");
        b.append(this.keyRestrictions);
        b.append(", ");
        b.append("includeTargets=");
        b.append(this.includeTargets);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
