package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "audiences", 
    "description", 
    "issuer", 
    "name", 
    "subject"})
@JsonInclude(Include.NON_NULL)
public class FederatedIdentityCredential extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.federatedIdentityCredential";
    }

    @JsonProperty("audiences")
    protected List<String> audiences;

    @JsonProperty("audiences@nextLink")
    protected String audiencesNextLink;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("issuer")
    protected String issuer;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("subject")
    protected String subject;

    protected FederatedIdentityCredential() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderFederatedIdentityCredential() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<String> audiences;
        private String audiencesNextLink;
        private String description;
        private String issuer;
        private String name;
        private String subject;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder audiences(List<String> audiences) {
            this.audiences = audiences;
            this.changedFields = changedFields.add("audiences");
            return this;
        }

        public Builder audiences(String... audiences) {
            return audiences(Arrays.asList(audiences));
        }

        public Builder audiencesNextLink(String audiencesNextLink) {
            this.audiencesNextLink = audiencesNextLink;
            this.changedFields = changedFields.add("audiences");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder issuer(String issuer) {
            this.issuer = issuer;
            this.changedFields = changedFields.add("issuer");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder subject(String subject) {
            this.subject = subject;
            this.changedFields = changedFields.add("subject");
            return this;
        }

        public FederatedIdentityCredential build() {
            FederatedIdentityCredential _x = new FederatedIdentityCredential();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.federatedIdentityCredential";
            _x.id = id;
            _x.audiences = audiences;
            _x.audiencesNextLink = audiencesNextLink;
            _x.description = description;
            _x.issuer = issuer;
            _x.name = name;
            _x.subject = subject;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="audiences")
    @JsonIgnore
    public CollectionPage<String> getAudiences() {
        return new CollectionPage<String>(contextPath, String.class, this.audiences, Optional.ofNullable(audiencesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public FederatedIdentityCredential withAudiences(List<String> audiences) {
        FederatedIdentityCredential _x = _copy();
        _x.changedFields = changedFields.add("audiences");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.federatedIdentityCredential");
        _x.audiences = audiences;
        return _x;
    }

    @Property(name="audiences")
    @JsonIgnore
    public CollectionPage<String> getAudiences(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.audiences, Optional.ofNullable(audiencesNextLink), Collections.emptyList(), options);
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public FederatedIdentityCredential withDescription(String description) {
        FederatedIdentityCredential _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.federatedIdentityCredential");
        _x.description = description;
        return _x;
    }

    @Property(name="issuer")
    @JsonIgnore
    public Optional<String> getIssuer() {
        return Optional.ofNullable(issuer);
    }

    public FederatedIdentityCredential withIssuer(String issuer) {
        FederatedIdentityCredential _x = _copy();
        _x.changedFields = changedFields.add("issuer");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.federatedIdentityCredential");
        _x.issuer = issuer;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public FederatedIdentityCredential withName(String name) {
        FederatedIdentityCredential _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.federatedIdentityCredential");
        _x.name = name;
        return _x;
    }

    @Property(name="subject")
    @JsonIgnore
    public Optional<String> getSubject() {
        return Optional.ofNullable(subject);
    }

    public FederatedIdentityCredential withSubject(String subject) {
        FederatedIdentityCredential _x = _copy();
        _x.changedFields = changedFields.add("subject");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.federatedIdentityCredential");
        _x.subject = subject;
        return _x;
    }

    public FederatedIdentityCredential withUnmappedField(String name, Object value) {
        FederatedIdentityCredential _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public FederatedIdentityCredential patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        FederatedIdentityCredential _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public FederatedIdentityCredential put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        FederatedIdentityCredential _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private FederatedIdentityCredential _copy() {
        FederatedIdentityCredential _x = new FederatedIdentityCredential();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.audiences = audiences;
        _x.description = description;
        _x.issuer = issuer;
        _x.name = name;
        _x.subject = subject;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("FederatedIdentityCredential[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("audiences=");
        b.append(this.audiences);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("issuer=");
        b.append(this.issuer);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("subject=");
        b.append(this.subject);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
