package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.DirectoryObjectCollectionRequest;
import odata.msgraph.client.beta.enums.StagedFeatureName;

@JsonPropertyOrder({
    "@odata.type", 
    "description", 
    "displayName", 
    "feature", 
    "isAppliedToOrganization", 
    "isEnabled", 
    "appliesTo"})
@JsonInclude(Include.NON_NULL)
public class FeatureRolloutPolicy extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.featureRolloutPolicy";
    }

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("feature")
    protected StagedFeatureName feature;

    @JsonProperty("isAppliedToOrganization")
    protected Boolean isAppliedToOrganization;

    @JsonProperty("isEnabled")
    protected Boolean isEnabled;

    @JsonProperty("appliesTo")
    protected List<DirectoryObject> appliesTo;

    protected FeatureRolloutPolicy() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderFeatureRolloutPolicy() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String description;
        private String displayName;
        private StagedFeatureName feature;
        private Boolean isAppliedToOrganization;
        private Boolean isEnabled;
        private List<DirectoryObject> appliesTo;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder feature(StagedFeatureName feature) {
            this.feature = feature;
            this.changedFields = changedFields.add("feature");
            return this;
        }

        public Builder isAppliedToOrganization(Boolean isAppliedToOrganization) {
            this.isAppliedToOrganization = isAppliedToOrganization;
            this.changedFields = changedFields.add("isAppliedToOrganization");
            return this;
        }

        public Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            this.changedFields = changedFields.add("isEnabled");
            return this;
        }

        public Builder appliesTo(List<DirectoryObject> appliesTo) {
            this.appliesTo = appliesTo;
            this.changedFields = changedFields.add("appliesTo");
            return this;
        }

        public Builder appliesTo(DirectoryObject... appliesTo) {
            return appliesTo(Arrays.asList(appliesTo));
        }

        public FeatureRolloutPolicy build() {
            FeatureRolloutPolicy _x = new FeatureRolloutPolicy();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.featureRolloutPolicy";
            _x.id = id;
            _x.description = description;
            _x.displayName = displayName;
            _x.feature = feature;
            _x.isAppliedToOrganization = isAppliedToOrganization;
            _x.isEnabled = isEnabled;
            _x.appliesTo = appliesTo;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public FeatureRolloutPolicy withDescription(String description) {
        FeatureRolloutPolicy _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.featureRolloutPolicy");
        _x.description = description;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public FeatureRolloutPolicy withDisplayName(String displayName) {
        FeatureRolloutPolicy _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.featureRolloutPolicy");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="feature")
    @JsonIgnore
    public Optional<StagedFeatureName> getFeature() {
        return Optional.ofNullable(feature);
    }

    public FeatureRolloutPolicy withFeature(StagedFeatureName feature) {
        FeatureRolloutPolicy _x = _copy();
        _x.changedFields = changedFields.add("feature");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.featureRolloutPolicy");
        _x.feature = feature;
        return _x;
    }

    @Property(name="isAppliedToOrganization")
    @JsonIgnore
    public Optional<Boolean> getIsAppliedToOrganization() {
        return Optional.ofNullable(isAppliedToOrganization);
    }

    public FeatureRolloutPolicy withIsAppliedToOrganization(Boolean isAppliedToOrganization) {
        FeatureRolloutPolicy _x = _copy();
        _x.changedFields = changedFields.add("isAppliedToOrganization");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.featureRolloutPolicy");
        _x.isAppliedToOrganization = isAppliedToOrganization;
        return _x;
    }

    @Property(name="isEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsEnabled() {
        return Optional.ofNullable(isEnabled);
    }

    public FeatureRolloutPolicy withIsEnabled(Boolean isEnabled) {
        FeatureRolloutPolicy _x = _copy();
        _x.changedFields = changedFields.add("isEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.featureRolloutPolicy");
        _x.isEnabled = isEnabled;
        return _x;
    }

    public FeatureRolloutPolicy withUnmappedField(String name, Object value) {
        FeatureRolloutPolicy _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="appliesTo")
    @JsonIgnore
    public DirectoryObjectCollectionRequest getAppliesTo() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("appliesTo"), Optional.ofNullable(appliesTo));
    }

    public FeatureRolloutPolicy withAppliesTo(List<DirectoryObject> appliesTo) {
        FeatureRolloutPolicy _x = _copy();
        _x.changedFields = changedFields.add("appliesTo");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.featureRolloutPolicy");
        _x.appliesTo = appliesTo;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public FeatureRolloutPolicy patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        FeatureRolloutPolicy _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public FeatureRolloutPolicy put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        FeatureRolloutPolicy _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private FeatureRolloutPolicy _copy() {
        FeatureRolloutPolicy _x = new FeatureRolloutPolicy();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.description = description;
        _x.displayName = displayName;
        _x.feature = feature;
        _x.isAppliedToOrganization = isAppliedToOrganization;
        _x.isEnabled = isEnabled;
        _x.appliesTo = appliesTo;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("FeatureRolloutPolicy[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("feature=");
        b.append(this.feature);
        b.append(", ");
        b.append("isAppliedToOrganization=");
        b.append(this.isAppliedToOrganization);
        b.append(", ");
        b.append("isEnabled=");
        b.append(this.isEnabled);
        b.append(", ");
        b.append("appliesTo=");
        b.append(this.appliesTo);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
