package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.complex.ClassificationError;

@JsonPropertyOrder({
    "@odata.type", 
    "dataStoreId", 
    "processingCompletionDateTime", 
    "remainingBlockCount", 
    "remainingJobCount", 
    "state", 
    "totalBlockCount", 
    "totalJobCount", 
    "uploadCompletionDateTime"})
@JsonInclude(Include.NON_NULL)
public class ExactMatchSessionBase extends ExactMatchJobBase implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.exactMatchSessionBase";
    }

    @JsonProperty("dataStoreId")
    protected String dataStoreId;

    @JsonProperty("processingCompletionDateTime")
    protected OffsetDateTime processingCompletionDateTime;

    @JsonProperty("remainingBlockCount")
    protected Integer remainingBlockCount;

    @JsonProperty("remainingJobCount")
    protected Integer remainingJobCount;

    @JsonProperty("state")
    protected String state;

    @JsonProperty("totalBlockCount")
    protected Integer totalBlockCount;

    @JsonProperty("totalJobCount")
    protected Integer totalJobCount;

    @JsonProperty("uploadCompletionDateTime")
    protected OffsetDateTime uploadCompletionDateTime;

    protected ExactMatchSessionBase() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderExactMatchSessionBase() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime completionDateTime;
        private OffsetDateTime creationDateTime;
        private ClassificationError error;
        private OffsetDateTime lastUpdatedDateTime;
        private OffsetDateTime startDateTime;
        private String dataStoreId;
        private OffsetDateTime processingCompletionDateTime;
        private Integer remainingBlockCount;
        private Integer remainingJobCount;
        private String state;
        private Integer totalBlockCount;
        private Integer totalJobCount;
        private OffsetDateTime uploadCompletionDateTime;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder completionDateTime(OffsetDateTime completionDateTime) {
            this.completionDateTime = completionDateTime;
            this.changedFields = changedFields.add("completionDateTime");
            return this;
        }

        public Builder creationDateTime(OffsetDateTime creationDateTime) {
            this.creationDateTime = creationDateTime;
            this.changedFields = changedFields.add("creationDateTime");
            return this;
        }

        public Builder error(ClassificationError error) {
            this.error = error;
            this.changedFields = changedFields.add("error");
            return this;
        }

        public Builder lastUpdatedDateTime(OffsetDateTime lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            this.changedFields = changedFields.add("lastUpdatedDateTime");
            return this;
        }

        public Builder startDateTime(OffsetDateTime startDateTime) {
            this.startDateTime = startDateTime;
            this.changedFields = changedFields.add("startDateTime");
            return this;
        }

        public Builder dataStoreId(String dataStoreId) {
            this.dataStoreId = dataStoreId;
            this.changedFields = changedFields.add("dataStoreId");
            return this;
        }

        public Builder processingCompletionDateTime(OffsetDateTime processingCompletionDateTime) {
            this.processingCompletionDateTime = processingCompletionDateTime;
            this.changedFields = changedFields.add("processingCompletionDateTime");
            return this;
        }

        public Builder remainingBlockCount(Integer remainingBlockCount) {
            this.remainingBlockCount = remainingBlockCount;
            this.changedFields = changedFields.add("remainingBlockCount");
            return this;
        }

        public Builder remainingJobCount(Integer remainingJobCount) {
            this.remainingJobCount = remainingJobCount;
            this.changedFields = changedFields.add("remainingJobCount");
            return this;
        }

        public Builder state(String state) {
            this.state = state;
            this.changedFields = changedFields.add("state");
            return this;
        }

        public Builder totalBlockCount(Integer totalBlockCount) {
            this.totalBlockCount = totalBlockCount;
            this.changedFields = changedFields.add("totalBlockCount");
            return this;
        }

        public Builder totalJobCount(Integer totalJobCount) {
            this.totalJobCount = totalJobCount;
            this.changedFields = changedFields.add("totalJobCount");
            return this;
        }

        public Builder uploadCompletionDateTime(OffsetDateTime uploadCompletionDateTime) {
            this.uploadCompletionDateTime = uploadCompletionDateTime;
            this.changedFields = changedFields.add("uploadCompletionDateTime");
            return this;
        }

        public ExactMatchSessionBase build() {
            ExactMatchSessionBase _x = new ExactMatchSessionBase();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.exactMatchSessionBase";
            _x.id = id;
            _x.completionDateTime = completionDateTime;
            _x.creationDateTime = creationDateTime;
            _x.error = error;
            _x.lastUpdatedDateTime = lastUpdatedDateTime;
            _x.startDateTime = startDateTime;
            _x.dataStoreId = dataStoreId;
            _x.processingCompletionDateTime = processingCompletionDateTime;
            _x.remainingBlockCount = remainingBlockCount;
            _x.remainingJobCount = remainingJobCount;
            _x.state = state;
            _x.totalBlockCount = totalBlockCount;
            _x.totalJobCount = totalJobCount;
            _x.uploadCompletionDateTime = uploadCompletionDateTime;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="dataStoreId")
    @JsonIgnore
    public Optional<String> getDataStoreId() {
        return Optional.ofNullable(dataStoreId);
    }

    public ExactMatchSessionBase withDataStoreId(String dataStoreId) {
        ExactMatchSessionBase _x = _copy();
        _x.changedFields = changedFields.add("dataStoreId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.exactMatchSessionBase");
        _x.dataStoreId = dataStoreId;
        return _x;
    }

    @Property(name="processingCompletionDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getProcessingCompletionDateTime() {
        return Optional.ofNullable(processingCompletionDateTime);
    }

    public ExactMatchSessionBase withProcessingCompletionDateTime(OffsetDateTime processingCompletionDateTime) {
        ExactMatchSessionBase _x = _copy();
        _x.changedFields = changedFields.add("processingCompletionDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.exactMatchSessionBase");
        _x.processingCompletionDateTime = processingCompletionDateTime;
        return _x;
    }

    @Property(name="remainingBlockCount")
    @JsonIgnore
    public Optional<Integer> getRemainingBlockCount() {
        return Optional.ofNullable(remainingBlockCount);
    }

    public ExactMatchSessionBase withRemainingBlockCount(Integer remainingBlockCount) {
        ExactMatchSessionBase _x = _copy();
        _x.changedFields = changedFields.add("remainingBlockCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.exactMatchSessionBase");
        _x.remainingBlockCount = remainingBlockCount;
        return _x;
    }

    @Property(name="remainingJobCount")
    @JsonIgnore
    public Optional<Integer> getRemainingJobCount() {
        return Optional.ofNullable(remainingJobCount);
    }

    public ExactMatchSessionBase withRemainingJobCount(Integer remainingJobCount) {
        ExactMatchSessionBase _x = _copy();
        _x.changedFields = changedFields.add("remainingJobCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.exactMatchSessionBase");
        _x.remainingJobCount = remainingJobCount;
        return _x;
    }

    @Property(name="state")
    @JsonIgnore
    public Optional<String> getState() {
        return Optional.ofNullable(state);
    }

    public ExactMatchSessionBase withState(String state) {
        ExactMatchSessionBase _x = _copy();
        _x.changedFields = changedFields.add("state");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.exactMatchSessionBase");
        _x.state = state;
        return _x;
    }

    @Property(name="totalBlockCount")
    @JsonIgnore
    public Optional<Integer> getTotalBlockCount() {
        return Optional.ofNullable(totalBlockCount);
    }

    public ExactMatchSessionBase withTotalBlockCount(Integer totalBlockCount) {
        ExactMatchSessionBase _x = _copy();
        _x.changedFields = changedFields.add("totalBlockCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.exactMatchSessionBase");
        _x.totalBlockCount = totalBlockCount;
        return _x;
    }

    @Property(name="totalJobCount")
    @JsonIgnore
    public Optional<Integer> getTotalJobCount() {
        return Optional.ofNullable(totalJobCount);
    }

    public ExactMatchSessionBase withTotalJobCount(Integer totalJobCount) {
        ExactMatchSessionBase _x = _copy();
        _x.changedFields = changedFields.add("totalJobCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.exactMatchSessionBase");
        _x.totalJobCount = totalJobCount;
        return _x;
    }

    @Property(name="uploadCompletionDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getUploadCompletionDateTime() {
        return Optional.ofNullable(uploadCompletionDateTime);
    }

    public ExactMatchSessionBase withUploadCompletionDateTime(OffsetDateTime uploadCompletionDateTime) {
        ExactMatchSessionBase _x = _copy();
        _x.changedFields = changedFields.add("uploadCompletionDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.exactMatchSessionBase");
        _x.uploadCompletionDateTime = uploadCompletionDateTime;
        return _x;
    }

    public ExactMatchSessionBase withUnmappedField(String name, Object value) {
        ExactMatchSessionBase _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ExactMatchSessionBase patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ExactMatchSessionBase _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ExactMatchSessionBase put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ExactMatchSessionBase _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ExactMatchSessionBase _copy() {
        ExactMatchSessionBase _x = new ExactMatchSessionBase();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.completionDateTime = completionDateTime;
        _x.creationDateTime = creationDateTime;
        _x.error = error;
        _x.lastUpdatedDateTime = lastUpdatedDateTime;
        _x.startDateTime = startDateTime;
        _x.dataStoreId = dataStoreId;
        _x.processingCompletionDateTime = processingCompletionDateTime;
        _x.remainingBlockCount = remainingBlockCount;
        _x.remainingJobCount = remainingJobCount;
        _x.state = state;
        _x.totalBlockCount = totalBlockCount;
        _x.totalJobCount = totalJobCount;
        _x.uploadCompletionDateTime = uploadCompletionDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ExactMatchSessionBase[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("completionDateTime=");
        b.append(this.completionDateTime);
        b.append(", ");
        b.append("creationDateTime=");
        b.append(this.creationDateTime);
        b.append(", ");
        b.append("error=");
        b.append(this.error);
        b.append(", ");
        b.append("lastUpdatedDateTime=");
        b.append(this.lastUpdatedDateTime);
        b.append(", ");
        b.append("startDateTime=");
        b.append(this.startDateTime);
        b.append(", ");
        b.append("dataStoreId=");
        b.append(this.dataStoreId);
        b.append(", ");
        b.append("processingCompletionDateTime=");
        b.append(this.processingCompletionDateTime);
        b.append(", ");
        b.append("remainingBlockCount=");
        b.append(this.remainingBlockCount);
        b.append(", ");
        b.append("remainingJobCount=");
        b.append(this.remainingJobCount);
        b.append(", ");
        b.append("state=");
        b.append(this.state);
        b.append(", ");
        b.append("totalBlockCount=");
        b.append(this.totalBlockCount);
        b.append(", ");
        b.append("totalJobCount=");
        b.append(this.totalJobCount);
        b.append(", ");
        b.append("uploadCompletionDateTime=");
        b.append(this.uploadCompletionDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
