package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.Attendee;
import odata.msgraph.client.beta.complex.DateTimeTimeZone;
import odata.msgraph.client.beta.complex.ItemBody;
import odata.msgraph.client.beta.complex.Location;
import odata.msgraph.client.beta.complex.OnlineMeetingInfo;
import odata.msgraph.client.beta.complex.PatternedRecurrence;
import odata.msgraph.client.beta.complex.Recipient;
import odata.msgraph.client.beta.complex.ResponseStatus;
import odata.msgraph.client.beta.complex.TimeSlot;
import odata.msgraph.client.beta.entity.collection.request.AttachmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EventCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ExtensionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MultiValueLegacyExtendedPropertyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SingleValueLegacyExtendedPropertyCollectionRequest;
import odata.msgraph.client.beta.entity.request.CalendarRequest;
import odata.msgraph.client.beta.enums.EventType;
import odata.msgraph.client.beta.enums.FreeBusyStatus;
import odata.msgraph.client.beta.enums.Importance;
import odata.msgraph.client.beta.enums.OnlineMeetingProviderType;
import odata.msgraph.client.beta.enums.Sensitivity;

@JsonPropertyOrder({
    "@odata.type", 
    "allowNewTimeProposals", 
    "attendees", 
    "body", 
    "bodyPreview", 
    "cancelledOccurrences", 
    "end", 
    "hasAttachments", 
    "hideAttendees", 
    "importance", 
    "isAllDay", 
    "isCancelled", 
    "isDraft", 
    "isOnlineMeeting", 
    "isOrganizer", 
    "isReminderOn", 
    "location", 
    "locations", 
    "occurrenceId", 
    "onlineMeeting", 
    "onlineMeetingProvider", 
    "onlineMeetingUrl", 
    "organizer", 
    "originalEndTimeZone", 
    "originalStart", 
    "originalStartTimeZone", 
    "recurrence", 
    "reminderMinutesBeforeStart", 
    "responseRequested", 
    "responseStatus", 
    "sensitivity", 
    "seriesMasterId", 
    "showAs", 
    "start", 
    "subject", 
    "transactionId", 
    "type", 
    "uid", 
    "webLink", 
    "attachments", 
    "calendar", 
    "exceptionOccurrences", 
    "extensions", 
    "instances", 
    "multiValueExtendedProperties", 
    "singleValueExtendedProperties"})
@JsonInclude(Include.NON_NULL)
public class Event extends OutlookItem implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.event";
    }

    @JsonProperty("allowNewTimeProposals")
    protected Boolean allowNewTimeProposals;

    @JsonProperty("attendees")
    protected List<Attendee> attendees;

    @JsonProperty("attendees@nextLink")
    protected String attendeesNextLink;

    @JsonProperty("body")
    protected ItemBody body;

    @JsonProperty("bodyPreview")
    protected String bodyPreview;

    @JsonProperty("cancelledOccurrences")
    protected List<String> cancelledOccurrences;

    @JsonProperty("cancelledOccurrences@nextLink")
    protected String cancelledOccurrencesNextLink;

    @JsonProperty("end")
    protected DateTimeTimeZone end;

    @JsonProperty("hasAttachments")
    protected Boolean hasAttachments;

    @JsonProperty("hideAttendees")
    protected Boolean hideAttendees;

    @JsonProperty("importance")
    protected Importance importance;

    @JsonProperty("isAllDay")
    protected Boolean isAllDay;

    @JsonProperty("isCancelled")
    protected Boolean isCancelled;

    @JsonProperty("isDraft")
    protected Boolean isDraft;

    @JsonProperty("isOnlineMeeting")
    protected Boolean isOnlineMeeting;

    @JsonProperty("isOrganizer")
    protected Boolean isOrganizer;

    @JsonProperty("isReminderOn")
    protected Boolean isReminderOn;

    @JsonProperty("location")
    protected Location location;

    @JsonProperty("locations")
    protected List<Location> locations;

    @JsonProperty("locations@nextLink")
    protected String locationsNextLink;

    @JsonProperty("occurrenceId")
    protected String occurrenceId;

    @JsonProperty("onlineMeeting")
    protected OnlineMeetingInfo onlineMeeting;

    @JsonProperty("onlineMeetingProvider")
    protected OnlineMeetingProviderType onlineMeetingProvider;

    @JsonProperty("onlineMeetingUrl")
    protected String onlineMeetingUrl;

    @JsonProperty("organizer")
    protected Recipient organizer;

    @JsonProperty("originalEndTimeZone")
    protected String originalEndTimeZone;

    @JsonProperty("originalStart")
    protected OffsetDateTime originalStart;

    @JsonProperty("originalStartTimeZone")
    protected String originalStartTimeZone;

    @JsonProperty("recurrence")
    protected PatternedRecurrence recurrence;

    @JsonProperty("reminderMinutesBeforeStart")
    protected Integer reminderMinutesBeforeStart;

    @JsonProperty("responseRequested")
    protected Boolean responseRequested;

    @JsonProperty("responseStatus")
    protected ResponseStatus responseStatus;

    @JsonProperty("sensitivity")
    protected Sensitivity sensitivity;

    @JsonProperty("seriesMasterId")
    protected String seriesMasterId;

    @JsonProperty("showAs")
    protected FreeBusyStatus showAs;

    @JsonProperty("start")
    protected DateTimeTimeZone start;

    @JsonProperty("subject")
    protected String subject;

    @JsonProperty("transactionId")
    protected String transactionId;

    @JsonProperty("type")
    protected EventType type;

    @JsonProperty("uid")
    protected String uid;

    @JsonProperty("webLink")
    protected String webLink;

    @JsonProperty("attachments")
    protected List<Attachment> attachments;

    @JsonProperty("calendar")
    protected Calendar calendar;

    @JsonProperty("exceptionOccurrences")
    protected List<Event> exceptionOccurrences;

    @JsonProperty("extensions")
    protected List<Extension> extensions;

    @JsonProperty("instances")
    protected List<Event> instances;

    @JsonProperty("multiValueExtendedProperties")
    protected List<MultiValueLegacyExtendedProperty> multiValueExtendedProperties;

    @JsonProperty("singleValueExtendedProperties")
    protected List<SingleValueLegacyExtendedProperty> singleValueExtendedProperties;

    protected Event() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEvent() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<String> categories;
        private String categoriesNextLink;
        private String changeKey;
        private OffsetDateTime createdDateTime;
        private OffsetDateTime lastModifiedDateTime;
        private Boolean allowNewTimeProposals;
        private List<Attendee> attendees;
        private String attendeesNextLink;
        private ItemBody body;
        private String bodyPreview;
        private List<String> cancelledOccurrences;
        private String cancelledOccurrencesNextLink;
        private DateTimeTimeZone end;
        private Boolean hasAttachments;
        private Boolean hideAttendees;
        private Importance importance;
        private Boolean isAllDay;
        private Boolean isCancelled;
        private Boolean isDraft;
        private Boolean isOnlineMeeting;
        private Boolean isOrganizer;
        private Boolean isReminderOn;
        private Location location;
        private List<Location> locations;
        private String locationsNextLink;
        private String occurrenceId;
        private OnlineMeetingInfo onlineMeeting;
        private OnlineMeetingProviderType onlineMeetingProvider;
        private String onlineMeetingUrl;
        private Recipient organizer;
        private String originalEndTimeZone;
        private OffsetDateTime originalStart;
        private String originalStartTimeZone;
        private PatternedRecurrence recurrence;
        private Integer reminderMinutesBeforeStart;
        private Boolean responseRequested;
        private ResponseStatus responseStatus;
        private Sensitivity sensitivity;
        private String seriesMasterId;
        private FreeBusyStatus showAs;
        private DateTimeTimeZone start;
        private String subject;
        private String transactionId;
        private EventType type;
        private String uid;
        private String webLink;
        private List<Attachment> attachments;
        private Calendar calendar;
        private List<Event> exceptionOccurrences;
        private List<Extension> extensions;
        private List<Event> instances;
        private List<MultiValueLegacyExtendedProperty> multiValueExtendedProperties;
        private List<SingleValueLegacyExtendedProperty> singleValueExtendedProperties;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder categories(List<String> categories) {
            this.categories = categories;
            this.changedFields = changedFields.add("categories");
            return this;
        }

        public Builder categories(String... categories) {
            return categories(Arrays.asList(categories));
        }

        public Builder categoriesNextLink(String categoriesNextLink) {
            this.categoriesNextLink = categoriesNextLink;
            this.changedFields = changedFields.add("categories");
            return this;
        }

        public Builder changeKey(String changeKey) {
            this.changeKey = changeKey;
            this.changedFields = changedFields.add("changeKey");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder allowNewTimeProposals(Boolean allowNewTimeProposals) {
            this.allowNewTimeProposals = allowNewTimeProposals;
            this.changedFields = changedFields.add("allowNewTimeProposals");
            return this;
        }

        public Builder attendees(List<Attendee> attendees) {
            this.attendees = attendees;
            this.changedFields = changedFields.add("attendees");
            return this;
        }

        public Builder attendees(Attendee... attendees) {
            return attendees(Arrays.asList(attendees));
        }

        public Builder attendeesNextLink(String attendeesNextLink) {
            this.attendeesNextLink = attendeesNextLink;
            this.changedFields = changedFields.add("attendees");
            return this;
        }

        public Builder body(ItemBody body) {
            this.body = body;
            this.changedFields = changedFields.add("body");
            return this;
        }

        public Builder bodyPreview(String bodyPreview) {
            this.bodyPreview = bodyPreview;
            this.changedFields = changedFields.add("bodyPreview");
            return this;
        }

        public Builder cancelledOccurrences(List<String> cancelledOccurrences) {
            this.cancelledOccurrences = cancelledOccurrences;
            this.changedFields = changedFields.add("cancelledOccurrences");
            return this;
        }

        public Builder cancelledOccurrences(String... cancelledOccurrences) {
            return cancelledOccurrences(Arrays.asList(cancelledOccurrences));
        }

        public Builder cancelledOccurrencesNextLink(String cancelledOccurrencesNextLink) {
            this.cancelledOccurrencesNextLink = cancelledOccurrencesNextLink;
            this.changedFields = changedFields.add("cancelledOccurrences");
            return this;
        }

        public Builder end(DateTimeTimeZone end) {
            this.end = end;
            this.changedFields = changedFields.add("end");
            return this;
        }

        public Builder hasAttachments(Boolean hasAttachments) {
            this.hasAttachments = hasAttachments;
            this.changedFields = changedFields.add("hasAttachments");
            return this;
        }

        public Builder hideAttendees(Boolean hideAttendees) {
            this.hideAttendees = hideAttendees;
            this.changedFields = changedFields.add("hideAttendees");
            return this;
        }

        public Builder importance(Importance importance) {
            this.importance = importance;
            this.changedFields = changedFields.add("importance");
            return this;
        }

        public Builder isAllDay(Boolean isAllDay) {
            this.isAllDay = isAllDay;
            this.changedFields = changedFields.add("isAllDay");
            return this;
        }

        public Builder isCancelled(Boolean isCancelled) {
            this.isCancelled = isCancelled;
            this.changedFields = changedFields.add("isCancelled");
            return this;
        }

        public Builder isDraft(Boolean isDraft) {
            this.isDraft = isDraft;
            this.changedFields = changedFields.add("isDraft");
            return this;
        }

        public Builder isOnlineMeeting(Boolean isOnlineMeeting) {
            this.isOnlineMeeting = isOnlineMeeting;
            this.changedFields = changedFields.add("isOnlineMeeting");
            return this;
        }

        public Builder isOrganizer(Boolean isOrganizer) {
            this.isOrganizer = isOrganizer;
            this.changedFields = changedFields.add("isOrganizer");
            return this;
        }

        public Builder isReminderOn(Boolean isReminderOn) {
            this.isReminderOn = isReminderOn;
            this.changedFields = changedFields.add("isReminderOn");
            return this;
        }

        public Builder location(Location location) {
            this.location = location;
            this.changedFields = changedFields.add("location");
            return this;
        }

        public Builder locations(List<Location> locations) {
            this.locations = locations;
            this.changedFields = changedFields.add("locations");
            return this;
        }

        public Builder locations(Location... locations) {
            return locations(Arrays.asList(locations));
        }

        public Builder locationsNextLink(String locationsNextLink) {
            this.locationsNextLink = locationsNextLink;
            this.changedFields = changedFields.add("locations");
            return this;
        }

        public Builder occurrenceId(String occurrenceId) {
            this.occurrenceId = occurrenceId;
            this.changedFields = changedFields.add("occurrenceId");
            return this;
        }

        public Builder onlineMeeting(OnlineMeetingInfo onlineMeeting) {
            this.onlineMeeting = onlineMeeting;
            this.changedFields = changedFields.add("onlineMeeting");
            return this;
        }

        public Builder onlineMeetingProvider(OnlineMeetingProviderType onlineMeetingProvider) {
            this.onlineMeetingProvider = onlineMeetingProvider;
            this.changedFields = changedFields.add("onlineMeetingProvider");
            return this;
        }

        public Builder onlineMeetingUrl(String onlineMeetingUrl) {
            this.onlineMeetingUrl = onlineMeetingUrl;
            this.changedFields = changedFields.add("onlineMeetingUrl");
            return this;
        }

        public Builder organizer(Recipient organizer) {
            this.organizer = organizer;
            this.changedFields = changedFields.add("organizer");
            return this;
        }

        public Builder originalEndTimeZone(String originalEndTimeZone) {
            this.originalEndTimeZone = originalEndTimeZone;
            this.changedFields = changedFields.add("originalEndTimeZone");
            return this;
        }

        public Builder originalStart(OffsetDateTime originalStart) {
            this.originalStart = originalStart;
            this.changedFields = changedFields.add("originalStart");
            return this;
        }

        public Builder originalStartTimeZone(String originalStartTimeZone) {
            this.originalStartTimeZone = originalStartTimeZone;
            this.changedFields = changedFields.add("originalStartTimeZone");
            return this;
        }

        public Builder recurrence(PatternedRecurrence recurrence) {
            this.recurrence = recurrence;
            this.changedFields = changedFields.add("recurrence");
            return this;
        }

        public Builder reminderMinutesBeforeStart(Integer reminderMinutesBeforeStart) {
            this.reminderMinutesBeforeStart = reminderMinutesBeforeStart;
            this.changedFields = changedFields.add("reminderMinutesBeforeStart");
            return this;
        }

        public Builder responseRequested(Boolean responseRequested) {
            this.responseRequested = responseRequested;
            this.changedFields = changedFields.add("responseRequested");
            return this;
        }

        public Builder responseStatus(ResponseStatus responseStatus) {
            this.responseStatus = responseStatus;
            this.changedFields = changedFields.add("responseStatus");
            return this;
        }

        public Builder sensitivity(Sensitivity sensitivity) {
            this.sensitivity = sensitivity;
            this.changedFields = changedFields.add("sensitivity");
            return this;
        }

        public Builder seriesMasterId(String seriesMasterId) {
            this.seriesMasterId = seriesMasterId;
            this.changedFields = changedFields.add("seriesMasterId");
            return this;
        }

        public Builder showAs(FreeBusyStatus showAs) {
            this.showAs = showAs;
            this.changedFields = changedFields.add("showAs");
            return this;
        }

        public Builder start(DateTimeTimeZone start) {
            this.start = start;
            this.changedFields = changedFields.add("start");
            return this;
        }

        public Builder subject(String subject) {
            this.subject = subject;
            this.changedFields = changedFields.add("subject");
            return this;
        }

        public Builder transactionId(String transactionId) {
            this.transactionId = transactionId;
            this.changedFields = changedFields.add("transactionId");
            return this;
        }

        public Builder type(EventType type) {
            this.type = type;
            this.changedFields = changedFields.add("type");
            return this;
        }

        public Builder uid(String uid) {
            this.uid = uid;
            this.changedFields = changedFields.add("uid");
            return this;
        }

        public Builder webLink(String webLink) {
            this.webLink = webLink;
            this.changedFields = changedFields.add("webLink");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = false
         * <p>
         * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
         * <p>
         * Searchable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
         * <p>
         * Updatable = false
         * 
         * @param attachments
         *            value of {@code attachments} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder attachments(List<Attachment> attachments) {
            this.attachments = attachments;
            this.changedFields = changedFields.add("attachments");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = false
         * <p>
         * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
         * <p>
         * Searchable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
         * <p>
         * Updatable = false
         * 
         * @param attachments
         *            value of {@code attachments} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder attachments(Attachment... attachments) {
            return attachments(Arrays.asList(attachments));
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = false
         * <p>
         * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
         * <p>
         * Deletable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
         * <p>
         * Expandable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
         * <p>
         * Insertable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.NavigationRestrictions</b>
         * <p>
         * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
         * <p>
         * Searchable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
         * <p>
         * Updatable = false
         * 
         * @param calendar
         *            value of {@code calendar} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder calendar(Calendar calendar) {
            this.calendar = calendar;
            this.changedFields = changedFields.add("calendar");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = false
         * <p>
         * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
         * <p>
         * Deletable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
         * <p>
         * Insertable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.NavigationRestrictions</b>
         * <p>
         * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
         * <p>
         * Searchable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
         * <p>
         * Updatable = false
         * 
         * @param exceptionOccurrences
         *            value of {@code exceptionOccurrences} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder exceptionOccurrences(List<Event> exceptionOccurrences) {
            this.exceptionOccurrences = exceptionOccurrences;
            this.changedFields = changedFields.add("exceptionOccurrences");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = false
         * <p>
         * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
         * <p>
         * Deletable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
         * <p>
         * Insertable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.NavigationRestrictions</b>
         * <p>
         * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
         * <p>
         * Searchable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
         * <p>
         * Updatable = false
         * 
         * @param exceptionOccurrences
         *            value of {@code exceptionOccurrences} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder exceptionOccurrences(Event... exceptionOccurrences) {
            return exceptionOccurrences(Arrays.asList(exceptionOccurrences));
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = false
         * <p>
         * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
         * <p>
         * Searchable = false
         * 
         * @param extensions
         *            value of {@code extensions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder extensions(List<Extension> extensions) {
            this.extensions = extensions;
            this.changedFields = changedFields.add("extensions");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = false
         * <p>
         * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
         * <p>
         * Searchable = false
         * 
         * @param extensions
         *            value of {@code extensions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder extensions(Extension... extensions) {
            return extensions(Arrays.asList(extensions));
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = false
         * <p>
         * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
         * <p>
         * Deletable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
         * <p>
         * Expandable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
         * <p>
         * Insertable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.NavigationRestrictions</b>
         * <p>
         * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
         * <p>
         * Searchable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
         * <p>
         * Updatable = false
         * 
         * @param instances
         *            value of {@code instances} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder instances(List<Event> instances) {
            this.instances = instances;
            this.changedFields = changedFields.add("instances");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = false
         * <p>
         * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
         * <p>
         * Deletable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
         * <p>
         * Expandable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
         * <p>
         * Insertable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.NavigationRestrictions</b>
         * <p>
         * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
         * <p>
         * Searchable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
         * <p>
         * Updatable = false
         * 
         * @param instances
         *            value of {@code instances} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder instances(Event... instances) {
            return instances(Arrays.asList(instances));
        }

        public Builder multiValueExtendedProperties(List<MultiValueLegacyExtendedProperty> multiValueExtendedProperties) {
            this.multiValueExtendedProperties = multiValueExtendedProperties;
            this.changedFields = changedFields.add("multiValueExtendedProperties");
            return this;
        }

        public Builder multiValueExtendedProperties(MultiValueLegacyExtendedProperty... multiValueExtendedProperties) {
            return multiValueExtendedProperties(Arrays.asList(multiValueExtendedProperties));
        }

        public Builder singleValueExtendedProperties(List<SingleValueLegacyExtendedProperty> singleValueExtendedProperties) {
            this.singleValueExtendedProperties = singleValueExtendedProperties;
            this.changedFields = changedFields.add("singleValueExtendedProperties");
            return this;
        }

        public Builder singleValueExtendedProperties(SingleValueLegacyExtendedProperty... singleValueExtendedProperties) {
            return singleValueExtendedProperties(Arrays.asList(singleValueExtendedProperties));
        }

        public Event build() {
            Event _x = new Event();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.event";
            _x.id = id;
            _x.categories = categories;
            _x.categoriesNextLink = categoriesNextLink;
            _x.changeKey = changeKey;
            _x.createdDateTime = createdDateTime;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.allowNewTimeProposals = allowNewTimeProposals;
            _x.attendees = attendees;
            _x.attendeesNextLink = attendeesNextLink;
            _x.body = body;
            _x.bodyPreview = bodyPreview;
            _x.cancelledOccurrences = cancelledOccurrences;
            _x.cancelledOccurrencesNextLink = cancelledOccurrencesNextLink;
            _x.end = end;
            _x.hasAttachments = hasAttachments;
            _x.hideAttendees = hideAttendees;
            _x.importance = importance;
            _x.isAllDay = isAllDay;
            _x.isCancelled = isCancelled;
            _x.isDraft = isDraft;
            _x.isOnlineMeeting = isOnlineMeeting;
            _x.isOrganizer = isOrganizer;
            _x.isReminderOn = isReminderOn;
            _x.location = location;
            _x.locations = locations;
            _x.locationsNextLink = locationsNextLink;
            _x.occurrenceId = occurrenceId;
            _x.onlineMeeting = onlineMeeting;
            _x.onlineMeetingProvider = onlineMeetingProvider;
            _x.onlineMeetingUrl = onlineMeetingUrl;
            _x.organizer = organizer;
            _x.originalEndTimeZone = originalEndTimeZone;
            _x.originalStart = originalStart;
            _x.originalStartTimeZone = originalStartTimeZone;
            _x.recurrence = recurrence;
            _x.reminderMinutesBeforeStart = reminderMinutesBeforeStart;
            _x.responseRequested = responseRequested;
            _x.responseStatus = responseStatus;
            _x.sensitivity = sensitivity;
            _x.seriesMasterId = seriesMasterId;
            _x.showAs = showAs;
            _x.start = start;
            _x.subject = subject;
            _x.transactionId = transactionId;
            _x.type = type;
            _x.uid = uid;
            _x.webLink = webLink;
            _x.attachments = attachments;
            _x.calendar = calendar;
            _x.exceptionOccurrences = exceptionOccurrences;
            _x.extensions = extensions;
            _x.instances = instances;
            _x.multiValueExtendedProperties = multiValueExtendedProperties;
            _x.singleValueExtendedProperties = singleValueExtendedProperties;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="allowNewTimeProposals")
    @JsonIgnore
    public Optional<Boolean> getAllowNewTimeProposals() {
        return Optional.ofNullable(allowNewTimeProposals);
    }

    public Event withAllowNewTimeProposals(Boolean allowNewTimeProposals) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("allowNewTimeProposals");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.allowNewTimeProposals = allowNewTimeProposals;
        return _x;
    }

    @Property(name="attendees")
    @JsonIgnore
    public CollectionPage<Attendee> getAttendees() {
        return new CollectionPage<Attendee>(contextPath, Attendee.class, this.attendees, Optional.ofNullable(attendeesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public Event withAttendees(List<Attendee> attendees) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("attendees");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.attendees = attendees;
        return _x;
    }

    @Property(name="attendees")
    @JsonIgnore
    public CollectionPage<Attendee> getAttendees(HttpRequestOptions options) {
        return new CollectionPage<Attendee>(contextPath, Attendee.class, this.attendees, Optional.ofNullable(attendeesNextLink), Collections.emptyList(), options);
    }

    @Property(name="body")
    @JsonIgnore
    public Optional<ItemBody> getBody() {
        return Optional.ofNullable(body);
    }

    public Event withBody(ItemBody body) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("body");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.body = body;
        return _x;
    }

    @Property(name="bodyPreview")
    @JsonIgnore
    public Optional<String> getBodyPreview() {
        return Optional.ofNullable(bodyPreview);
    }

    public Event withBodyPreview(String bodyPreview) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("bodyPreview");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.bodyPreview = bodyPreview;
        return _x;
    }

    @Property(name="cancelledOccurrences")
    @JsonIgnore
    public CollectionPage<String> getCancelledOccurrences() {
        return new CollectionPage<String>(contextPath, String.class, this.cancelledOccurrences, Optional.ofNullable(cancelledOccurrencesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public Event withCancelledOccurrences(List<String> cancelledOccurrences) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("cancelledOccurrences");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.cancelledOccurrences = cancelledOccurrences;
        return _x;
    }

    @Property(name="cancelledOccurrences")
    @JsonIgnore
    public CollectionPage<String> getCancelledOccurrences(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.cancelledOccurrences, Optional.ofNullable(cancelledOccurrencesNextLink), Collections.emptyList(), options);
    }

    @Property(name="end")
    @JsonIgnore
    public Optional<DateTimeTimeZone> getEnd() {
        return Optional.ofNullable(end);
    }

    public Event withEnd(DateTimeTimeZone end) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("end");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.end = end;
        return _x;
    }

    @Property(name="hasAttachments")
    @JsonIgnore
    public Optional<Boolean> getHasAttachments() {
        return Optional.ofNullable(hasAttachments);
    }

    public Event withHasAttachments(Boolean hasAttachments) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("hasAttachments");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.hasAttachments = hasAttachments;
        return _x;
    }

    @Property(name="hideAttendees")
    @JsonIgnore
    public Optional<Boolean> getHideAttendees() {
        return Optional.ofNullable(hideAttendees);
    }

    public Event withHideAttendees(Boolean hideAttendees) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("hideAttendees");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.hideAttendees = hideAttendees;
        return _x;
    }

    @Property(name="importance")
    @JsonIgnore
    public Optional<Importance> getImportance() {
        return Optional.ofNullable(importance);
    }

    public Event withImportance(Importance importance) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("importance");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.importance = importance;
        return _x;
    }

    @Property(name="isAllDay")
    @JsonIgnore
    public Optional<Boolean> getIsAllDay() {
        return Optional.ofNullable(isAllDay);
    }

    public Event withIsAllDay(Boolean isAllDay) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("isAllDay");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.isAllDay = isAllDay;
        return _x;
    }

    @Property(name="isCancelled")
    @JsonIgnore
    public Optional<Boolean> getIsCancelled() {
        return Optional.ofNullable(isCancelled);
    }

    public Event withIsCancelled(Boolean isCancelled) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("isCancelled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.isCancelled = isCancelled;
        return _x;
    }

    @Property(name="isDraft")
    @JsonIgnore
    public Optional<Boolean> getIsDraft() {
        return Optional.ofNullable(isDraft);
    }

    public Event withIsDraft(Boolean isDraft) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("isDraft");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.isDraft = isDraft;
        return _x;
    }

    @Property(name="isOnlineMeeting")
    @JsonIgnore
    public Optional<Boolean> getIsOnlineMeeting() {
        return Optional.ofNullable(isOnlineMeeting);
    }

    public Event withIsOnlineMeeting(Boolean isOnlineMeeting) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("isOnlineMeeting");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.isOnlineMeeting = isOnlineMeeting;
        return _x;
    }

    @Property(name="isOrganizer")
    @JsonIgnore
    public Optional<Boolean> getIsOrganizer() {
        return Optional.ofNullable(isOrganizer);
    }

    public Event withIsOrganizer(Boolean isOrganizer) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("isOrganizer");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.isOrganizer = isOrganizer;
        return _x;
    }

    @Property(name="isReminderOn")
    @JsonIgnore
    public Optional<Boolean> getIsReminderOn() {
        return Optional.ofNullable(isReminderOn);
    }

    public Event withIsReminderOn(Boolean isReminderOn) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("isReminderOn");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.isReminderOn = isReminderOn;
        return _x;
    }

    @Property(name="location")
    @JsonIgnore
    public Optional<Location> getLocation() {
        return Optional.ofNullable(location);
    }

    public Event withLocation(Location location) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("location");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.location = location;
        return _x;
    }

    @Property(name="locations")
    @JsonIgnore
    public CollectionPage<Location> getLocations() {
        return new CollectionPage<Location>(contextPath, Location.class, this.locations, Optional.ofNullable(locationsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public Event withLocations(List<Location> locations) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("locations");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.locations = locations;
        return _x;
    }

    @Property(name="locations")
    @JsonIgnore
    public CollectionPage<Location> getLocations(HttpRequestOptions options) {
        return new CollectionPage<Location>(contextPath, Location.class, this.locations, Optional.ofNullable(locationsNextLink), Collections.emptyList(), options);
    }

    @Property(name="occurrenceId")
    @JsonIgnore
    public Optional<String> getOccurrenceId() {
        return Optional.ofNullable(occurrenceId);
    }

    public Event withOccurrenceId(String occurrenceId) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("occurrenceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.occurrenceId = occurrenceId;
        return _x;
    }

    @Property(name="onlineMeeting")
    @JsonIgnore
    public Optional<OnlineMeetingInfo> getOnlineMeeting() {
        return Optional.ofNullable(onlineMeeting);
    }

    public Event withOnlineMeeting(OnlineMeetingInfo onlineMeeting) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("onlineMeeting");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.onlineMeeting = onlineMeeting;
        return _x;
    }

    @Property(name="onlineMeetingProvider")
    @JsonIgnore
    public Optional<OnlineMeetingProviderType> getOnlineMeetingProvider() {
        return Optional.ofNullable(onlineMeetingProvider);
    }

    public Event withOnlineMeetingProvider(OnlineMeetingProviderType onlineMeetingProvider) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("onlineMeetingProvider");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.onlineMeetingProvider = onlineMeetingProvider;
        return _x;
    }

    @Property(name="onlineMeetingUrl")
    @JsonIgnore
    public Optional<String> getOnlineMeetingUrl() {
        return Optional.ofNullable(onlineMeetingUrl);
    }

    public Event withOnlineMeetingUrl(String onlineMeetingUrl) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("onlineMeetingUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.onlineMeetingUrl = onlineMeetingUrl;
        return _x;
    }

    @Property(name="organizer")
    @JsonIgnore
    public Optional<Recipient> getOrganizer() {
        return Optional.ofNullable(organizer);
    }

    public Event withOrganizer(Recipient organizer) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("organizer");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.organizer = organizer;
        return _x;
    }

    @Property(name="originalEndTimeZone")
    @JsonIgnore
    public Optional<String> getOriginalEndTimeZone() {
        return Optional.ofNullable(originalEndTimeZone);
    }

    public Event withOriginalEndTimeZone(String originalEndTimeZone) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("originalEndTimeZone");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.originalEndTimeZone = originalEndTimeZone;
        return _x;
    }

    @Property(name="originalStart")
    @JsonIgnore
    public Optional<OffsetDateTime> getOriginalStart() {
        return Optional.ofNullable(originalStart);
    }

    public Event withOriginalStart(OffsetDateTime originalStart) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("originalStart");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.originalStart = originalStart;
        return _x;
    }

    @Property(name="originalStartTimeZone")
    @JsonIgnore
    public Optional<String> getOriginalStartTimeZone() {
        return Optional.ofNullable(originalStartTimeZone);
    }

    public Event withOriginalStartTimeZone(String originalStartTimeZone) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("originalStartTimeZone");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.originalStartTimeZone = originalStartTimeZone;
        return _x;
    }

    @Property(name="recurrence")
    @JsonIgnore
    public Optional<PatternedRecurrence> getRecurrence() {
        return Optional.ofNullable(recurrence);
    }

    public Event withRecurrence(PatternedRecurrence recurrence) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("recurrence");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.recurrence = recurrence;
        return _x;
    }

    @Property(name="reminderMinutesBeforeStart")
    @JsonIgnore
    public Optional<Integer> getReminderMinutesBeforeStart() {
        return Optional.ofNullable(reminderMinutesBeforeStart);
    }

    public Event withReminderMinutesBeforeStart(Integer reminderMinutesBeforeStart) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("reminderMinutesBeforeStart");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.reminderMinutesBeforeStart = reminderMinutesBeforeStart;
        return _x;
    }

    @Property(name="responseRequested")
    @JsonIgnore
    public Optional<Boolean> getResponseRequested() {
        return Optional.ofNullable(responseRequested);
    }

    public Event withResponseRequested(Boolean responseRequested) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("responseRequested");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.responseRequested = responseRequested;
        return _x;
    }

    @Property(name="responseStatus")
    @JsonIgnore
    public Optional<ResponseStatus> getResponseStatus() {
        return Optional.ofNullable(responseStatus);
    }

    public Event withResponseStatus(ResponseStatus responseStatus) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("responseStatus");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.responseStatus = responseStatus;
        return _x;
    }

    @Property(name="sensitivity")
    @JsonIgnore
    public Optional<Sensitivity> getSensitivity() {
        return Optional.ofNullable(sensitivity);
    }

    public Event withSensitivity(Sensitivity sensitivity) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("sensitivity");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.sensitivity = sensitivity;
        return _x;
    }

    @Property(name="seriesMasterId")
    @JsonIgnore
    public Optional<String> getSeriesMasterId() {
        return Optional.ofNullable(seriesMasterId);
    }

    public Event withSeriesMasterId(String seriesMasterId) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("seriesMasterId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.seriesMasterId = seriesMasterId;
        return _x;
    }

    @Property(name="showAs")
    @JsonIgnore
    public Optional<FreeBusyStatus> getShowAs() {
        return Optional.ofNullable(showAs);
    }

    public Event withShowAs(FreeBusyStatus showAs) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("showAs");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.showAs = showAs;
        return _x;
    }

    @Property(name="start")
    @JsonIgnore
    public Optional<DateTimeTimeZone> getStart() {
        return Optional.ofNullable(start);
    }

    public Event withStart(DateTimeTimeZone start) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("start");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.start = start;
        return _x;
    }

    @Property(name="subject")
    @JsonIgnore
    public Optional<String> getSubject() {
        return Optional.ofNullable(subject);
    }

    public Event withSubject(String subject) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("subject");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.subject = subject;
        return _x;
    }

    @Property(name="transactionId")
    @JsonIgnore
    public Optional<String> getTransactionId() {
        return Optional.ofNullable(transactionId);
    }

    public Event withTransactionId(String transactionId) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("transactionId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.transactionId = transactionId;
        return _x;
    }

    @Property(name="type")
    @JsonIgnore
    public Optional<EventType> getType() {
        return Optional.ofNullable(type);
    }

    public Event withType(EventType type) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("type");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.type = type;
        return _x;
    }

    @Property(name="uid")
    @JsonIgnore
    public Optional<String> getUid() {
        return Optional.ofNullable(uid);
    }

    public Event withUid(String uid) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("uid");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.uid = uid;
        return _x;
    }

    @Property(name="webLink")
    @JsonIgnore
    public Optional<String> getWebLink() {
        return Optional.ofNullable(webLink);
    }

    public Event withWebLink(String webLink) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("webLink");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.webLink = webLink;
        return _x;
    }

    public Event withUnmappedField(String name, Object value) {
        Event _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
     * <p>
     * Updatable = false
     * 
     * @return navigational property attachments
     */
    @NavigationProperty(name="attachments")
    @JsonIgnore
    public AttachmentCollectionRequest getAttachments() {
        return new AttachmentCollectionRequest(
                        contextPath.addSegment("attachments"), Optional.ofNullable(attachments));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
     * <p>
     * Deletable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
     * <p>
     * Insertable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.NavigationRestrictions</b>
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
     * <p>
     * Updatable = false
     * 
     * @return navigational property calendar
     */
    @NavigationProperty(name="calendar")
    @JsonIgnore
    public CalendarRequest getCalendar() {
        return new CalendarRequest(contextPath.addSegment("calendar"), Optional.ofNullable(calendar));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
     * <p>
     * Deletable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
     * <p>
     * Insertable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.NavigationRestrictions</b>
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
     * <p>
     * Updatable = false
     * 
     * @return navigational property exceptionOccurrences
     */
    @NavigationProperty(name="exceptionOccurrences")
    @JsonIgnore
    public EventCollectionRequest getExceptionOccurrences() {
        return new EventCollectionRequest(
                        contextPath.addSegment("exceptionOccurrences"), Optional.ofNullable(exceptionOccurrences));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * 
     * @return navigational property extensions
     */
    @NavigationProperty(name="extensions")
    @JsonIgnore
    public ExtensionCollectionRequest getExtensions() {
        return new ExtensionCollectionRequest(
                        contextPath.addSegment("extensions"), Optional.ofNullable(extensions));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
     * <p>
     * Deletable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
     * <p>
     * Insertable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.NavigationRestrictions</b>
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
     * <p>
     * Updatable = false
     * 
     * @return navigational property instances
     */
    @NavigationProperty(name="instances")
    @JsonIgnore
    public EventCollectionRequest getInstances() {
        return new EventCollectionRequest(
                        contextPath.addSegment("instances"), Optional.ofNullable(instances));
    }

    @NavigationProperty(name="multiValueExtendedProperties")
    @JsonIgnore
    public MultiValueLegacyExtendedPropertyCollectionRequest getMultiValueExtendedProperties() {
        return new MultiValueLegacyExtendedPropertyCollectionRequest(
                        contextPath.addSegment("multiValueExtendedProperties"), Optional.ofNullable(multiValueExtendedProperties));
    }

    @NavigationProperty(name="singleValueExtendedProperties")
    @JsonIgnore
    public SingleValueLegacyExtendedPropertyCollectionRequest getSingleValueExtendedProperties() {
        return new SingleValueLegacyExtendedPropertyCollectionRequest(
                        contextPath.addSegment("singleValueExtendedProperties"), Optional.ofNullable(singleValueExtendedProperties));
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code attachments}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
     * <p>
     * Updatable = false
     * 
     * @param attachments
     *            new value of {@code attachments} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code attachments} field changed
     */
    public Event withAttachments(List<Attachment> attachments) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("attachments");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.attachments = attachments;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code calendar} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
     * <p>
     * Deletable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
     * <p>
     * Insertable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.NavigationRestrictions</b>
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
     * <p>
     * Updatable = false
     * 
     * @param calendar
     *            new value of {@code calendar} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code calendar} field changed
     */
    public Event withCalendar(Calendar calendar) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("calendar");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.calendar = calendar;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * exceptionOccurrences} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
     * <p>
     * Deletable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
     * <p>
     * Insertable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.NavigationRestrictions</b>
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
     * <p>
     * Updatable = false
     * 
     * @param exceptionOccurrences
     *            new value of {@code exceptionOccurrences} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code exceptionOccurrences} field changed
     */
    public Event withExceptionOccurrences(List<Event> exceptionOccurrences) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("exceptionOccurrences");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.exceptionOccurrences = exceptionOccurrences;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code extensions} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * 
     * @param extensions
     *            new value of {@code extensions} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code extensions} field changed
     */
    public Event withExtensions(List<Extension> extensions) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("extensions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.extensions = extensions;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code instances} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
     * <p>
     * Deletable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
     * <p>
     * Insertable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.NavigationRestrictions</b>
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
     * <p>
     * Updatable = false
     * 
     * @param instances
     *            new value of {@code instances} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code instances} field changed
     */
    public Event withInstances(List<Event> instances) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("instances");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.instances = instances;
        return _x;
    }

    public Event withMultiValueExtendedProperties(List<MultiValueLegacyExtendedProperty> multiValueExtendedProperties) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("multiValueExtendedProperties");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.multiValueExtendedProperties = multiValueExtendedProperties;
        return _x;
    }

    public Event withSingleValueExtendedProperties(List<SingleValueLegacyExtendedProperty> singleValueExtendedProperties) {
        Event _x = _copy();
        _x.changedFields = changedFields.add("singleValueExtendedProperties");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.event");
        _x.singleValueExtendedProperties = singleValueExtendedProperties;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Event patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Event _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Event put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Event _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Event _copy() {
        Event _x = new Event();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.categories = categories;
        _x.changeKey = changeKey;
        _x.createdDateTime = createdDateTime;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.allowNewTimeProposals = allowNewTimeProposals;
        _x.attendees = attendees;
        _x.body = body;
        _x.bodyPreview = bodyPreview;
        _x.cancelledOccurrences = cancelledOccurrences;
        _x.end = end;
        _x.hasAttachments = hasAttachments;
        _x.hideAttendees = hideAttendees;
        _x.importance = importance;
        _x.isAllDay = isAllDay;
        _x.isCancelled = isCancelled;
        _x.isDraft = isDraft;
        _x.isOnlineMeeting = isOnlineMeeting;
        _x.isOrganizer = isOrganizer;
        _x.isReminderOn = isReminderOn;
        _x.location = location;
        _x.locations = locations;
        _x.occurrenceId = occurrenceId;
        _x.onlineMeeting = onlineMeeting;
        _x.onlineMeetingProvider = onlineMeetingProvider;
        _x.onlineMeetingUrl = onlineMeetingUrl;
        _x.organizer = organizer;
        _x.originalEndTimeZone = originalEndTimeZone;
        _x.originalStart = originalStart;
        _x.originalStartTimeZone = originalStartTimeZone;
        _x.recurrence = recurrence;
        _x.reminderMinutesBeforeStart = reminderMinutesBeforeStart;
        _x.responseRequested = responseRequested;
        _x.responseStatus = responseStatus;
        _x.sensitivity = sensitivity;
        _x.seriesMasterId = seriesMasterId;
        _x.showAs = showAs;
        _x.start = start;
        _x.subject = subject;
        _x.transactionId = transactionId;
        _x.type = type;
        _x.uid = uid;
        _x.webLink = webLink;
        _x.attachments = attachments;
        _x.calendar = calendar;
        _x.exceptionOccurrences = exceptionOccurrences;
        _x.extensions = extensions;
        _x.instances = instances;
        _x.multiValueExtendedProperties = multiValueExtendedProperties;
        _x.singleValueExtendedProperties = singleValueExtendedProperties;
        return _x;
    }

    @Action(name = "cancel")
    @JsonIgnore
    public ActionRequestNoReturn cancel(String comment) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Comment", "Edm.String", Checks.checkIsAscii(comment))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.cancel"), _parameters);
    }

    @Action(name = "accept")
    @JsonIgnore
    public ActionRequestNoReturn accept(Boolean sendResponse, String comment) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("SendResponse", "Edm.Boolean", sendResponse)
            .put("Comment", "Edm.String", Checks.checkIsAscii(comment))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.accept"), _parameters);
    }

    @Action(name = "decline")
    @JsonIgnore
    public ActionRequestNoReturn decline(TimeSlot proposedNewTime, Boolean sendResponse, String comment) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ProposedNewTime", "microsoft.graph.timeSlot", proposedNewTime)
            .put("SendResponse", "Edm.Boolean", sendResponse)
            .put("Comment", "Edm.String", Checks.checkIsAscii(comment))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.decline"), _parameters);
    }

    @Action(name = "dismissReminder")
    @JsonIgnore
    public ActionRequestNoReturn dismissReminder() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.dismissReminder"), _parameters);
    }

    @Action(name = "forward")
    @JsonIgnore
    public ActionRequestNoReturn forward(List<Recipient> toRecipients, String comment) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ToRecipients", "Collection(microsoft.graph.recipient)", toRecipients)
            .put("Comment", "Edm.String", Checks.checkIsAscii(comment))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.forward"), _parameters);
    }

    @Action(name = "snoozeReminder")
    @JsonIgnore
    public ActionRequestNoReturn snoozeReminder(DateTimeTimeZone newReminderTime) {
        Preconditions.checkNotNull(newReminderTime, "newReminderTime cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("NewReminderTime", "microsoft.graph.dateTimeTimeZone", newReminderTime)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.snoozeReminder"), _parameters);
    }

    @Action(name = "tentativelyAccept")
    @JsonIgnore
    public ActionRequestNoReturn tentativelyAccept(TimeSlot proposedNewTime, Boolean sendResponse, String comment) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ProposedNewTime", "microsoft.graph.timeSlot", proposedNewTime)
            .put("SendResponse", "Edm.Boolean", sendResponse)
            .put("Comment", "Edm.String", Checks.checkIsAscii(comment))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.tentativelyAccept"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Event[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("categories=");
        b.append(this.categories);
        b.append(", ");
        b.append("changeKey=");
        b.append(this.changeKey);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("allowNewTimeProposals=");
        b.append(this.allowNewTimeProposals);
        b.append(", ");
        b.append("attendees=");
        b.append(this.attendees);
        b.append(", ");
        b.append("body=");
        b.append(this.body);
        b.append(", ");
        b.append("bodyPreview=");
        b.append(this.bodyPreview);
        b.append(", ");
        b.append("cancelledOccurrences=");
        b.append(this.cancelledOccurrences);
        b.append(", ");
        b.append("end=");
        b.append(this.end);
        b.append(", ");
        b.append("hasAttachments=");
        b.append(this.hasAttachments);
        b.append(", ");
        b.append("hideAttendees=");
        b.append(this.hideAttendees);
        b.append(", ");
        b.append("importance=");
        b.append(this.importance);
        b.append(", ");
        b.append("isAllDay=");
        b.append(this.isAllDay);
        b.append(", ");
        b.append("isCancelled=");
        b.append(this.isCancelled);
        b.append(", ");
        b.append("isDraft=");
        b.append(this.isDraft);
        b.append(", ");
        b.append("isOnlineMeeting=");
        b.append(this.isOnlineMeeting);
        b.append(", ");
        b.append("isOrganizer=");
        b.append(this.isOrganizer);
        b.append(", ");
        b.append("isReminderOn=");
        b.append(this.isReminderOn);
        b.append(", ");
        b.append("location=");
        b.append(this.location);
        b.append(", ");
        b.append("locations=");
        b.append(this.locations);
        b.append(", ");
        b.append("occurrenceId=");
        b.append(this.occurrenceId);
        b.append(", ");
        b.append("onlineMeeting=");
        b.append(this.onlineMeeting);
        b.append(", ");
        b.append("onlineMeetingProvider=");
        b.append(this.onlineMeetingProvider);
        b.append(", ");
        b.append("onlineMeetingUrl=");
        b.append(this.onlineMeetingUrl);
        b.append(", ");
        b.append("organizer=");
        b.append(this.organizer);
        b.append(", ");
        b.append("originalEndTimeZone=");
        b.append(this.originalEndTimeZone);
        b.append(", ");
        b.append("originalStart=");
        b.append(this.originalStart);
        b.append(", ");
        b.append("originalStartTimeZone=");
        b.append(this.originalStartTimeZone);
        b.append(", ");
        b.append("recurrence=");
        b.append(this.recurrence);
        b.append(", ");
        b.append("reminderMinutesBeforeStart=");
        b.append(this.reminderMinutesBeforeStart);
        b.append(", ");
        b.append("responseRequested=");
        b.append(this.responseRequested);
        b.append(", ");
        b.append("responseStatus=");
        b.append(this.responseStatus);
        b.append(", ");
        b.append("sensitivity=");
        b.append(this.sensitivity);
        b.append(", ");
        b.append("seriesMasterId=");
        b.append(this.seriesMasterId);
        b.append(", ");
        b.append("showAs=");
        b.append(this.showAs);
        b.append(", ");
        b.append("start=");
        b.append(this.start);
        b.append(", ");
        b.append("subject=");
        b.append(this.subject);
        b.append(", ");
        b.append("transactionId=");
        b.append(this.transactionId);
        b.append(", ");
        b.append("type=");
        b.append(this.type);
        b.append(", ");
        b.append("uid=");
        b.append(this.uid);
        b.append(", ");
        b.append("webLink=");
        b.append(this.webLink);
        b.append(", ");
        b.append("attachments=");
        b.append(this.attachments);
        b.append(", ");
        b.append("calendar=");
        b.append(this.calendar);
        b.append(", ");
        b.append("exceptionOccurrences=");
        b.append(this.exceptionOccurrences);
        b.append(", ");
        b.append("extensions=");
        b.append(this.extensions);
        b.append(", ");
        b.append("instances=");
        b.append(this.instances);
        b.append(", ");
        b.append("multiValueExtendedProperties=");
        b.append(this.multiValueExtendedProperties);
        b.append(", ");
        b.append("singleValueExtendedProperties=");
        b.append(this.singleValueExtendedProperties);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
