package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.complex.ClassificationError;
import odata.msgraph.client.beta.complex.EvaluateLabelJobResultGroup;

@JsonPropertyOrder({
    "@odata.type", 
    "result"})
@JsonInclude(Include.NON_NULL)
public class EvaluateLabelJobResponse extends JobResponseBase implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.evaluateLabelJobResponse";
    }

    @JsonProperty("result")
    protected EvaluateLabelJobResultGroup result;

    protected EvaluateLabelJobResponse() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEvaluateLabelJobResponse() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime creationDateTime;
        private OffsetDateTime endDateTime;
        private ClassificationError error;
        private OffsetDateTime startDateTime;
        private String status;
        private String tenantId;
        private String type;
        private EvaluateLabelJobResultGroup result;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder creationDateTime(OffsetDateTime creationDateTime) {
            this.creationDateTime = creationDateTime;
            this.changedFields = changedFields.add("creationDateTime");
            return this;
        }

        public Builder endDateTime(OffsetDateTime endDateTime) {
            this.endDateTime = endDateTime;
            this.changedFields = changedFields.add("endDateTime");
            return this;
        }

        public Builder error(ClassificationError error) {
            this.error = error;
            this.changedFields = changedFields.add("error");
            return this;
        }

        public Builder startDateTime(OffsetDateTime startDateTime) {
            this.startDateTime = startDateTime;
            this.changedFields = changedFields.add("startDateTime");
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            this.changedFields = changedFields.add("tenantId");
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            this.changedFields = changedFields.add("type");
            return this;
        }

        public Builder result(EvaluateLabelJobResultGroup result) {
            this.result = result;
            this.changedFields = changedFields.add("result");
            return this;
        }

        public EvaluateLabelJobResponse build() {
            EvaluateLabelJobResponse _x = new EvaluateLabelJobResponse();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.evaluateLabelJobResponse";
            _x.id = id;
            _x.creationDateTime = creationDateTime;
            _x.endDateTime = endDateTime;
            _x.error = error;
            _x.startDateTime = startDateTime;
            _x.status = status;
            _x.tenantId = tenantId;
            _x.type = type;
            _x.result = result;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="result")
    @JsonIgnore
    public Optional<EvaluateLabelJobResultGroup> getResult() {
        return Optional.ofNullable(result);
    }

    public EvaluateLabelJobResponse withResult(EvaluateLabelJobResultGroup result) {
        EvaluateLabelJobResponse _x = _copy();
        _x.changedFields = changedFields.add("result");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.evaluateLabelJobResponse");
        _x.result = result;
        return _x;
    }

    public EvaluateLabelJobResponse withUnmappedField(String name, Object value) {
        EvaluateLabelJobResponse _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EvaluateLabelJobResponse patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        EvaluateLabelJobResponse _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EvaluateLabelJobResponse put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        EvaluateLabelJobResponse _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private EvaluateLabelJobResponse _copy() {
        EvaluateLabelJobResponse _x = new EvaluateLabelJobResponse();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.creationDateTime = creationDateTime;
        _x.endDateTime = endDateTime;
        _x.error = error;
        _x.startDateTime = startDateTime;
        _x.status = status;
        _x.tenantId = tenantId;
        _x.type = type;
        _x.result = result;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EvaluateLabelJobResponse[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("creationDateTime=");
        b.append(this.creationDateTime);
        b.append(", ");
        b.append("endDateTime=");
        b.append(this.endDateTime);
        b.append(", ");
        b.append("error=");
        b.append(this.error);
        b.append(", ");
        b.append("startDateTime=");
        b.append(this.startDateTime);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("tenantId=");
        b.append(this.tenantId);
        b.append(", ");
        b.append("type=");
        b.append(this.type);
        b.append(", ");
        b.append("result=");
        b.append(this.result);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
