package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.EducationSubmissionRecipient;
import odata.msgraph.client.beta.complex.IdentitySet;
import odata.msgraph.client.beta.entity.collection.request.EducationOutcomeCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EducationSubmissionResourceCollectionRequest;
import odata.msgraph.client.beta.enums.EducationSubmissionStatus;

@JsonPropertyOrder({
    "@odata.type", 
    "reassignedBy", 
    "reassignedDateTime", 
    "recipient", 
    "resourcesFolderUrl", 
    "returnedBy", 
    "returnedDateTime", 
    "status", 
    "submittedBy", 
    "submittedDateTime", 
    "unsubmittedBy", 
    "unsubmittedDateTime", 
    "outcomes", 
    "resources", 
    "submittedResources"})
@JsonInclude(Include.NON_NULL)
public class EducationSubmission extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.educationSubmission";
    }

    @JsonProperty("reassignedBy")
    protected IdentitySet reassignedBy;

    @JsonProperty("reassignedDateTime")
    protected OffsetDateTime reassignedDateTime;

    @JsonProperty("recipient")
    protected EducationSubmissionRecipient recipient;

    @JsonProperty("resourcesFolderUrl")
    protected String resourcesFolderUrl;

    @JsonProperty("returnedBy")
    protected IdentitySet returnedBy;

    @JsonProperty("returnedDateTime")
    protected OffsetDateTime returnedDateTime;

    @JsonProperty("status")
    protected EducationSubmissionStatus status;

    @JsonProperty("submittedBy")
    protected IdentitySet submittedBy;

    @JsonProperty("submittedDateTime")
    protected OffsetDateTime submittedDateTime;

    @JsonProperty("unsubmittedBy")
    protected IdentitySet unsubmittedBy;

    @JsonProperty("unsubmittedDateTime")
    protected OffsetDateTime unsubmittedDateTime;

    @JsonProperty("outcomes")
    protected List<EducationOutcome> outcomes;

    @JsonProperty("resources")
    protected List<EducationSubmissionResource> resources;

    @JsonProperty("submittedResources")
    protected List<EducationSubmissionResource> submittedResources;

    protected EducationSubmission() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEducationSubmission() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private IdentitySet reassignedBy;
        private OffsetDateTime reassignedDateTime;
        private EducationSubmissionRecipient recipient;
        private String resourcesFolderUrl;
        private IdentitySet returnedBy;
        private OffsetDateTime returnedDateTime;
        private EducationSubmissionStatus status;
        private IdentitySet submittedBy;
        private OffsetDateTime submittedDateTime;
        private IdentitySet unsubmittedBy;
        private OffsetDateTime unsubmittedDateTime;
        private List<EducationOutcome> outcomes;
        private List<EducationSubmissionResource> resources;
        private List<EducationSubmissionResource> submittedResources;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * 
         * @param reassignedBy
         *            value of {@code reassignedBy} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder reassignedBy(IdentitySet reassignedBy) {
            this.reassignedBy = reassignedBy;
            this.changedFields = changedFields.add("reassignedBy");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * 
         * @param reassignedDateTime
         *            value of {@code reassignedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder reassignedDateTime(OffsetDateTime reassignedDateTime) {
            this.reassignedDateTime = reassignedDateTime;
            this.changedFields = changedFields.add("reassignedDateTime");
            return this;
        }

        public Builder recipient(EducationSubmissionRecipient recipient) {
            this.recipient = recipient;
            this.changedFields = changedFields.add("recipient");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * 
         * @param resourcesFolderUrl
         *            value of {@code resourcesFolderUrl} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder resourcesFolderUrl(String resourcesFolderUrl) {
            this.resourcesFolderUrl = resourcesFolderUrl;
            this.changedFields = changedFields.add("resourcesFolderUrl");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * 
         * @param returnedBy
         *            value of {@code returnedBy} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder returnedBy(IdentitySet returnedBy) {
            this.returnedBy = returnedBy;
            this.changedFields = changedFields.add("returnedBy");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * 
         * @param returnedDateTime
         *            value of {@code returnedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder returnedDateTime(OffsetDateTime returnedDateTime) {
            this.returnedDateTime = returnedDateTime;
            this.changedFields = changedFields.add("returnedDateTime");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * 
         * @param status
         *            value of {@code status} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder status(EducationSubmissionStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * 
         * @param submittedBy
         *            value of {@code submittedBy} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder submittedBy(IdentitySet submittedBy) {
            this.submittedBy = submittedBy;
            this.changedFields = changedFields.add("submittedBy");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * 
         * @param submittedDateTime
         *            value of {@code submittedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder submittedDateTime(OffsetDateTime submittedDateTime) {
            this.submittedDateTime = submittedDateTime;
            this.changedFields = changedFields.add("submittedDateTime");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * 
         * @param unsubmittedBy
         *            value of {@code unsubmittedBy} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder unsubmittedBy(IdentitySet unsubmittedBy) {
            this.unsubmittedBy = unsubmittedBy;
            this.changedFields = changedFields.add("unsubmittedBy");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * 
         * @param unsubmittedDateTime
         *            value of {@code unsubmittedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder unsubmittedDateTime(OffsetDateTime unsubmittedDateTime) {
            this.unsubmittedDateTime = unsubmittedDateTime;
            this.changedFields = changedFields.add("unsubmittedDateTime");
            return this;
        }

        public Builder outcomes(List<EducationOutcome> outcomes) {
            this.outcomes = outcomes;
            this.changedFields = changedFields.add("outcomes");
            return this;
        }

        public Builder outcomes(EducationOutcome... outcomes) {
            return outcomes(Arrays.asList(outcomes));
        }

        public Builder resources(List<EducationSubmissionResource> resources) {
            this.resources = resources;
            this.changedFields = changedFields.add("resources");
            return this;
        }

        public Builder resources(EducationSubmissionResource... resources) {
            return resources(Arrays.asList(resources));
        }

        public Builder submittedResources(List<EducationSubmissionResource> submittedResources) {
            this.submittedResources = submittedResources;
            this.changedFields = changedFields.add("submittedResources");
            return this;
        }

        public Builder submittedResources(EducationSubmissionResource... submittedResources) {
            return submittedResources(Arrays.asList(submittedResources));
        }

        public EducationSubmission build() {
            EducationSubmission _x = new EducationSubmission();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.educationSubmission";
            _x.id = id;
            _x.reassignedBy = reassignedBy;
            _x.reassignedDateTime = reassignedDateTime;
            _x.recipient = recipient;
            _x.resourcesFolderUrl = resourcesFolderUrl;
            _x.returnedBy = returnedBy;
            _x.returnedDateTime = returnedDateTime;
            _x.status = status;
            _x.submittedBy = submittedBy;
            _x.submittedDateTime = submittedDateTime;
            _x.unsubmittedBy = unsubmittedBy;
            _x.unsubmittedDateTime = unsubmittedDateTime;
            _x.outcomes = outcomes;
            _x.resources = resources;
            _x.submittedResources = submittedResources;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @return property reassignedBy
     */
    @Property(name="reassignedBy")
    @JsonIgnore
    public Optional<IdentitySet> getReassignedBy() {
        return Optional.ofNullable(reassignedBy);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code reassignedBy}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @param reassignedBy
     *            new value of {@code reassignedBy} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code reassignedBy} field changed
     */
    public EducationSubmission withReassignedBy(IdentitySet reassignedBy) {
        EducationSubmission _x = _copy();
        _x.changedFields = changedFields.add("reassignedBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationSubmission");
        _x.reassignedBy = reassignedBy;
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @return property reassignedDateTime
     */
    @Property(name="reassignedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getReassignedDateTime() {
        return Optional.ofNullable(reassignedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * reassignedDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @param reassignedDateTime
     *            new value of {@code reassignedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code reassignedDateTime} field changed
     */
    public EducationSubmission withReassignedDateTime(OffsetDateTime reassignedDateTime) {
        EducationSubmission _x = _copy();
        _x.changedFields = changedFields.add("reassignedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationSubmission");
        _x.reassignedDateTime = reassignedDateTime;
        return _x;
    }

    @Property(name="recipient")
    @JsonIgnore
    public Optional<EducationSubmissionRecipient> getRecipient() {
        return Optional.ofNullable(recipient);
    }

    public EducationSubmission withRecipient(EducationSubmissionRecipient recipient) {
        EducationSubmission _x = _copy();
        _x.changedFields = changedFields.add("recipient");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationSubmission");
        _x.recipient = recipient;
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @return property resourcesFolderUrl
     */
    @Property(name="resourcesFolderUrl")
    @JsonIgnore
    public Optional<String> getResourcesFolderUrl() {
        return Optional.ofNullable(resourcesFolderUrl);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * resourcesFolderUrl} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @param resourcesFolderUrl
     *            new value of {@code resourcesFolderUrl} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code resourcesFolderUrl} field changed
     */
    public EducationSubmission withResourcesFolderUrl(String resourcesFolderUrl) {
        EducationSubmission _x = _copy();
        _x.changedFields = changedFields.add("resourcesFolderUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationSubmission");
        _x.resourcesFolderUrl = resourcesFolderUrl;
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @return property returnedBy
     */
    @Property(name="returnedBy")
    @JsonIgnore
    public Optional<IdentitySet> getReturnedBy() {
        return Optional.ofNullable(returnedBy);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code returnedBy} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @param returnedBy
     *            new value of {@code returnedBy} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code returnedBy} field changed
     */
    public EducationSubmission withReturnedBy(IdentitySet returnedBy) {
        EducationSubmission _x = _copy();
        _x.changedFields = changedFields.add("returnedBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationSubmission");
        _x.returnedBy = returnedBy;
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @return property returnedDateTime
     */
    @Property(name="returnedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getReturnedDateTime() {
        return Optional.ofNullable(returnedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code returnedDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @param returnedDateTime
     *            new value of {@code returnedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code returnedDateTime} field changed
     */
    public EducationSubmission withReturnedDateTime(OffsetDateTime returnedDateTime) {
        EducationSubmission _x = _copy();
        _x.changedFields = changedFields.add("returnedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationSubmission");
        _x.returnedDateTime = returnedDateTime;
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @return property status
     */
    @Property(name="status")
    @JsonIgnore
    public Optional<EducationSubmissionStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code status} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @param status
     *            new value of {@code status} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code status} field changed
     */
    public EducationSubmission withStatus(EducationSubmissionStatus status) {
        EducationSubmission _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationSubmission");
        _x.status = status;
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @return property submittedBy
     */
    @Property(name="submittedBy")
    @JsonIgnore
    public Optional<IdentitySet> getSubmittedBy() {
        return Optional.ofNullable(submittedBy);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code submittedBy}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @param submittedBy
     *            new value of {@code submittedBy} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code submittedBy} field changed
     */
    public EducationSubmission withSubmittedBy(IdentitySet submittedBy) {
        EducationSubmission _x = _copy();
        _x.changedFields = changedFields.add("submittedBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationSubmission");
        _x.submittedBy = submittedBy;
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @return property submittedDateTime
     */
    @Property(name="submittedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getSubmittedDateTime() {
        return Optional.ofNullable(submittedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code submittedDateTime
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @param submittedDateTime
     *            new value of {@code submittedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code submittedDateTime} field changed
     */
    public EducationSubmission withSubmittedDateTime(OffsetDateTime submittedDateTime) {
        EducationSubmission _x = _copy();
        _x.changedFields = changedFields.add("submittedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationSubmission");
        _x.submittedDateTime = submittedDateTime;
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @return property unsubmittedBy
     */
    @Property(name="unsubmittedBy")
    @JsonIgnore
    public Optional<IdentitySet> getUnsubmittedBy() {
        return Optional.ofNullable(unsubmittedBy);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code unsubmittedBy}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @param unsubmittedBy
     *            new value of {@code unsubmittedBy} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code unsubmittedBy} field changed
     */
    public EducationSubmission withUnsubmittedBy(IdentitySet unsubmittedBy) {
        EducationSubmission _x = _copy();
        _x.changedFields = changedFields.add("unsubmittedBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationSubmission");
        _x.unsubmittedBy = unsubmittedBy;
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @return property unsubmittedDateTime
     */
    @Property(name="unsubmittedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getUnsubmittedDateTime() {
        return Optional.ofNullable(unsubmittedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * unsubmittedDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @param unsubmittedDateTime
     *            new value of {@code unsubmittedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code unsubmittedDateTime} field changed
     */
    public EducationSubmission withUnsubmittedDateTime(OffsetDateTime unsubmittedDateTime) {
        EducationSubmission _x = _copy();
        _x.changedFields = changedFields.add("unsubmittedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationSubmission");
        _x.unsubmittedDateTime = unsubmittedDateTime;
        return _x;
    }

    public EducationSubmission withUnmappedField(String name, Object value) {
        EducationSubmission _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="outcomes")
    @JsonIgnore
    public EducationOutcomeCollectionRequest getOutcomes() {
        return new EducationOutcomeCollectionRequest(
                        contextPath.addSegment("outcomes"), Optional.ofNullable(outcomes));
    }

    @NavigationProperty(name="resources")
    @JsonIgnore
    public EducationSubmissionResourceCollectionRequest getResources() {
        return new EducationSubmissionResourceCollectionRequest(
                        contextPath.addSegment("resources"), Optional.ofNullable(resources));
    }

    @NavigationProperty(name="submittedResources")
    @JsonIgnore
    public EducationSubmissionResourceCollectionRequest getSubmittedResources() {
        return new EducationSubmissionResourceCollectionRequest(
                        contextPath.addSegment("submittedResources"), Optional.ofNullable(submittedResources));
    }

    public EducationSubmission withOutcomes(List<EducationOutcome> outcomes) {
        EducationSubmission _x = _copy();
        _x.changedFields = changedFields.add("outcomes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationSubmission");
        _x.outcomes = outcomes;
        return _x;
    }

    public EducationSubmission withResources(List<EducationSubmissionResource> resources) {
        EducationSubmission _x = _copy();
        _x.changedFields = changedFields.add("resources");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationSubmission");
        _x.resources = resources;
        return _x;
    }

    public EducationSubmission withSubmittedResources(List<EducationSubmissionResource> submittedResources) {
        EducationSubmission _x = _copy();
        _x.changedFields = changedFields.add("submittedResources");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationSubmission");
        _x.submittedResources = submittedResources;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EducationSubmission patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        EducationSubmission _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EducationSubmission put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        EducationSubmission _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private EducationSubmission _copy() {
        EducationSubmission _x = new EducationSubmission();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.reassignedBy = reassignedBy;
        _x.reassignedDateTime = reassignedDateTime;
        _x.recipient = recipient;
        _x.resourcesFolderUrl = resourcesFolderUrl;
        _x.returnedBy = returnedBy;
        _x.returnedDateTime = returnedDateTime;
        _x.status = status;
        _x.submittedBy = submittedBy;
        _x.submittedDateTime = submittedDateTime;
        _x.unsubmittedBy = unsubmittedBy;
        _x.unsubmittedDateTime = unsubmittedDateTime;
        _x.outcomes = outcomes;
        _x.resources = resources;
        _x.submittedResources = submittedResources;
        return _x;
    }

    @Action(name = "setUpResourcesFolder")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<EducationSubmission> setUpResourcesFolder() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<EducationSubmission>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.setUpResourcesFolder"), EducationSubmission.class, _parameters);
    }

    @Action(name = "reassign")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<EducationSubmission> reassign() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<EducationSubmission>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.reassign"), EducationSubmission.class, _parameters);
    }

    @Action(name = "return")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<EducationSubmission> return_() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<EducationSubmission>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.return"), EducationSubmission.class, _parameters);
    }

    @Action(name = "submit")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<EducationSubmission> submit() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<EducationSubmission>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.submit"), EducationSubmission.class, _parameters);
    }

    @Action(name = "unsubmit")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<EducationSubmission> unsubmit() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<EducationSubmission>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.unsubmit"), EducationSubmission.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EducationSubmission[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("reassignedBy=");
        b.append(this.reassignedBy);
        b.append(", ");
        b.append("reassignedDateTime=");
        b.append(this.reassignedDateTime);
        b.append(", ");
        b.append("recipient=");
        b.append(this.recipient);
        b.append(", ");
        b.append("resourcesFolderUrl=");
        b.append(this.resourcesFolderUrl);
        b.append(", ");
        b.append("returnedBy=");
        b.append(this.returnedBy);
        b.append(", ");
        b.append("returnedDateTime=");
        b.append(this.returnedDateTime);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("submittedBy=");
        b.append(this.submittedBy);
        b.append(", ");
        b.append("submittedDateTime=");
        b.append(this.submittedDateTime);
        b.append(", ");
        b.append("unsubmittedBy=");
        b.append(this.unsubmittedBy);
        b.append(", ");
        b.append("unsubmittedDateTime=");
        b.append(this.unsubmittedDateTime);
        b.append(", ");
        b.append("outcomes=");
        b.append(this.outcomes);
        b.append(", ");
        b.append("resources=");
        b.append(this.resources);
        b.append(", ");
        b.append("submittedResources=");
        b.append(this.submittedResources);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
