package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.IdentitySet;
import odata.msgraph.client.beta.complex.RubricQualityFeedbackModel;
import odata.msgraph.client.beta.complex.RubricQualitySelectedColumnModel;

@JsonPropertyOrder({
    "@odata.type", 
    "publishedRubricQualityFeedback", 
    "publishedRubricQualitySelectedLevels", 
    "rubricQualityFeedback", 
    "rubricQualitySelectedLevels"})
@JsonInclude(Include.NON_NULL)
public class EducationRubricOutcome extends EducationOutcome implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.educationRubricOutcome";
    }

    @JsonProperty("publishedRubricQualityFeedback")
    protected List<RubricQualityFeedbackModel> publishedRubricQualityFeedback;

    @JsonProperty("publishedRubricQualityFeedback@nextLink")
    protected String publishedRubricQualityFeedbackNextLink;

    @JsonProperty("publishedRubricQualitySelectedLevels")
    protected List<RubricQualitySelectedColumnModel> publishedRubricQualitySelectedLevels;

    @JsonProperty("publishedRubricQualitySelectedLevels@nextLink")
    protected String publishedRubricQualitySelectedLevelsNextLink;

    @JsonProperty("rubricQualityFeedback")
    protected List<RubricQualityFeedbackModel> rubricQualityFeedback;

    @JsonProperty("rubricQualityFeedback@nextLink")
    protected String rubricQualityFeedbackNextLink;

    @JsonProperty("rubricQualitySelectedLevels")
    protected List<RubricQualitySelectedColumnModel> rubricQualitySelectedLevels;

    @JsonProperty("rubricQualitySelectedLevels@nextLink")
    protected String rubricQualitySelectedLevelsNextLink;

    protected EducationRubricOutcome() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEducationRubricOutcome() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private IdentitySet lastModifiedBy;
        private OffsetDateTime lastModifiedDateTime;
        private List<RubricQualityFeedbackModel> publishedRubricQualityFeedback;
        private String publishedRubricQualityFeedbackNextLink;
        private List<RubricQualitySelectedColumnModel> publishedRubricQualitySelectedLevels;
        private String publishedRubricQualitySelectedLevelsNextLink;
        private List<RubricQualityFeedbackModel> rubricQualityFeedback;
        private String rubricQualityFeedbackNextLink;
        private List<RubricQualitySelectedColumnModel> rubricQualitySelectedLevels;
        private String rubricQualitySelectedLevelsNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder lastModifiedBy(IdentitySet lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            this.changedFields = changedFields.add("lastModifiedBy");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder publishedRubricQualityFeedback(List<RubricQualityFeedbackModel> publishedRubricQualityFeedback) {
            this.publishedRubricQualityFeedback = publishedRubricQualityFeedback;
            this.changedFields = changedFields.add("publishedRubricQualityFeedback");
            return this;
        }

        public Builder publishedRubricQualityFeedback(RubricQualityFeedbackModel... publishedRubricQualityFeedback) {
            return publishedRubricQualityFeedback(Arrays.asList(publishedRubricQualityFeedback));
        }

        public Builder publishedRubricQualityFeedbackNextLink(String publishedRubricQualityFeedbackNextLink) {
            this.publishedRubricQualityFeedbackNextLink = publishedRubricQualityFeedbackNextLink;
            this.changedFields = changedFields.add("publishedRubricQualityFeedback");
            return this;
        }

        public Builder publishedRubricQualitySelectedLevels(List<RubricQualitySelectedColumnModel> publishedRubricQualitySelectedLevels) {
            this.publishedRubricQualitySelectedLevels = publishedRubricQualitySelectedLevels;
            this.changedFields = changedFields.add("publishedRubricQualitySelectedLevels");
            return this;
        }

        public Builder publishedRubricQualitySelectedLevels(RubricQualitySelectedColumnModel... publishedRubricQualitySelectedLevels) {
            return publishedRubricQualitySelectedLevels(Arrays.asList(publishedRubricQualitySelectedLevels));
        }

        public Builder publishedRubricQualitySelectedLevelsNextLink(String publishedRubricQualitySelectedLevelsNextLink) {
            this.publishedRubricQualitySelectedLevelsNextLink = publishedRubricQualitySelectedLevelsNextLink;
            this.changedFields = changedFields.add("publishedRubricQualitySelectedLevels");
            return this;
        }

        public Builder rubricQualityFeedback(List<RubricQualityFeedbackModel> rubricQualityFeedback) {
            this.rubricQualityFeedback = rubricQualityFeedback;
            this.changedFields = changedFields.add("rubricQualityFeedback");
            return this;
        }

        public Builder rubricQualityFeedback(RubricQualityFeedbackModel... rubricQualityFeedback) {
            return rubricQualityFeedback(Arrays.asList(rubricQualityFeedback));
        }

        public Builder rubricQualityFeedbackNextLink(String rubricQualityFeedbackNextLink) {
            this.rubricQualityFeedbackNextLink = rubricQualityFeedbackNextLink;
            this.changedFields = changedFields.add("rubricQualityFeedback");
            return this;
        }

        public Builder rubricQualitySelectedLevels(List<RubricQualitySelectedColumnModel> rubricQualitySelectedLevels) {
            this.rubricQualitySelectedLevels = rubricQualitySelectedLevels;
            this.changedFields = changedFields.add("rubricQualitySelectedLevels");
            return this;
        }

        public Builder rubricQualitySelectedLevels(RubricQualitySelectedColumnModel... rubricQualitySelectedLevels) {
            return rubricQualitySelectedLevels(Arrays.asList(rubricQualitySelectedLevels));
        }

        public Builder rubricQualitySelectedLevelsNextLink(String rubricQualitySelectedLevelsNextLink) {
            this.rubricQualitySelectedLevelsNextLink = rubricQualitySelectedLevelsNextLink;
            this.changedFields = changedFields.add("rubricQualitySelectedLevels");
            return this;
        }

        public EducationRubricOutcome build() {
            EducationRubricOutcome _x = new EducationRubricOutcome();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.educationRubricOutcome";
            _x.id = id;
            _x.lastModifiedBy = lastModifiedBy;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.publishedRubricQualityFeedback = publishedRubricQualityFeedback;
            _x.publishedRubricQualityFeedbackNextLink = publishedRubricQualityFeedbackNextLink;
            _x.publishedRubricQualitySelectedLevels = publishedRubricQualitySelectedLevels;
            _x.publishedRubricQualitySelectedLevelsNextLink = publishedRubricQualitySelectedLevelsNextLink;
            _x.rubricQualityFeedback = rubricQualityFeedback;
            _x.rubricQualityFeedbackNextLink = rubricQualityFeedbackNextLink;
            _x.rubricQualitySelectedLevels = rubricQualitySelectedLevels;
            _x.rubricQualitySelectedLevelsNextLink = rubricQualitySelectedLevelsNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="publishedRubricQualityFeedback")
    @JsonIgnore
    public CollectionPage<RubricQualityFeedbackModel> getPublishedRubricQualityFeedback() {
        return new CollectionPage<RubricQualityFeedbackModel>(contextPath, RubricQualityFeedbackModel.class, this.publishedRubricQualityFeedback, Optional.ofNullable(publishedRubricQualityFeedbackNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public EducationRubricOutcome withPublishedRubricQualityFeedback(List<RubricQualityFeedbackModel> publishedRubricQualityFeedback) {
        EducationRubricOutcome _x = _copy();
        _x.changedFields = changedFields.add("publishedRubricQualityFeedback");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationRubricOutcome");
        _x.publishedRubricQualityFeedback = publishedRubricQualityFeedback;
        return _x;
    }

    @Property(name="publishedRubricQualityFeedback")
    @JsonIgnore
    public CollectionPage<RubricQualityFeedbackModel> getPublishedRubricQualityFeedback(HttpRequestOptions options) {
        return new CollectionPage<RubricQualityFeedbackModel>(contextPath, RubricQualityFeedbackModel.class, this.publishedRubricQualityFeedback, Optional.ofNullable(publishedRubricQualityFeedbackNextLink), Collections.emptyList(), options);
    }

    @Property(name="publishedRubricQualitySelectedLevels")
    @JsonIgnore
    public CollectionPage<RubricQualitySelectedColumnModel> getPublishedRubricQualitySelectedLevels() {
        return new CollectionPage<RubricQualitySelectedColumnModel>(contextPath, RubricQualitySelectedColumnModel.class, this.publishedRubricQualitySelectedLevels, Optional.ofNullable(publishedRubricQualitySelectedLevelsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public EducationRubricOutcome withPublishedRubricQualitySelectedLevels(List<RubricQualitySelectedColumnModel> publishedRubricQualitySelectedLevels) {
        EducationRubricOutcome _x = _copy();
        _x.changedFields = changedFields.add("publishedRubricQualitySelectedLevels");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationRubricOutcome");
        _x.publishedRubricQualitySelectedLevels = publishedRubricQualitySelectedLevels;
        return _x;
    }

    @Property(name="publishedRubricQualitySelectedLevels")
    @JsonIgnore
    public CollectionPage<RubricQualitySelectedColumnModel> getPublishedRubricQualitySelectedLevels(HttpRequestOptions options) {
        return new CollectionPage<RubricQualitySelectedColumnModel>(contextPath, RubricQualitySelectedColumnModel.class, this.publishedRubricQualitySelectedLevels, Optional.ofNullable(publishedRubricQualitySelectedLevelsNextLink), Collections.emptyList(), options);
    }

    @Property(name="rubricQualityFeedback")
    @JsonIgnore
    public CollectionPage<RubricQualityFeedbackModel> getRubricQualityFeedback() {
        return new CollectionPage<RubricQualityFeedbackModel>(contextPath, RubricQualityFeedbackModel.class, this.rubricQualityFeedback, Optional.ofNullable(rubricQualityFeedbackNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public EducationRubricOutcome withRubricQualityFeedback(List<RubricQualityFeedbackModel> rubricQualityFeedback) {
        EducationRubricOutcome _x = _copy();
        _x.changedFields = changedFields.add("rubricQualityFeedback");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationRubricOutcome");
        _x.rubricQualityFeedback = rubricQualityFeedback;
        return _x;
    }

    @Property(name="rubricQualityFeedback")
    @JsonIgnore
    public CollectionPage<RubricQualityFeedbackModel> getRubricQualityFeedback(HttpRequestOptions options) {
        return new CollectionPage<RubricQualityFeedbackModel>(contextPath, RubricQualityFeedbackModel.class, this.rubricQualityFeedback, Optional.ofNullable(rubricQualityFeedbackNextLink), Collections.emptyList(), options);
    }

    @Property(name="rubricQualitySelectedLevels")
    @JsonIgnore
    public CollectionPage<RubricQualitySelectedColumnModel> getRubricQualitySelectedLevels() {
        return new CollectionPage<RubricQualitySelectedColumnModel>(contextPath, RubricQualitySelectedColumnModel.class, this.rubricQualitySelectedLevels, Optional.ofNullable(rubricQualitySelectedLevelsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public EducationRubricOutcome withRubricQualitySelectedLevels(List<RubricQualitySelectedColumnModel> rubricQualitySelectedLevels) {
        EducationRubricOutcome _x = _copy();
        _x.changedFields = changedFields.add("rubricQualitySelectedLevels");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationRubricOutcome");
        _x.rubricQualitySelectedLevels = rubricQualitySelectedLevels;
        return _x;
    }

    @Property(name="rubricQualitySelectedLevels")
    @JsonIgnore
    public CollectionPage<RubricQualitySelectedColumnModel> getRubricQualitySelectedLevels(HttpRequestOptions options) {
        return new CollectionPage<RubricQualitySelectedColumnModel>(contextPath, RubricQualitySelectedColumnModel.class, this.rubricQualitySelectedLevels, Optional.ofNullable(rubricQualitySelectedLevelsNextLink), Collections.emptyList(), options);
    }

    public EducationRubricOutcome withUnmappedField(String name, Object value) {
        EducationRubricOutcome _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EducationRubricOutcome patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        EducationRubricOutcome _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EducationRubricOutcome put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        EducationRubricOutcome _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private EducationRubricOutcome _copy() {
        EducationRubricOutcome _x = new EducationRubricOutcome();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.lastModifiedBy = lastModifiedBy;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.publishedRubricQualityFeedback = publishedRubricQualityFeedback;
        _x.publishedRubricQualitySelectedLevels = publishedRubricQualitySelectedLevels;
        _x.rubricQualityFeedback = rubricQualityFeedback;
        _x.rubricQualitySelectedLevels = rubricQualitySelectedLevels;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EducationRubricOutcome[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("lastModifiedBy=");
        b.append(this.lastModifiedBy);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("publishedRubricQualityFeedback=");
        b.append(this.publishedRubricQualityFeedback);
        b.append(", ");
        b.append("publishedRubricQualitySelectedLevels=");
        b.append(this.publishedRubricQualitySelectedLevels);
        b.append(", ");
        b.append("rubricQualityFeedback=");
        b.append(this.rubricQualityFeedback);
        b.append(", ");
        b.append("rubricQualitySelectedLevels=");
        b.append(this.rubricQualitySelectedLevels);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
