package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.EducationClassCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EducationSchoolCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EducationSynchronizationProfileCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EducationUserCollectionRequest;
import odata.msgraph.client.beta.entity.request.EducationUserRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "synchronizationProfiles", 
    "classes", 
    "me", 
    "schools", 
    "users"})
@JsonInclude(Include.NON_NULL)
public class EducationRoot implements ODataEntityType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JacksonInject
    @JsonIgnore
    protected ChangedFields changedFields;

    @Override
    public String odataTypeName() {
        return "microsoft.graph.educationRoot";
    }

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("synchronizationProfiles")
    protected List<EducationSynchronizationProfile> synchronizationProfiles;

    @JsonProperty("classes")
    protected List<EducationClass> classes;

    @JsonProperty("me")
    protected EducationUser me;

    @JsonProperty("schools")
    protected List<EducationSchool> schools;

    @JsonProperty("users")
    protected List<EducationUser> users;

    protected EducationRoot() {
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<EducationSynchronizationProfile> synchronizationProfiles;
        private List<EducationClass> classes;
        private EducationUser me;
        private List<EducationSchool> schools;
        private List<EducationUser> users;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder synchronizationProfiles(List<EducationSynchronizationProfile> synchronizationProfiles) {
            this.synchronizationProfiles = synchronizationProfiles;
            this.changedFields = changedFields.add("synchronizationProfiles");
            return this;
        }

        public Builder synchronizationProfiles(EducationSynchronizationProfile... synchronizationProfiles) {
            return synchronizationProfiles(Arrays.asList(synchronizationProfiles));
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = true
         * 
         * @param classes
         *            value of {@code classes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder classes(List<EducationClass> classes) {
            this.classes = classes;
            this.changedFields = changedFields.add("classes");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = true
         * 
         * @param classes
         *            value of {@code classes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder classes(EducationClass... classes) {
            return classes(Arrays.asList(classes));
        }

        public Builder me(EducationUser me) {
            this.me = me;
            this.changedFields = changedFields.add("me");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = true
         * 
         * @param schools
         *            value of {@code schools} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder schools(List<EducationSchool> schools) {
            this.schools = schools;
            this.changedFields = changedFields.add("schools");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = true
         * 
         * @param schools
         *            value of {@code schools} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder schools(EducationSchool... schools) {
            return schools(Arrays.asList(schools));
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = true
         * 
         * @param users
         *            value of {@code users} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder users(List<EducationUser> users) {
            this.users = users;
            this.changedFields = changedFields.add("users");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = true
         * 
         * @param users
         *            value of {@code users} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder users(EducationUser... users) {
            return users(Arrays.asList(users));
        }

        public EducationRoot build() {
            EducationRoot _x = new EducationRoot();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.educationRoot";
            _x.synchronizationProfiles = synchronizationProfiles;
            _x.classes = classes;
            _x.me = me;
            _x.schools = schools;
            _x.users = users;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath) {
            contextPath = contextPath.clearQueries();
        }
    }

    public EducationRoot withUnmappedField(String name, Object value) {
        EducationRoot _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="synchronizationProfiles")
    @JsonIgnore
    public EducationSynchronizationProfileCollectionRequest getSynchronizationProfiles() {
        return new EducationSynchronizationProfileCollectionRequest(
                        contextPath.addSegment("synchronizationProfiles"), Optional.ofNullable(synchronizationProfiles));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = true
     * 
     * @return navigational property classes
     */
    @NavigationProperty(name="classes")
    @JsonIgnore
    public EducationClassCollectionRequest getClasses() {
        return new EducationClassCollectionRequest(
                        contextPath.addSegment("classes"), Optional.ofNullable(classes));
    }

    @NavigationProperty(name="me")
    @JsonIgnore
    public EducationUserRequest getMe() {
        return new EducationUserRequest(contextPath.addSegment("me"), Optional.ofNullable(me));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = true
     * 
     * @return navigational property schools
     */
    @NavigationProperty(name="schools")
    @JsonIgnore
    public EducationSchoolCollectionRequest getSchools() {
        return new EducationSchoolCollectionRequest(
                        contextPath.addSegment("schools"), Optional.ofNullable(schools));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = true
     * 
     * @return navigational property users
     */
    @NavigationProperty(name="users")
    @JsonIgnore
    public EducationUserCollectionRequest getUsers() {
        return new EducationUserCollectionRequest(
                        contextPath.addSegment("users"), Optional.ofNullable(users));
    }

    public EducationRoot withSynchronizationProfiles(List<EducationSynchronizationProfile> synchronizationProfiles) {
        EducationRoot _x = _copy();
        _x.changedFields = changedFields.add("synchronizationProfiles");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationRoot");
        _x.synchronizationProfiles = synchronizationProfiles;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code classes} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = true
     * 
     * @param classes
     *            new value of {@code classes} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code classes} field changed
     */
    public EducationRoot withClasses(List<EducationClass> classes) {
        EducationRoot _x = _copy();
        _x.changedFields = changedFields.add("classes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationRoot");
        _x.classes = classes;
        return _x;
    }

    public EducationRoot withMe(EducationUser me) {
        EducationRoot _x = _copy();
        _x.changedFields = changedFields.add("me");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationRoot");
        _x.me = me;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code schools} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = true
     * 
     * @param schools
     *            new value of {@code schools} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code schools} field changed
     */
    public EducationRoot withSchools(List<EducationSchool> schools) {
        EducationRoot _x = _copy();
        _x.changedFields = changedFields.add("schools");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationRoot");
        _x.schools = schools;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code users} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = true
     * 
     * @param users
     *            new value of {@code users} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code users} field changed
     */
    public EducationRoot withUsers(List<EducationUser> users) {
        EducationRoot _x = _copy();
        _x.changedFields = changedFields.add("users");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationRoot");
        _x.users = users;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EducationRoot patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        EducationRoot _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EducationRoot put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        EducationRoot _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private EducationRoot _copy() {
        EducationRoot _x = new EducationRoot();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.synchronizationProfiles = synchronizationProfiles;
        _x.classes = classes;
        _x.me = me;
        _x.schools = schools;
        _x.users = users;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EducationRoot[");
        b.append("synchronizationProfiles=");
        b.append(this.synchronizationProfiles);
        b.append(", ");
        b.append("classes=");
        b.append(this.classes);
        b.append(", ");
        b.append("me=");
        b.append(this.me);
        b.append(", ");
        b.append("schools=");
        b.append(this.schools);
        b.append(", ");
        b.append("users=");
        b.append(this.users);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
