package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.complex.EducationAssignmentPointsGrade;
import odata.msgraph.client.beta.complex.IdentitySet;

@JsonPropertyOrder({
    "@odata.type", 
    "points", 
    "publishedPoints"})
@JsonInclude(Include.NON_NULL)
public class EducationPointsOutcome extends EducationOutcome implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.educationPointsOutcome";
    }

    @JsonProperty("points")
    protected EducationAssignmentPointsGrade points;

    @JsonProperty("publishedPoints")
    protected EducationAssignmentPointsGrade publishedPoints;

    protected EducationPointsOutcome() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEducationPointsOutcome() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private IdentitySet lastModifiedBy;
        private OffsetDateTime lastModifiedDateTime;
        private EducationAssignmentPointsGrade points;
        private EducationAssignmentPointsGrade publishedPoints;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder lastModifiedBy(IdentitySet lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            this.changedFields = changedFields.add("lastModifiedBy");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder points(EducationAssignmentPointsGrade points) {
            this.points = points;
            this.changedFields = changedFields.add("points");
            return this;
        }

        public Builder publishedPoints(EducationAssignmentPointsGrade publishedPoints) {
            this.publishedPoints = publishedPoints;
            this.changedFields = changedFields.add("publishedPoints");
            return this;
        }

        public EducationPointsOutcome build() {
            EducationPointsOutcome _x = new EducationPointsOutcome();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.educationPointsOutcome";
            _x.id = id;
            _x.lastModifiedBy = lastModifiedBy;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.points = points;
            _x.publishedPoints = publishedPoints;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="points")
    @JsonIgnore
    public Optional<EducationAssignmentPointsGrade> getPoints() {
        return Optional.ofNullable(points);
    }

    public EducationPointsOutcome withPoints(EducationAssignmentPointsGrade points) {
        EducationPointsOutcome _x = _copy();
        _x.changedFields = changedFields.add("points");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationPointsOutcome");
        _x.points = points;
        return _x;
    }

    @Property(name="publishedPoints")
    @JsonIgnore
    public Optional<EducationAssignmentPointsGrade> getPublishedPoints() {
        return Optional.ofNullable(publishedPoints);
    }

    public EducationPointsOutcome withPublishedPoints(EducationAssignmentPointsGrade publishedPoints) {
        EducationPointsOutcome _x = _copy();
        _x.changedFields = changedFields.add("publishedPoints");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationPointsOutcome");
        _x.publishedPoints = publishedPoints;
        return _x;
    }

    public EducationPointsOutcome withUnmappedField(String name, Object value) {
        EducationPointsOutcome _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EducationPointsOutcome patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        EducationPointsOutcome _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EducationPointsOutcome put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        EducationPointsOutcome _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private EducationPointsOutcome _copy() {
        EducationPointsOutcome _x = new EducationPointsOutcome();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.lastModifiedBy = lastModifiedBy;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.points = points;
        _x.publishedPoints = publishedPoints;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EducationPointsOutcome[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("lastModifiedBy=");
        b.append(this.lastModifiedBy);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("points=");
        b.append(this.points);
        b.append(", ");
        b.append("publishedPoints=");
        b.append(this.publishedPoints);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
