package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.LocalTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.EducationAddToCalendarOptions;
import odata.msgraph.client.beta.enums.EducationAddedStudentAction;

@JsonPropertyOrder({
    "@odata.type", 
    "addedStudentAction", 
    "addToCalendarAction", 
    "dueTime", 
    "notificationChannelUrl"})
@JsonInclude(Include.NON_NULL)
public class EducationAssignmentDefaults extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.educationAssignmentDefaults";
    }

    @JsonProperty("addedStudentAction")
    protected EducationAddedStudentAction addedStudentAction;

    @JsonProperty("addToCalendarAction")
    protected EducationAddToCalendarOptions addToCalendarAction;

    @JsonProperty("dueTime")
    protected LocalTime dueTime;

    @JsonProperty("notificationChannelUrl")
    protected String notificationChannelUrl;

    protected EducationAssignmentDefaults() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEducationAssignmentDefaults() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private EducationAddedStudentAction addedStudentAction;
        private EducationAddToCalendarOptions addToCalendarAction;
        private LocalTime dueTime;
        private String notificationChannelUrl;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder addedStudentAction(EducationAddedStudentAction addedStudentAction) {
            this.addedStudentAction = addedStudentAction;
            this.changedFields = changedFields.add("addedStudentAction");
            return this;
        }

        public Builder addToCalendarAction(EducationAddToCalendarOptions addToCalendarAction) {
            this.addToCalendarAction = addToCalendarAction;
            this.changedFields = changedFields.add("addToCalendarAction");
            return this;
        }

        public Builder dueTime(LocalTime dueTime) {
            this.dueTime = dueTime;
            this.changedFields = changedFields.add("dueTime");
            return this;
        }

        public Builder notificationChannelUrl(String notificationChannelUrl) {
            this.notificationChannelUrl = notificationChannelUrl;
            this.changedFields = changedFields.add("notificationChannelUrl");
            return this;
        }

        public EducationAssignmentDefaults build() {
            EducationAssignmentDefaults _x = new EducationAssignmentDefaults();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.educationAssignmentDefaults";
            _x.id = id;
            _x.addedStudentAction = addedStudentAction;
            _x.addToCalendarAction = addToCalendarAction;
            _x.dueTime = dueTime;
            _x.notificationChannelUrl = notificationChannelUrl;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="addedStudentAction")
    @JsonIgnore
    public Optional<EducationAddedStudentAction> getAddedStudentAction() {
        return Optional.ofNullable(addedStudentAction);
    }

    public EducationAssignmentDefaults withAddedStudentAction(EducationAddedStudentAction addedStudentAction) {
        EducationAssignmentDefaults _x = _copy();
        _x.changedFields = changedFields.add("addedStudentAction");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationAssignmentDefaults");
        _x.addedStudentAction = addedStudentAction;
        return _x;
    }

    @Property(name="addToCalendarAction")
    @JsonIgnore
    public Optional<EducationAddToCalendarOptions> getAddToCalendarAction() {
        return Optional.ofNullable(addToCalendarAction);
    }

    public EducationAssignmentDefaults withAddToCalendarAction(EducationAddToCalendarOptions addToCalendarAction) {
        EducationAssignmentDefaults _x = _copy();
        _x.changedFields = changedFields.add("addToCalendarAction");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationAssignmentDefaults");
        _x.addToCalendarAction = addToCalendarAction;
        return _x;
    }

    @Property(name="dueTime")
    @JsonIgnore
    public Optional<LocalTime> getDueTime() {
        return Optional.ofNullable(dueTime);
    }

    public EducationAssignmentDefaults withDueTime(LocalTime dueTime) {
        EducationAssignmentDefaults _x = _copy();
        _x.changedFields = changedFields.add("dueTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationAssignmentDefaults");
        _x.dueTime = dueTime;
        return _x;
    }

    @Property(name="notificationChannelUrl")
    @JsonIgnore
    public Optional<String> getNotificationChannelUrl() {
        return Optional.ofNullable(notificationChannelUrl);
    }

    public EducationAssignmentDefaults withNotificationChannelUrl(String notificationChannelUrl) {
        EducationAssignmentDefaults _x = _copy();
        _x.changedFields = changedFields.add("notificationChannelUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationAssignmentDefaults");
        _x.notificationChannelUrl = notificationChannelUrl;
        return _x;
    }

    public EducationAssignmentDefaults withUnmappedField(String name, Object value) {
        EducationAssignmentDefaults _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EducationAssignmentDefaults patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        EducationAssignmentDefaults _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public EducationAssignmentDefaults put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        EducationAssignmentDefaults _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private EducationAssignmentDefaults _copy() {
        EducationAssignmentDefaults _x = new EducationAssignmentDefaults();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.addedStudentAction = addedStudentAction;
        _x.addToCalendarAction = addToCalendarAction;
        _x.dueTime = dueTime;
        _x.notificationChannelUrl = notificationChannelUrl;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EducationAssignmentDefaults[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("addedStudentAction=");
        b.append(this.addedStudentAction);
        b.append(", ");
        b.append("addToCalendarAction=");
        b.append(this.addToCalendarAction);
        b.append(", ");
        b.append("dueTime=");
        b.append(this.dueTime);
        b.append(", ");
        b.append("notificationChannelUrl=");
        b.append(this.notificationChannelUrl);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
