package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.HttpMethod;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.StreamProvider;
import com.github.davidmoten.odata.client.StreamUploader;
import com.github.davidmoten.odata.client.StreamUploaderChunked;
import com.github.davidmoten.odata.client.StreamUploaderSingleCall;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.UploadStrategy;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Double;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.Audio;
import odata.msgraph.client.beta.complex.Bundle;
import odata.msgraph.client.beta.complex.Deleted;
import odata.msgraph.client.beta.complex.DriveItemSource;
import odata.msgraph.client.beta.complex.DriveItemUploadableProperties;
import odata.msgraph.client.beta.complex.DriveRecipient;
import odata.msgraph.client.beta.complex.File;
import odata.msgraph.client.beta.complex.FileSystemInfo;
import odata.msgraph.client.beta.complex.Folder;
import odata.msgraph.client.beta.complex.GeoCoordinates;
import odata.msgraph.client.beta.complex.IdentitySet;
import odata.msgraph.client.beta.complex.Image;
import odata.msgraph.client.beta.complex.ItemPreviewInfo;
import odata.msgraph.client.beta.complex.ItemReference;
import odata.msgraph.client.beta.complex.Malware;
import odata.msgraph.client.beta.complex.Media;
import odata.msgraph.client.beta.complex.Package;
import odata.msgraph.client.beta.complex.PendingOperations;
import odata.msgraph.client.beta.complex.Photo;
import odata.msgraph.client.beta.complex.PublicationFacet;
import odata.msgraph.client.beta.complex.RemoteItem;
import odata.msgraph.client.beta.complex.Root;
import odata.msgraph.client.beta.complex.SearchResult;
import odata.msgraph.client.beta.complex.Shared;
import odata.msgraph.client.beta.complex.SharepointIds;
import odata.msgraph.client.beta.complex.SpecialFolder;
import odata.msgraph.client.beta.complex.UploadSession;
import odata.msgraph.client.beta.complex.Video;
import odata.msgraph.client.beta.entity.collection.request.DriveItemCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DriveItemVersionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ItemActivityOLDCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PermissionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SubscriptionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ThumbnailSetCollectionRequest;
import odata.msgraph.client.beta.entity.request.ItemAnalyticsRequest;
import odata.msgraph.client.beta.entity.request.ListItemRequest;
import odata.msgraph.client.beta.entity.request.WorkbookRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "audio", 
    "bundle", 
    "content", 
    "cTag", 
    "deleted", 
    "file", 
    "fileSystemInfo", 
    "folder", 
    "image", 
    "location", 
    "malware", 
    "media", 
    "package", 
    "pendingOperations", 
    "photo", 
    "publication", 
    "remoteItem", 
    "root", 
    "searchResult", 
    "shared", 
    "sharepointIds", 
    "size", 
    "source", 
    "specialFolder", 
    "video", 
    "webDavUrl", 
    "workbook", 
    "activities", 
    "children", 
    "listItem", 
    "permissions", 
    "subscriptions", 
    "thumbnails", 
    "versions"})
@JsonInclude(Include.NON_NULL)
public class DriveItem extends BaseItem implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.driveItem";
    }

    @JsonProperty("audio")
    protected Audio audio;

    @JsonProperty("bundle")
    protected Bundle bundle;

    @JsonProperty("content")
    protected String content;

    @JsonProperty("cTag")
    protected String cTag;

    @JsonProperty("deleted")
    protected Deleted deleted;

    @JsonProperty("file")
    protected File file;

    @JsonProperty("fileSystemInfo")
    protected FileSystemInfo fileSystemInfo;

    @JsonProperty("folder")
    protected Folder folder;

    @JsonProperty("image")
    protected Image image;

    @JsonProperty("location")
    protected GeoCoordinates location;

    @JsonProperty("malware")
    protected Malware malware;

    @JsonProperty("media")
    protected Media media;

    @JsonProperty("package")
    protected Package package_;

    @JsonProperty("pendingOperations")
    protected PendingOperations pendingOperations;

    @JsonProperty("photo")
    protected Photo photo;

    @JsonProperty("publication")
    protected PublicationFacet publication;

    @JsonProperty("remoteItem")
    protected RemoteItem remoteItem;

    @JsonProperty("root")
    protected Root root;

    @JsonProperty("searchResult")
    protected SearchResult searchResult;

    @JsonProperty("shared")
    protected Shared shared;

    @JsonProperty("sharepointIds")
    protected SharepointIds sharepointIds;

    @JsonProperty("size")
    protected Long size;

    @JsonProperty("source")
    protected DriveItemSource source;

    @JsonProperty("specialFolder")
    protected SpecialFolder specialFolder;

    @JsonProperty("video")
    protected Video video;

    @JsonProperty("webDavUrl")
    protected String webDavUrl;

    @JsonProperty("workbook")
    protected Workbook workbook;

    @JsonProperty("activities")
    protected List<ItemActivityOLD> activities;

    @JsonProperty("children")
    protected List<DriveItem> children;

    @JsonProperty("listItem")
    protected ListItem listItem;

    @JsonProperty("permissions")
    protected List<Permission> permissions;

    @JsonProperty("subscriptions")
    protected List<Subscription> subscriptions;

    @JsonProperty("thumbnails")
    protected List<ThumbnailSet> thumbnails;

    @JsonProperty("versions")
    protected List<DriveItemVersion> versions;

    protected DriveItem() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDriveItem() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private IdentitySet createdBy;
        private OffsetDateTime createdDateTime;
        private String description;
        private String eTag;
        private IdentitySet lastModifiedBy;
        private OffsetDateTime lastModifiedDateTime;
        private String name;
        private ItemReference parentReference;
        private String webUrl;
        private Audio audio;
        private Bundle bundle;
        private String content;
        private String cTag;
        private Deleted deleted;
        private File file;
        private FileSystemInfo fileSystemInfo;
        private Folder folder;
        private Image image;
        private GeoCoordinates location;
        private Malware malware;
        private Media media;
        private Package package_;
        private PendingOperations pendingOperations;
        private Photo photo;
        private PublicationFacet publication;
        private RemoteItem remoteItem;
        private Root root;
        private SearchResult searchResult;
        private Shared shared;
        private SharepointIds sharepointIds;
        private Long size;
        private DriveItemSource source;
        private SpecialFolder specialFolder;
        private Video video;
        private String webDavUrl;
        private Workbook workbook;
        private List<ItemActivityOLD> activities;
        private List<DriveItem> children;
        private ListItem listItem;
        private List<Permission> permissions;
        private List<Subscription> subscriptions;
        private List<ThumbnailSet> thumbnails;
        private List<DriveItemVersion> versions;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdBy(IdentitySet createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder eTag(String eTag) {
            this.eTag = eTag;
            this.changedFields = changedFields.add("eTag");
            return this;
        }

        public Builder lastModifiedBy(IdentitySet lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            this.changedFields = changedFields.add("lastModifiedBy");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder parentReference(ItemReference parentReference) {
            this.parentReference = parentReference;
            this.changedFields = changedFields.add("parentReference");
            return this;
        }

        public Builder webUrl(String webUrl) {
            this.webUrl = webUrl;
            this.changedFields = changedFields.add("webUrl");
            return this;
        }

        public Builder audio(Audio audio) {
            this.audio = audio;
            this.changedFields = changedFields.add("audio");
            return this;
        }

        public Builder bundle(Bundle bundle) {
            this.bundle = bundle;
            this.changedFields = changedFields.add("bundle");
            return this;
        }

        public Builder content(String content) {
            this.content = content;
            this.changedFields = changedFields.add("content");
            return this;
        }

        public Builder cTag(String cTag) {
            this.cTag = cTag;
            this.changedFields = changedFields.add("cTag");
            return this;
        }

        public Builder deleted(Deleted deleted) {
            this.deleted = deleted;
            this.changedFields = changedFields.add("deleted");
            return this;
        }

        public Builder file(File file) {
            this.file = file;
            this.changedFields = changedFields.add("file");
            return this;
        }

        public Builder fileSystemInfo(FileSystemInfo fileSystemInfo) {
            this.fileSystemInfo = fileSystemInfo;
            this.changedFields = changedFields.add("fileSystemInfo");
            return this;
        }

        public Builder folder(Folder folder) {
            this.folder = folder;
            this.changedFields = changedFields.add("folder");
            return this;
        }

        public Builder image(Image image) {
            this.image = image;
            this.changedFields = changedFields.add("image");
            return this;
        }

        public Builder location(GeoCoordinates location) {
            this.location = location;
            this.changedFields = changedFields.add("location");
            return this;
        }

        public Builder malware(Malware malware) {
            this.malware = malware;
            this.changedFields = changedFields.add("malware");
            return this;
        }

        public Builder media(Media media) {
            this.media = media;
            this.changedFields = changedFields.add("media");
            return this;
        }

        public Builder package_(Package package_) {
            this.package_ = package_;
            this.changedFields = changedFields.add("package");
            return this;
        }

        public Builder pendingOperations(PendingOperations pendingOperations) {
            this.pendingOperations = pendingOperations;
            this.changedFields = changedFields.add("pendingOperations");
            return this;
        }

        public Builder photo(Photo photo) {
            this.photo = photo;
            this.changedFields = changedFields.add("photo");
            return this;
        }

        public Builder publication(PublicationFacet publication) {
            this.publication = publication;
            this.changedFields = changedFields.add("publication");
            return this;
        }

        public Builder remoteItem(RemoteItem remoteItem) {
            this.remoteItem = remoteItem;
            this.changedFields = changedFields.add("remoteItem");
            return this;
        }

        public Builder root(Root root) {
            this.root = root;
            this.changedFields = changedFields.add("root");
            return this;
        }

        public Builder searchResult(SearchResult searchResult) {
            this.searchResult = searchResult;
            this.changedFields = changedFields.add("searchResult");
            return this;
        }

        public Builder shared(Shared shared) {
            this.shared = shared;
            this.changedFields = changedFields.add("shared");
            return this;
        }

        public Builder sharepointIds(SharepointIds sharepointIds) {
            this.sharepointIds = sharepointIds;
            this.changedFields = changedFields.add("sharepointIds");
            return this;
        }

        public Builder size(Long size) {
            this.size = size;
            this.changedFields = changedFields.add("size");
            return this;
        }

        public Builder source(DriveItemSource source) {
            this.source = source;
            this.changedFields = changedFields.add("source");
            return this;
        }

        public Builder specialFolder(SpecialFolder specialFolder) {
            this.specialFolder = specialFolder;
            this.changedFields = changedFields.add("specialFolder");
            return this;
        }

        public Builder video(Video video) {
            this.video = video;
            this.changedFields = changedFields.add("video");
            return this;
        }

        public Builder webDavUrl(String webDavUrl) {
            this.webDavUrl = webDavUrl;
            this.changedFields = changedFields.add("webDavUrl");
            return this;
        }

        public Builder workbook(Workbook workbook) {
            this.workbook = workbook;
            this.changedFields = changedFields.add("workbook");
            return this;
        }

        public Builder activities(List<ItemActivityOLD> activities) {
            this.activities = activities;
            this.changedFields = changedFields.add("activities");
            return this;
        }

        public Builder activities(ItemActivityOLD... activities) {
            return activities(Arrays.asList(activities));
        }

        public Builder children(List<DriveItem> children) {
            this.children = children;
            this.changedFields = changedFields.add("children");
            return this;
        }

        public Builder children(DriveItem... children) {
            return children(Arrays.asList(children));
        }

        public Builder listItem(ListItem listItem) {
            this.listItem = listItem;
            this.changedFields = changedFields.add("listItem");
            return this;
        }

        public Builder permissions(List<Permission> permissions) {
            this.permissions = permissions;
            this.changedFields = changedFields.add("permissions");
            return this;
        }

        public Builder permissions(Permission... permissions) {
            return permissions(Arrays.asList(permissions));
        }

        public Builder subscriptions(List<Subscription> subscriptions) {
            this.subscriptions = subscriptions;
            this.changedFields = changedFields.add("subscriptions");
            return this;
        }

        public Builder subscriptions(Subscription... subscriptions) {
            return subscriptions(Arrays.asList(subscriptions));
        }

        public Builder thumbnails(List<ThumbnailSet> thumbnails) {
            this.thumbnails = thumbnails;
            this.changedFields = changedFields.add("thumbnails");
            return this;
        }

        public Builder thumbnails(ThumbnailSet... thumbnails) {
            return thumbnails(Arrays.asList(thumbnails));
        }

        public Builder versions(List<DriveItemVersion> versions) {
            this.versions = versions;
            this.changedFields = changedFields.add("versions");
            return this;
        }

        public Builder versions(DriveItemVersion... versions) {
            return versions(Arrays.asList(versions));
        }

        public DriveItem build() {
            DriveItem _x = new DriveItem();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.driveItem";
            _x.id = id;
            _x.createdBy = createdBy;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.eTag = eTag;
            _x.lastModifiedBy = lastModifiedBy;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.name = name;
            _x.parentReference = parentReference;
            _x.webUrl = webUrl;
            _x.audio = audio;
            _x.bundle = bundle;
            _x.content = content;
            _x.cTag = cTag;
            _x.deleted = deleted;
            _x.file = file;
            _x.fileSystemInfo = fileSystemInfo;
            _x.folder = folder;
            _x.image = image;
            _x.location = location;
            _x.malware = malware;
            _x.media = media;
            _x.package_ = package_;
            _x.pendingOperations = pendingOperations;
            _x.photo = photo;
            _x.publication = publication;
            _x.remoteItem = remoteItem;
            _x.root = root;
            _x.searchResult = searchResult;
            _x.shared = shared;
            _x.sharepointIds = sharepointIds;
            _x.size = size;
            _x.source = source;
            _x.specialFolder = specialFolder;
            _x.video = video;
            _x.webDavUrl = webDavUrl;
            _x.workbook = workbook;
            _x.activities = activities;
            _x.children = children;
            _x.listItem = listItem;
            _x.permissions = permissions;
            _x.subscriptions = subscriptions;
            _x.thumbnails = thumbnails;
            _x.versions = versions;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="audio")
    @JsonIgnore
    public Optional<Audio> getAudio() {
        return Optional.ofNullable(audio);
    }

    public DriveItem withAudio(Audio audio) {
        DriveItem _x = _copy();
        _x.changedFields = changedFields.add("audio");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.driveItem");
        _x.audio = audio;
        return _x;
    }

    @Property(name="bundle")
    @JsonIgnore
    public Optional<Bundle> getBundle() {
        return Optional.ofNullable(bundle);
    }

    public DriveItem withBundle(Bundle bundle) {
        DriveItem _x = _copy();
        _x.changedFields = changedFields.add("bundle");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.driveItem");
        _x.bundle = bundle;
        return _x;
    }

    @Property(name="content")
    @JsonIgnore
    public Optional<StreamProvider> getContent() {
        return RequestHelper.createStreamForEdmStream(contextPath, this, "content", content);
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploader} which can be used to upload the stream
     * to the {@code content} property, using HTTP POST.
     *
     * @return a StreamUploader if upload permitted
     */
    @Property(name="content")
    public Optional<StreamUploaderSingleCall> postContent() {
        return postContent(UploadStrategy.singleCall());
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploaderChunked} which can be used to upload the stream
     * to the {@code content} property, using HTTP POST.
     *
     * @return a StreamUploaderChunked if upload permitted
     */
    @Property(name="content")
    public Optional<StreamUploaderChunked> postChunkedContent() {
        return postContent(UploadStrategy.chunked());
    }

    @Property(name="content")
    public <T extends StreamUploader<T>> Optional<T> postContent(UploadStrategy<T> strategy) {
        return strategy.builder(contextPath.addSegment("content"), this, "content", HttpMethod.POST);
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploader} which can be used to upload the stream
     * to the {@code content} property, using HTTP PATCH.
     *
     * @return a StreamUploader if upload permitted
     */
    @Property(name="content")
    public Optional<StreamUploaderSingleCall> patchContent() {
        return patchContent(UploadStrategy.singleCall());
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploaderChunked} which can be used to upload the stream
     * to the {@code content} property, using HTTP PATCH.
     *
     * @return a StreamUploaderChunked if upload permitted
     */
    @Property(name="content")
    public Optional<StreamUploaderChunked> patchChunkedContent() {
        return patchContent(UploadStrategy.chunked());
    }

    @Property(name="content")
    public <T extends StreamUploader<T>> Optional<T> patchContent(UploadStrategy<T> strategy) {
        return strategy.builder(contextPath.addSegment("content"), this, "content", HttpMethod.PATCH);
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploader} which can be used to upload the stream
     * to the {@code content} property, using HTTP PUT.
     *
     * @return a StreamUploader if upload permitted
     */
    @Property(name="content")
    public Optional<StreamUploaderSingleCall> putContent() {
        return putContent(UploadStrategy.singleCall());
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploaderChunked} which can be used to upload the stream
     * to the {@code content} property, using HTTP PUT.
     *
     * @return a StreamUploaderChunked if upload permitted
     */
    @Property(name="content")
    public Optional<StreamUploaderChunked> putChunkedContent() {
        return putContent(UploadStrategy.chunked());
    }

    @Property(name="content")
    public <T extends StreamUploader<T>> Optional<T> putContent(UploadStrategy<T> strategy) {
        return strategy.builder(contextPath.addSegment("content"), this, "content", HttpMethod.PUT);
    }

    @Property(name="cTag")
    @JsonIgnore
    public Optional<String> getCTag() {
        return Optional.ofNullable(cTag);
    }

    public DriveItem withCTag(String cTag) {
        DriveItem _x = _copy();
        _x.changedFields = changedFields.add("cTag");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.driveItem");
        _x.cTag = cTag;
        return _x;
    }

    @Property(name="deleted")
    @JsonIgnore
    public Optional<Deleted> getDeleted() {
        return Optional.ofNullable(deleted);
    }

    public DriveItem withDeleted(Deleted deleted) {
        DriveItem _x = _copy();
        _x.changedFields = changedFields.add("deleted");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.driveItem");
        _x.deleted = deleted;
        return _x;
    }

    @Property(name="file")
    @JsonIgnore
    public Optional<File> getFile() {
        return Optional.ofNullable(file);
    }

    public DriveItem withFile(File file) {
        DriveItem _x = _copy();
        _x.changedFields = changedFields.add("file");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.driveItem");
        _x.file = file;
        return _x;
    }

    @Property(name="fileSystemInfo")
    @JsonIgnore
    public Optional<FileSystemInfo> getFileSystemInfo() {
        return Optional.ofNullable(fileSystemInfo);
    }

    public DriveItem withFileSystemInfo(FileSystemInfo fileSystemInfo) {
        DriveItem _x = _copy();
        _x.changedFields = changedFields.add("fileSystemInfo");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.driveItem");
        _x.fileSystemInfo = fileSystemInfo;
        return _x;
    }

    @Property(name="folder")
    @JsonIgnore
    public Optional<Folder> getFolder() {
        return Optional.ofNullable(folder);
    }

    public DriveItem withFolder(Folder folder) {
        DriveItem _x = _copy();
        _x.changedFields = changedFields.add("folder");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.driveItem");
        _x.folder = folder;
        return _x;
    }

    @Property(name="image")
    @JsonIgnore
    public Optional<Image> getImage() {
        return Optional.ofNullable(image);
    }

    public DriveItem withImage(Image image) {
        DriveItem _x = _copy();
        _x.changedFields = changedFields.add("image");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.driveItem");
        _x.image = image;
        return _x;
    }

    @Property(name="location")
    @JsonIgnore
    public Optional<GeoCoordinates> getLocation() {
        return Optional.ofNullable(location);
    }

    public DriveItem withLocation(GeoCoordinates location) {
        DriveItem _x = _copy();
        _x.changedFields = changedFields.add("location");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.driveItem");
        _x.location = location;
        return _x;
    }

    @Property(name="malware")
    @JsonIgnore
    public Optional<Malware> getMalware() {
        return Optional.ofNullable(malware);
    }

    public DriveItem withMalware(Malware malware) {
        DriveItem _x = _copy();
        _x.changedFields = changedFields.add("malware");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.driveItem");
        _x.malware = malware;
        return _x;
    }

    @Property(name="media")
    @JsonIgnore
    public Optional<Media> getMedia() {
        return Optional.ofNullable(media);
    }

    public DriveItem withMedia(Media media) {
        DriveItem _x = _copy();
        _x.changedFields = changedFields.add("media");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.driveItem");
        _x.media = media;
        return _x;
    }

    @Property(name="package")
    @JsonIgnore
    public Optional<Package> getPackage() {
        return Optional.ofNullable(package_);
    }

    public DriveItem withPackage(Package package_) {
        DriveItem _x = _copy();
        _x.changedFields = changedFields.add("package");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.driveItem");
        _x.package_ = package_;
        return _x;
    }

    @Property(name="pendingOperations")
    @JsonIgnore
    public Optional<PendingOperations> getPendingOperations() {
        return Optional.ofNullable(pendingOperations);
    }

    public DriveItem withPendingOperations(PendingOperations pendingOperations) {
        DriveItem _x = _copy();
        _x.changedFields = changedFields.add("pendingOperations");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.driveItem");
        _x.pendingOperations = pendingOperations;
        return _x;
    }

    @Property(name="photo")
    @JsonIgnore
    public Optional<Photo> getPhoto() {
        return Optional.ofNullable(photo);
    }

    public DriveItem withPhoto(Photo photo) {
        DriveItem _x = _copy();
        _x.changedFields = changedFields.add("photo");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.driveItem");
        _x.photo = photo;
        return _x;
    }

    @Property(name="publication")
    @JsonIgnore
    public Optional<PublicationFacet> getPublication() {
        return Optional.ofNullable(publication);
    }

    public DriveItem withPublication(PublicationFacet publication) {
        DriveItem _x = _copy();
        _x.changedFields = changedFields.add("publication");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.driveItem");
        _x.publication = publication;
        return _x;
    }

    @Property(name="remoteItem")
    @JsonIgnore
    public Optional<RemoteItem> getRemoteItem() {
        return Optional.ofNullable(remoteItem);
    }

    public DriveItem withRemoteItem(RemoteItem remoteItem) {
        DriveItem _x = _copy();
        _x.changedFields = changedFields.add("remoteItem");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.driveItem");
        _x.remoteItem = remoteItem;
        return _x;
    }

    @Property(name="root")
    @JsonIgnore
    public Optional<Root> getRoot() {
        return Optional.ofNullable(root);
    }

    public DriveItem withRoot(Root root) {
        DriveItem _x = _copy();
        _x.changedFields = changedFields.add("root");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.driveItem");
        _x.root = root;
        return _x;
    }

    @Property(name="searchResult")
    @JsonIgnore
    public Optional<SearchResult> getSearchResult() {
        return Optional.ofNullable(searchResult);
    }

    public DriveItem withSearchResult(SearchResult searchResult) {
        DriveItem _x = _copy();
        _x.changedFields = changedFields.add("searchResult");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.driveItem");
        _x.searchResult = searchResult;
        return _x;
    }

    @Property(name="shared")
    @JsonIgnore
    public Optional<Shared> getShared() {
        return Optional.ofNullable(shared);
    }

    public DriveItem withShared(Shared shared) {
        DriveItem _x = _copy();
        _x.changedFields = changedFields.add("shared");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.driveItem");
        _x.shared = shared;
        return _x;
    }

    @Property(name="sharepointIds")
    @JsonIgnore
    public Optional<SharepointIds> getSharepointIds() {
        return Optional.ofNullable(sharepointIds);
    }

    public DriveItem withSharepointIds(SharepointIds sharepointIds) {
        DriveItem _x = _copy();
        _x.changedFields = changedFields.add("sharepointIds");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.driveItem");
        _x.sharepointIds = sharepointIds;
        return _x;
    }

    @Property(name="size")
    @JsonIgnore
    public Optional<Long> getSize() {
        return Optional.ofNullable(size);
    }

    public DriveItem withSize(Long size) {
        DriveItem _x = _copy();
        _x.changedFields = changedFields.add("size");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.driveItem");
        _x.size = size;
        return _x;
    }

    @Property(name="source")
    @JsonIgnore
    public Optional<DriveItemSource> getSource() {
        return Optional.ofNullable(source);
    }

    public DriveItem withSource(DriveItemSource source) {
        DriveItem _x = _copy();
        _x.changedFields = changedFields.add("source");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.driveItem");
        _x.source = source;
        return _x;
    }

    @Property(name="specialFolder")
    @JsonIgnore
    public Optional<SpecialFolder> getSpecialFolder() {
        return Optional.ofNullable(specialFolder);
    }

    public DriveItem withSpecialFolder(SpecialFolder specialFolder) {
        DriveItem _x = _copy();
        _x.changedFields = changedFields.add("specialFolder");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.driveItem");
        _x.specialFolder = specialFolder;
        return _x;
    }

    @Property(name="video")
    @JsonIgnore
    public Optional<Video> getVideo() {
        return Optional.ofNullable(video);
    }

    public DriveItem withVideo(Video video) {
        DriveItem _x = _copy();
        _x.changedFields = changedFields.add("video");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.driveItem");
        _x.video = video;
        return _x;
    }

    @Property(name="webDavUrl")
    @JsonIgnore
    public Optional<String> getWebDavUrl() {
        return Optional.ofNullable(webDavUrl);
    }

    public DriveItem withWebDavUrl(String webDavUrl) {
        DriveItem _x = _copy();
        _x.changedFields = changedFields.add("webDavUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.driveItem");
        _x.webDavUrl = webDavUrl;
        return _x;
    }

    public DriveItem withUnmappedField(String name, Object value) {
        DriveItem _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="workbook")
    @JsonIgnore
    public WorkbookRequest getWorkbook() {
        return new WorkbookRequest(contextPath.addSegment("workbook"), Optional.ofNullable(workbook));
    }

    @NavigationProperty(name="activities")
    @JsonIgnore
    public ItemActivityOLDCollectionRequest getActivities() {
        return new ItemActivityOLDCollectionRequest(
                        contextPath.addSegment("activities"), Optional.ofNullable(activities));
    }

    @NavigationProperty(name="analytics")
    @JsonIgnore
    public ItemAnalyticsRequest getAnalytics() {
        return new ItemAnalyticsRequest(contextPath.addSegment("analytics"), RequestHelper.getValue(unmappedFields, "analytics"));
    }

    @NavigationProperty(name="children")
    @JsonIgnore
    public DriveItemCollectionRequest getChildren() {
        return new DriveItemCollectionRequest(
                        contextPath.addSegment("children"), Optional.ofNullable(children));
    }

    @NavigationProperty(name="listItem")
    @JsonIgnore
    public ListItemRequest getListItem() {
        return new ListItemRequest(contextPath.addSegment("listItem"), Optional.ofNullable(listItem));
    }

    @NavigationProperty(name="permissions")
    @JsonIgnore
    public PermissionCollectionRequest getPermissions() {
        return new PermissionCollectionRequest(
                        contextPath.addSegment("permissions"), Optional.ofNullable(permissions));
    }

    @NavigationProperty(name="subscriptions")
    @JsonIgnore
    public SubscriptionCollectionRequest getSubscriptions() {
        return new SubscriptionCollectionRequest(
                        contextPath.addSegment("subscriptions"), Optional.ofNullable(subscriptions));
    }

    @NavigationProperty(name="thumbnails")
    @JsonIgnore
    public ThumbnailSetCollectionRequest getThumbnails() {
        return new ThumbnailSetCollectionRequest(
                        contextPath.addSegment("thumbnails"), Optional.ofNullable(thumbnails));
    }

    @NavigationProperty(name="versions")
    @JsonIgnore
    public DriveItemVersionCollectionRequest getVersions() {
        return new DriveItemVersionCollectionRequest(
                        contextPath.addSegment("versions"), Optional.ofNullable(versions));
    }

    public DriveItem withWorkbook(Workbook workbook) {
        DriveItem _x = _copy();
        _x.changedFields = changedFields.add("workbook");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.driveItem");
        _x.workbook = workbook;
        return _x;
    }

    public DriveItem withActivities(List<ItemActivityOLD> activities) {
        DriveItem _x = _copy();
        _x.changedFields = changedFields.add("activities");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.driveItem");
        _x.activities = activities;
        return _x;
    }

    public DriveItem withChildren(List<DriveItem> children) {
        DriveItem _x = _copy();
        _x.changedFields = changedFields.add("children");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.driveItem");
        _x.children = children;
        return _x;
    }

    public DriveItem withListItem(ListItem listItem) {
        DriveItem _x = _copy();
        _x.changedFields = changedFields.add("listItem");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.driveItem");
        _x.listItem = listItem;
        return _x;
    }

    public DriveItem withPermissions(List<Permission> permissions) {
        DriveItem _x = _copy();
        _x.changedFields = changedFields.add("permissions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.driveItem");
        _x.permissions = permissions;
        return _x;
    }

    public DriveItem withSubscriptions(List<Subscription> subscriptions) {
        DriveItem _x = _copy();
        _x.changedFields = changedFields.add("subscriptions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.driveItem");
        _x.subscriptions = subscriptions;
        return _x;
    }

    public DriveItem withThumbnails(List<ThumbnailSet> thumbnails) {
        DriveItem _x = _copy();
        _x.changedFields = changedFields.add("thumbnails");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.driveItem");
        _x.thumbnails = thumbnails;
        return _x;
    }

    public DriveItem withVersions(List<DriveItemVersion> versions) {
        DriveItem _x = _copy();
        _x.changedFields = changedFields.add("versions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.driveItem");
        _x.versions = versions;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DriveItem patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DriveItem _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DriveItem put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DriveItem _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DriveItem _copy() {
        DriveItem _x = new DriveItem();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdBy = createdBy;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.eTag = eTag;
        _x.lastModifiedBy = lastModifiedBy;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.name = name;
        _x.parentReference = parentReference;
        _x.webUrl = webUrl;
        _x.audio = audio;
        _x.bundle = bundle;
        _x.content = content;
        _x.cTag = cTag;
        _x.deleted = deleted;
        _x.file = file;
        _x.fileSystemInfo = fileSystemInfo;
        _x.folder = folder;
        _x.image = image;
        _x.location = location;
        _x.malware = malware;
        _x.media = media;
        _x.package_ = package_;
        _x.pendingOperations = pendingOperations;
        _x.photo = photo;
        _x.publication = publication;
        _x.remoteItem = remoteItem;
        _x.root = root;
        _x.searchResult = searchResult;
        _x.shared = shared;
        _x.sharepointIds = sharepointIds;
        _x.size = size;
        _x.source = source;
        _x.specialFolder = specialFolder;
        _x.video = video;
        _x.webDavUrl = webDavUrl;
        _x.workbook = workbook;
        _x.activities = activities;
        _x.children = children;
        _x.listItem = listItem;
        _x.permissions = permissions;
        _x.subscriptions = subscriptions;
        _x.thumbnails = thumbnails;
        _x.versions = versions;
        return _x;
    }

    @Action(name = "restore")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<DriveItem> restore(ItemReference parentReference, String name) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("parentReference", "microsoft.graph.itemReference", parentReference)
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<DriveItem>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.restore"), DriveItem.class, _parameters);
    }

    @Action(name = "copy")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<DriveItem> copy(String name, ItemReference parentReference) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("parentReference", "microsoft.graph.itemReference", parentReference)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<DriveItem>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.copy"), DriveItem.class, _parameters);
    }

    @Action(name = "createUploadSession")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<UploadSession> createUploadSession(DriveItemUploadableProperties item, Boolean deferCommit) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("item", "microsoft.graph.driveItemUploadableProperties", item)
            .put("deferCommit", "Edm.Boolean", deferCommit)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<UploadSession>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.createUploadSession"), UploadSession.class, _parameters);
    }

    @Action(name = "checkin")
    @JsonIgnore
    public ActionRequestNoReturn checkin(String checkInAs, String comment) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("checkInAs", "Edm.String", Checks.checkIsAscii(checkInAs))
            .put("comment", "Edm.String", Checks.checkIsAscii(comment))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.checkin"), _parameters);
    }

    @Action(name = "checkout")
    @JsonIgnore
    public ActionRequestNoReturn checkout() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.checkout"), _parameters);
    }

    @Action(name = "createLink")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Permission> createLink(String type, String scope, OffsetDateTime expirationDateTime, String password, String message, List<DriveRecipient> recipients, Boolean retainInheritedPermissions) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("type", "Edm.String", Checks.checkIsAscii(type))
            .put("scope", "Edm.String", Checks.checkIsAscii(scope))
            .put("expirationDateTime", "Edm.DateTimeOffset", expirationDateTime)
            .put("password", "Edm.String", Checks.checkIsAscii(password))
            .put("message", "Edm.String", Checks.checkIsAscii(message))
            .put("recipients", "Collection(microsoft.graph.driveRecipient)", recipients)
            .put("retainInheritedPermissions", "Edm.Boolean", retainInheritedPermissions)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Permission>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.createLink"), Permission.class, _parameters);
    }

    @Action(name = "follow")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<DriveItem> follow() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<DriveItem>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.follow"), DriveItem.class, _parameters);
    }

    @Action(name = "invite")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Permission> invite(Boolean requireSignIn, List<String> roles, Boolean sendInvitation, String message, List<DriveRecipient> recipients, Boolean retainInheritedPermissions, String expirationDateTime, String password) {
        Preconditions.checkNotNull(recipients, "recipients cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("requireSignIn", "Edm.Boolean", requireSignIn)
            .put("roles", "Collection(Edm.String)", Checks.checkIsAscii(roles))
            .put("sendInvitation", "Edm.Boolean", sendInvitation)
            .put("message", "Edm.String", Checks.checkIsAscii(message))
            .put("recipients", "Collection(microsoft.graph.driveRecipient)", recipients)
            .put("retainInheritedPermissions", "Edm.Boolean", retainInheritedPermissions)
            .put("expirationDateTime", "Edm.String", Checks.checkIsAscii(expirationDateTime))
            .put("password", "Edm.String", Checks.checkIsAscii(password))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.invite"), Permission.class, _parameters);
    }

    @Action(name = "preview")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<ItemPreviewInfo> preview(String viewer, Boolean chromeless, Boolean allowEdit, String page, Double zoom) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("viewer", "Edm.String", Checks.checkIsAscii(viewer))
            .put("chromeless", "Edm.Boolean", chromeless)
            .put("allowEdit", "Edm.Boolean", allowEdit)
            .put("page", "Edm.String", Checks.checkIsAscii(page))
            .put("zoom", "Edm.Double", zoom)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<ItemPreviewInfo>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.preview"), ItemPreviewInfo.class, _parameters);
    }

    @Action(name = "unfollow")
    @JsonIgnore
    public ActionRequestNoReturn unfollow() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.unfollow"), _parameters);
    }

    @Action(name = "validatePermission")
    @JsonIgnore
    public ActionRequestNoReturn validatePermission(String challengeToken, String password) {
        Preconditions.checkNotNull(password, "password cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("challengeToken", "Edm.String", Checks.checkIsAscii(challengeToken))
            .put("password", "Edm.String", Checks.checkIsAscii(password))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.validatePermission"), _parameters);
    }

    @Function(name = "delta")
    @JsonIgnore
    public CollectionPageNonEntityRequest<DriveItem> delta() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.delta"), DriveItem.class, _parameters);
    }

    @Function(name = "delta")
    @JsonIgnore
    public CollectionPageNonEntityRequest<DriveItem> delta_Function(String token) {
        Preconditions.checkNotNull(token, "token cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("token", "Edm.String", Checks.checkIsAscii(token))
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.delta"), DriveItem.class, _parameters);
    }

    @Function(name = "getActivitiesByInterval")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ItemActivityStat> getActivitiesByInterval(String startDateTime, String endDateTime, String interval) {
        Preconditions.checkNotNull(startDateTime, "startDateTime cannot be null");
        Preconditions.checkNotNull(endDateTime, "endDateTime cannot be null");
        Preconditions.checkNotNull(interval, "interval cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("startDateTime", "Edm.String", Checks.checkIsAscii(startDateTime))
            .put("endDateTime", "Edm.String", Checks.checkIsAscii(endDateTime))
            .put("interval", "Edm.String", Checks.checkIsAscii(interval))
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getActivitiesByInterval"), ItemActivityStat.class, _parameters);
    }

    @Function(name = "search")
    @JsonIgnore
    public CollectionPageNonEntityRequest<DriveItem> search(String q) {
        Preconditions.checkNotNull(q, "q cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("q", "Edm.String", Checks.checkIsAscii(q))
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.search"), DriveItem.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DriveItem[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("eTag=");
        b.append(this.eTag);
        b.append(", ");
        b.append("lastModifiedBy=");
        b.append(this.lastModifiedBy);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("parentReference=");
        b.append(this.parentReference);
        b.append(", ");
        b.append("webUrl=");
        b.append(this.webUrl);
        b.append(", ");
        b.append("audio=");
        b.append(this.audio);
        b.append(", ");
        b.append("bundle=");
        b.append(this.bundle);
        b.append(", ");
        b.append("content=");
        b.append(this.content);
        b.append(", ");
        b.append("cTag=");
        b.append(this.cTag);
        b.append(", ");
        b.append("deleted=");
        b.append(this.deleted);
        b.append(", ");
        b.append("file=");
        b.append(this.file);
        b.append(", ");
        b.append("fileSystemInfo=");
        b.append(this.fileSystemInfo);
        b.append(", ");
        b.append("folder=");
        b.append(this.folder);
        b.append(", ");
        b.append("image=");
        b.append(this.image);
        b.append(", ");
        b.append("location=");
        b.append(this.location);
        b.append(", ");
        b.append("malware=");
        b.append(this.malware);
        b.append(", ");
        b.append("media=");
        b.append(this.media);
        b.append(", ");
        b.append("package=");
        b.append(this.package_);
        b.append(", ");
        b.append("pendingOperations=");
        b.append(this.pendingOperations);
        b.append(", ");
        b.append("photo=");
        b.append(this.photo);
        b.append(", ");
        b.append("publication=");
        b.append(this.publication);
        b.append(", ");
        b.append("remoteItem=");
        b.append(this.remoteItem);
        b.append(", ");
        b.append("root=");
        b.append(this.root);
        b.append(", ");
        b.append("searchResult=");
        b.append(this.searchResult);
        b.append(", ");
        b.append("shared=");
        b.append(this.shared);
        b.append(", ");
        b.append("sharepointIds=");
        b.append(this.sharepointIds);
        b.append(", ");
        b.append("size=");
        b.append(this.size);
        b.append(", ");
        b.append("source=");
        b.append(this.source);
        b.append(", ");
        b.append("specialFolder=");
        b.append(this.specialFolder);
        b.append(", ");
        b.append("video=");
        b.append(this.video);
        b.append(", ");
        b.append("webDavUrl=");
        b.append(this.webDavUrl);
        b.append(", ");
        b.append("workbook=");
        b.append(this.workbook);
        b.append(", ");
        b.append("activities=");
        b.append(this.activities);
        b.append(", ");
        b.append("children=");
        b.append(this.children);
        b.append(", ");
        b.append("listItem=");
        b.append(this.listItem);
        b.append(", ");
        b.append("permissions=");
        b.append(this.permissions);
        b.append(", ");
        b.append("subscriptions=");
        b.append(this.subscriptions);
        b.append(", ");
        b.append("thumbnails=");
        b.append(this.thumbnails);
        b.append(", ");
        b.append("versions=");
        b.append(this.versions);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
