package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.IdentitySet;
import odata.msgraph.client.beta.complex.ItemReference;
import odata.msgraph.client.beta.complex.Quota;
import odata.msgraph.client.beta.complex.SharepointIds;
import odata.msgraph.client.beta.complex.SystemFacet;
import odata.msgraph.client.beta.entity.collection.request.DriveItemCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ItemActivityOLDCollectionRequest;
import odata.msgraph.client.beta.entity.request.DriveItemRequest;
import odata.msgraph.client.beta.entity.request.ListRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "driveType", 
    "owner", 
    "quota", 
    "sharePointIds", 
    "system", 
    "activities", 
    "bundles", 
    "following", 
    "items", 
    "list", 
    "root", 
    "special"})
@JsonInclude(Include.NON_NULL)
public class Drive extends BaseItem implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.drive";
    }

    @JsonProperty("driveType")
    protected String driveType;

    @JsonProperty("owner")
    protected IdentitySet owner;

    @JsonProperty("quota")
    protected Quota quota;

    @JsonProperty("sharePointIds")
    protected SharepointIds sharePointIds;

    @JsonProperty("system")
    protected SystemFacet system;

    @JsonProperty("activities")
    protected List<ItemActivityOLD> activities;

    @JsonProperty("bundles")
    protected List<DriveItem> bundles;

    @JsonProperty("following")
    protected List<DriveItem> following;

    @JsonProperty("items")
    protected List<DriveItem> items;

    @JsonProperty("list")
    protected odata.msgraph.client.beta.entity.List list;

    @JsonProperty("root")
    protected DriveItem root;

    @JsonProperty("special")
    protected List<DriveItem> special;

    protected Drive() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDrive() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private IdentitySet createdBy;
        private OffsetDateTime createdDateTime;
        private String description;
        private String eTag;
        private IdentitySet lastModifiedBy;
        private OffsetDateTime lastModifiedDateTime;
        private String name;
        private ItemReference parentReference;
        private String webUrl;
        private String driveType;
        private IdentitySet owner;
        private Quota quota;
        private SharepointIds sharePointIds;
        private SystemFacet system;
        private List<ItemActivityOLD> activities;
        private List<DriveItem> bundles;
        private List<DriveItem> following;
        private List<DriveItem> items;
        private odata.msgraph.client.beta.entity.List list;
        private DriveItem root;
        private List<DriveItem> special;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdBy(IdentitySet createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder eTag(String eTag) {
            this.eTag = eTag;
            this.changedFields = changedFields.add("eTag");
            return this;
        }

        public Builder lastModifiedBy(IdentitySet lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            this.changedFields = changedFields.add("lastModifiedBy");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder parentReference(ItemReference parentReference) {
            this.parentReference = parentReference;
            this.changedFields = changedFields.add("parentReference");
            return this;
        }

        public Builder webUrl(String webUrl) {
            this.webUrl = webUrl;
            this.changedFields = changedFields.add("webUrl");
            return this;
        }

        public Builder driveType(String driveType) {
            this.driveType = driveType;
            this.changedFields = changedFields.add("driveType");
            return this;
        }

        public Builder owner(IdentitySet owner) {
            this.owner = owner;
            this.changedFields = changedFields.add("owner");
            return this;
        }

        public Builder quota(Quota quota) {
            this.quota = quota;
            this.changedFields = changedFields.add("quota");
            return this;
        }

        public Builder sharePointIds(SharepointIds sharePointIds) {
            this.sharePointIds = sharePointIds;
            this.changedFields = changedFields.add("sharePointIds");
            return this;
        }

        public Builder system(SystemFacet system) {
            this.system = system;
            this.changedFields = changedFields.add("system");
            return this;
        }

        public Builder activities(List<ItemActivityOLD> activities) {
            this.activities = activities;
            this.changedFields = changedFields.add("activities");
            return this;
        }

        public Builder activities(ItemActivityOLD... activities) {
            return activities(Arrays.asList(activities));
        }

        public Builder bundles(List<DriveItem> bundles) {
            this.bundles = bundles;
            this.changedFields = changedFields.add("bundles");
            return this;
        }

        public Builder bundles(DriveItem... bundles) {
            return bundles(Arrays.asList(bundles));
        }

        public Builder following(List<DriveItem> following) {
            this.following = following;
            this.changedFields = changedFields.add("following");
            return this;
        }

        public Builder following(DriveItem... following) {
            return following(Arrays.asList(following));
        }

        public Builder items(List<DriveItem> items) {
            this.items = items;
            this.changedFields = changedFields.add("items");
            return this;
        }

        public Builder items(DriveItem... items) {
            return items(Arrays.asList(items));
        }

        public Builder list(odata.msgraph.client.beta.entity.List list) {
            this.list = list;
            this.changedFields = changedFields.add("list");
            return this;
        }

        public Builder root(DriveItem root) {
            this.root = root;
            this.changedFields = changedFields.add("root");
            return this;
        }

        public Builder special(List<DriveItem> special) {
            this.special = special;
            this.changedFields = changedFields.add("special");
            return this;
        }

        public Builder special(DriveItem... special) {
            return special(Arrays.asList(special));
        }

        public Drive build() {
            Drive _x = new Drive();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.drive";
            _x.id = id;
            _x.createdBy = createdBy;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.eTag = eTag;
            _x.lastModifiedBy = lastModifiedBy;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.name = name;
            _x.parentReference = parentReference;
            _x.webUrl = webUrl;
            _x.driveType = driveType;
            _x.owner = owner;
            _x.quota = quota;
            _x.sharePointIds = sharePointIds;
            _x.system = system;
            _x.activities = activities;
            _x.bundles = bundles;
            _x.following = following;
            _x.items = items;
            _x.list = list;
            _x.root = root;
            _x.special = special;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="driveType")
    @JsonIgnore
    public Optional<String> getDriveType() {
        return Optional.ofNullable(driveType);
    }

    public Drive withDriveType(String driveType) {
        Drive _x = _copy();
        _x.changedFields = changedFields.add("driveType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.drive");
        _x.driveType = driveType;
        return _x;
    }

    @Property(name="owner")
    @JsonIgnore
    public Optional<IdentitySet> getOwner() {
        return Optional.ofNullable(owner);
    }

    public Drive withOwner(IdentitySet owner) {
        Drive _x = _copy();
        _x.changedFields = changedFields.add("owner");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.drive");
        _x.owner = owner;
        return _x;
    }

    @Property(name="quota")
    @JsonIgnore
    public Optional<Quota> getQuota() {
        return Optional.ofNullable(quota);
    }

    public Drive withQuota(Quota quota) {
        Drive _x = _copy();
        _x.changedFields = changedFields.add("quota");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.drive");
        _x.quota = quota;
        return _x;
    }

    @Property(name="sharePointIds")
    @JsonIgnore
    public Optional<SharepointIds> getSharePointIds() {
        return Optional.ofNullable(sharePointIds);
    }

    public Drive withSharePointIds(SharepointIds sharePointIds) {
        Drive _x = _copy();
        _x.changedFields = changedFields.add("sharePointIds");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.drive");
        _x.sharePointIds = sharePointIds;
        return _x;
    }

    @Property(name="system")
    @JsonIgnore
    public Optional<SystemFacet> getSystem() {
        return Optional.ofNullable(system);
    }

    public Drive withSystem(SystemFacet system) {
        Drive _x = _copy();
        _x.changedFields = changedFields.add("system");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.drive");
        _x.system = system;
        return _x;
    }

    public Drive withUnmappedField(String name, Object value) {
        Drive _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="activities")
    @JsonIgnore
    public ItemActivityOLDCollectionRequest getActivities() {
        return new ItemActivityOLDCollectionRequest(
                        contextPath.addSegment("activities"), Optional.ofNullable(activities));
    }

    @NavigationProperty(name="bundles")
    @JsonIgnore
    public DriveItemCollectionRequest getBundles() {
        return new DriveItemCollectionRequest(
                        contextPath.addSegment("bundles"), Optional.ofNullable(bundles));
    }

    @NavigationProperty(name="following")
    @JsonIgnore
    public DriveItemCollectionRequest getFollowing() {
        return new DriveItemCollectionRequest(
                        contextPath.addSegment("following"), Optional.ofNullable(following));
    }

    @NavigationProperty(name="items")
    @JsonIgnore
    public DriveItemCollectionRequest getItems() {
        return new DriveItemCollectionRequest(
                        contextPath.addSegment("items"), Optional.ofNullable(items));
    }

    @NavigationProperty(name="list")
    @JsonIgnore
    public ListRequest getList() {
        return new ListRequest(contextPath.addSegment("list"), Optional.ofNullable(list));
    }

    @NavigationProperty(name="root")
    @JsonIgnore
    public DriveItemRequest getRoot() {
        return new DriveItemRequest(contextPath.addSegment("root"), Optional.ofNullable(root));
    }

    @NavigationProperty(name="special")
    @JsonIgnore
    public DriveItemCollectionRequest getSpecial() {
        return new DriveItemCollectionRequest(
                        contextPath.addSegment("special"), Optional.ofNullable(special));
    }

    public Drive withActivities(List<ItemActivityOLD> activities) {
        Drive _x = _copy();
        _x.changedFields = changedFields.add("activities");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.drive");
        _x.activities = activities;
        return _x;
    }

    public Drive withBundles(List<DriveItem> bundles) {
        Drive _x = _copy();
        _x.changedFields = changedFields.add("bundles");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.drive");
        _x.bundles = bundles;
        return _x;
    }

    public Drive withFollowing(List<DriveItem> following) {
        Drive _x = _copy();
        _x.changedFields = changedFields.add("following");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.drive");
        _x.following = following;
        return _x;
    }

    public Drive withItems(List<DriveItem> items) {
        Drive _x = _copy();
        _x.changedFields = changedFields.add("items");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.drive");
        _x.items = items;
        return _x;
    }

    public Drive withList(odata.msgraph.client.beta.entity.List list) {
        Drive _x = _copy();
        _x.changedFields = changedFields.add("list");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.drive");
        _x.list = list;
        return _x;
    }

    public Drive withRoot(DriveItem root) {
        Drive _x = _copy();
        _x.changedFields = changedFields.add("root");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.drive");
        _x.root = root;
        return _x;
    }

    public Drive withSpecial(List<DriveItem> special) {
        Drive _x = _copy();
        _x.changedFields = changedFields.add("special");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.drive");
        _x.special = special;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Drive patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Drive _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Drive put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Drive _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Drive _copy() {
        Drive _x = new Drive();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdBy = createdBy;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.eTag = eTag;
        _x.lastModifiedBy = lastModifiedBy;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.name = name;
        _x.parentReference = parentReference;
        _x.webUrl = webUrl;
        _x.driveType = driveType;
        _x.owner = owner;
        _x.quota = quota;
        _x.sharePointIds = sharePointIds;
        _x.system = system;
        _x.activities = activities;
        _x.bundles = bundles;
        _x.following = following;
        _x.items = items;
        _x.list = list;
        _x.root = root;
        _x.special = special;
        return _x;
    }

    @Function(name = "search")
    @JsonIgnore
    public CollectionPageNonEntityRequest<DriveItem> search(String q) {
        Preconditions.checkNotNull(q, "q cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("q", "Edm.String", Checks.checkIsAscii(q))
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.search"), DriveItem.class, _parameters);
    }

    @Function(name = "recent")
    @JsonIgnore
    public CollectionPageNonEntityRequest<DriveItem> recent() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.recent"), DriveItem.class, _parameters);
    }

    @Function(name = "sharedWithMe")
    @JsonIgnore
    public CollectionPageNonEntityRequest<DriveItem> sharedWithMe() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.sharedWithMe"), DriveItem.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Drive[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("eTag=");
        b.append(this.eTag);
        b.append(", ");
        b.append("lastModifiedBy=");
        b.append(this.lastModifiedBy);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("parentReference=");
        b.append(this.parentReference);
        b.append(", ");
        b.append("webUrl=");
        b.append(this.webUrl);
        b.append(", ");
        b.append("driveType=");
        b.append(this.driveType);
        b.append(", ");
        b.append("owner=");
        b.append(this.owner);
        b.append(", ");
        b.append("quota=");
        b.append(this.quota);
        b.append(", ");
        b.append("sharePointIds=");
        b.append(this.sharePointIds);
        b.append(", ");
        b.append("system=");
        b.append(this.system);
        b.append(", ");
        b.append("activities=");
        b.append(this.activities);
        b.append(", ");
        b.append("bundles=");
        b.append(this.bundles);
        b.append(", ");
        b.append("following=");
        b.append(this.following);
        b.append(", ");
        b.append("items=");
        b.append(this.items);
        b.append(", ");
        b.append("list=");
        b.append(this.list);
        b.append(", ");
        b.append("root=");
        b.append(this.root);
        b.append(", ");
        b.append("special=");
        b.append(this.special);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
