package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DomainRegistrant;
import odata.msgraph.client.beta.complex.ReputationCategory;
import odata.msgraph.client.beta.complex.SecurityVendorInformation;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.CountRestrictions</b>
 * <p>
 * Countable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.FilterRestrictions</b>
 * <p>
 * Filterable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.SelectRestrictions</b>
 * <p>
 * Selectable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.SkipSupported</b>
 * <p>
 * true
 * <p>
 * <b>Org.OData.Capabilities.V1.SortRestrictions</b>
 * <p>
 * Sortable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.TopSupported</b>
 * <p>
 * true
 */@JsonPropertyOrder({
    "@odata.type", 
    "activityGroupNames", 
    "azureSubscriptionId", 
    "azureTenantId", 
    "countHits", 
    "countInOrg", 
    "domainCategories", 
    "domainRegisteredDateTime", 
    "firstSeenDateTime", 
    "lastSeenDateTime", 
    "name", 
    "registrant", 
    "riskScore", 
    "tags", 
    "vendorInformation"})
@JsonInclude(Include.NON_NULL)
public class DomainSecurityProfile extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.domainSecurityProfile";
    }

    @JsonProperty("activityGroupNames")
    protected List<String> activityGroupNames;

    @JsonProperty("activityGroupNames@nextLink")
    protected String activityGroupNamesNextLink;

    @JsonProperty("azureSubscriptionId")
    protected String azureSubscriptionId;

    @JsonProperty("azureTenantId")
    protected String azureTenantId;

    @JsonProperty("countHits")
    protected Integer countHits;

    @JsonProperty("countInOrg")
    protected Integer countInOrg;

    @JsonProperty("domainCategories")
    protected List<ReputationCategory> domainCategories;

    @JsonProperty("domainCategories@nextLink")
    protected String domainCategoriesNextLink;

    @JsonProperty("domainRegisteredDateTime")
    protected OffsetDateTime domainRegisteredDateTime;

    @JsonProperty("firstSeenDateTime")
    protected OffsetDateTime firstSeenDateTime;

    @JsonProperty("lastSeenDateTime")
    protected OffsetDateTime lastSeenDateTime;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("registrant")
    protected DomainRegistrant registrant;

    @JsonProperty("riskScore")
    protected String riskScore;

    @JsonProperty("tags")
    protected List<String> tags;

    @JsonProperty("tags@nextLink")
    protected String tagsNextLink;

    @JsonProperty("vendorInformation")
    protected SecurityVendorInformation vendorInformation;

    protected DomainSecurityProfile() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDomainSecurityProfile() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<String> activityGroupNames;
        private String activityGroupNamesNextLink;
        private String azureSubscriptionId;
        private String azureTenantId;
        private Integer countHits;
        private Integer countInOrg;
        private List<ReputationCategory> domainCategories;
        private String domainCategoriesNextLink;
        private OffsetDateTime domainRegisteredDateTime;
        private OffsetDateTime firstSeenDateTime;
        private OffsetDateTime lastSeenDateTime;
        private String name;
        private DomainRegistrant registrant;
        private String riskScore;
        private List<String> tags;
        private String tagsNextLink;
        private SecurityVendorInformation vendorInformation;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder activityGroupNames(List<String> activityGroupNames) {
            this.activityGroupNames = activityGroupNames;
            this.changedFields = changedFields.add("activityGroupNames");
            return this;
        }

        public Builder activityGroupNames(String... activityGroupNames) {
            return activityGroupNames(Arrays.asList(activityGroupNames));
        }

        public Builder activityGroupNamesNextLink(String activityGroupNamesNextLink) {
            this.activityGroupNamesNextLink = activityGroupNamesNextLink;
            this.changedFields = changedFields.add("activityGroupNames");
            return this;
        }

        public Builder azureSubscriptionId(String azureSubscriptionId) {
            this.azureSubscriptionId = azureSubscriptionId;
            this.changedFields = changedFields.add("azureSubscriptionId");
            return this;
        }

        public Builder azureTenantId(String azureTenantId) {
            this.azureTenantId = azureTenantId;
            this.changedFields = changedFields.add("azureTenantId");
            return this;
        }

        public Builder countHits(Integer countHits) {
            this.countHits = countHits;
            this.changedFields = changedFields.add("countHits");
            return this;
        }

        public Builder countInOrg(Integer countInOrg) {
            this.countInOrg = countInOrg;
            this.changedFields = changedFields.add("countInOrg");
            return this;
        }

        public Builder domainCategories(List<ReputationCategory> domainCategories) {
            this.domainCategories = domainCategories;
            this.changedFields = changedFields.add("domainCategories");
            return this;
        }

        public Builder domainCategories(ReputationCategory... domainCategories) {
            return domainCategories(Arrays.asList(domainCategories));
        }

        public Builder domainCategoriesNextLink(String domainCategoriesNextLink) {
            this.domainCategoriesNextLink = domainCategoriesNextLink;
            this.changedFields = changedFields.add("domainCategories");
            return this;
        }

        public Builder domainRegisteredDateTime(OffsetDateTime domainRegisteredDateTime) {
            this.domainRegisteredDateTime = domainRegisteredDateTime;
            this.changedFields = changedFields.add("domainRegisteredDateTime");
            return this;
        }

        public Builder firstSeenDateTime(OffsetDateTime firstSeenDateTime) {
            this.firstSeenDateTime = firstSeenDateTime;
            this.changedFields = changedFields.add("firstSeenDateTime");
            return this;
        }

        public Builder lastSeenDateTime(OffsetDateTime lastSeenDateTime) {
            this.lastSeenDateTime = lastSeenDateTime;
            this.changedFields = changedFields.add("lastSeenDateTime");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder registrant(DomainRegistrant registrant) {
            this.registrant = registrant;
            this.changedFields = changedFields.add("registrant");
            return this;
        }

        public Builder riskScore(String riskScore) {
            this.riskScore = riskScore;
            this.changedFields = changedFields.add("riskScore");
            return this;
        }

        public Builder tags(List<String> tags) {
            this.tags = tags;
            this.changedFields = changedFields.add("tags");
            return this;
        }

        public Builder tags(String... tags) {
            return tags(Arrays.asList(tags));
        }

        public Builder tagsNextLink(String tagsNextLink) {
            this.tagsNextLink = tagsNextLink;
            this.changedFields = changedFields.add("tags");
            return this;
        }

        public Builder vendorInformation(SecurityVendorInformation vendorInformation) {
            this.vendorInformation = vendorInformation;
            this.changedFields = changedFields.add("vendorInformation");
            return this;
        }

        public DomainSecurityProfile build() {
            DomainSecurityProfile _x = new DomainSecurityProfile();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.domainSecurityProfile";
            _x.id = id;
            _x.activityGroupNames = activityGroupNames;
            _x.activityGroupNamesNextLink = activityGroupNamesNextLink;
            _x.azureSubscriptionId = azureSubscriptionId;
            _x.azureTenantId = azureTenantId;
            _x.countHits = countHits;
            _x.countInOrg = countInOrg;
            _x.domainCategories = domainCategories;
            _x.domainCategoriesNextLink = domainCategoriesNextLink;
            _x.domainRegisteredDateTime = domainRegisteredDateTime;
            _x.firstSeenDateTime = firstSeenDateTime;
            _x.lastSeenDateTime = lastSeenDateTime;
            _x.name = name;
            _x.registrant = registrant;
            _x.riskScore = riskScore;
            _x.tags = tags;
            _x.tagsNextLink = tagsNextLink;
            _x.vendorInformation = vendorInformation;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="activityGroupNames")
    @JsonIgnore
    public CollectionPage<String> getActivityGroupNames() {
        return new CollectionPage<String>(contextPath, String.class, this.activityGroupNames, Optional.ofNullable(activityGroupNamesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public DomainSecurityProfile withActivityGroupNames(List<String> activityGroupNames) {
        DomainSecurityProfile _x = _copy();
        _x.changedFields = changedFields.add("activityGroupNames");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.domainSecurityProfile");
        _x.activityGroupNames = activityGroupNames;
        return _x;
    }

    @Property(name="activityGroupNames")
    @JsonIgnore
    public CollectionPage<String> getActivityGroupNames(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.activityGroupNames, Optional.ofNullable(activityGroupNamesNextLink), Collections.emptyList(), options);
    }

    @Property(name="azureSubscriptionId")
    @JsonIgnore
    public Optional<String> getAzureSubscriptionId() {
        return Optional.ofNullable(azureSubscriptionId);
    }

    public DomainSecurityProfile withAzureSubscriptionId(String azureSubscriptionId) {
        DomainSecurityProfile _x = _copy();
        _x.changedFields = changedFields.add("azureSubscriptionId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.domainSecurityProfile");
        _x.azureSubscriptionId = azureSubscriptionId;
        return _x;
    }

    @Property(name="azureTenantId")
    @JsonIgnore
    public Optional<String> getAzureTenantId() {
        return Optional.ofNullable(azureTenantId);
    }

    public DomainSecurityProfile withAzureTenantId(String azureTenantId) {
        DomainSecurityProfile _x = _copy();
        _x.changedFields = changedFields.add("azureTenantId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.domainSecurityProfile");
        _x.azureTenantId = azureTenantId;
        return _x;
    }

    @Property(name="countHits")
    @JsonIgnore
    public Optional<Integer> getCountHits() {
        return Optional.ofNullable(countHits);
    }

    public DomainSecurityProfile withCountHits(Integer countHits) {
        DomainSecurityProfile _x = _copy();
        _x.changedFields = changedFields.add("countHits");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.domainSecurityProfile");
        _x.countHits = countHits;
        return _x;
    }

    @Property(name="countInOrg")
    @JsonIgnore
    public Optional<Integer> getCountInOrg() {
        return Optional.ofNullable(countInOrg);
    }

    public DomainSecurityProfile withCountInOrg(Integer countInOrg) {
        DomainSecurityProfile _x = _copy();
        _x.changedFields = changedFields.add("countInOrg");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.domainSecurityProfile");
        _x.countInOrg = countInOrg;
        return _x;
    }

    @Property(name="domainCategories")
    @JsonIgnore
    public CollectionPage<ReputationCategory> getDomainCategories() {
        return new CollectionPage<ReputationCategory>(contextPath, ReputationCategory.class, this.domainCategories, Optional.ofNullable(domainCategoriesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public DomainSecurityProfile withDomainCategories(List<ReputationCategory> domainCategories) {
        DomainSecurityProfile _x = _copy();
        _x.changedFields = changedFields.add("domainCategories");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.domainSecurityProfile");
        _x.domainCategories = domainCategories;
        return _x;
    }

    @Property(name="domainCategories")
    @JsonIgnore
    public CollectionPage<ReputationCategory> getDomainCategories(HttpRequestOptions options) {
        return new CollectionPage<ReputationCategory>(contextPath, ReputationCategory.class, this.domainCategories, Optional.ofNullable(domainCategoriesNextLink), Collections.emptyList(), options);
    }

    @Property(name="domainRegisteredDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getDomainRegisteredDateTime() {
        return Optional.ofNullable(domainRegisteredDateTime);
    }

    public DomainSecurityProfile withDomainRegisteredDateTime(OffsetDateTime domainRegisteredDateTime) {
        DomainSecurityProfile _x = _copy();
        _x.changedFields = changedFields.add("domainRegisteredDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.domainSecurityProfile");
        _x.domainRegisteredDateTime = domainRegisteredDateTime;
        return _x;
    }

    @Property(name="firstSeenDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getFirstSeenDateTime() {
        return Optional.ofNullable(firstSeenDateTime);
    }

    public DomainSecurityProfile withFirstSeenDateTime(OffsetDateTime firstSeenDateTime) {
        DomainSecurityProfile _x = _copy();
        _x.changedFields = changedFields.add("firstSeenDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.domainSecurityProfile");
        _x.firstSeenDateTime = firstSeenDateTime;
        return _x;
    }

    @Property(name="lastSeenDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastSeenDateTime() {
        return Optional.ofNullable(lastSeenDateTime);
    }

    public DomainSecurityProfile withLastSeenDateTime(OffsetDateTime lastSeenDateTime) {
        DomainSecurityProfile _x = _copy();
        _x.changedFields = changedFields.add("lastSeenDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.domainSecurityProfile");
        _x.lastSeenDateTime = lastSeenDateTime;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public DomainSecurityProfile withName(String name) {
        DomainSecurityProfile _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.domainSecurityProfile");
        _x.name = name;
        return _x;
    }

    @Property(name="registrant")
    @JsonIgnore
    public Optional<DomainRegistrant> getRegistrant() {
        return Optional.ofNullable(registrant);
    }

    public DomainSecurityProfile withRegistrant(DomainRegistrant registrant) {
        DomainSecurityProfile _x = _copy();
        _x.changedFields = changedFields.add("registrant");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.domainSecurityProfile");
        _x.registrant = registrant;
        return _x;
    }

    @Property(name="riskScore")
    @JsonIgnore
    public Optional<String> getRiskScore() {
        return Optional.ofNullable(riskScore);
    }

    public DomainSecurityProfile withRiskScore(String riskScore) {
        DomainSecurityProfile _x = _copy();
        _x.changedFields = changedFields.add("riskScore");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.domainSecurityProfile");
        _x.riskScore = riskScore;
        return _x;
    }

    @Property(name="tags")
    @JsonIgnore
    public CollectionPage<String> getTags() {
        return new CollectionPage<String>(contextPath, String.class, this.tags, Optional.ofNullable(tagsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public DomainSecurityProfile withTags(List<String> tags) {
        DomainSecurityProfile _x = _copy();
        _x.changedFields = changedFields.add("tags");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.domainSecurityProfile");
        _x.tags = tags;
        return _x;
    }

    @Property(name="tags")
    @JsonIgnore
    public CollectionPage<String> getTags(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.tags, Optional.ofNullable(tagsNextLink), Collections.emptyList(), options);
    }

    @Property(name="vendorInformation")
    @JsonIgnore
    public Optional<SecurityVendorInformation> getVendorInformation() {
        return Optional.ofNullable(vendorInformation);
    }

    public DomainSecurityProfile withVendorInformation(SecurityVendorInformation vendorInformation) {
        DomainSecurityProfile _x = _copy();
        _x.changedFields = changedFields.add("vendorInformation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.domainSecurityProfile");
        _x.vendorInformation = vendorInformation;
        return _x;
    }

    public DomainSecurityProfile withUnmappedField(String name, Object value) {
        DomainSecurityProfile _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DomainSecurityProfile patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DomainSecurityProfile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DomainSecurityProfile put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DomainSecurityProfile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DomainSecurityProfile _copy() {
        DomainSecurityProfile _x = new DomainSecurityProfile();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.activityGroupNames = activityGroupNames;
        _x.azureSubscriptionId = azureSubscriptionId;
        _x.azureTenantId = azureTenantId;
        _x.countHits = countHits;
        _x.countInOrg = countInOrg;
        _x.domainCategories = domainCategories;
        _x.domainRegisteredDateTime = domainRegisteredDateTime;
        _x.firstSeenDateTime = firstSeenDateTime;
        _x.lastSeenDateTime = lastSeenDateTime;
        _x.name = name;
        _x.registrant = registrant;
        _x.riskScore = riskScore;
        _x.tags = tags;
        _x.vendorInformation = vendorInformation;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DomainSecurityProfile[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("activityGroupNames=");
        b.append(this.activityGroupNames);
        b.append(", ");
        b.append("azureSubscriptionId=");
        b.append(this.azureSubscriptionId);
        b.append(", ");
        b.append("azureTenantId=");
        b.append(this.azureTenantId);
        b.append(", ");
        b.append("countHits=");
        b.append(this.countHits);
        b.append(", ");
        b.append("countInOrg=");
        b.append(this.countInOrg);
        b.append(", ");
        b.append("domainCategories=");
        b.append(this.domainCategories);
        b.append(", ");
        b.append("domainRegisteredDateTime=");
        b.append(this.domainRegisteredDateTime);
        b.append(", ");
        b.append("firstSeenDateTime=");
        b.append(this.firstSeenDateTime);
        b.append(", ");
        b.append("lastSeenDateTime=");
        b.append(this.lastSeenDateTime);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("registrant=");
        b.append(this.registrant);
        b.append(", ");
        b.append("riskScore=");
        b.append(this.riskScore);
        b.append(", ");
        b.append("tags=");
        b.append(this.tags);
        b.append(", ");
        b.append("vendorInformation=");
        b.append(this.vendorInformation);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
