package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "nameTarget", 
    "port", 
    "priority", 
    "protocol", 
    "service", 
    "weight"})
@JsonInclude(Include.NON_NULL)
public class DomainDnsSrvRecord extends DomainDnsRecord implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.domainDnsSrvRecord";
    }

    @JsonProperty("nameTarget")
    protected String nameTarget;

    @JsonProperty("port")
    protected Integer port;

    @JsonProperty("priority")
    protected Integer priority;

    @JsonProperty("protocol")
    protected String protocol;

    @JsonProperty("service")
    protected String service;

    @JsonProperty("weight")
    protected Integer weight;

    protected DomainDnsSrvRecord() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDomainDnsSrvRecord() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Boolean isOptional;
        private String label;
        private String recordType;
        private String supportedService;
        private Integer ttl;
        private String nameTarget;
        private Integer port;
        private Integer priority;
        private String protocol;
        private String service;
        private Integer weight;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder isOptional(Boolean isOptional) {
            this.isOptional = isOptional;
            this.changedFields = changedFields.add("isOptional");
            return this;
        }

        public Builder label(String label) {
            this.label = label;
            this.changedFields = changedFields.add("label");
            return this;
        }

        public Builder recordType(String recordType) {
            this.recordType = recordType;
            this.changedFields = changedFields.add("recordType");
            return this;
        }

        public Builder supportedService(String supportedService) {
            this.supportedService = supportedService;
            this.changedFields = changedFields.add("supportedService");
            return this;
        }

        public Builder ttl(Integer ttl) {
            this.ttl = ttl;
            this.changedFields = changedFields.add("ttl");
            return this;
        }

        public Builder nameTarget(String nameTarget) {
            this.nameTarget = nameTarget;
            this.changedFields = changedFields.add("nameTarget");
            return this;
        }

        public Builder port(Integer port) {
            this.port = port;
            this.changedFields = changedFields.add("port");
            return this;
        }

        public Builder priority(Integer priority) {
            this.priority = priority;
            this.changedFields = changedFields.add("priority");
            return this;
        }

        public Builder protocol(String protocol) {
            this.protocol = protocol;
            this.changedFields = changedFields.add("protocol");
            return this;
        }

        public Builder service(String service) {
            this.service = service;
            this.changedFields = changedFields.add("service");
            return this;
        }

        public Builder weight(Integer weight) {
            this.weight = weight;
            this.changedFields = changedFields.add("weight");
            return this;
        }

        public DomainDnsSrvRecord build() {
            DomainDnsSrvRecord _x = new DomainDnsSrvRecord();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.domainDnsSrvRecord";
            _x.id = id;
            _x.isOptional = isOptional;
            _x.label = label;
            _x.recordType = recordType;
            _x.supportedService = supportedService;
            _x.ttl = ttl;
            _x.nameTarget = nameTarget;
            _x.port = port;
            _x.priority = priority;
            _x.protocol = protocol;
            _x.service = service;
            _x.weight = weight;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="nameTarget")
    @JsonIgnore
    public Optional<String> getNameTarget() {
        return Optional.ofNullable(nameTarget);
    }

    public DomainDnsSrvRecord withNameTarget(String nameTarget) {
        DomainDnsSrvRecord _x = _copy();
        _x.changedFields = changedFields.add("nameTarget");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.domainDnsSrvRecord");
        _x.nameTarget = nameTarget;
        return _x;
    }

    @Property(name="port")
    @JsonIgnore
    public Optional<Integer> getPort() {
        return Optional.ofNullable(port);
    }

    public DomainDnsSrvRecord withPort(Integer port) {
        DomainDnsSrvRecord _x = _copy();
        _x.changedFields = changedFields.add("port");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.domainDnsSrvRecord");
        _x.port = port;
        return _x;
    }

    @Property(name="priority")
    @JsonIgnore
    public Optional<Integer> getPriority() {
        return Optional.ofNullable(priority);
    }

    public DomainDnsSrvRecord withPriority(Integer priority) {
        DomainDnsSrvRecord _x = _copy();
        _x.changedFields = changedFields.add("priority");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.domainDnsSrvRecord");
        _x.priority = priority;
        return _x;
    }

    @Property(name="protocol")
    @JsonIgnore
    public Optional<String> getProtocol() {
        return Optional.ofNullable(protocol);
    }

    public DomainDnsSrvRecord withProtocol(String protocol) {
        DomainDnsSrvRecord _x = _copy();
        _x.changedFields = changedFields.add("protocol");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.domainDnsSrvRecord");
        _x.protocol = protocol;
        return _x;
    }

    @Property(name="service")
    @JsonIgnore
    public Optional<String> getService() {
        return Optional.ofNullable(service);
    }

    public DomainDnsSrvRecord withService(String service) {
        DomainDnsSrvRecord _x = _copy();
        _x.changedFields = changedFields.add("service");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.domainDnsSrvRecord");
        _x.service = service;
        return _x;
    }

    @Property(name="weight")
    @JsonIgnore
    public Optional<Integer> getWeight() {
        return Optional.ofNullable(weight);
    }

    public DomainDnsSrvRecord withWeight(Integer weight) {
        DomainDnsSrvRecord _x = _copy();
        _x.changedFields = changedFields.add("weight");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.domainDnsSrvRecord");
        _x.weight = weight;
        return _x;
    }

    public DomainDnsSrvRecord withUnmappedField(String name, Object value) {
        DomainDnsSrvRecord _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DomainDnsSrvRecord patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DomainDnsSrvRecord _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DomainDnsSrvRecord put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DomainDnsSrvRecord _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DomainDnsSrvRecord _copy() {
        DomainDnsSrvRecord _x = new DomainDnsSrvRecord();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.isOptional = isOptional;
        _x.label = label;
        _x.recordType = recordType;
        _x.supportedService = supportedService;
        _x.ttl = ttl;
        _x.nameTarget = nameTarget;
        _x.port = port;
        _x.priority = priority;
        _x.protocol = protocol;
        _x.service = service;
        _x.weight = weight;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DomainDnsSrvRecord[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("isOptional=");
        b.append(this.isOptional);
        b.append(", ");
        b.append("label=");
        b.append(this.label);
        b.append(", ");
        b.append("recordType=");
        b.append(this.recordType);
        b.append(", ");
        b.append("supportedService=");
        b.append(this.supportedService);
        b.append(", ");
        b.append("ttl=");
        b.append(this.ttl);
        b.append(", ");
        b.append("nameTarget=");
        b.append(this.nameTarget);
        b.append(", ");
        b.append("port=");
        b.append(this.port);
        b.append(", ");
        b.append("priority=");
        b.append(this.priority);
        b.append(", ");
        b.append("protocol=");
        b.append(this.protocol);
        b.append(", ");
        b.append("service=");
        b.append(this.service);
        b.append(", ");
        b.append("weight=");
        b.append(this.weight);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
