package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "mailExchange", 
    "preference"})
@JsonInclude(Include.NON_NULL)
public class DomainDnsMxRecord extends DomainDnsRecord implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.domainDnsMxRecord";
    }

    @JsonProperty("mailExchange")
    protected String mailExchange;

    @JsonProperty("preference")
    protected Integer preference;

    protected DomainDnsMxRecord() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDomainDnsMxRecord() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Boolean isOptional;
        private String label;
        private String recordType;
        private String supportedService;
        private Integer ttl;
        private String mailExchange;
        private Integer preference;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder isOptional(Boolean isOptional) {
            this.isOptional = isOptional;
            this.changedFields = changedFields.add("isOptional");
            return this;
        }

        public Builder label(String label) {
            this.label = label;
            this.changedFields = changedFields.add("label");
            return this;
        }

        public Builder recordType(String recordType) {
            this.recordType = recordType;
            this.changedFields = changedFields.add("recordType");
            return this;
        }

        public Builder supportedService(String supportedService) {
            this.supportedService = supportedService;
            this.changedFields = changedFields.add("supportedService");
            return this;
        }

        public Builder ttl(Integer ttl) {
            this.ttl = ttl;
            this.changedFields = changedFields.add("ttl");
            return this;
        }

        public Builder mailExchange(String mailExchange) {
            this.mailExchange = mailExchange;
            this.changedFields = changedFields.add("mailExchange");
            return this;
        }

        public Builder preference(Integer preference) {
            this.preference = preference;
            this.changedFields = changedFields.add("preference");
            return this;
        }

        public DomainDnsMxRecord build() {
            DomainDnsMxRecord _x = new DomainDnsMxRecord();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.domainDnsMxRecord";
            _x.id = id;
            _x.isOptional = isOptional;
            _x.label = label;
            _x.recordType = recordType;
            _x.supportedService = supportedService;
            _x.ttl = ttl;
            _x.mailExchange = mailExchange;
            _x.preference = preference;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="mailExchange")
    @JsonIgnore
    public Optional<String> getMailExchange() {
        return Optional.ofNullable(mailExchange);
    }

    public DomainDnsMxRecord withMailExchange(String mailExchange) {
        DomainDnsMxRecord _x = _copy();
        _x.changedFields = changedFields.add("mailExchange");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.domainDnsMxRecord");
        _x.mailExchange = mailExchange;
        return _x;
    }

    @Property(name="preference")
    @JsonIgnore
    public Optional<Integer> getPreference() {
        return Optional.ofNullable(preference);
    }

    public DomainDnsMxRecord withPreference(Integer preference) {
        DomainDnsMxRecord _x = _copy();
        _x.changedFields = changedFields.add("preference");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.domainDnsMxRecord");
        _x.preference = preference;
        return _x;
    }

    public DomainDnsMxRecord withUnmappedField(String name, Object value) {
        DomainDnsMxRecord _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DomainDnsMxRecord patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DomainDnsMxRecord _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DomainDnsMxRecord put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DomainDnsMxRecord _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DomainDnsMxRecord _copy() {
        DomainDnsMxRecord _x = new DomainDnsMxRecord();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.isOptional = isOptional;
        _x.label = label;
        _x.recordType = recordType;
        _x.supportedService = supportedService;
        _x.ttl = ttl;
        _x.mailExchange = mailExchange;
        _x.preference = preference;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DomainDnsMxRecord[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("isOptional=");
        b.append(this.isOptional);
        b.append(", ");
        b.append("label=");
        b.append(this.label);
        b.append(", ");
        b.append("recordType=");
        b.append(this.recordType);
        b.append(", ");
        b.append("supportedService=");
        b.append(this.supportedService);
        b.append(", ");
        b.append("ttl=");
        b.append(this.ttl);
        b.append(", ");
        b.append("mailExchange=");
        b.append(this.mailExchange);
        b.append(", ");
        b.append("preference=");
        b.append(this.preference);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
