package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.DocumentCommentReplyCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "content", 
    "replies"})
@JsonInclude(Include.NON_NULL)
public class DocumentComment extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.documentComment";
    }

    @JsonProperty("content")
    protected String content;

    @JsonProperty("replies")
    protected List<DocumentCommentReply> replies;

    protected DocumentComment() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDocumentComment() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String content;
        private List<DocumentCommentReply> replies;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder content(String content) {
            this.content = content;
            this.changedFields = changedFields.add("content");
            return this;
        }

        public Builder replies(List<DocumentCommentReply> replies) {
            this.replies = replies;
            this.changedFields = changedFields.add("replies");
            return this;
        }

        public Builder replies(DocumentCommentReply... replies) {
            return replies(Arrays.asList(replies));
        }

        public DocumentComment build() {
            DocumentComment _x = new DocumentComment();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.documentComment";
            _x.id = id;
            _x.content = content;
            _x.replies = replies;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="content")
    @JsonIgnore
    public Optional<String> getContent() {
        return Optional.ofNullable(content);
    }

    public DocumentComment withContent(String content) {
        DocumentComment _x = _copy();
        _x.changedFields = changedFields.add("content");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.documentComment");
        _x.content = content;
        return _x;
    }

    public DocumentComment withUnmappedField(String name, Object value) {
        DocumentComment _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="replies")
    @JsonIgnore
    public DocumentCommentReplyCollectionRequest getReplies() {
        return new DocumentCommentReplyCollectionRequest(
                        contextPath.addSegment("replies"), Optional.ofNullable(replies));
    }

    public DocumentComment withReplies(List<DocumentCommentReply> replies) {
        DocumentComment _x = _copy();
        _x.changedFields = changedFields.add("replies");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.documentComment");
        _x.replies = replies;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DocumentComment patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DocumentComment _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DocumentComment put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DocumentComment _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DocumentComment _copy() {
        DocumentComment _x = new DocumentComment();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.content = content;
        _x.replies = replies;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DocumentComment[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("content=");
        b.append(this.content);
        b.append(", ");
        b.append("replies=");
        b.append(this.replies);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
