package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.ObjectDefinition;
import odata.msgraph.client.beta.enums.DirectoryDefinitionDiscoverabilities;

@JsonPropertyOrder({
    "@odata.type", 
    "discoverabilities", 
    "discoveryDateTime", 
    "name", 
    "objects", 
    "readOnly", 
    "version"})
@JsonInclude(Include.NON_NULL)
public class DirectoryDefinition extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.directoryDefinition";
    }

    @JsonProperty("discoverabilities")
    protected DirectoryDefinitionDiscoverabilities discoverabilities;

    @JsonProperty("discoveryDateTime")
    protected OffsetDateTime discoveryDateTime;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("objects")
    protected List<ObjectDefinition> objects;

    @JsonProperty("objects@nextLink")
    protected String objectsNextLink;

    @JsonProperty("readOnly")
    protected Boolean readOnly;

    @JsonProperty("version")
    protected String version;

    protected DirectoryDefinition() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDirectoryDefinition() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private DirectoryDefinitionDiscoverabilities discoverabilities;
        private OffsetDateTime discoveryDateTime;
        private String name;
        private List<ObjectDefinition> objects;
        private String objectsNextLink;
        private Boolean readOnly;
        private String version;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder discoverabilities(DirectoryDefinitionDiscoverabilities discoverabilities) {
            this.discoverabilities = discoverabilities;
            this.changedFields = changedFields.add("discoverabilities");
            return this;
        }

        public Builder discoveryDateTime(OffsetDateTime discoveryDateTime) {
            this.discoveryDateTime = discoveryDateTime;
            this.changedFields = changedFields.add("discoveryDateTime");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder objects(List<ObjectDefinition> objects) {
            this.objects = objects;
            this.changedFields = changedFields.add("objects");
            return this;
        }

        public Builder objects(ObjectDefinition... objects) {
            return objects(Arrays.asList(objects));
        }

        public Builder objectsNextLink(String objectsNextLink) {
            this.objectsNextLink = objectsNextLink;
            this.changedFields = changedFields.add("objects");
            return this;
        }

        public Builder readOnly(Boolean readOnly) {
            this.readOnly = readOnly;
            this.changedFields = changedFields.add("readOnly");
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public DirectoryDefinition build() {
            DirectoryDefinition _x = new DirectoryDefinition();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.directoryDefinition";
            _x.id = id;
            _x.discoverabilities = discoverabilities;
            _x.discoveryDateTime = discoveryDateTime;
            _x.name = name;
            _x.objects = objects;
            _x.objectsNextLink = objectsNextLink;
            _x.readOnly = readOnly;
            _x.version = version;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="discoverabilities")
    @JsonIgnore
    public Optional<DirectoryDefinitionDiscoverabilities> getDiscoverabilities() {
        return Optional.ofNullable(discoverabilities);
    }

    public DirectoryDefinition withDiscoverabilities(DirectoryDefinitionDiscoverabilities discoverabilities) {
        DirectoryDefinition _x = _copy();
        _x.changedFields = changedFields.add("discoverabilities");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.directoryDefinition");
        _x.discoverabilities = discoverabilities;
        return _x;
    }

    @Property(name="discoveryDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getDiscoveryDateTime() {
        return Optional.ofNullable(discoveryDateTime);
    }

    public DirectoryDefinition withDiscoveryDateTime(OffsetDateTime discoveryDateTime) {
        DirectoryDefinition _x = _copy();
        _x.changedFields = changedFields.add("discoveryDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.directoryDefinition");
        _x.discoveryDateTime = discoveryDateTime;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public DirectoryDefinition withName(String name) {
        DirectoryDefinition _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.directoryDefinition");
        _x.name = name;
        return _x;
    }

    @Property(name="objects")
    @JsonIgnore
    public CollectionPage<ObjectDefinition> getObjects() {
        return new CollectionPage<ObjectDefinition>(contextPath, ObjectDefinition.class, this.objects, Optional.ofNullable(objectsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public DirectoryDefinition withObjects(List<ObjectDefinition> objects) {
        DirectoryDefinition _x = _copy();
        _x.changedFields = changedFields.add("objects");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.directoryDefinition");
        _x.objects = objects;
        return _x;
    }

    @Property(name="objects")
    @JsonIgnore
    public CollectionPage<ObjectDefinition> getObjects(HttpRequestOptions options) {
        return new CollectionPage<ObjectDefinition>(contextPath, ObjectDefinition.class, this.objects, Optional.ofNullable(objectsNextLink), Collections.emptyList(), options);
    }

    @Property(name="readOnly")
    @JsonIgnore
    public Optional<Boolean> getReadOnly() {
        return Optional.ofNullable(readOnly);
    }

    public DirectoryDefinition withReadOnly(Boolean readOnly) {
        DirectoryDefinition _x = _copy();
        _x.changedFields = changedFields.add("readOnly");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.directoryDefinition");
        _x.readOnly = readOnly;
        return _x;
    }

    @Property(name="version")
    @JsonIgnore
    public Optional<String> getVersion() {
        return Optional.ofNullable(version);
    }

    public DirectoryDefinition withVersion(String version) {
        DirectoryDefinition _x = _copy();
        _x.changedFields = changedFields.add("version");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.directoryDefinition");
        _x.version = version;
        return _x;
    }

    public DirectoryDefinition withUnmappedField(String name, Object value) {
        DirectoryDefinition _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DirectoryDefinition patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DirectoryDefinition _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DirectoryDefinition put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DirectoryDefinition _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DirectoryDefinition _copy() {
        DirectoryDefinition _x = new DirectoryDefinition();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.discoverabilities = discoverabilities;
        _x.discoveryDateTime = discoveryDateTime;
        _x.name = name;
        _x.objects = objects;
        _x.readOnly = readOnly;
        _x.version = version;
        return _x;
    }

    @Action(name = "discover")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<DirectoryDefinition> discover() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<DirectoryDefinition>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.discover"), DirectoryDefinition.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DirectoryDefinition[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("discoverabilities=");
        b.append(this.discoverabilities);
        b.append(", ");
        b.append("discoveryDateTime=");
        b.append(this.discoveryDateTime);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("objects=");
        b.append(this.objects);
        b.append(", ");
        b.append("readOnly=");
        b.append(this.readOnly);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
