package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.AdministrativeUnitCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AttributeSetCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.CustomSecurityAttributeDefinitionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DirectoryObjectCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.FeatureRolloutPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.IdentityProviderBaseCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.InboundSharedUserProfileCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.OutboundSharedUserProfileCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.RecommendationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.RecommendationResourceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SharedEmailDomainCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "impactedResources", 
    "recommendations", 
    "administrativeUnits", 
    "attributeSets", 
    "customSecurityAttributeDefinitions", 
    "deletedItems", 
    "federationConfigurations", 
    "inboundSharedUserProfiles", 
    "outboundSharedUserProfiles", 
    "sharedEmailDomains", 
    "featureRolloutPolicies"})
@JsonInclude(Include.NON_NULL)
public class Directory extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.directory";
    }

    @JsonProperty("impactedResources")
    protected List<RecommendationResource> impactedResources;

    @JsonProperty("recommendations")
    protected List<Recommendation> recommendations;

    @JsonProperty("administrativeUnits")
    protected List<AdministrativeUnit> administrativeUnits;

    @JsonProperty("attributeSets")
    protected List<AttributeSet> attributeSets;

    @JsonProperty("customSecurityAttributeDefinitions")
    protected List<CustomSecurityAttributeDefinition> customSecurityAttributeDefinitions;

    @JsonProperty("deletedItems")
    protected List<DirectoryObject> deletedItems;

    @JsonProperty("federationConfigurations")
    protected List<IdentityProviderBase> federationConfigurations;

    @JsonProperty("inboundSharedUserProfiles")
    protected List<InboundSharedUserProfile> inboundSharedUserProfiles;

    @JsonProperty("outboundSharedUserProfiles")
    protected List<OutboundSharedUserProfile> outboundSharedUserProfiles;

    @JsonProperty("sharedEmailDomains")
    protected List<SharedEmailDomain> sharedEmailDomains;

    @JsonProperty("featureRolloutPolicies")
    protected List<FeatureRolloutPolicy> featureRolloutPolicies;

    protected Directory() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDirectory() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<RecommendationResource> impactedResources;
        private List<Recommendation> recommendations;
        private List<AdministrativeUnit> administrativeUnits;
        private List<AttributeSet> attributeSets;
        private List<CustomSecurityAttributeDefinition> customSecurityAttributeDefinitions;
        private List<DirectoryObject> deletedItems;
        private List<IdentityProviderBase> federationConfigurations;
        private List<InboundSharedUserProfile> inboundSharedUserProfiles;
        private List<OutboundSharedUserProfile> outboundSharedUserProfiles;
        private List<SharedEmailDomain> sharedEmailDomains;
        private List<FeatureRolloutPolicy> featureRolloutPolicies;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder impactedResources(List<RecommendationResource> impactedResources) {
            this.impactedResources = impactedResources;
            this.changedFields = changedFields.add("impactedResources");
            return this;
        }

        public Builder impactedResources(RecommendationResource... impactedResources) {
            return impactedResources(Arrays.asList(impactedResources));
        }

        public Builder recommendations(List<Recommendation> recommendations) {
            this.recommendations = recommendations;
            this.changedFields = changedFields.add("recommendations");
            return this;
        }

        public Builder recommendations(Recommendation... recommendations) {
            return recommendations(Arrays.asList(recommendations));
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = true
         * 
         * @param administrativeUnits
         *            value of {@code administrativeUnits} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder administrativeUnits(List<AdministrativeUnit> administrativeUnits) {
            this.administrativeUnits = administrativeUnits;
            this.changedFields = changedFields.add("administrativeUnits");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = true
         * 
         * @param administrativeUnits
         *            value of {@code administrativeUnits} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder administrativeUnits(AdministrativeUnit... administrativeUnits) {
            return administrativeUnits(Arrays.asList(administrativeUnits));
        }

        public Builder attributeSets(List<AttributeSet> attributeSets) {
            this.attributeSets = attributeSets;
            this.changedFields = changedFields.add("attributeSets");
            return this;
        }

        public Builder attributeSets(AttributeSet... attributeSets) {
            return attributeSets(Arrays.asList(attributeSets));
        }

        public Builder customSecurityAttributeDefinitions(List<CustomSecurityAttributeDefinition> customSecurityAttributeDefinitions) {
            this.customSecurityAttributeDefinitions = customSecurityAttributeDefinitions;
            this.changedFields = changedFields.add("customSecurityAttributeDefinitions");
            return this;
        }

        public Builder customSecurityAttributeDefinitions(CustomSecurityAttributeDefinition... customSecurityAttributeDefinitions) {
            return customSecurityAttributeDefinitions(Arrays.asList(customSecurityAttributeDefinitions));
        }

        public Builder deletedItems(List<DirectoryObject> deletedItems) {
            this.deletedItems = deletedItems;
            this.changedFields = changedFields.add("deletedItems");
            return this;
        }

        public Builder deletedItems(DirectoryObject... deletedItems) {
            return deletedItems(Arrays.asList(deletedItems));
        }

        public Builder federationConfigurations(List<IdentityProviderBase> federationConfigurations) {
            this.federationConfigurations = federationConfigurations;
            this.changedFields = changedFields.add("federationConfigurations");
            return this;
        }

        public Builder federationConfigurations(IdentityProviderBase... federationConfigurations) {
            return federationConfigurations(Arrays.asList(federationConfigurations));
        }

        public Builder inboundSharedUserProfiles(List<InboundSharedUserProfile> inboundSharedUserProfiles) {
            this.inboundSharedUserProfiles = inboundSharedUserProfiles;
            this.changedFields = changedFields.add("inboundSharedUserProfiles");
            return this;
        }

        public Builder inboundSharedUserProfiles(InboundSharedUserProfile... inboundSharedUserProfiles) {
            return inboundSharedUserProfiles(Arrays.asList(inboundSharedUserProfiles));
        }

        public Builder outboundSharedUserProfiles(List<OutboundSharedUserProfile> outboundSharedUserProfiles) {
            this.outboundSharedUserProfiles = outboundSharedUserProfiles;
            this.changedFields = changedFields.add("outboundSharedUserProfiles");
            return this;
        }

        public Builder outboundSharedUserProfiles(OutboundSharedUserProfile... outboundSharedUserProfiles) {
            return outboundSharedUserProfiles(Arrays.asList(outboundSharedUserProfiles));
        }

        public Builder sharedEmailDomains(List<SharedEmailDomain> sharedEmailDomains) {
            this.sharedEmailDomains = sharedEmailDomains;
            this.changedFields = changedFields.add("sharedEmailDomains");
            return this;
        }

        public Builder sharedEmailDomains(SharedEmailDomain... sharedEmailDomains) {
            return sharedEmailDomains(Arrays.asList(sharedEmailDomains));
        }

        /**
         * <p>
         * <b>Org.OData.Core.V1.Revisions</b>
         * 
         * @param featureRolloutPolicies
         *            value of {@code featureRolloutPolicies} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder featureRolloutPolicies(List<FeatureRolloutPolicy> featureRolloutPolicies) {
            this.featureRolloutPolicies = featureRolloutPolicies;
            this.changedFields = changedFields.add("featureRolloutPolicies");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Core.V1.Revisions</b>
         * 
         * @param featureRolloutPolicies
         *            value of {@code featureRolloutPolicies} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder featureRolloutPolicies(FeatureRolloutPolicy... featureRolloutPolicies) {
            return featureRolloutPolicies(Arrays.asList(featureRolloutPolicies));
        }

        public Directory build() {
            Directory _x = new Directory();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.directory";
            _x.id = id;
            _x.impactedResources = impactedResources;
            _x.recommendations = recommendations;
            _x.administrativeUnits = administrativeUnits;
            _x.attributeSets = attributeSets;
            _x.customSecurityAttributeDefinitions = customSecurityAttributeDefinitions;
            _x.deletedItems = deletedItems;
            _x.federationConfigurations = federationConfigurations;
            _x.inboundSharedUserProfiles = inboundSharedUserProfiles;
            _x.outboundSharedUserProfiles = outboundSharedUserProfiles;
            _x.sharedEmailDomains = sharedEmailDomains;
            _x.featureRolloutPolicies = featureRolloutPolicies;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    public Directory withUnmappedField(String name, Object value) {
        Directory _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="impactedResources")
    @JsonIgnore
    public RecommendationResourceCollectionRequest getImpactedResources() {
        return new RecommendationResourceCollectionRequest(
                        contextPath.addSegment("impactedResources"), Optional.ofNullable(impactedResources));
    }

    @NavigationProperty(name="recommendations")
    @JsonIgnore
    public RecommendationCollectionRequest getRecommendations() {
        return new RecommendationCollectionRequest(
                        contextPath.addSegment("recommendations"), Optional.ofNullable(recommendations));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = true
     * 
     * @return navigational property administrativeUnits
     */
    @NavigationProperty(name="administrativeUnits")
    @JsonIgnore
    public AdministrativeUnitCollectionRequest getAdministrativeUnits() {
        return new AdministrativeUnitCollectionRequest(
                        contextPath.addSegment("administrativeUnits"), Optional.ofNullable(administrativeUnits));
    }

    @NavigationProperty(name="attributeSets")
    @JsonIgnore
    public AttributeSetCollectionRequest getAttributeSets() {
        return new AttributeSetCollectionRequest(
                        contextPath.addSegment("attributeSets"), Optional.ofNullable(attributeSets));
    }

    @NavigationProperty(name="customSecurityAttributeDefinitions")
    @JsonIgnore
    public CustomSecurityAttributeDefinitionCollectionRequest getCustomSecurityAttributeDefinitions() {
        return new CustomSecurityAttributeDefinitionCollectionRequest(
                        contextPath.addSegment("customSecurityAttributeDefinitions"), Optional.ofNullable(customSecurityAttributeDefinitions));
    }

    @NavigationProperty(name="deletedItems")
    @JsonIgnore
    public DirectoryObjectCollectionRequest getDeletedItems() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("deletedItems"), Optional.ofNullable(deletedItems));
    }

    @NavigationProperty(name="federationConfigurations")
    @JsonIgnore
    public IdentityProviderBaseCollectionRequest getFederationConfigurations() {
        return new IdentityProviderBaseCollectionRequest(
                        contextPath.addSegment("federationConfigurations"), Optional.ofNullable(federationConfigurations));
    }

    @NavigationProperty(name="inboundSharedUserProfiles")
    @JsonIgnore
    public InboundSharedUserProfileCollectionRequest getInboundSharedUserProfiles() {
        return new InboundSharedUserProfileCollectionRequest(
                        contextPath.addSegment("inboundSharedUserProfiles"), Optional.ofNullable(inboundSharedUserProfiles));
    }

    @NavigationProperty(name="outboundSharedUserProfiles")
    @JsonIgnore
    public OutboundSharedUserProfileCollectionRequest getOutboundSharedUserProfiles() {
        return new OutboundSharedUserProfileCollectionRequest(
                        contextPath.addSegment("outboundSharedUserProfiles"), Optional.ofNullable(outboundSharedUserProfiles));
    }

    @NavigationProperty(name="sharedEmailDomains")
    @JsonIgnore
    public SharedEmailDomainCollectionRequest getSharedEmailDomains() {
        return new SharedEmailDomainCollectionRequest(
                        contextPath.addSegment("sharedEmailDomains"), Optional.ofNullable(sharedEmailDomains));
    }

    /**
     * <p>
     * <b>Org.OData.Core.V1.Revisions</b>
     * 
     * @return navigational property featureRolloutPolicies
     */
    @NavigationProperty(name="featureRolloutPolicies")
    @JsonIgnore
    public FeatureRolloutPolicyCollectionRequest getFeatureRolloutPolicies() {
        return new FeatureRolloutPolicyCollectionRequest(
                        contextPath.addSegment("featureRolloutPolicies"), Optional.ofNullable(featureRolloutPolicies));
    }

    public Directory withImpactedResources(List<RecommendationResource> impactedResources) {
        Directory _x = _copy();
        _x.changedFields = changedFields.add("impactedResources");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.directory");
        _x.impactedResources = impactedResources;
        return _x;
    }

    public Directory withRecommendations(List<Recommendation> recommendations) {
        Directory _x = _copy();
        _x.changedFields = changedFields.add("recommendations");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.directory");
        _x.recommendations = recommendations;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * administrativeUnits} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = true
     * 
     * @param administrativeUnits
     *            new value of {@code administrativeUnits} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code administrativeUnits} field changed
     */
    public Directory withAdministrativeUnits(List<AdministrativeUnit> administrativeUnits) {
        Directory _x = _copy();
        _x.changedFields = changedFields.add("administrativeUnits");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.directory");
        _x.administrativeUnits = administrativeUnits;
        return _x;
    }

    public Directory withAttributeSets(List<AttributeSet> attributeSets) {
        Directory _x = _copy();
        _x.changedFields = changedFields.add("attributeSets");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.directory");
        _x.attributeSets = attributeSets;
        return _x;
    }

    public Directory withCustomSecurityAttributeDefinitions(List<CustomSecurityAttributeDefinition> customSecurityAttributeDefinitions) {
        Directory _x = _copy();
        _x.changedFields = changedFields.add("customSecurityAttributeDefinitions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.directory");
        _x.customSecurityAttributeDefinitions = customSecurityAttributeDefinitions;
        return _x;
    }

    public Directory withDeletedItems(List<DirectoryObject> deletedItems) {
        Directory _x = _copy();
        _x.changedFields = changedFields.add("deletedItems");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.directory");
        _x.deletedItems = deletedItems;
        return _x;
    }

    public Directory withFederationConfigurations(List<IdentityProviderBase> federationConfigurations) {
        Directory _x = _copy();
        _x.changedFields = changedFields.add("federationConfigurations");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.directory");
        _x.federationConfigurations = federationConfigurations;
        return _x;
    }

    public Directory withInboundSharedUserProfiles(List<InboundSharedUserProfile> inboundSharedUserProfiles) {
        Directory _x = _copy();
        _x.changedFields = changedFields.add("inboundSharedUserProfiles");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.directory");
        _x.inboundSharedUserProfiles = inboundSharedUserProfiles;
        return _x;
    }

    public Directory withOutboundSharedUserProfiles(List<OutboundSharedUserProfile> outboundSharedUserProfiles) {
        Directory _x = _copy();
        _x.changedFields = changedFields.add("outboundSharedUserProfiles");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.directory");
        _x.outboundSharedUserProfiles = outboundSharedUserProfiles;
        return _x;
    }

    public Directory withSharedEmailDomains(List<SharedEmailDomain> sharedEmailDomains) {
        Directory _x = _copy();
        _x.changedFields = changedFields.add("sharedEmailDomains");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.directory");
        _x.sharedEmailDomains = sharedEmailDomains;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * featureRolloutPolicies} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <b>Org.OData.Core.V1.Revisions</b>
     * 
     * @param featureRolloutPolicies
     *            new value of {@code featureRolloutPolicies} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code featureRolloutPolicies} field changed
     */
    public Directory withFeatureRolloutPolicies(List<FeatureRolloutPolicy> featureRolloutPolicies) {
        Directory _x = _copy();
        _x.changedFields = changedFields.add("featureRolloutPolicies");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.directory");
        _x.featureRolloutPolicies = featureRolloutPolicies;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Directory patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Directory _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Directory put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Directory _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Directory _copy() {
        Directory _x = new Directory();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.impactedResources = impactedResources;
        _x.recommendations = recommendations;
        _x.administrativeUnits = administrativeUnits;
        _x.attributeSets = attributeSets;
        _x.customSecurityAttributeDefinitions = customSecurityAttributeDefinitions;
        _x.deletedItems = deletedItems;
        _x.federationConfigurations = federationConfigurations;
        _x.inboundSharedUserProfiles = inboundSharedUserProfiles;
        _x.outboundSharedUserProfiles = outboundSharedUserProfiles;
        _x.sharedEmailDomains = sharedEmailDomains;
        _x.featureRolloutPolicies = featureRolloutPolicies;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Directory[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("impactedResources=");
        b.append(this.impactedResources);
        b.append(", ");
        b.append("recommendations=");
        b.append(this.recommendations);
        b.append(", ");
        b.append("administrativeUnits=");
        b.append(this.administrativeUnits);
        b.append(", ");
        b.append("attributeSets=");
        b.append(this.attributeSets);
        b.append(", ");
        b.append("customSecurityAttributeDefinitions=");
        b.append(this.customSecurityAttributeDefinitions);
        b.append(", ");
        b.append("deletedItems=");
        b.append(this.deletedItems);
        b.append(", ");
        b.append("federationConfigurations=");
        b.append(this.federationConfigurations);
        b.append(", ");
        b.append("inboundSharedUserProfiles=");
        b.append(this.inboundSharedUserProfiles);
        b.append(", ");
        b.append("outboundSharedUserProfiles=");
        b.append(this.outboundSharedUserProfiles);
        b.append(", ");
        b.append("sharedEmailDomains=");
        b.append(this.sharedEmailDomains);
        b.append(", ");
        b.append("featureRolloutPolicies=");
        b.append(this.featureRolloutPolicies);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
