package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“Contains properties for the run summary of a device management script.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "errorDeviceCount", 
    "errorUserCount", 
    "successDeviceCount", 
    "successUserCount"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementScriptRunSummary extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementScriptRunSummary";
    }

    @JsonProperty("errorDeviceCount")
    protected Integer errorDeviceCount;

    @JsonProperty("errorUserCount")
    protected Integer errorUserCount;

    @JsonProperty("successDeviceCount")
    protected Integer successDeviceCount;

    @JsonProperty("successUserCount")
    protected Integer successUserCount;

    protected DeviceManagementScriptRunSummary() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceManagementScriptRunSummary() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Integer errorDeviceCount;
        private Integer errorUserCount;
        private Integer successDeviceCount;
        private Integer successUserCount;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Error device count.”</i>
         * 
         * @param errorDeviceCount
         *            value of {@code errorDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder errorDeviceCount(Integer errorDeviceCount) {
            this.errorDeviceCount = errorDeviceCount;
            this.changedFields = changedFields.add("errorDeviceCount");
            return this;
        }

        /**
         * <i>“Error user count.”</i>
         * 
         * @param errorUserCount
         *            value of {@code errorUserCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder errorUserCount(Integer errorUserCount) {
            this.errorUserCount = errorUserCount;
            this.changedFields = changedFields.add("errorUserCount");
            return this;
        }

        /**
         * <i>“Success device count.”</i>
         * 
         * @param successDeviceCount
         *            value of {@code successDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder successDeviceCount(Integer successDeviceCount) {
            this.successDeviceCount = successDeviceCount;
            this.changedFields = changedFields.add("successDeviceCount");
            return this;
        }

        /**
         * <i>“Success user count.”</i>
         * 
         * @param successUserCount
         *            value of {@code successUserCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder successUserCount(Integer successUserCount) {
            this.successUserCount = successUserCount;
            this.changedFields = changedFields.add("successUserCount");
            return this;
        }

        public DeviceManagementScriptRunSummary build() {
            DeviceManagementScriptRunSummary _x = new DeviceManagementScriptRunSummary();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceManagementScriptRunSummary";
            _x.id = id;
            _x.errorDeviceCount = errorDeviceCount;
            _x.errorUserCount = errorUserCount;
            _x.successDeviceCount = successDeviceCount;
            _x.successUserCount = successUserCount;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Error device count.”</i>
     * 
     * @return property errorDeviceCount
     */
    @Property(name="errorDeviceCount")
    @JsonIgnore
    public Optional<Integer> getErrorDeviceCount() {
        return Optional.ofNullable(errorDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code errorDeviceCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Error device count.”</i>
     * 
     * @param errorDeviceCount
     *            new value of {@code errorDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code errorDeviceCount} field changed
     */
    public DeviceManagementScriptRunSummary withErrorDeviceCount(Integer errorDeviceCount) {
        DeviceManagementScriptRunSummary _x = _copy();
        _x.changedFields = changedFields.add("errorDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementScriptRunSummary");
        _x.errorDeviceCount = errorDeviceCount;
        return _x;
    }

    /**
     * <i>“Error user count.”</i>
     * 
     * @return property errorUserCount
     */
    @Property(name="errorUserCount")
    @JsonIgnore
    public Optional<Integer> getErrorUserCount() {
        return Optional.ofNullable(errorUserCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code errorUserCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Error user count.”</i>
     * 
     * @param errorUserCount
     *            new value of {@code errorUserCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code errorUserCount} field changed
     */
    public DeviceManagementScriptRunSummary withErrorUserCount(Integer errorUserCount) {
        DeviceManagementScriptRunSummary _x = _copy();
        _x.changedFields = changedFields.add("errorUserCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementScriptRunSummary");
        _x.errorUserCount = errorUserCount;
        return _x;
    }

    /**
     * <i>“Success device count.”</i>
     * 
     * @return property successDeviceCount
     */
    @Property(name="successDeviceCount")
    @JsonIgnore
    public Optional<Integer> getSuccessDeviceCount() {
        return Optional.ofNullable(successDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * successDeviceCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Success device count.”</i>
     * 
     * @param successDeviceCount
     *            new value of {@code successDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code successDeviceCount} field changed
     */
    public DeviceManagementScriptRunSummary withSuccessDeviceCount(Integer successDeviceCount) {
        DeviceManagementScriptRunSummary _x = _copy();
        _x.changedFields = changedFields.add("successDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementScriptRunSummary");
        _x.successDeviceCount = successDeviceCount;
        return _x;
    }

    /**
     * <i>“Success user count.”</i>
     * 
     * @return property successUserCount
     */
    @Property(name="successUserCount")
    @JsonIgnore
    public Optional<Integer> getSuccessUserCount() {
        return Optional.ofNullable(successUserCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code successUserCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Success user count.”</i>
     * 
     * @param successUserCount
     *            new value of {@code successUserCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code successUserCount} field changed
     */
    public DeviceManagementScriptRunSummary withSuccessUserCount(Integer successUserCount) {
        DeviceManagementScriptRunSummary _x = _copy();
        _x.changedFields = changedFields.add("successUserCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementScriptRunSummary");
        _x.successUserCount = successUserCount;
        return _x;
    }

    public DeviceManagementScriptRunSummary withUnmappedField(String name, Object value) {
        DeviceManagementScriptRunSummary _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementScriptRunSummary patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementScriptRunSummary _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementScriptRunSummary put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementScriptRunSummary _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceManagementScriptRunSummary _copy() {
        DeviceManagementScriptRunSummary _x = new DeviceManagementScriptRunSummary();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.errorDeviceCount = errorDeviceCount;
        _x.errorUserCount = errorUserCount;
        _x.successDeviceCount = successDeviceCount;
        _x.successUserCount = successUserCount;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementScriptRunSummary[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("errorDeviceCount=");
        b.append(this.errorDeviceCount);
        b.append(", ");
        b.append("errorUserCount=");
        b.append(this.errorUserCount);
        b.append(", ");
        b.append("successDeviceCount=");
        b.append(this.successDeviceCount);
        b.append(", ");
        b.append("successUserCount=");
        b.append(this.successUserCount);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
