package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.entity.request.ManagedDeviceRequest;
import odata.msgraph.client.beta.enums.RunState;


/**
 * <i>“Contains properties for device run state of the device management script.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "errorCode", 
    "errorDescription", 
    "lastStateUpdateDateTime", 
    "resultMessage", 
    "runState"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementScriptDeviceState extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementScriptDeviceState";
    }

    @JsonProperty("errorCode")
    protected Integer errorCode;

    @JsonProperty("errorDescription")
    protected String errorDescription;

    @JsonProperty("lastStateUpdateDateTime")
    protected OffsetDateTime lastStateUpdateDateTime;

    @JsonProperty("resultMessage")
    protected String resultMessage;

    @JsonProperty("runState")
    protected RunState runState;

    protected DeviceManagementScriptDeviceState() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceManagementScriptDeviceState() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Integer errorCode;
        private String errorDescription;
        private OffsetDateTime lastStateUpdateDateTime;
        private String resultMessage;
        private RunState runState;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Error code corresponding to erroneous execution of the device management script.”</i>
         * 
         * @param errorCode
         *            value of {@code errorCode} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder errorCode(Integer errorCode) {
            this.errorCode = errorCode;
            this.changedFields = changedFields.add("errorCode");
            return this;
        }

        /**
         * <i>“Error description corresponding to erroneous execution of the device management
         * script.”</i>
         * 
         * @param errorDescription
         *            value of {@code errorDescription} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder errorDescription(String errorDescription) {
            this.errorDescription = errorDescription;
            this.changedFields = changedFields.add("errorDescription");
            return this;
        }

        /**
         * <i>“Latest time the device management script executes.”</i>
         * 
         * @param lastStateUpdateDateTime
         *            value of {@code lastStateUpdateDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastStateUpdateDateTime(OffsetDateTime lastStateUpdateDateTime) {
            this.lastStateUpdateDateTime = lastStateUpdateDateTime;
            this.changedFields = changedFields.add("lastStateUpdateDateTime");
            return this;
        }

        /**
         * <i>“Details of execution output.”</i>
         * 
         * @param resultMessage
         *            value of {@code resultMessage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder resultMessage(String resultMessage) {
            this.resultMessage = resultMessage;
            this.changedFields = changedFields.add("resultMessage");
            return this;
        }

        /**
         * <i>“State of latest run of the device management script.”</i>
         * 
         * @param runState
         *            value of {@code runState} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder runState(RunState runState) {
            this.runState = runState;
            this.changedFields = changedFields.add("runState");
            return this;
        }

        public DeviceManagementScriptDeviceState build() {
            DeviceManagementScriptDeviceState _x = new DeviceManagementScriptDeviceState();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceManagementScriptDeviceState";
            _x.id = id;
            _x.errorCode = errorCode;
            _x.errorDescription = errorDescription;
            _x.lastStateUpdateDateTime = lastStateUpdateDateTime;
            _x.resultMessage = resultMessage;
            _x.runState = runState;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Error code corresponding to erroneous execution of the device management script.”</i>
     * 
     * @return property errorCode
     */
    @Property(name="errorCode")
    @JsonIgnore
    public Optional<Integer> getErrorCode() {
        return Optional.ofNullable(errorCode);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code errorCode} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Error code corresponding to erroneous execution of the device management script.”</i>
     * 
     * @param errorCode
     *            new value of {@code errorCode} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code errorCode} field changed
     */
    public DeviceManagementScriptDeviceState withErrorCode(Integer errorCode) {
        DeviceManagementScriptDeviceState _x = _copy();
        _x.changedFields = changedFields.add("errorCode");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementScriptDeviceState");
        _x.errorCode = errorCode;
        return _x;
    }

    /**
     * <i>“Error description corresponding to erroneous execution of the device management
     * script.”</i>
     * 
     * @return property errorDescription
     */
    @Property(name="errorDescription")
    @JsonIgnore
    public Optional<String> getErrorDescription() {
        return Optional.ofNullable(errorDescription);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code errorDescription}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Error description corresponding to erroneous execution of the device management
     * script.”</i>
     * 
     * @param errorDescription
     *            new value of {@code errorDescription} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code errorDescription} field changed
     */
    public DeviceManagementScriptDeviceState withErrorDescription(String errorDescription) {
        DeviceManagementScriptDeviceState _x = _copy();
        _x.changedFields = changedFields.add("errorDescription");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementScriptDeviceState");
        _x.errorDescription = errorDescription;
        return _x;
    }

    /**
     * <i>“Latest time the device management script executes.”</i>
     * 
     * @return property lastStateUpdateDateTime
     */
    @Property(name="lastStateUpdateDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastStateUpdateDateTime() {
        return Optional.ofNullable(lastStateUpdateDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastStateUpdateDateTime} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Latest time the device management script executes.”</i>
     * 
     * @param lastStateUpdateDateTime
     *            new value of {@code lastStateUpdateDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastStateUpdateDateTime} field changed
     */
    public DeviceManagementScriptDeviceState withLastStateUpdateDateTime(OffsetDateTime lastStateUpdateDateTime) {
        DeviceManagementScriptDeviceState _x = _copy();
        _x.changedFields = changedFields.add("lastStateUpdateDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementScriptDeviceState");
        _x.lastStateUpdateDateTime = lastStateUpdateDateTime;
        return _x;
    }

    /**
     * <i>“Details of execution output.”</i>
     * 
     * @return property resultMessage
     */
    @Property(name="resultMessage")
    @JsonIgnore
    public Optional<String> getResultMessage() {
        return Optional.ofNullable(resultMessage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code resultMessage}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Details of execution output.”</i>
     * 
     * @param resultMessage
     *            new value of {@code resultMessage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code resultMessage} field changed
     */
    public DeviceManagementScriptDeviceState withResultMessage(String resultMessage) {
        DeviceManagementScriptDeviceState _x = _copy();
        _x.changedFields = changedFields.add("resultMessage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementScriptDeviceState");
        _x.resultMessage = resultMessage;
        return _x;
    }

    /**
     * <i>“State of latest run of the device management script.”</i>
     * 
     * @return property runState
     */
    @Property(name="runState")
    @JsonIgnore
    public Optional<RunState> getRunState() {
        return Optional.ofNullable(runState);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code runState} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“State of latest run of the device management script.”</i>
     * 
     * @param runState
     *            new value of {@code runState} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code runState} field changed
     */
    public DeviceManagementScriptDeviceState withRunState(RunState runState) {
        DeviceManagementScriptDeviceState _x = _copy();
        _x.changedFields = changedFields.add("runState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementScriptDeviceState");
        _x.runState = runState;
        return _x;
    }

    public DeviceManagementScriptDeviceState withUnmappedField(String name, Object value) {
        DeviceManagementScriptDeviceState _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“The managed devices that executes the device management script.”</i>
     * 
     * @return navigational property managedDevice
     */
    @NavigationProperty(name="managedDevice")
    @JsonIgnore
    public ManagedDeviceRequest getManagedDevice() {
        return new ManagedDeviceRequest(contextPath.addSegment("managedDevice"), RequestHelper.getValue(unmappedFields, "managedDevice"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementScriptDeviceState patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementScriptDeviceState _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementScriptDeviceState put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementScriptDeviceState _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceManagementScriptDeviceState _copy() {
        DeviceManagementScriptDeviceState _x = new DeviceManagementScriptDeviceState();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.errorCode = errorCode;
        _x.errorDescription = errorDescription;
        _x.lastStateUpdateDateTime = lastStateUpdateDateTime;
        _x.resultMessage = resultMessage;
        _x.runState = runState;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementScriptDeviceState[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("errorCode=");
        b.append(this.errorCode);
        b.append(", ");
        b.append("errorDescription=");
        b.append(this.errorDescription);
        b.append(", ");
        b.append("lastStateUpdateDateTime=");
        b.append(this.lastStateUpdateDateTime);
        b.append(", ");
        b.append("resultMessage=");
        b.append(this.resultMessage);
        b.append(", ");
        b.append("runState=");
        b.append(this.runState);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
