package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DeviceManagementSettingComparison;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementIntentAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementIntentDeviceSettingStateSummaryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementIntentDeviceStateCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementIntentSettingCategoryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementIntentUserStateCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementSettingInstanceCollectionRequest;
import odata.msgraph.client.beta.entity.request.DeviceManagementIntentDeviceStateSummaryRequest;
import odata.msgraph.client.beta.entity.request.DeviceManagementIntentUserStateSummaryRequest;


/**
 * <i>“Entity that represents an intent to apply settings to a device”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "description", 
    "displayName", 
    "isAssigned", 
    "lastModifiedDateTime", 
    "roleScopeTagIds", 
    "templateId", 
    "assignments", 
    "categories", 
    "deviceSettingStateSummaries", 
    "deviceStates", 
    "deviceStateSummary", 
    "settings", 
    "userStates", 
    "userStateSummary"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementIntent extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementIntent";
    }

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("isAssigned")
    protected Boolean isAssigned;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("roleScopeTagIds")
    protected List<String> roleScopeTagIds;

    @JsonProperty("roleScopeTagIds@nextLink")
    protected String roleScopeTagIdsNextLink;

    @JsonProperty("templateId")
    protected String templateId;

    @JsonProperty("assignments")
    protected List<DeviceManagementIntentAssignment> assignments;

    @JsonProperty("categories")
    protected List<DeviceManagementIntentSettingCategory> categories;

    @JsonProperty("deviceSettingStateSummaries")
    protected List<DeviceManagementIntentDeviceSettingStateSummary> deviceSettingStateSummaries;

    @JsonProperty("deviceStates")
    protected List<DeviceManagementIntentDeviceState> deviceStates;

    @JsonProperty("deviceStateSummary")
    protected DeviceManagementIntentDeviceStateSummary deviceStateSummary;

    @JsonProperty("settings")
    protected List<DeviceManagementSettingInstance> settings;

    @JsonProperty("userStates")
    protected List<DeviceManagementIntentUserState> userStates;

    @JsonProperty("userStateSummary")
    protected DeviceManagementIntentUserStateSummary userStateSummary;

    protected DeviceManagementIntent() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceManagementIntent() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String description;
        private String displayName;
        private Boolean isAssigned;
        private OffsetDateTime lastModifiedDateTime;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private String templateId;
        private List<DeviceManagementIntentAssignment> assignments;
        private List<DeviceManagementIntentSettingCategory> categories;
        private List<DeviceManagementIntentDeviceSettingStateSummary> deviceSettingStateSummaries;
        private List<DeviceManagementIntentDeviceState> deviceStates;
        private DeviceManagementIntentDeviceStateSummary deviceStateSummary;
        private List<DeviceManagementSettingInstance> settings;
        private List<DeviceManagementIntentUserState> userStates;
        private DeviceManagementIntentUserStateSummary userStateSummary;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The user given description”</i>
         * 
         * @param description
         *            value of {@code description} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        /**
         * <i>“The user given display name”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“Signifies whether or not the intent is assigned to users”</i>
         * 
         * @param isAssigned
         *            value of {@code isAssigned} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder isAssigned(Boolean isAssigned) {
            this.isAssigned = isAssigned;
            this.changedFields = changedFields.add("isAssigned");
            return this;
        }

        /**
         * <i>“When the intent was last modified”</i>
         * 
         * @param lastModifiedDateTime
         *            value of {@code lastModifiedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        /**
         * <i>“List of Scope Tags for this Entity instance.”</i>
         * 
         * @param roleScopeTagIds
         *            value of {@code roleScopeTagIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        /**
         * <i>“List of Scope Tags for this Entity instance.”</i>
         * 
         * @param roleScopeTagIds
         *            value of {@code roleScopeTagIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        /**
         * <i>“List of Scope Tags for this Entity instance.”</i>
         * 
         * @param roleScopeTagIdsNextLink
         *            value of {@code roleScopeTagIds@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        /**
         * <i>“The ID of the template this intent was created from (if any)”</i>
         * 
         * @param templateId
         *            value of {@code templateId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder templateId(String templateId) {
            this.templateId = templateId;
            this.changedFields = changedFields.add("templateId");
            return this;
        }

        /**
         * <i>“Collection of assignments”</i>
         * 
         * @param assignments
         *            value of {@code assignments} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder assignments(List<DeviceManagementIntentAssignment> assignments) {
            this.assignments = assignments;
            this.changedFields = changedFields.add("assignments");
            return this;
        }

        /**
         * <i>“Collection of assignments”</i>
         * 
         * @param assignments
         *            value of {@code assignments} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder assignments(DeviceManagementIntentAssignment... assignments) {
            return assignments(Arrays.asList(assignments));
        }

        /**
         * <i>“Collection of setting categories within the intent”</i>
         * 
         * @param categories
         *            value of {@code categories} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder categories(List<DeviceManagementIntentSettingCategory> categories) {
            this.categories = categories;
            this.changedFields = changedFields.add("categories");
            return this;
        }

        /**
         * <i>“Collection of setting categories within the intent”</i>
         * 
         * @param categories
         *            value of {@code categories} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder categories(DeviceManagementIntentSettingCategory... categories) {
            return categories(Arrays.asList(categories));
        }

        /**
         * <i>“Collection of settings and their states and counts of devices that belong to
         * corresponding state for all settings within the intent”</i>
         * 
         * @param deviceSettingStateSummaries
         *            value of {@code deviceSettingStateSummaries} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceSettingStateSummaries(List<DeviceManagementIntentDeviceSettingStateSummary> deviceSettingStateSummaries) {
            this.deviceSettingStateSummaries = deviceSettingStateSummaries;
            this.changedFields = changedFields.add("deviceSettingStateSummaries");
            return this;
        }

        /**
         * <i>“Collection of settings and their states and counts of devices that belong to
         * corresponding state for all settings within the intent”</i>
         * 
         * @param deviceSettingStateSummaries
         *            value of {@code deviceSettingStateSummaries} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceSettingStateSummaries(DeviceManagementIntentDeviceSettingStateSummary... deviceSettingStateSummaries) {
            return deviceSettingStateSummaries(Arrays.asList(deviceSettingStateSummaries));
        }

        /**
         * <i>“Collection of states of all devices that the intent is applied to”</i>
         * 
         * @param deviceStates
         *            value of {@code deviceStates} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceStates(List<DeviceManagementIntentDeviceState> deviceStates) {
            this.deviceStates = deviceStates;
            this.changedFields = changedFields.add("deviceStates");
            return this;
        }

        /**
         * <i>“Collection of states of all devices that the intent is applied to”</i>
         * 
         * @param deviceStates
         *            value of {@code deviceStates} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceStates(DeviceManagementIntentDeviceState... deviceStates) {
            return deviceStates(Arrays.asList(deviceStates));
        }

        /**
         * <i>“A summary of device states and counts of devices that belong to corresponding
         * state for all devices that the intent is applied to”</i>
         * 
         * @param deviceStateSummary
         *            value of {@code deviceStateSummary} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceStateSummary(DeviceManagementIntentDeviceStateSummary deviceStateSummary) {
            this.deviceStateSummary = deviceStateSummary;
            this.changedFields = changedFields.add("deviceStateSummary");
            return this;
        }

        /**
         * <i>“Collection of all settings to be applied”</i>
         * 
         * @param settings
         *            value of {@code settings} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settings(List<DeviceManagementSettingInstance> settings) {
            this.settings = settings;
            this.changedFields = changedFields.add("settings");
            return this;
        }

        /**
         * <i>“Collection of all settings to be applied”</i>
         * 
         * @param settings
         *            value of {@code settings} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settings(DeviceManagementSettingInstance... settings) {
            return settings(Arrays.asList(settings));
        }

        /**
         * <i>“Collection of states of all users that the intent is applied to”</i>
         * 
         * @param userStates
         *            value of {@code userStates} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userStates(List<DeviceManagementIntentUserState> userStates) {
            this.userStates = userStates;
            this.changedFields = changedFields.add("userStates");
            return this;
        }

        /**
         * <i>“Collection of states of all users that the intent is applied to”</i>
         * 
         * @param userStates
         *            value of {@code userStates} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userStates(DeviceManagementIntentUserState... userStates) {
            return userStates(Arrays.asList(userStates));
        }

        /**
         * <i>“A summary of user states and counts of users that belong to corresponding state
         * for all users that the intent is applied to”</i>
         * 
         * @param userStateSummary
         *            value of {@code userStateSummary} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userStateSummary(DeviceManagementIntentUserStateSummary userStateSummary) {
            this.userStateSummary = userStateSummary;
            this.changedFields = changedFields.add("userStateSummary");
            return this;
        }

        public DeviceManagementIntent build() {
            DeviceManagementIntent _x = new DeviceManagementIntent();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceManagementIntent";
            _x.id = id;
            _x.description = description;
            _x.displayName = displayName;
            _x.isAssigned = isAssigned;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.templateId = templateId;
            _x.assignments = assignments;
            _x.categories = categories;
            _x.deviceSettingStateSummaries = deviceSettingStateSummaries;
            _x.deviceStates = deviceStates;
            _x.deviceStateSummary = deviceStateSummary;
            _x.settings = settings;
            _x.userStates = userStates;
            _x.userStateSummary = userStateSummary;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The user given description”</i>
     * 
     * @return property description
     */
    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code description}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The user given description”</i>
     * 
     * @param description
     *            new value of {@code description} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code description} field changed
     */
    public DeviceManagementIntent withDescription(String description) {
        DeviceManagementIntent _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementIntent");
        _x.description = description;
        return _x;
    }

    /**
     * <i>“The user given display name”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The user given display name”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public DeviceManagementIntent withDisplayName(String displayName) {
        DeviceManagementIntent _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementIntent");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“Signifies whether or not the intent is assigned to users”</i>
     * 
     * @return property isAssigned
     */
    @Property(name="isAssigned")
    @JsonIgnore
    public Optional<Boolean> getIsAssigned() {
        return Optional.ofNullable(isAssigned);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code isAssigned} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Signifies whether or not the intent is assigned to users”</i>
     * 
     * @param isAssigned
     *            new value of {@code isAssigned} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code isAssigned} field changed
     */
    public DeviceManagementIntent withIsAssigned(Boolean isAssigned) {
        DeviceManagementIntent _x = _copy();
        _x.changedFields = changedFields.add("isAssigned");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementIntent");
        _x.isAssigned = isAssigned;
        return _x;
    }

    /**
     * <i>“When the intent was last modified”</i>
     * 
     * @return property lastModifiedDateTime
     */
    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastModifiedDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“When the intent was last modified”</i>
     * 
     * @param lastModifiedDateTime
     *            new value of {@code lastModifiedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastModifiedDateTime} field changed
     */
    public DeviceManagementIntent withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        DeviceManagementIntent _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementIntent");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    /**
     * <i>“List of Scope Tags for this Entity instance.”</i>
     * 
     * @return property roleScopeTagIds
     */
    @Property(name="roleScopeTagIds")
    @JsonIgnore
    public CollectionPage<String> getRoleScopeTagIds() {
        return new CollectionPage<String>(contextPath, String.class, this.roleScopeTagIds, Optional.ofNullable(roleScopeTagIdsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code roleScopeTagIds}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“List of Scope Tags for this Entity instance.”</i>
     * 
     * @param roleScopeTagIds
     *            new value of {@code roleScopeTagIds} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code roleScopeTagIds} field changed
     */
    public DeviceManagementIntent withRoleScopeTagIds(List<String> roleScopeTagIds) {
        DeviceManagementIntent _x = _copy();
        _x.changedFields = changedFields.add("roleScopeTagIds");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementIntent");
        _x.roleScopeTagIds = roleScopeTagIds;
        return _x;
    }

    /**
     * <i>“List of Scope Tags for this Entity instance.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property roleScopeTagIds
     */
    @Property(name="roleScopeTagIds")
    @JsonIgnore
    public CollectionPage<String> getRoleScopeTagIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.roleScopeTagIds, Optional.ofNullable(roleScopeTagIdsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“The ID of the template this intent was created from (if any)”</i>
     * 
     * @return property templateId
     */
    @Property(name="templateId")
    @JsonIgnore
    public Optional<String> getTemplateId() {
        return Optional.ofNullable(templateId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code templateId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The ID of the template this intent was created from (if any)”</i>
     * 
     * @param templateId
     *            new value of {@code templateId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code templateId} field changed
     */
    public DeviceManagementIntent withTemplateId(String templateId) {
        DeviceManagementIntent _x = _copy();
        _x.changedFields = changedFields.add("templateId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementIntent");
        _x.templateId = templateId;
        return _x;
    }

    public DeviceManagementIntent withUnmappedField(String name, Object value) {
        DeviceManagementIntent _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“Collection of assignments”</i>
     * 
     * @return navigational property assignments
     */
    @NavigationProperty(name="assignments")
    @JsonIgnore
    public DeviceManagementIntentAssignmentCollectionRequest getAssignments() {
        return new DeviceManagementIntentAssignmentCollectionRequest(
                        contextPath.addSegment("assignments"), Optional.ofNullable(assignments));
    }

    /**
     * <i>“Collection of setting categories within the intent”</i>
     * 
     * @return navigational property categories
     */
    @NavigationProperty(name="categories")
    @JsonIgnore
    public DeviceManagementIntentSettingCategoryCollectionRequest getCategories() {
        return new DeviceManagementIntentSettingCategoryCollectionRequest(
                        contextPath.addSegment("categories"), Optional.ofNullable(categories));
    }

    /**
     * <i>“Collection of settings and their states and counts of devices that belong to
     * corresponding state for all settings within the intent”</i>
     * 
     * @return navigational property deviceSettingStateSummaries
     */
    @NavigationProperty(name="deviceSettingStateSummaries")
    @JsonIgnore
    public DeviceManagementIntentDeviceSettingStateSummaryCollectionRequest getDeviceSettingStateSummaries() {
        return new DeviceManagementIntentDeviceSettingStateSummaryCollectionRequest(
                        contextPath.addSegment("deviceSettingStateSummaries"), Optional.ofNullable(deviceSettingStateSummaries));
    }

    /**
     * <i>“Collection of states of all devices that the intent is applied to”</i>
     * 
     * @return navigational property deviceStates
     */
    @NavigationProperty(name="deviceStates")
    @JsonIgnore
    public DeviceManagementIntentDeviceStateCollectionRequest getDeviceStates() {
        return new DeviceManagementIntentDeviceStateCollectionRequest(
                        contextPath.addSegment("deviceStates"), Optional.ofNullable(deviceStates));
    }

    /**
     * <i>“A summary of device states and counts of devices that belong to corresponding
     * state for all devices that the intent is applied to”</i>
     * 
     * @return navigational property deviceStateSummary
     */
    @NavigationProperty(name="deviceStateSummary")
    @JsonIgnore
    public DeviceManagementIntentDeviceStateSummaryRequest getDeviceStateSummary() {
        return new DeviceManagementIntentDeviceStateSummaryRequest(contextPath.addSegment("deviceStateSummary"), Optional.ofNullable(deviceStateSummary));
    }

    /**
     * <i>“Collection of all settings to be applied”</i>
     * 
     * @return navigational property settings
     */
    @NavigationProperty(name="settings")
    @JsonIgnore
    public DeviceManagementSettingInstanceCollectionRequest getSettings() {
        return new DeviceManagementSettingInstanceCollectionRequest(
                        contextPath.addSegment("settings"), Optional.ofNullable(settings));
    }

    /**
     * <i>“Collection of states of all users that the intent is applied to”</i>
     * 
     * @return navigational property userStates
     */
    @NavigationProperty(name="userStates")
    @JsonIgnore
    public DeviceManagementIntentUserStateCollectionRequest getUserStates() {
        return new DeviceManagementIntentUserStateCollectionRequest(
                        contextPath.addSegment("userStates"), Optional.ofNullable(userStates));
    }

    /**
     * <i>“A summary of user states and counts of users that belong to corresponding state
     * for all users that the intent is applied to”</i>
     * 
     * @return navigational property userStateSummary
     */
    @NavigationProperty(name="userStateSummary")
    @JsonIgnore
    public DeviceManagementIntentUserStateSummaryRequest getUserStateSummary() {
        return new DeviceManagementIntentUserStateSummaryRequest(contextPath.addSegment("userStateSummary"), Optional.ofNullable(userStateSummary));
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code assignments}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Collection of assignments”</i>
     * 
     * @param assignments
     *            new value of {@code assignments} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code assignments} field changed
     */
    public DeviceManagementIntent withAssignments(List<DeviceManagementIntentAssignment> assignments) {
        DeviceManagementIntent _x = _copy();
        _x.changedFields = changedFields.add("assignments");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementIntent");
        _x.assignments = assignments;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code categories} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Collection of setting categories within the intent”</i>
     * 
     * @param categories
     *            new value of {@code categories} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code categories} field changed
     */
    public DeviceManagementIntent withCategories(List<DeviceManagementIntentSettingCategory> categories) {
        DeviceManagementIntent _x = _copy();
        _x.changedFields = changedFields.add("categories");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementIntent");
        _x.categories = categories;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceSettingStateSummaries} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Collection of settings and their states and counts of devices that belong to
     * corresponding state for all settings within the intent”</i>
     * 
     * @param deviceSettingStateSummaries
     *            new value of {@code deviceSettingStateSummaries} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceSettingStateSummaries} field changed
     */
    public DeviceManagementIntent withDeviceSettingStateSummaries(List<DeviceManagementIntentDeviceSettingStateSummary> deviceSettingStateSummaries) {
        DeviceManagementIntent _x = _copy();
        _x.changedFields = changedFields.add("deviceSettingStateSummaries");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementIntent");
        _x.deviceSettingStateSummaries = deviceSettingStateSummaries;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceStates}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Collection of states of all devices that the intent is applied to”</i>
     * 
     * @param deviceStates
     *            new value of {@code deviceStates} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceStates} field changed
     */
    public DeviceManagementIntent withDeviceStates(List<DeviceManagementIntentDeviceState> deviceStates) {
        DeviceManagementIntent _x = _copy();
        _x.changedFields = changedFields.add("deviceStates");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementIntent");
        _x.deviceStates = deviceStates;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceStateSummary} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“A summary of device states and counts of devices that belong to corresponding
     * state for all devices that the intent is applied to”</i>
     * 
     * @param deviceStateSummary
     *            new value of {@code deviceStateSummary} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceStateSummary} field changed
     */
    public DeviceManagementIntent withDeviceStateSummary(DeviceManagementIntentDeviceStateSummary deviceStateSummary) {
        DeviceManagementIntent _x = _copy();
        _x.changedFields = changedFields.add("deviceStateSummary");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementIntent");
        _x.deviceStateSummary = deviceStateSummary;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code settings} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Collection of all settings to be applied”</i>
     * 
     * @param settings
     *            new value of {@code settings} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code settings} field changed
     */
    public DeviceManagementIntent withSettings(List<DeviceManagementSettingInstance> settings) {
        DeviceManagementIntent _x = _copy();
        _x.changedFields = changedFields.add("settings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementIntent");
        _x.settings = settings;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userStates} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Collection of states of all users that the intent is applied to”</i>
     * 
     * @param userStates
     *            new value of {@code userStates} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userStates} field changed
     */
    public DeviceManagementIntent withUserStates(List<DeviceManagementIntentUserState> userStates) {
        DeviceManagementIntent _x = _copy();
        _x.changedFields = changedFields.add("userStates");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementIntent");
        _x.userStates = userStates;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userStateSummary}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“A summary of user states and counts of users that belong to corresponding state
     * for all users that the intent is applied to”</i>
     * 
     * @param userStateSummary
     *            new value of {@code userStateSummary} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userStateSummary} field changed
     */
    public DeviceManagementIntent withUserStateSummary(DeviceManagementIntentUserStateSummary userStateSummary) {
        DeviceManagementIntent _x = _copy();
        _x.changedFields = changedFields.add("userStateSummary");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementIntent");
        _x.userStateSummary = userStateSummary;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementIntent patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementIntent _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementIntent put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementIntent _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceManagementIntent _copy() {
        DeviceManagementIntent _x = new DeviceManagementIntent();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.description = description;
        _x.displayName = displayName;
        _x.isAssigned = isAssigned;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.templateId = templateId;
        _x.assignments = assignments;
        _x.categories = categories;
        _x.deviceSettingStateSummaries = deviceSettingStateSummaries;
        _x.deviceStates = deviceStates;
        _x.deviceStateSummary = deviceStateSummary;
        _x.settings = settings;
        _x.userStates = userStates;
        _x.userStateSummary = userStateSummary;
        return _x;
    }

    @Action(name = "assign")
    @JsonIgnore
    public ActionRequestNoReturn assign(List<DeviceManagementIntentAssignment> assignments) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("assignments", "Collection(microsoft.graph.deviceManagementIntentAssignment)", assignments)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.assign"), _parameters);
    }

    @Action(name = "createCopy")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<DeviceManagementIntent> createCopy(String displayName, String description) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("displayName", "Edm.String", Checks.checkIsAscii(displayName))
            .put("description", "Edm.String", Checks.checkIsAscii(description))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<DeviceManagementIntent>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.createCopy"), DeviceManagementIntent.class, _parameters);
    }

    @Action(name = "migrateToTemplate")
    @JsonIgnore
    public ActionRequestNoReturn migrateToTemplate(String newTemplateId, Boolean preserveCustomValues) {
        Preconditions.checkNotNull(preserveCustomValues, "preserveCustomValues cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("newTemplateId", "Edm.String", Checks.checkIsAscii(newTemplateId))
            .put("preserveCustomValues", "Edm.Boolean", preserveCustomValues)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.migrateToTemplate"), _parameters);
    }

    @Action(name = "updateSettings")
    @JsonIgnore
    public ActionRequestNoReturn updateSettings(List<DeviceManagementSettingInstance> settings) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("settings", "Collection(microsoft.graph.deviceManagementSettingInstance)", settings)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.updateSettings"), _parameters);
    }

    @Function(name = "compare")
    @JsonIgnore
    public CollectionPageNonEntityRequest<DeviceManagementSettingComparison> compare(String templateId) {
        Preconditions.checkNotNull(templateId, "templateId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("templateId", "Edm.String", Checks.checkIsAscii(templateId))
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.compare"), DeviceManagementSettingComparison.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementIntent[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("isAssigned=");
        b.append(this.isAssigned);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("templateId=");
        b.append(this.templateId);
        b.append(", ");
        b.append("assignments=");
        b.append(this.assignments);
        b.append(", ");
        b.append("categories=");
        b.append(this.categories);
        b.append(", ");
        b.append("deviceSettingStateSummaries=");
        b.append(this.deviceSettingStateSummaries);
        b.append(", ");
        b.append("deviceStates=");
        b.append(this.deviceStates);
        b.append(", ");
        b.append("deviceStateSummary=");
        b.append(this.deviceStateSummary);
        b.append(", ");
        b.append("settings=");
        b.append(this.settings);
        b.append(", ");
        b.append("userStates=");
        b.append(this.userStates);
        b.append(", ");
        b.append("userStateSummary=");
        b.append(this.userStateSummary);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
