package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DeviceManagementExchangeAccessRule;
import odata.msgraph.client.beta.complex.DeviceManagementExchangeDeviceClass;
import odata.msgraph.client.beta.entity.request.OnPremisesConditionalAccessSettingsRequest;
import odata.msgraph.client.beta.enums.DeviceManagementExchangeAccessLevel;


/**
 * <i>“Singleton entity which represents the Exchange OnPremises policy configured for
 * a tenant.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "accessRules", 
    "defaultAccessLevel", 
    "knownDeviceClasses", 
    "notificationContent", 
    "conditionalAccessSettings"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementExchangeOnPremisesPolicy extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementExchangeOnPremisesPolicy";
    }

    @JsonProperty("accessRules")
    protected List<DeviceManagementExchangeAccessRule> accessRules;

    @JsonProperty("accessRules@nextLink")
    protected String accessRulesNextLink;

    @JsonProperty("defaultAccessLevel")
    protected DeviceManagementExchangeAccessLevel defaultAccessLevel;

    @JsonProperty("knownDeviceClasses")
    protected List<DeviceManagementExchangeDeviceClass> knownDeviceClasses;

    @JsonProperty("knownDeviceClasses@nextLink")
    protected String knownDeviceClassesNextLink;

    @JsonProperty("notificationContent")
    protected byte[] notificationContent;

    @JsonProperty("conditionalAccessSettings")
    protected OnPremisesConditionalAccessSettings conditionalAccessSettings;

    protected DeviceManagementExchangeOnPremisesPolicy() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceManagementExchangeOnPremisesPolicy() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<DeviceManagementExchangeAccessRule> accessRules;
        private String accessRulesNextLink;
        private DeviceManagementExchangeAccessLevel defaultAccessLevel;
        private List<DeviceManagementExchangeDeviceClass> knownDeviceClasses;
        private String knownDeviceClassesNextLink;
        private byte[] notificationContent;
        private OnPremisesConditionalAccessSettings conditionalAccessSettings;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The list of device access rules in Exchange. The access rules apply globally to
         * the entire Exchange organization”</i>
         * 
         * @param accessRules
         *            value of {@code accessRules} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder accessRules(List<DeviceManagementExchangeAccessRule> accessRules) {
            this.accessRules = accessRules;
            this.changedFields = changedFields.add("accessRules");
            return this;
        }

        /**
         * <i>“The list of device access rules in Exchange. The access rules apply globally to
         * the entire Exchange organization”</i>
         * 
         * @param accessRules
         *            value of {@code accessRules} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder accessRules(DeviceManagementExchangeAccessRule... accessRules) {
            return accessRules(Arrays.asList(accessRules));
        }

        /**
         * <i>“The list of device access rules in Exchange. The access rules apply globally to
         * the entire Exchange organization”</i>
         * 
         * @param accessRulesNextLink
         *            value of {@code accessRules@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder accessRulesNextLink(String accessRulesNextLink) {
            this.accessRulesNextLink = accessRulesNextLink;
            this.changedFields = changedFields.add("accessRules");
            return this;
        }

        /**
         * <i>“Default access state in Exchange. This rule applies globally to the entire
         * Exchange organization”</i>
         * 
         * @param defaultAccessLevel
         *            value of {@code defaultAccessLevel} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defaultAccessLevel(DeviceManagementExchangeAccessLevel defaultAccessLevel) {
            this.defaultAccessLevel = defaultAccessLevel;
            this.changedFields = changedFields.add("defaultAccessLevel");
            return this;
        }

        /**
         * <i>“The list of device classes known to Exchange”</i>
         * 
         * @param knownDeviceClasses
         *            value of {@code knownDeviceClasses} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder knownDeviceClasses(List<DeviceManagementExchangeDeviceClass> knownDeviceClasses) {
            this.knownDeviceClasses = knownDeviceClasses;
            this.changedFields = changedFields.add("knownDeviceClasses");
            return this;
        }

        /**
         * <i>“The list of device classes known to Exchange”</i>
         * 
         * @param knownDeviceClasses
         *            value of {@code knownDeviceClasses} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder knownDeviceClasses(DeviceManagementExchangeDeviceClass... knownDeviceClasses) {
            return knownDeviceClasses(Arrays.asList(knownDeviceClasses));
        }

        /**
         * <i>“The list of device classes known to Exchange”</i>
         * 
         * @param knownDeviceClassesNextLink
         *            value of {@code knownDeviceClasses@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder knownDeviceClassesNextLink(String knownDeviceClassesNextLink) {
            this.knownDeviceClassesNextLink = knownDeviceClassesNextLink;
            this.changedFields = changedFields.add("knownDeviceClasses");
            return this;
        }

        /**
         * <i>“Notification text that will be sent to users quarantined by this policy. This is
         * UTF8 encoded byte array HTML.”</i>
         * 
         * @param notificationContent
         *            value of {@code notificationContent} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder notificationContent(byte[] notificationContent) {
            this.notificationContent = notificationContent;
            this.changedFields = changedFields.add("notificationContent");
            return this;
        }

        /**
         * <i>“The Exchange on premises conditional access settings. On premises conditional
         * access will require devices to be both enrolled and compliant for mail access”</i>
         * 
         * @param conditionalAccessSettings
         *            value of {@code conditionalAccessSettings} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder conditionalAccessSettings(OnPremisesConditionalAccessSettings conditionalAccessSettings) {
            this.conditionalAccessSettings = conditionalAccessSettings;
            this.changedFields = changedFields.add("conditionalAccessSettings");
            return this;
        }

        public DeviceManagementExchangeOnPremisesPolicy build() {
            DeviceManagementExchangeOnPremisesPolicy _x = new DeviceManagementExchangeOnPremisesPolicy();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceManagementExchangeOnPremisesPolicy";
            _x.id = id;
            _x.accessRules = accessRules;
            _x.accessRulesNextLink = accessRulesNextLink;
            _x.defaultAccessLevel = defaultAccessLevel;
            _x.knownDeviceClasses = knownDeviceClasses;
            _x.knownDeviceClassesNextLink = knownDeviceClassesNextLink;
            _x.notificationContent = notificationContent;
            _x.conditionalAccessSettings = conditionalAccessSettings;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The list of device access rules in Exchange. The access rules apply globally to
     * the entire Exchange organization”</i>
     * 
     * @return property accessRules
     */
    @Property(name="accessRules")
    @JsonIgnore
    public CollectionPage<DeviceManagementExchangeAccessRule> getAccessRules() {
        return new CollectionPage<DeviceManagementExchangeAccessRule>(contextPath, DeviceManagementExchangeAccessRule.class, this.accessRules, Optional.ofNullable(accessRulesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code accessRules}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The list of device access rules in Exchange. The access rules apply globally to
     * the entire Exchange organization”</i>
     * 
     * @param accessRules
     *            new value of {@code accessRules} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code accessRules} field changed
     */
    public DeviceManagementExchangeOnPremisesPolicy withAccessRules(List<DeviceManagementExchangeAccessRule> accessRules) {
        DeviceManagementExchangeOnPremisesPolicy _x = _copy();
        _x.changedFields = changedFields.add("accessRules");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementExchangeOnPremisesPolicy");
        _x.accessRules = accessRules;
        return _x;
    }

    /**
     * <i>“The list of device access rules in Exchange. The access rules apply globally to
     * the entire Exchange organization”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property accessRules
     */
    @Property(name="accessRules")
    @JsonIgnore
    public CollectionPage<DeviceManagementExchangeAccessRule> getAccessRules(HttpRequestOptions options) {
        return new CollectionPage<DeviceManagementExchangeAccessRule>(contextPath, DeviceManagementExchangeAccessRule.class, this.accessRules, Optional.ofNullable(accessRulesNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Default access state in Exchange. This rule applies globally to the entire
     * Exchange organization”</i>
     * 
     * @return property defaultAccessLevel
     */
    @Property(name="defaultAccessLevel")
    @JsonIgnore
    public Optional<DeviceManagementExchangeAccessLevel> getDefaultAccessLevel() {
        return Optional.ofNullable(defaultAccessLevel);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defaultAccessLevel} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Default access state in Exchange. This rule applies globally to the entire
     * Exchange organization”</i>
     * 
     * @param defaultAccessLevel
     *            new value of {@code defaultAccessLevel} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defaultAccessLevel} field changed
     */
    public DeviceManagementExchangeOnPremisesPolicy withDefaultAccessLevel(DeviceManagementExchangeAccessLevel defaultAccessLevel) {
        DeviceManagementExchangeOnPremisesPolicy _x = _copy();
        _x.changedFields = changedFields.add("defaultAccessLevel");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementExchangeOnPremisesPolicy");
        _x.defaultAccessLevel = defaultAccessLevel;
        return _x;
    }

    /**
     * <i>“The list of device classes known to Exchange”</i>
     * 
     * @return property knownDeviceClasses
     */
    @Property(name="knownDeviceClasses")
    @JsonIgnore
    public CollectionPage<DeviceManagementExchangeDeviceClass> getKnownDeviceClasses() {
        return new CollectionPage<DeviceManagementExchangeDeviceClass>(contextPath, DeviceManagementExchangeDeviceClass.class, this.knownDeviceClasses, Optional.ofNullable(knownDeviceClassesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * knownDeviceClasses} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The list of device classes known to Exchange”</i>
     * 
     * @param knownDeviceClasses
     *            new value of {@code knownDeviceClasses} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code knownDeviceClasses} field changed
     */
    public DeviceManagementExchangeOnPremisesPolicy withKnownDeviceClasses(List<DeviceManagementExchangeDeviceClass> knownDeviceClasses) {
        DeviceManagementExchangeOnPremisesPolicy _x = _copy();
        _x.changedFields = changedFields.add("knownDeviceClasses");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementExchangeOnPremisesPolicy");
        _x.knownDeviceClasses = knownDeviceClasses;
        return _x;
    }

    /**
     * <i>“The list of device classes known to Exchange”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property knownDeviceClasses
     */
    @Property(name="knownDeviceClasses")
    @JsonIgnore
    public CollectionPage<DeviceManagementExchangeDeviceClass> getKnownDeviceClasses(HttpRequestOptions options) {
        return new CollectionPage<DeviceManagementExchangeDeviceClass>(contextPath, DeviceManagementExchangeDeviceClass.class, this.knownDeviceClasses, Optional.ofNullable(knownDeviceClassesNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Notification text that will be sent to users quarantined by this policy. This is
     * UTF8 encoded byte array HTML.”</i>
     * 
     * @return property notificationContent
     */
    @Property(name="notificationContent")
    @JsonIgnore
    public Optional<byte[]> getNotificationContent() {
        return Optional.ofNullable(notificationContent);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * notificationContent} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Notification text that will be sent to users quarantined by this policy. This is
     * UTF8 encoded byte array HTML.”</i>
     * 
     * @param notificationContent
     *            new value of {@code notificationContent} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code notificationContent} field changed
     */
    public DeviceManagementExchangeOnPremisesPolicy withNotificationContent(byte[] notificationContent) {
        DeviceManagementExchangeOnPremisesPolicy _x = _copy();
        _x.changedFields = changedFields.add("notificationContent");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementExchangeOnPremisesPolicy");
        _x.notificationContent = notificationContent;
        return _x;
    }

    public DeviceManagementExchangeOnPremisesPolicy withUnmappedField(String name, Object value) {
        DeviceManagementExchangeOnPremisesPolicy _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“The Exchange on premises conditional access settings. On premises conditional
     * access will require devices to be both enrolled and compliant for mail access”</i>
     * 
     * @return navigational property conditionalAccessSettings
     */
    @NavigationProperty(name="conditionalAccessSettings")
    @JsonIgnore
    public OnPremisesConditionalAccessSettingsRequest getConditionalAccessSettings() {
        return new OnPremisesConditionalAccessSettingsRequest(contextPath.addSegment("conditionalAccessSettings"), Optional.ofNullable(conditionalAccessSettings));
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * conditionalAccessSettings} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The Exchange on premises conditional access settings. On premises conditional
     * access will require devices to be both enrolled and compliant for mail access”</i>
     * 
     * @param conditionalAccessSettings
     *            new value of {@code conditionalAccessSettings} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code conditionalAccessSettings} field changed
     */
    public DeviceManagementExchangeOnPremisesPolicy withConditionalAccessSettings(OnPremisesConditionalAccessSettings conditionalAccessSettings) {
        DeviceManagementExchangeOnPremisesPolicy _x = _copy();
        _x.changedFields = changedFields.add("conditionalAccessSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementExchangeOnPremisesPolicy");
        _x.conditionalAccessSettings = conditionalAccessSettings;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementExchangeOnPremisesPolicy patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementExchangeOnPremisesPolicy _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementExchangeOnPremisesPolicy put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementExchangeOnPremisesPolicy _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceManagementExchangeOnPremisesPolicy _copy() {
        DeviceManagementExchangeOnPremisesPolicy _x = new DeviceManagementExchangeOnPremisesPolicy();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.accessRules = accessRules;
        _x.defaultAccessLevel = defaultAccessLevel;
        _x.knownDeviceClasses = knownDeviceClasses;
        _x.notificationContent = notificationContent;
        _x.conditionalAccessSettings = conditionalAccessSettings;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementExchangeOnPremisesPolicy[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("accessRules=");
        b.append(this.accessRules);
        b.append(", ");
        b.append("defaultAccessLevel=");
        b.append(this.defaultAccessLevel);
        b.append(", ");
        b.append("knownDeviceClasses=");
        b.append(this.knownDeviceClasses);
        b.append(", ");
        b.append("notificationContent=");
        b.append(this.notificationContent);
        b.append(", ");
        b.append("conditionalAccessSettings=");
        b.append(this.conditionalAccessSettings);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
