package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.DeviceManagementDerivedCredentialIssuer;
import odata.msgraph.client.beta.enums.DeviceManagementDerivedCredentialNotificationType;


/**
 * <i>“Entity that describes tenant level settings for derived credentials”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "helpUrl", 
    "issuer", 
    "notificationType"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementDerivedCredentialSettings extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementDerivedCredentialSettings";
    }

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("helpUrl")
    protected String helpUrl;

    @JsonProperty("issuer")
    protected DeviceManagementDerivedCredentialIssuer issuer;

    @JsonProperty("notificationType")
    protected DeviceManagementDerivedCredentialNotificationType notificationType;

    protected DeviceManagementDerivedCredentialSettings() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceManagementDerivedCredentialSettings() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private String helpUrl;
        private DeviceManagementDerivedCredentialIssuer issuer;
        private DeviceManagementDerivedCredentialNotificationType notificationType;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The display name for the profile.”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“The URL that will be accessible to end users as they retrieve a derived
         * credential using the Company Portal.”</i>
         * 
         * @param helpUrl
         *            value of {@code helpUrl} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder helpUrl(String helpUrl) {
            this.helpUrl = helpUrl;
            this.changedFields = changedFields.add("helpUrl");
            return this;
        }

        /**
         * <i>“The derived credential provider to use.”</i>
         * 
         * @param issuer
         *            value of {@code issuer} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder issuer(DeviceManagementDerivedCredentialIssuer issuer) {
            this.issuer = issuer;
            this.changedFields = changedFields.add("issuer");
            return this;
        }

        /**
         * <i>“The methods used to inform the end user to open Company Portal to deliver Wi-Fi,
         * VPN, or email profiles that use certificates to the device.”</i>
         * 
         * @param notificationType
         *            value of {@code notificationType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder notificationType(DeviceManagementDerivedCredentialNotificationType notificationType) {
            this.notificationType = notificationType;
            this.changedFields = changedFields.add("notificationType");
            return this;
        }

        public DeviceManagementDerivedCredentialSettings build() {
            DeviceManagementDerivedCredentialSettings _x = new DeviceManagementDerivedCredentialSettings();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceManagementDerivedCredentialSettings";
            _x.id = id;
            _x.displayName = displayName;
            _x.helpUrl = helpUrl;
            _x.issuer = issuer;
            _x.notificationType = notificationType;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The display name for the profile.”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The display name for the profile.”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public DeviceManagementDerivedCredentialSettings withDisplayName(String displayName) {
        DeviceManagementDerivedCredentialSettings _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementDerivedCredentialSettings");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“The URL that will be accessible to end users as they retrieve a derived
     * credential using the Company Portal.”</i>
     * 
     * @return property helpUrl
     */
    @Property(name="helpUrl")
    @JsonIgnore
    public Optional<String> getHelpUrl() {
        return Optional.ofNullable(helpUrl);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code helpUrl} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The URL that will be accessible to end users as they retrieve a derived
     * credential using the Company Portal.”</i>
     * 
     * @param helpUrl
     *            new value of {@code helpUrl} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code helpUrl} field changed
     */
    public DeviceManagementDerivedCredentialSettings withHelpUrl(String helpUrl) {
        DeviceManagementDerivedCredentialSettings _x = _copy();
        _x.changedFields = changedFields.add("helpUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementDerivedCredentialSettings");
        _x.helpUrl = helpUrl;
        return _x;
    }

    /**
     * <i>“The derived credential provider to use.”</i>
     * 
     * @return property issuer
     */
    @Property(name="issuer")
    @JsonIgnore
    public Optional<DeviceManagementDerivedCredentialIssuer> getIssuer() {
        return Optional.ofNullable(issuer);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code issuer} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The derived credential provider to use.”</i>
     * 
     * @param issuer
     *            new value of {@code issuer} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code issuer} field changed
     */
    public DeviceManagementDerivedCredentialSettings withIssuer(DeviceManagementDerivedCredentialIssuer issuer) {
        DeviceManagementDerivedCredentialSettings _x = _copy();
        _x.changedFields = changedFields.add("issuer");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementDerivedCredentialSettings");
        _x.issuer = issuer;
        return _x;
    }

    /**
     * <i>“The methods used to inform the end user to open Company Portal to deliver Wi-Fi,
     * VPN, or email profiles that use certificates to the device.”</i>
     * 
     * @return property notificationType
     */
    @Property(name="notificationType")
    @JsonIgnore
    public Optional<DeviceManagementDerivedCredentialNotificationType> getNotificationType() {
        return Optional.ofNullable(notificationType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code notificationType}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The methods used to inform the end user to open Company Portal to deliver Wi-Fi,
     * VPN, or email profiles that use certificates to the device.”</i>
     * 
     * @param notificationType
     *            new value of {@code notificationType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code notificationType} field changed
     */
    public DeviceManagementDerivedCredentialSettings withNotificationType(DeviceManagementDerivedCredentialNotificationType notificationType) {
        DeviceManagementDerivedCredentialSettings _x = _copy();
        _x.changedFields = changedFields.add("notificationType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementDerivedCredentialSettings");
        _x.notificationType = notificationType;
        return _x;
    }

    public DeviceManagementDerivedCredentialSettings withUnmappedField(String name, Object value) {
        DeviceManagementDerivedCredentialSettings _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementDerivedCredentialSettings patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementDerivedCredentialSettings _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementDerivedCredentialSettings put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementDerivedCredentialSettings _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceManagementDerivedCredentialSettings _copy() {
        DeviceManagementDerivedCredentialSettings _x = new DeviceManagementDerivedCredentialSettings();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.helpUrl = helpUrl;
        _x.issuer = issuer;
        _x.notificationType = notificationType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementDerivedCredentialSettings[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("helpUrl=");
        b.append(this.helpUrl);
        b.append(", ");
        b.append("issuer=");
        b.append(this.issuer);
        b.append(", ");
        b.append("notificationType=");
        b.append(this.notificationType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
