package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DeviceManagementConfigurationSettingInstanceTemplate;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementConfigurationSettingDefinitionCollectionRequest;


/**
 * <i>“Setting Template”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "settingInstanceTemplate", 
    "settingDefinitions"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementConfigurationSettingTemplate extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementConfigurationSettingTemplate";
    }

    @JsonProperty("settingInstanceTemplate")
    protected DeviceManagementConfigurationSettingInstanceTemplate settingInstanceTemplate;

    @JsonProperty("settingDefinitions")
    protected List<DeviceManagementConfigurationSettingDefinition> settingDefinitions;

    protected DeviceManagementConfigurationSettingTemplate() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceManagementConfigurationSettingTemplate() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private DeviceManagementConfigurationSettingInstanceTemplate settingInstanceTemplate;
        private List<DeviceManagementConfigurationSettingDefinition> settingDefinitions;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Setting Instance Template”</i>
         * 
         * @param settingInstanceTemplate
         *            value of {@code settingInstanceTemplate} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settingInstanceTemplate(DeviceManagementConfigurationSettingInstanceTemplate settingInstanceTemplate) {
            this.settingInstanceTemplate = settingInstanceTemplate;
            this.changedFields = changedFields.add("settingInstanceTemplate");
            return this;
        }

        /**
         * <i>“List of related Setting Definitions”</i>
         * 
         * @param settingDefinitions
         *            value of {@code settingDefinitions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settingDefinitions(List<DeviceManagementConfigurationSettingDefinition> settingDefinitions) {
            this.settingDefinitions = settingDefinitions;
            this.changedFields = changedFields.add("settingDefinitions");
            return this;
        }

        /**
         * <i>“List of related Setting Definitions”</i>
         * 
         * @param settingDefinitions
         *            value of {@code settingDefinitions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settingDefinitions(DeviceManagementConfigurationSettingDefinition... settingDefinitions) {
            return settingDefinitions(Arrays.asList(settingDefinitions));
        }

        public DeviceManagementConfigurationSettingTemplate build() {
            DeviceManagementConfigurationSettingTemplate _x = new DeviceManagementConfigurationSettingTemplate();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceManagementConfigurationSettingTemplate";
            _x.id = id;
            _x.settingInstanceTemplate = settingInstanceTemplate;
            _x.settingDefinitions = settingDefinitions;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Setting Instance Template”</i>
     * 
     * @return property settingInstanceTemplate
     */
    @Property(name="settingInstanceTemplate")
    @JsonIgnore
    public Optional<DeviceManagementConfigurationSettingInstanceTemplate> getSettingInstanceTemplate() {
        return Optional.ofNullable(settingInstanceTemplate);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * settingInstanceTemplate} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Setting Instance Template”</i>
     * 
     * @param settingInstanceTemplate
     *            new value of {@code settingInstanceTemplate} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code settingInstanceTemplate} field changed
     */
    public DeviceManagementConfigurationSettingTemplate withSettingInstanceTemplate(DeviceManagementConfigurationSettingInstanceTemplate settingInstanceTemplate) {
        DeviceManagementConfigurationSettingTemplate _x = _copy();
        _x.changedFields = changedFields.add("settingInstanceTemplate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationSettingTemplate");
        _x.settingInstanceTemplate = settingInstanceTemplate;
        return _x;
    }

    public DeviceManagementConfigurationSettingTemplate withUnmappedField(String name, Object value) {
        DeviceManagementConfigurationSettingTemplate _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“List of related Setting Definitions”</i>
     * 
     * @return navigational property settingDefinitions
     */
    @NavigationProperty(name="settingDefinitions")
    @JsonIgnore
    public DeviceManagementConfigurationSettingDefinitionCollectionRequest getSettingDefinitions() {
        return new DeviceManagementConfigurationSettingDefinitionCollectionRequest(
                        contextPath.addSegment("settingDefinitions"), Optional.ofNullable(settingDefinitions));
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * settingDefinitions} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“List of related Setting Definitions”</i>
     * 
     * @param settingDefinitions
     *            new value of {@code settingDefinitions} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code settingDefinitions} field changed
     */
    public DeviceManagementConfigurationSettingTemplate withSettingDefinitions(List<DeviceManagementConfigurationSettingDefinition> settingDefinitions) {
        DeviceManagementConfigurationSettingTemplate _x = _copy();
        _x.changedFields = changedFields.add("settingDefinitions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationSettingTemplate");
        _x.settingDefinitions = settingDefinitions;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementConfigurationSettingTemplate patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementConfigurationSettingTemplate _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementConfigurationSettingTemplate put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementConfigurationSettingTemplate _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceManagementConfigurationSettingTemplate _copy() {
        DeviceManagementConfigurationSettingTemplate _x = new DeviceManagementConfigurationSettingTemplate();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.settingInstanceTemplate = settingInstanceTemplate;
        _x.settingDefinitions = settingDefinitions;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementConfigurationSettingTemplate[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("settingInstanceTemplate=");
        b.append(this.settingInstanceTemplate);
        b.append(", ");
        b.append("settingDefinitions=");
        b.append(this.settingDefinitions);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
