package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DeviceManagementConfigurationDependentOn;
import odata.msgraph.client.beta.complex.DeviceManagementConfigurationReferredSettingInformation;
import odata.msgraph.client.beta.complex.DeviceManagementConfigurationSettingApplicability;
import odata.msgraph.client.beta.complex.DeviceManagementConfigurationSettingDependedOnBy;
import odata.msgraph.client.beta.complex.DeviceManagementConfigurationSettingOccurrence;
import odata.msgraph.client.beta.enums.DeviceManagementConfigurationControlType;
import odata.msgraph.client.beta.enums.DeviceManagementConfigurationSettingAccessTypes;
import odata.msgraph.client.beta.enums.DeviceManagementConfigurationSettingUsage;
import odata.msgraph.client.beta.enums.DeviceManagementConfigurationSettingVisibility;

@JsonPropertyOrder({
    "@odata.type", 
    "childIds", 
    "dependedOnBy", 
    "dependentOn"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementConfigurationSettingGroupDefinition extends DeviceManagementConfigurationSettingDefinition implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementConfigurationSettingGroupDefinition";
    }

    @JsonProperty("childIds")
    protected List<String> childIds;

    @JsonProperty("childIds@nextLink")
    protected String childIdsNextLink;

    @JsonProperty("dependedOnBy")
    protected List<DeviceManagementConfigurationSettingDependedOnBy> dependedOnBy;

    @JsonProperty("dependedOnBy@nextLink")
    protected String dependedOnByNextLink;

    @JsonProperty("dependentOn")
    protected List<DeviceManagementConfigurationDependentOn> dependentOn;

    @JsonProperty("dependentOn@nextLink")
    protected String dependentOnNextLink;

    protected DeviceManagementConfigurationSettingGroupDefinition() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceManagementConfigurationSettingGroupDefinition() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private DeviceManagementConfigurationSettingAccessTypes accessTypes;
        private DeviceManagementConfigurationSettingApplicability applicability;
        private String baseUri;
        private String categoryId;
        private String description;
        private String displayName;
        private String helpText;
        private List<String> infoUrls;
        private String infoUrlsNextLink;
        private List<String> keywords;
        private String keywordsNextLink;
        private String name;
        private DeviceManagementConfigurationSettingOccurrence occurrence;
        private String offsetUri;
        private List<DeviceManagementConfigurationReferredSettingInformation> referredSettingInformationList;
        private String referredSettingInformationListNextLink;
        private String rootDefinitionId;
        private DeviceManagementConfigurationSettingUsage settingUsage;
        private DeviceManagementConfigurationControlType uxBehavior;
        private String version;
        private DeviceManagementConfigurationSettingVisibility visibility;
        private List<String> childIds;
        private String childIdsNextLink;
        private List<DeviceManagementConfigurationSettingDependedOnBy> dependedOnBy;
        private String dependedOnByNextLink;
        private List<DeviceManagementConfigurationDependentOn> dependentOn;
        private String dependentOnNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder accessTypes(DeviceManagementConfigurationSettingAccessTypes accessTypes) {
            this.accessTypes = accessTypes;
            this.changedFields = changedFields.add("accessTypes");
            return this;
        }

        public Builder applicability(DeviceManagementConfigurationSettingApplicability applicability) {
            this.applicability = applicability;
            this.changedFields = changedFields.add("applicability");
            return this;
        }

        public Builder baseUri(String baseUri) {
            this.baseUri = baseUri;
            this.changedFields = changedFields.add("baseUri");
            return this;
        }

        public Builder categoryId(String categoryId) {
            this.categoryId = categoryId;
            this.changedFields = changedFields.add("categoryId");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder helpText(String helpText) {
            this.helpText = helpText;
            this.changedFields = changedFields.add("helpText");
            return this;
        }

        public Builder infoUrls(List<String> infoUrls) {
            this.infoUrls = infoUrls;
            this.changedFields = changedFields.add("infoUrls");
            return this;
        }

        public Builder infoUrls(String... infoUrls) {
            return infoUrls(Arrays.asList(infoUrls));
        }

        public Builder infoUrlsNextLink(String infoUrlsNextLink) {
            this.infoUrlsNextLink = infoUrlsNextLink;
            this.changedFields = changedFields.add("infoUrls");
            return this;
        }

        public Builder keywords(List<String> keywords) {
            this.keywords = keywords;
            this.changedFields = changedFields.add("keywords");
            return this;
        }

        public Builder keywords(String... keywords) {
            return keywords(Arrays.asList(keywords));
        }

        public Builder keywordsNextLink(String keywordsNextLink) {
            this.keywordsNextLink = keywordsNextLink;
            this.changedFields = changedFields.add("keywords");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder occurrence(DeviceManagementConfigurationSettingOccurrence occurrence) {
            this.occurrence = occurrence;
            this.changedFields = changedFields.add("occurrence");
            return this;
        }

        public Builder offsetUri(String offsetUri) {
            this.offsetUri = offsetUri;
            this.changedFields = changedFields.add("offsetUri");
            return this;
        }

        public Builder referredSettingInformationList(List<DeviceManagementConfigurationReferredSettingInformation> referredSettingInformationList) {
            this.referredSettingInformationList = referredSettingInformationList;
            this.changedFields = changedFields.add("referredSettingInformationList");
            return this;
        }

        public Builder referredSettingInformationList(DeviceManagementConfigurationReferredSettingInformation... referredSettingInformationList) {
            return referredSettingInformationList(Arrays.asList(referredSettingInformationList));
        }

        public Builder referredSettingInformationListNextLink(String referredSettingInformationListNextLink) {
            this.referredSettingInformationListNextLink = referredSettingInformationListNextLink;
            this.changedFields = changedFields.add("referredSettingInformationList");
            return this;
        }

        public Builder rootDefinitionId(String rootDefinitionId) {
            this.rootDefinitionId = rootDefinitionId;
            this.changedFields = changedFields.add("rootDefinitionId");
            return this;
        }

        public Builder settingUsage(DeviceManagementConfigurationSettingUsage settingUsage) {
            this.settingUsage = settingUsage;
            this.changedFields = changedFields.add("settingUsage");
            return this;
        }

        public Builder uxBehavior(DeviceManagementConfigurationControlType uxBehavior) {
            this.uxBehavior = uxBehavior;
            this.changedFields = changedFields.add("uxBehavior");
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public Builder visibility(DeviceManagementConfigurationSettingVisibility visibility) {
            this.visibility = visibility;
            this.changedFields = changedFields.add("visibility");
            return this;
        }

        /**
         * <i>“Dependent child settings to this group of settings”</i>
         * 
         * @param childIds
         *            value of {@code childIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder childIds(List<String> childIds) {
            this.childIds = childIds;
            this.changedFields = changedFields.add("childIds");
            return this;
        }

        /**
         * <i>“Dependent child settings to this group of settings”</i>
         * 
         * @param childIds
         *            value of {@code childIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder childIds(String... childIds) {
            return childIds(Arrays.asList(childIds));
        }

        /**
         * <i>“Dependent child settings to this group of settings”</i>
         * 
         * @param childIdsNextLink
         *            value of {@code childIds@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder childIdsNextLink(String childIdsNextLink) {
            this.childIdsNextLink = childIdsNextLink;
            this.changedFields = changedFields.add("childIds");
            return this;
        }

        /**
         * <i>“List of child settings that depend on this setting”</i>
         * 
         * @param dependedOnBy
         *            value of {@code dependedOnBy} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder dependedOnBy(List<DeviceManagementConfigurationSettingDependedOnBy> dependedOnBy) {
            this.dependedOnBy = dependedOnBy;
            this.changedFields = changedFields.add("dependedOnBy");
            return this;
        }

        /**
         * <i>“List of child settings that depend on this setting”</i>
         * 
         * @param dependedOnBy
         *            value of {@code dependedOnBy} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder dependedOnBy(DeviceManagementConfigurationSettingDependedOnBy... dependedOnBy) {
            return dependedOnBy(Arrays.asList(dependedOnBy));
        }

        /**
         * <i>“List of child settings that depend on this setting”</i>
         * 
         * @param dependedOnByNextLink
         *            value of {@code dependedOnBy@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder dependedOnByNextLink(String dependedOnByNextLink) {
            this.dependedOnByNextLink = dependedOnByNextLink;
            this.changedFields = changedFields.add("dependedOnBy");
            return this;
        }

        /**
         * <i>“List of Dependencies for the setting group”</i>
         * 
         * @param dependentOn
         *            value of {@code dependentOn} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder dependentOn(List<DeviceManagementConfigurationDependentOn> dependentOn) {
            this.dependentOn = dependentOn;
            this.changedFields = changedFields.add("dependentOn");
            return this;
        }

        /**
         * <i>“List of Dependencies for the setting group”</i>
         * 
         * @param dependentOn
         *            value of {@code dependentOn} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder dependentOn(DeviceManagementConfigurationDependentOn... dependentOn) {
            return dependentOn(Arrays.asList(dependentOn));
        }

        /**
         * <i>“List of Dependencies for the setting group”</i>
         * 
         * @param dependentOnNextLink
         *            value of {@code dependentOn@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder dependentOnNextLink(String dependentOnNextLink) {
            this.dependentOnNextLink = dependentOnNextLink;
            this.changedFields = changedFields.add("dependentOn");
            return this;
        }

        public DeviceManagementConfigurationSettingGroupDefinition build() {
            DeviceManagementConfigurationSettingGroupDefinition _x = new DeviceManagementConfigurationSettingGroupDefinition();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceManagementConfigurationSettingGroupDefinition";
            _x.id = id;
            _x.accessTypes = accessTypes;
            _x.applicability = applicability;
            _x.baseUri = baseUri;
            _x.categoryId = categoryId;
            _x.description = description;
            _x.displayName = displayName;
            _x.helpText = helpText;
            _x.infoUrls = infoUrls;
            _x.infoUrlsNextLink = infoUrlsNextLink;
            _x.keywords = keywords;
            _x.keywordsNextLink = keywordsNextLink;
            _x.name = name;
            _x.occurrence = occurrence;
            _x.offsetUri = offsetUri;
            _x.referredSettingInformationList = referredSettingInformationList;
            _x.referredSettingInformationListNextLink = referredSettingInformationListNextLink;
            _x.rootDefinitionId = rootDefinitionId;
            _x.settingUsage = settingUsage;
            _x.uxBehavior = uxBehavior;
            _x.version = version;
            _x.visibility = visibility;
            _x.childIds = childIds;
            _x.childIdsNextLink = childIdsNextLink;
            _x.dependedOnBy = dependedOnBy;
            _x.dependedOnByNextLink = dependedOnByNextLink;
            _x.dependentOn = dependentOn;
            _x.dependentOnNextLink = dependentOnNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Dependent child settings to this group of settings”</i>
     * 
     * @return property childIds
     */
    @Property(name="childIds")
    @JsonIgnore
    public CollectionPage<String> getChildIds() {
        return new CollectionPage<String>(contextPath, String.class, this.childIds, Optional.ofNullable(childIdsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code childIds} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Dependent child settings to this group of settings”</i>
     * 
     * @param childIds
     *            new value of {@code childIds} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code childIds} field changed
     */
    public DeviceManagementConfigurationSettingGroupDefinition withChildIds(List<String> childIds) {
        DeviceManagementConfigurationSettingGroupDefinition _x = _copy();
        _x.changedFields = changedFields.add("childIds");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationSettingGroupDefinition");
        _x.childIds = childIds;
        return _x;
    }

    /**
     * <i>“Dependent child settings to this group of settings”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property childIds
     */
    @Property(name="childIds")
    @JsonIgnore
    public CollectionPage<String> getChildIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.childIds, Optional.ofNullable(childIdsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“List of child settings that depend on this setting”</i>
     * 
     * @return property dependedOnBy
     */
    @Property(name="dependedOnBy")
    @JsonIgnore
    public CollectionPage<DeviceManagementConfigurationSettingDependedOnBy> getDependedOnBy() {
        return new CollectionPage<DeviceManagementConfigurationSettingDependedOnBy>(contextPath, DeviceManagementConfigurationSettingDependedOnBy.class, this.dependedOnBy, Optional.ofNullable(dependedOnByNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code dependedOnBy}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“List of child settings that depend on this setting”</i>
     * 
     * @param dependedOnBy
     *            new value of {@code dependedOnBy} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code dependedOnBy} field changed
     */
    public DeviceManagementConfigurationSettingGroupDefinition withDependedOnBy(List<DeviceManagementConfigurationSettingDependedOnBy> dependedOnBy) {
        DeviceManagementConfigurationSettingGroupDefinition _x = _copy();
        _x.changedFields = changedFields.add("dependedOnBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationSettingGroupDefinition");
        _x.dependedOnBy = dependedOnBy;
        return _x;
    }

    /**
     * <i>“List of child settings that depend on this setting”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property dependedOnBy
     */
    @Property(name="dependedOnBy")
    @JsonIgnore
    public CollectionPage<DeviceManagementConfigurationSettingDependedOnBy> getDependedOnBy(HttpRequestOptions options) {
        return new CollectionPage<DeviceManagementConfigurationSettingDependedOnBy>(contextPath, DeviceManagementConfigurationSettingDependedOnBy.class, this.dependedOnBy, Optional.ofNullable(dependedOnByNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“List of Dependencies for the setting group”</i>
     * 
     * @return property dependentOn
     */
    @Property(name="dependentOn")
    @JsonIgnore
    public CollectionPage<DeviceManagementConfigurationDependentOn> getDependentOn() {
        return new CollectionPage<DeviceManagementConfigurationDependentOn>(contextPath, DeviceManagementConfigurationDependentOn.class, this.dependentOn, Optional.ofNullable(dependentOnNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code dependentOn}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“List of Dependencies for the setting group”</i>
     * 
     * @param dependentOn
     *            new value of {@code dependentOn} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code dependentOn} field changed
     */
    public DeviceManagementConfigurationSettingGroupDefinition withDependentOn(List<DeviceManagementConfigurationDependentOn> dependentOn) {
        DeviceManagementConfigurationSettingGroupDefinition _x = _copy();
        _x.changedFields = changedFields.add("dependentOn");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationSettingGroupDefinition");
        _x.dependentOn = dependentOn;
        return _x;
    }

    /**
     * <i>“List of Dependencies for the setting group”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property dependentOn
     */
    @Property(name="dependentOn")
    @JsonIgnore
    public CollectionPage<DeviceManagementConfigurationDependentOn> getDependentOn(HttpRequestOptions options) {
        return new CollectionPage<DeviceManagementConfigurationDependentOn>(contextPath, DeviceManagementConfigurationDependentOn.class, this.dependentOn, Optional.ofNullable(dependentOnNextLink), Collections.emptyList(), options);
    }

    public DeviceManagementConfigurationSettingGroupDefinition withUnmappedField(String name, Object value) {
        DeviceManagementConfigurationSettingGroupDefinition _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementConfigurationSettingGroupDefinition patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementConfigurationSettingGroupDefinition _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementConfigurationSettingGroupDefinition put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementConfigurationSettingGroupDefinition _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceManagementConfigurationSettingGroupDefinition _copy() {
        DeviceManagementConfigurationSettingGroupDefinition _x = new DeviceManagementConfigurationSettingGroupDefinition();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.accessTypes = accessTypes;
        _x.applicability = applicability;
        _x.baseUri = baseUri;
        _x.categoryId = categoryId;
        _x.description = description;
        _x.displayName = displayName;
        _x.helpText = helpText;
        _x.infoUrls = infoUrls;
        _x.keywords = keywords;
        _x.name = name;
        _x.occurrence = occurrence;
        _x.offsetUri = offsetUri;
        _x.referredSettingInformationList = referredSettingInformationList;
        _x.rootDefinitionId = rootDefinitionId;
        _x.settingUsage = settingUsage;
        _x.uxBehavior = uxBehavior;
        _x.version = version;
        _x.visibility = visibility;
        _x.childIds = childIds;
        _x.dependedOnBy = dependedOnBy;
        _x.dependentOn = dependentOn;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementConfigurationSettingGroupDefinition[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("accessTypes=");
        b.append(this.accessTypes);
        b.append(", ");
        b.append("applicability=");
        b.append(this.applicability);
        b.append(", ");
        b.append("baseUri=");
        b.append(this.baseUri);
        b.append(", ");
        b.append("categoryId=");
        b.append(this.categoryId);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("helpText=");
        b.append(this.helpText);
        b.append(", ");
        b.append("infoUrls=");
        b.append(this.infoUrls);
        b.append(", ");
        b.append("keywords=");
        b.append(this.keywords);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("occurrence=");
        b.append(this.occurrence);
        b.append(", ");
        b.append("offsetUri=");
        b.append(this.offsetUri);
        b.append(", ");
        b.append("referredSettingInformationList=");
        b.append(this.referredSettingInformationList);
        b.append(", ");
        b.append("rootDefinitionId=");
        b.append(this.rootDefinitionId);
        b.append(", ");
        b.append("settingUsage=");
        b.append(this.settingUsage);
        b.append(", ");
        b.append("uxBehavior=");
        b.append(this.uxBehavior);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("visibility=");
        b.append(this.visibility);
        b.append(", ");
        b.append("childIds=");
        b.append(this.childIds);
        b.append(", ");
        b.append("dependedOnBy=");
        b.append(this.dependedOnBy);
        b.append(", ");
        b.append("dependentOn=");
        b.append(this.dependentOn);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
