package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DeviceManagementConfigurationReferredSettingInformation;
import odata.msgraph.client.beta.complex.DeviceManagementConfigurationSettingApplicability;
import odata.msgraph.client.beta.complex.DeviceManagementConfigurationSettingOccurrence;
import odata.msgraph.client.beta.enums.DeviceManagementConfigurationControlType;
import odata.msgraph.client.beta.enums.DeviceManagementConfigurationSettingAccessTypes;
import odata.msgraph.client.beta.enums.DeviceManagementConfigurationSettingUsage;
import odata.msgraph.client.beta.enums.DeviceManagementConfigurationSettingVisibility;

@JsonPropertyOrder({
    "@odata.type", 
    "accessTypes", 
    "applicability", 
    "baseUri", 
    "categoryId", 
    "description", 
    "displayName", 
    "helpText", 
    "infoUrls", 
    "keywords", 
    "name", 
    "occurrence", 
    "offsetUri", 
    "referredSettingInformationList", 
    "rootDefinitionId", 
    "settingUsage", 
    "uxBehavior", 
    "version", 
    "visibility"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementConfigurationSettingDefinition extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementConfigurationSettingDefinition";
    }

    @JsonProperty("accessTypes")
    protected DeviceManagementConfigurationSettingAccessTypes accessTypes;

    @JsonProperty("applicability")
    protected DeviceManagementConfigurationSettingApplicability applicability;

    @JsonProperty("baseUri")
    protected String baseUri;

    @JsonProperty("categoryId")
    protected String categoryId;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("helpText")
    protected String helpText;

    @JsonProperty("infoUrls")
    protected List<String> infoUrls;

    @JsonProperty("infoUrls@nextLink")
    protected String infoUrlsNextLink;

    @JsonProperty("keywords")
    protected List<String> keywords;

    @JsonProperty("keywords@nextLink")
    protected String keywordsNextLink;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("occurrence")
    protected DeviceManagementConfigurationSettingOccurrence occurrence;

    @JsonProperty("offsetUri")
    protected String offsetUri;

    @JsonProperty("referredSettingInformationList")
    protected List<DeviceManagementConfigurationReferredSettingInformation> referredSettingInformationList;

    @JsonProperty("referredSettingInformationList@nextLink")
    protected String referredSettingInformationListNextLink;

    @JsonProperty("rootDefinitionId")
    protected String rootDefinitionId;

    @JsonProperty("settingUsage")
    protected DeviceManagementConfigurationSettingUsage settingUsage;

    @JsonProperty("uxBehavior")
    protected DeviceManagementConfigurationControlType uxBehavior;

    @JsonProperty("version")
    protected String version;

    @JsonProperty("visibility")
    protected DeviceManagementConfigurationSettingVisibility visibility;

    protected DeviceManagementConfigurationSettingDefinition() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceManagementConfigurationSettingDefinition() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private DeviceManagementConfigurationSettingAccessTypes accessTypes;
        private DeviceManagementConfigurationSettingApplicability applicability;
        private String baseUri;
        private String categoryId;
        private String description;
        private String displayName;
        private String helpText;
        private List<String> infoUrls;
        private String infoUrlsNextLink;
        private List<String> keywords;
        private String keywordsNextLink;
        private String name;
        private DeviceManagementConfigurationSettingOccurrence occurrence;
        private String offsetUri;
        private List<DeviceManagementConfigurationReferredSettingInformation> referredSettingInformationList;
        private String referredSettingInformationListNextLink;
        private String rootDefinitionId;
        private DeviceManagementConfigurationSettingUsage settingUsage;
        private DeviceManagementConfigurationControlType uxBehavior;
        private String version;
        private DeviceManagementConfigurationSettingVisibility visibility;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Read/write access mode of the setting”</i>
         * 
         * @param accessTypes
         *            value of {@code accessTypes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder accessTypes(DeviceManagementConfigurationSettingAccessTypes accessTypes) {
            this.accessTypes = accessTypes;
            this.changedFields = changedFields.add("accessTypes");
            return this;
        }

        /**
         * <i>“Details which device setting is applicable on”</i>
         * 
         * @param applicability
         *            value of {@code applicability} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder applicability(DeviceManagementConfigurationSettingApplicability applicability) {
            this.applicability = applicability;
            this.changedFields = changedFields.add("applicability");
            return this;
        }

        /**
         * <i>“Base CSP Path”</i>
         * 
         * @param baseUri
         *            value of {@code baseUri} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder baseUri(String baseUri) {
            this.baseUri = baseUri;
            this.changedFields = changedFields.add("baseUri");
            return this;
        }

        /**
         * <i>“Specifies the area group under which the setting is configured in a specified
         * configuration service provider (CSP)”</i>
         * 
         * @param categoryId
         *            value of {@code categoryId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder categoryId(String categoryId) {
            this.categoryId = categoryId;
            this.changedFields = changedFields.add("categoryId");
            return this;
        }

        /**
         * <i>“Description of the item”</i>
         * 
         * @param description
         *            value of {@code description} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        /**
         * <i>“Display name of the item”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“Help text of the item”</i>
         * 
         * @param helpText
         *            value of {@code helpText} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder helpText(String helpText) {
            this.helpText = helpText;
            this.changedFields = changedFields.add("helpText");
            return this;
        }

        /**
         * <i>“List of links more info for the setting can be found at”</i>
         * 
         * @param infoUrls
         *            value of {@code infoUrls} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder infoUrls(List<String> infoUrls) {
            this.infoUrls = infoUrls;
            this.changedFields = changedFields.add("infoUrls");
            return this;
        }

        /**
         * <i>“List of links more info for the setting can be found at”</i>
         * 
         * @param infoUrls
         *            value of {@code infoUrls} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder infoUrls(String... infoUrls) {
            return infoUrls(Arrays.asList(infoUrls));
        }

        /**
         * <i>“List of links more info for the setting can be found at”</i>
         * 
         * @param infoUrlsNextLink
         *            value of {@code infoUrls@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder infoUrlsNextLink(String infoUrlsNextLink) {
            this.infoUrlsNextLink = infoUrlsNextLink;
            this.changedFields = changedFields.add("infoUrls");
            return this;
        }

        /**
         * <i>“Tokens which to search settings on”</i>
         * 
         * @param keywords
         *            value of {@code keywords} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder keywords(List<String> keywords) {
            this.keywords = keywords;
            this.changedFields = changedFields.add("keywords");
            return this;
        }

        /**
         * <i>“Tokens which to search settings on”</i>
         * 
         * @param keywords
         *            value of {@code keywords} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder keywords(String... keywords) {
            return keywords(Arrays.asList(keywords));
        }

        /**
         * <i>“Tokens which to search settings on”</i>
         * 
         * @param keywordsNextLink
         *            value of {@code keywords@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder keywordsNextLink(String keywordsNextLink) {
            this.keywordsNextLink = keywordsNextLink;
            this.changedFields = changedFields.add("keywords");
            return this;
        }

        /**
         * <i>“Name of the item”</i>
         * 
         * @param name
         *            value of {@code name} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        /**
         * <i>“Indicates whether the setting is required or not”</i>
         * 
         * @param occurrence
         *            value of {@code occurrence} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder occurrence(DeviceManagementConfigurationSettingOccurrence occurrence) {
            this.occurrence = occurrence;
            this.changedFields = changedFields.add("occurrence");
            return this;
        }

        /**
         * <i>“Offset CSP Path from Base”</i>
         * 
         * @param offsetUri
         *            value of {@code offsetUri} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder offsetUri(String offsetUri) {
            this.offsetUri = offsetUri;
            this.changedFields = changedFields.add("offsetUri");
            return this;
        }

        /**
         * <i>“List of referred setting information.”</i>
         * 
         * @param referredSettingInformationList
         *            value of {@code referredSettingInformationList} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder referredSettingInformationList(List<DeviceManagementConfigurationReferredSettingInformation> referredSettingInformationList) {
            this.referredSettingInformationList = referredSettingInformationList;
            this.changedFields = changedFields.add("referredSettingInformationList");
            return this;
        }

        /**
         * <i>“List of referred setting information.”</i>
         * 
         * @param referredSettingInformationList
         *            value of {@code referredSettingInformationList} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder referredSettingInformationList(DeviceManagementConfigurationReferredSettingInformation... referredSettingInformationList) {
            return referredSettingInformationList(Arrays.asList(referredSettingInformationList));
        }

        /**
         * <i>“List of referred setting information.”</i>
         * 
         * @param referredSettingInformationListNextLink
         *            value of {@code referredSettingInformationList@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder referredSettingInformationListNextLink(String referredSettingInformationListNextLink) {
            this.referredSettingInformationListNextLink = referredSettingInformationListNextLink;
            this.changedFields = changedFields.add("referredSettingInformationList");
            return this;
        }

        /**
         * <i>“Root setting definition if the setting is a child setting.”</i>
         * 
         * @param rootDefinitionId
         *            value of {@code rootDefinitionId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder rootDefinitionId(String rootDefinitionId) {
            this.rootDefinitionId = rootDefinitionId;
            this.changedFields = changedFields.add("rootDefinitionId");
            return this;
        }

        /**
         * <i>“Setting type, for example, configuration and compliance”</i>
         * 
         * @param settingUsage
         *            value of {@code settingUsage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settingUsage(DeviceManagementConfigurationSettingUsage settingUsage) {
            this.settingUsage = settingUsage;
            this.changedFields = changedFields.add("settingUsage");
            return this;
        }

        /**
         * <i>“Setting control type representation in the UX”</i>
         * 
         * @param uxBehavior
         *            value of {@code uxBehavior} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder uxBehavior(DeviceManagementConfigurationControlType uxBehavior) {
            this.uxBehavior = uxBehavior;
            this.changedFields = changedFields.add("uxBehavior");
            return this;
        }

        /**
         * <i>“Item Version”</i>
         * 
         * @param version
         *            value of {@code version} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder version(String version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        /**
         * <i>“Setting visibility scope to UX”</i>
         * 
         * @param visibility
         *            value of {@code visibility} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder visibility(DeviceManagementConfigurationSettingVisibility visibility) {
            this.visibility = visibility;
            this.changedFields = changedFields.add("visibility");
            return this;
        }

        public DeviceManagementConfigurationSettingDefinition build() {
            DeviceManagementConfigurationSettingDefinition _x = new DeviceManagementConfigurationSettingDefinition();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceManagementConfigurationSettingDefinition";
            _x.id = id;
            _x.accessTypes = accessTypes;
            _x.applicability = applicability;
            _x.baseUri = baseUri;
            _x.categoryId = categoryId;
            _x.description = description;
            _x.displayName = displayName;
            _x.helpText = helpText;
            _x.infoUrls = infoUrls;
            _x.infoUrlsNextLink = infoUrlsNextLink;
            _x.keywords = keywords;
            _x.keywordsNextLink = keywordsNextLink;
            _x.name = name;
            _x.occurrence = occurrence;
            _x.offsetUri = offsetUri;
            _x.referredSettingInformationList = referredSettingInformationList;
            _x.referredSettingInformationListNextLink = referredSettingInformationListNextLink;
            _x.rootDefinitionId = rootDefinitionId;
            _x.settingUsage = settingUsage;
            _x.uxBehavior = uxBehavior;
            _x.version = version;
            _x.visibility = visibility;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Read/write access mode of the setting”</i>
     * 
     * @return property accessTypes
     */
    @Property(name="accessTypes")
    @JsonIgnore
    public Optional<DeviceManagementConfigurationSettingAccessTypes> getAccessTypes() {
        return Optional.ofNullable(accessTypes);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code accessTypes}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Read/write access mode of the setting”</i>
     * 
     * @param accessTypes
     *            new value of {@code accessTypes} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code accessTypes} field changed
     */
    public DeviceManagementConfigurationSettingDefinition withAccessTypes(DeviceManagementConfigurationSettingAccessTypes accessTypes) {
        DeviceManagementConfigurationSettingDefinition _x = _copy();
        _x.changedFields = changedFields.add("accessTypes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationSettingDefinition");
        _x.accessTypes = accessTypes;
        return _x;
    }

    /**
     * <i>“Details which device setting is applicable on”</i>
     * 
     * @return property applicability
     */
    @Property(name="applicability")
    @JsonIgnore
    public Optional<DeviceManagementConfigurationSettingApplicability> getApplicability() {
        return Optional.ofNullable(applicability);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code applicability}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Details which device setting is applicable on”</i>
     * 
     * @param applicability
     *            new value of {@code applicability} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code applicability} field changed
     */
    public DeviceManagementConfigurationSettingDefinition withApplicability(DeviceManagementConfigurationSettingApplicability applicability) {
        DeviceManagementConfigurationSettingDefinition _x = _copy();
        _x.changedFields = changedFields.add("applicability");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationSettingDefinition");
        _x.applicability = applicability;
        return _x;
    }

    /**
     * <i>“Base CSP Path”</i>
     * 
     * @return property baseUri
     */
    @Property(name="baseUri")
    @JsonIgnore
    public Optional<String> getBaseUri() {
        return Optional.ofNullable(baseUri);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code baseUri} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Base CSP Path”</i>
     * 
     * @param baseUri
     *            new value of {@code baseUri} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code baseUri} field changed
     */
    public DeviceManagementConfigurationSettingDefinition withBaseUri(String baseUri) {
        DeviceManagementConfigurationSettingDefinition _x = _copy();
        _x.changedFields = changedFields.add("baseUri");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationSettingDefinition");
        _x.baseUri = baseUri;
        return _x;
    }

    /**
     * <i>“Specifies the area group under which the setting is configured in a specified
     * configuration service provider (CSP)”</i>
     * 
     * @return property categoryId
     */
    @Property(name="categoryId")
    @JsonIgnore
    public Optional<String> getCategoryId() {
        return Optional.ofNullable(categoryId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code categoryId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Specifies the area group under which the setting is configured in a specified
     * configuration service provider (CSP)”</i>
     * 
     * @param categoryId
     *            new value of {@code categoryId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code categoryId} field changed
     */
    public DeviceManagementConfigurationSettingDefinition withCategoryId(String categoryId) {
        DeviceManagementConfigurationSettingDefinition _x = _copy();
        _x.changedFields = changedFields.add("categoryId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationSettingDefinition");
        _x.categoryId = categoryId;
        return _x;
    }

    /**
     * <i>“Description of the item”</i>
     * 
     * @return property description
     */
    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code description}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Description of the item”</i>
     * 
     * @param description
     *            new value of {@code description} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code description} field changed
     */
    public DeviceManagementConfigurationSettingDefinition withDescription(String description) {
        DeviceManagementConfigurationSettingDefinition _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationSettingDefinition");
        _x.description = description;
        return _x;
    }

    /**
     * <i>“Display name of the item”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Display name of the item”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public DeviceManagementConfigurationSettingDefinition withDisplayName(String displayName) {
        DeviceManagementConfigurationSettingDefinition _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationSettingDefinition");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“Help text of the item”</i>
     * 
     * @return property helpText
     */
    @Property(name="helpText")
    @JsonIgnore
    public Optional<String> getHelpText() {
        return Optional.ofNullable(helpText);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code helpText} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Help text of the item”</i>
     * 
     * @param helpText
     *            new value of {@code helpText} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code helpText} field changed
     */
    public DeviceManagementConfigurationSettingDefinition withHelpText(String helpText) {
        DeviceManagementConfigurationSettingDefinition _x = _copy();
        _x.changedFields = changedFields.add("helpText");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationSettingDefinition");
        _x.helpText = helpText;
        return _x;
    }

    /**
     * <i>“List of links more info for the setting can be found at”</i>
     * 
     * @return property infoUrls
     */
    @Property(name="infoUrls")
    @JsonIgnore
    public CollectionPage<String> getInfoUrls() {
        return new CollectionPage<String>(contextPath, String.class, this.infoUrls, Optional.ofNullable(infoUrlsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code infoUrls} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“List of links more info for the setting can be found at”</i>
     * 
     * @param infoUrls
     *            new value of {@code infoUrls} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code infoUrls} field changed
     */
    public DeviceManagementConfigurationSettingDefinition withInfoUrls(List<String> infoUrls) {
        DeviceManagementConfigurationSettingDefinition _x = _copy();
        _x.changedFields = changedFields.add("infoUrls");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationSettingDefinition");
        _x.infoUrls = infoUrls;
        return _x;
    }

    /**
     * <i>“List of links more info for the setting can be found at”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property infoUrls
     */
    @Property(name="infoUrls")
    @JsonIgnore
    public CollectionPage<String> getInfoUrls(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.infoUrls, Optional.ofNullable(infoUrlsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Tokens which to search settings on”</i>
     * 
     * @return property keywords
     */
    @Property(name="keywords")
    @JsonIgnore
    public CollectionPage<String> getKeywords() {
        return new CollectionPage<String>(contextPath, String.class, this.keywords, Optional.ofNullable(keywordsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code keywords} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Tokens which to search settings on”</i>
     * 
     * @param keywords
     *            new value of {@code keywords} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code keywords} field changed
     */
    public DeviceManagementConfigurationSettingDefinition withKeywords(List<String> keywords) {
        DeviceManagementConfigurationSettingDefinition _x = _copy();
        _x.changedFields = changedFields.add("keywords");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationSettingDefinition");
        _x.keywords = keywords;
        return _x;
    }

    /**
     * <i>“Tokens which to search settings on”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property keywords
     */
    @Property(name="keywords")
    @JsonIgnore
    public CollectionPage<String> getKeywords(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.keywords, Optional.ofNullable(keywordsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Name of the item”</i>
     * 
     * @return property name
     */
    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code name} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Name of the item”</i>
     * 
     * @param name
     *            new value of {@code name} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code name} field changed
     */
    public DeviceManagementConfigurationSettingDefinition withName(String name) {
        DeviceManagementConfigurationSettingDefinition _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationSettingDefinition");
        _x.name = name;
        return _x;
    }

    /**
     * <i>“Indicates whether the setting is required or not”</i>
     * 
     * @return property occurrence
     */
    @Property(name="occurrence")
    @JsonIgnore
    public Optional<DeviceManagementConfigurationSettingOccurrence> getOccurrence() {
        return Optional.ofNullable(occurrence);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code occurrence} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Indicates whether the setting is required or not”</i>
     * 
     * @param occurrence
     *            new value of {@code occurrence} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code occurrence} field changed
     */
    public DeviceManagementConfigurationSettingDefinition withOccurrence(DeviceManagementConfigurationSettingOccurrence occurrence) {
        DeviceManagementConfigurationSettingDefinition _x = _copy();
        _x.changedFields = changedFields.add("occurrence");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationSettingDefinition");
        _x.occurrence = occurrence;
        return _x;
    }

    /**
     * <i>“Offset CSP Path from Base”</i>
     * 
     * @return property offsetUri
     */
    @Property(name="offsetUri")
    @JsonIgnore
    public Optional<String> getOffsetUri() {
        return Optional.ofNullable(offsetUri);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code offsetUri} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Offset CSP Path from Base”</i>
     * 
     * @param offsetUri
     *            new value of {@code offsetUri} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code offsetUri} field changed
     */
    public DeviceManagementConfigurationSettingDefinition withOffsetUri(String offsetUri) {
        DeviceManagementConfigurationSettingDefinition _x = _copy();
        _x.changedFields = changedFields.add("offsetUri");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationSettingDefinition");
        _x.offsetUri = offsetUri;
        return _x;
    }

    /**
     * <i>“List of referred setting information.”</i>
     * 
     * @return property referredSettingInformationList
     */
    @Property(name="referredSettingInformationList")
    @JsonIgnore
    public CollectionPage<DeviceManagementConfigurationReferredSettingInformation> getReferredSettingInformationList() {
        return new CollectionPage<DeviceManagementConfigurationReferredSettingInformation>(contextPath, DeviceManagementConfigurationReferredSettingInformation.class, this.referredSettingInformationList, Optional.ofNullable(referredSettingInformationListNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * referredSettingInformationList} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“List of referred setting information.”</i>
     * 
     * @param referredSettingInformationList
     *            new value of {@code referredSettingInformationList} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code referredSettingInformationList} field changed
     */
    public DeviceManagementConfigurationSettingDefinition withReferredSettingInformationList(List<DeviceManagementConfigurationReferredSettingInformation> referredSettingInformationList) {
        DeviceManagementConfigurationSettingDefinition _x = _copy();
        _x.changedFields = changedFields.add("referredSettingInformationList");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationSettingDefinition");
        _x.referredSettingInformationList = referredSettingInformationList;
        return _x;
    }

    /**
     * <i>“List of referred setting information.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property referredSettingInformationList
     */
    @Property(name="referredSettingInformationList")
    @JsonIgnore
    public CollectionPage<DeviceManagementConfigurationReferredSettingInformation> getReferredSettingInformationList(HttpRequestOptions options) {
        return new CollectionPage<DeviceManagementConfigurationReferredSettingInformation>(contextPath, DeviceManagementConfigurationReferredSettingInformation.class, this.referredSettingInformationList, Optional.ofNullable(referredSettingInformationListNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Root setting definition if the setting is a child setting.”</i>
     * 
     * @return property rootDefinitionId
     */
    @Property(name="rootDefinitionId")
    @JsonIgnore
    public Optional<String> getRootDefinitionId() {
        return Optional.ofNullable(rootDefinitionId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code rootDefinitionId}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Root setting definition if the setting is a child setting.”</i>
     * 
     * @param rootDefinitionId
     *            new value of {@code rootDefinitionId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code rootDefinitionId} field changed
     */
    public DeviceManagementConfigurationSettingDefinition withRootDefinitionId(String rootDefinitionId) {
        DeviceManagementConfigurationSettingDefinition _x = _copy();
        _x.changedFields = changedFields.add("rootDefinitionId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationSettingDefinition");
        _x.rootDefinitionId = rootDefinitionId;
        return _x;
    }

    /**
     * <i>“Setting type, for example, configuration and compliance”</i>
     * 
     * @return property settingUsage
     */
    @Property(name="settingUsage")
    @JsonIgnore
    public Optional<DeviceManagementConfigurationSettingUsage> getSettingUsage() {
        return Optional.ofNullable(settingUsage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code settingUsage}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Setting type, for example, configuration and compliance”</i>
     * 
     * @param settingUsage
     *            new value of {@code settingUsage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code settingUsage} field changed
     */
    public DeviceManagementConfigurationSettingDefinition withSettingUsage(DeviceManagementConfigurationSettingUsage settingUsage) {
        DeviceManagementConfigurationSettingDefinition _x = _copy();
        _x.changedFields = changedFields.add("settingUsage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationSettingDefinition");
        _x.settingUsage = settingUsage;
        return _x;
    }

    /**
     * <i>“Setting control type representation in the UX”</i>
     * 
     * @return property uxBehavior
     */
    @Property(name="uxBehavior")
    @JsonIgnore
    public Optional<DeviceManagementConfigurationControlType> getUxBehavior() {
        return Optional.ofNullable(uxBehavior);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code uxBehavior} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Setting control type representation in the UX”</i>
     * 
     * @param uxBehavior
     *            new value of {@code uxBehavior} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code uxBehavior} field changed
     */
    public DeviceManagementConfigurationSettingDefinition withUxBehavior(DeviceManagementConfigurationControlType uxBehavior) {
        DeviceManagementConfigurationSettingDefinition _x = _copy();
        _x.changedFields = changedFields.add("uxBehavior");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationSettingDefinition");
        _x.uxBehavior = uxBehavior;
        return _x;
    }

    /**
     * <i>“Item Version”</i>
     * 
     * @return property version
     */
    @Property(name="version")
    @JsonIgnore
    public Optional<String> getVersion() {
        return Optional.ofNullable(version);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code version} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Item Version”</i>
     * 
     * @param version
     *            new value of {@code version} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code version} field changed
     */
    public DeviceManagementConfigurationSettingDefinition withVersion(String version) {
        DeviceManagementConfigurationSettingDefinition _x = _copy();
        _x.changedFields = changedFields.add("version");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationSettingDefinition");
        _x.version = version;
        return _x;
    }

    /**
     * <i>“Setting visibility scope to UX”</i>
     * 
     * @return property visibility
     */
    @Property(name="visibility")
    @JsonIgnore
    public Optional<DeviceManagementConfigurationSettingVisibility> getVisibility() {
        return Optional.ofNullable(visibility);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code visibility} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Setting visibility scope to UX”</i>
     * 
     * @param visibility
     *            new value of {@code visibility} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code visibility} field changed
     */
    public DeviceManagementConfigurationSettingDefinition withVisibility(DeviceManagementConfigurationSettingVisibility visibility) {
        DeviceManagementConfigurationSettingDefinition _x = _copy();
        _x.changedFields = changedFields.add("visibility");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationSettingDefinition");
        _x.visibility = visibility;
        return _x;
    }

    public DeviceManagementConfigurationSettingDefinition withUnmappedField(String name, Object value) {
        DeviceManagementConfigurationSettingDefinition _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementConfigurationSettingDefinition patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementConfigurationSettingDefinition _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementConfigurationSettingDefinition put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementConfigurationSettingDefinition _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceManagementConfigurationSettingDefinition _copy() {
        DeviceManagementConfigurationSettingDefinition _x = new DeviceManagementConfigurationSettingDefinition();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.accessTypes = accessTypes;
        _x.applicability = applicability;
        _x.baseUri = baseUri;
        _x.categoryId = categoryId;
        _x.description = description;
        _x.displayName = displayName;
        _x.helpText = helpText;
        _x.infoUrls = infoUrls;
        _x.keywords = keywords;
        _x.name = name;
        _x.occurrence = occurrence;
        _x.offsetUri = offsetUri;
        _x.referredSettingInformationList = referredSettingInformationList;
        _x.rootDefinitionId = rootDefinitionId;
        _x.settingUsage = settingUsage;
        _x.uxBehavior = uxBehavior;
        _x.version = version;
        _x.visibility = visibility;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementConfigurationSettingDefinition[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("accessTypes=");
        b.append(this.accessTypes);
        b.append(", ");
        b.append("applicability=");
        b.append(this.applicability);
        b.append(", ");
        b.append("baseUri=");
        b.append(this.baseUri);
        b.append(", ");
        b.append("categoryId=");
        b.append(this.categoryId);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("helpText=");
        b.append(this.helpText);
        b.append(", ");
        b.append("infoUrls=");
        b.append(this.infoUrls);
        b.append(", ");
        b.append("keywords=");
        b.append(this.keywords);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("occurrence=");
        b.append(this.occurrence);
        b.append(", ");
        b.append("offsetUri=");
        b.append(this.offsetUri);
        b.append(", ");
        b.append("referredSettingInformationList=");
        b.append(this.referredSettingInformationList);
        b.append(", ");
        b.append("rootDefinitionId=");
        b.append(this.rootDefinitionId);
        b.append(", ");
        b.append("settingUsage=");
        b.append(this.settingUsage);
        b.append(", ");
        b.append("uxBehavior=");
        b.append(this.uxBehavior);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("visibility=");
        b.append(this.visibility);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
