package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DeviceManagementConfigurationReferredSettingInformation;
import odata.msgraph.client.beta.complex.DeviceManagementConfigurationSettingApplicability;
import odata.msgraph.client.beta.complex.DeviceManagementConfigurationSettingOccurrence;
import odata.msgraph.client.beta.enums.DeviceManagementConfigurationControlType;
import odata.msgraph.client.beta.enums.DeviceManagementConfigurationSettingAccessTypes;
import odata.msgraph.client.beta.enums.DeviceManagementConfigurationSettingUsage;
import odata.msgraph.client.beta.enums.DeviceManagementConfigurationSettingVisibility;

@JsonPropertyOrder({
    "@odata.type", 
    "deepLink", 
    "redirectMessage", 
    "redirectReason"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementConfigurationRedirectSettingDefinition extends DeviceManagementConfigurationSettingDefinition implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementConfigurationRedirectSettingDefinition";
    }

    @JsonProperty("deepLink")
    protected String deepLink;

    @JsonProperty("redirectMessage")
    protected String redirectMessage;

    @JsonProperty("redirectReason")
    protected String redirectReason;

    protected DeviceManagementConfigurationRedirectSettingDefinition() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceManagementConfigurationRedirectSettingDefinition() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private DeviceManagementConfigurationSettingAccessTypes accessTypes;
        private DeviceManagementConfigurationSettingApplicability applicability;
        private String baseUri;
        private String categoryId;
        private String description;
        private String displayName;
        private String helpText;
        private List<String> infoUrls;
        private String infoUrlsNextLink;
        private List<String> keywords;
        private String keywordsNextLink;
        private String name;
        private DeviceManagementConfigurationSettingOccurrence occurrence;
        private String offsetUri;
        private List<DeviceManagementConfigurationReferredSettingInformation> referredSettingInformationList;
        private String referredSettingInformationListNextLink;
        private String rootDefinitionId;
        private DeviceManagementConfigurationSettingUsage settingUsage;
        private DeviceManagementConfigurationControlType uxBehavior;
        private String version;
        private DeviceManagementConfigurationSettingVisibility visibility;
        private String deepLink;
        private String redirectMessage;
        private String redirectReason;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder accessTypes(DeviceManagementConfigurationSettingAccessTypes accessTypes) {
            this.accessTypes = accessTypes;
            this.changedFields = changedFields.add("accessTypes");
            return this;
        }

        public Builder applicability(DeviceManagementConfigurationSettingApplicability applicability) {
            this.applicability = applicability;
            this.changedFields = changedFields.add("applicability");
            return this;
        }

        public Builder baseUri(String baseUri) {
            this.baseUri = baseUri;
            this.changedFields = changedFields.add("baseUri");
            return this;
        }

        public Builder categoryId(String categoryId) {
            this.categoryId = categoryId;
            this.changedFields = changedFields.add("categoryId");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder helpText(String helpText) {
            this.helpText = helpText;
            this.changedFields = changedFields.add("helpText");
            return this;
        }

        public Builder infoUrls(List<String> infoUrls) {
            this.infoUrls = infoUrls;
            this.changedFields = changedFields.add("infoUrls");
            return this;
        }

        public Builder infoUrls(String... infoUrls) {
            return infoUrls(Arrays.asList(infoUrls));
        }

        public Builder infoUrlsNextLink(String infoUrlsNextLink) {
            this.infoUrlsNextLink = infoUrlsNextLink;
            this.changedFields = changedFields.add("infoUrls");
            return this;
        }

        public Builder keywords(List<String> keywords) {
            this.keywords = keywords;
            this.changedFields = changedFields.add("keywords");
            return this;
        }

        public Builder keywords(String... keywords) {
            return keywords(Arrays.asList(keywords));
        }

        public Builder keywordsNextLink(String keywordsNextLink) {
            this.keywordsNextLink = keywordsNextLink;
            this.changedFields = changedFields.add("keywords");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder occurrence(DeviceManagementConfigurationSettingOccurrence occurrence) {
            this.occurrence = occurrence;
            this.changedFields = changedFields.add("occurrence");
            return this;
        }

        public Builder offsetUri(String offsetUri) {
            this.offsetUri = offsetUri;
            this.changedFields = changedFields.add("offsetUri");
            return this;
        }

        public Builder referredSettingInformationList(List<DeviceManagementConfigurationReferredSettingInformation> referredSettingInformationList) {
            this.referredSettingInformationList = referredSettingInformationList;
            this.changedFields = changedFields.add("referredSettingInformationList");
            return this;
        }

        public Builder referredSettingInformationList(DeviceManagementConfigurationReferredSettingInformation... referredSettingInformationList) {
            return referredSettingInformationList(Arrays.asList(referredSettingInformationList));
        }

        public Builder referredSettingInformationListNextLink(String referredSettingInformationListNextLink) {
            this.referredSettingInformationListNextLink = referredSettingInformationListNextLink;
            this.changedFields = changedFields.add("referredSettingInformationList");
            return this;
        }

        public Builder rootDefinitionId(String rootDefinitionId) {
            this.rootDefinitionId = rootDefinitionId;
            this.changedFields = changedFields.add("rootDefinitionId");
            return this;
        }

        public Builder settingUsage(DeviceManagementConfigurationSettingUsage settingUsage) {
            this.settingUsage = settingUsage;
            this.changedFields = changedFields.add("settingUsage");
            return this;
        }

        public Builder uxBehavior(DeviceManagementConfigurationControlType uxBehavior) {
            this.uxBehavior = uxBehavior;
            this.changedFields = changedFields.add("uxBehavior");
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public Builder visibility(DeviceManagementConfigurationSettingVisibility visibility) {
            this.visibility = visibility;
            this.changedFields = changedFields.add("visibility");
            return this;
        }

        /**
         * <i>“A deep link that points to the specific location in the Intune console where
         * feature support must be managed from.”</i>
         * 
         * @param deepLink
         *            value of {@code deepLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deepLink(String deepLink) {
            this.deepLink = deepLink;
            this.changedFields = changedFields.add("deepLink");
            return this;
        }

        /**
         * <i>“A message that explains that clicking the link will redirect the user to a
         * supported page to manage the settings.”</i>
         * 
         * @param redirectMessage
         *            value of {@code redirectMessage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder redirectMessage(String redirectMessage) {
            this.redirectMessage = redirectMessage;
            this.changedFields = changedFields.add("redirectMessage");
            return this;
        }

        /**
         * <i>“Indicates the reason for redirecting the user to an alternative location in the
         * console.  For example: WiFi profiles are not supported in the settings catalog
         * and must be created with a template policy.”</i>
         * 
         * @param redirectReason
         *            value of {@code redirectReason} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder redirectReason(String redirectReason) {
            this.redirectReason = redirectReason;
            this.changedFields = changedFields.add("redirectReason");
            return this;
        }

        public DeviceManagementConfigurationRedirectSettingDefinition build() {
            DeviceManagementConfigurationRedirectSettingDefinition _x = new DeviceManagementConfigurationRedirectSettingDefinition();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceManagementConfigurationRedirectSettingDefinition";
            _x.id = id;
            _x.accessTypes = accessTypes;
            _x.applicability = applicability;
            _x.baseUri = baseUri;
            _x.categoryId = categoryId;
            _x.description = description;
            _x.displayName = displayName;
            _x.helpText = helpText;
            _x.infoUrls = infoUrls;
            _x.infoUrlsNextLink = infoUrlsNextLink;
            _x.keywords = keywords;
            _x.keywordsNextLink = keywordsNextLink;
            _x.name = name;
            _x.occurrence = occurrence;
            _x.offsetUri = offsetUri;
            _x.referredSettingInformationList = referredSettingInformationList;
            _x.referredSettingInformationListNextLink = referredSettingInformationListNextLink;
            _x.rootDefinitionId = rootDefinitionId;
            _x.settingUsage = settingUsage;
            _x.uxBehavior = uxBehavior;
            _x.version = version;
            _x.visibility = visibility;
            _x.deepLink = deepLink;
            _x.redirectMessage = redirectMessage;
            _x.redirectReason = redirectReason;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“A deep link that points to the specific location in the Intune console where
     * feature support must be managed from.”</i>
     * 
     * @return property deepLink
     */
    @Property(name="deepLink")
    @JsonIgnore
    public Optional<String> getDeepLink() {
        return Optional.ofNullable(deepLink);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deepLink} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“A deep link that points to the specific location in the Intune console where
     * feature support must be managed from.”</i>
     * 
     * @param deepLink
     *            new value of {@code deepLink} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deepLink} field changed
     */
    public DeviceManagementConfigurationRedirectSettingDefinition withDeepLink(String deepLink) {
        DeviceManagementConfigurationRedirectSettingDefinition _x = _copy();
        _x.changedFields = changedFields.add("deepLink");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationRedirectSettingDefinition");
        _x.deepLink = deepLink;
        return _x;
    }

    /**
     * <i>“A message that explains that clicking the link will redirect the user to a
     * supported page to manage the settings.”</i>
     * 
     * @return property redirectMessage
     */
    @Property(name="redirectMessage")
    @JsonIgnore
    public Optional<String> getRedirectMessage() {
        return Optional.ofNullable(redirectMessage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code redirectMessage}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“A message that explains that clicking the link will redirect the user to a
     * supported page to manage the settings.”</i>
     * 
     * @param redirectMessage
     *            new value of {@code redirectMessage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code redirectMessage} field changed
     */
    public DeviceManagementConfigurationRedirectSettingDefinition withRedirectMessage(String redirectMessage) {
        DeviceManagementConfigurationRedirectSettingDefinition _x = _copy();
        _x.changedFields = changedFields.add("redirectMessage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationRedirectSettingDefinition");
        _x.redirectMessage = redirectMessage;
        return _x;
    }

    /**
     * <i>“Indicates the reason for redirecting the user to an alternative location in the
     * console.  For example: WiFi profiles are not supported in the settings catalog
     * and must be created with a template policy.”</i>
     * 
     * @return property redirectReason
     */
    @Property(name="redirectReason")
    @JsonIgnore
    public Optional<String> getRedirectReason() {
        return Optional.ofNullable(redirectReason);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code redirectReason}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates the reason for redirecting the user to an alternative location in the
     * console.  For example: WiFi profiles are not supported in the settings catalog
     * and must be created with a template policy.”</i>
     * 
     * @param redirectReason
     *            new value of {@code redirectReason} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code redirectReason} field changed
     */
    public DeviceManagementConfigurationRedirectSettingDefinition withRedirectReason(String redirectReason) {
        DeviceManagementConfigurationRedirectSettingDefinition _x = _copy();
        _x.changedFields = changedFields.add("redirectReason");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationRedirectSettingDefinition");
        _x.redirectReason = redirectReason;
        return _x;
    }

    public DeviceManagementConfigurationRedirectSettingDefinition withUnmappedField(String name, Object value) {
        DeviceManagementConfigurationRedirectSettingDefinition _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementConfigurationRedirectSettingDefinition patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementConfigurationRedirectSettingDefinition _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementConfigurationRedirectSettingDefinition put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementConfigurationRedirectSettingDefinition _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceManagementConfigurationRedirectSettingDefinition _copy() {
        DeviceManagementConfigurationRedirectSettingDefinition _x = new DeviceManagementConfigurationRedirectSettingDefinition();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.accessTypes = accessTypes;
        _x.applicability = applicability;
        _x.baseUri = baseUri;
        _x.categoryId = categoryId;
        _x.description = description;
        _x.displayName = displayName;
        _x.helpText = helpText;
        _x.infoUrls = infoUrls;
        _x.keywords = keywords;
        _x.name = name;
        _x.occurrence = occurrence;
        _x.offsetUri = offsetUri;
        _x.referredSettingInformationList = referredSettingInformationList;
        _x.rootDefinitionId = rootDefinitionId;
        _x.settingUsage = settingUsage;
        _x.uxBehavior = uxBehavior;
        _x.version = version;
        _x.visibility = visibility;
        _x.deepLink = deepLink;
        _x.redirectMessage = redirectMessage;
        _x.redirectReason = redirectReason;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementConfigurationRedirectSettingDefinition[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("accessTypes=");
        b.append(this.accessTypes);
        b.append(", ");
        b.append("applicability=");
        b.append(this.applicability);
        b.append(", ");
        b.append("baseUri=");
        b.append(this.baseUri);
        b.append(", ");
        b.append("categoryId=");
        b.append(this.categoryId);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("helpText=");
        b.append(this.helpText);
        b.append(", ");
        b.append("infoUrls=");
        b.append(this.infoUrls);
        b.append(", ");
        b.append("keywords=");
        b.append(this.keywords);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("occurrence=");
        b.append(this.occurrence);
        b.append(", ");
        b.append("offsetUri=");
        b.append(this.offsetUri);
        b.append(", ");
        b.append("referredSettingInformationList=");
        b.append(this.referredSettingInformationList);
        b.append(", ");
        b.append("rootDefinitionId=");
        b.append(this.rootDefinitionId);
        b.append(", ");
        b.append("settingUsage=");
        b.append(this.settingUsage);
        b.append(", ");
        b.append("uxBehavior=");
        b.append(this.uxBehavior);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("visibility=");
        b.append(this.visibility);
        b.append(", ");
        b.append("deepLink=");
        b.append(this.deepLink);
        b.append(", ");
        b.append("redirectMessage=");
        b.append(this.redirectMessage);
        b.append(", ");
        b.append("redirectReason=");
        b.append(this.redirectReason);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
