package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DeviceManagementConfigurationOptionDefinition;
import odata.msgraph.client.beta.complex.DeviceManagementConfigurationReferredSettingInformation;
import odata.msgraph.client.beta.complex.DeviceManagementConfigurationSettingApplicability;
import odata.msgraph.client.beta.complex.DeviceManagementConfigurationSettingOccurrence;
import odata.msgraph.client.beta.enums.DeviceManagementConfigurationControlType;
import odata.msgraph.client.beta.enums.DeviceManagementConfigurationSettingAccessTypes;
import odata.msgraph.client.beta.enums.DeviceManagementConfigurationSettingUsage;
import odata.msgraph.client.beta.enums.DeviceManagementConfigurationSettingVisibility;

@JsonPropertyOrder({
    "@odata.type", 
    "defaultOptionId", 
    "options"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementConfigurationChoiceSettingDefinition extends DeviceManagementConfigurationSettingDefinition implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementConfigurationChoiceSettingDefinition";
    }

    @JsonProperty("defaultOptionId")
    protected String defaultOptionId;

    @JsonProperty("options")
    protected List<DeviceManagementConfigurationOptionDefinition> options;

    @JsonProperty("options@nextLink")
    protected String optionsNextLink;

    protected DeviceManagementConfigurationChoiceSettingDefinition() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceManagementConfigurationChoiceSettingDefinition() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private DeviceManagementConfigurationSettingAccessTypes accessTypes;
        private DeviceManagementConfigurationSettingApplicability applicability;
        private String baseUri;
        private String categoryId;
        private String description;
        private String displayName;
        private String helpText;
        private List<String> infoUrls;
        private String infoUrlsNextLink;
        private List<String> keywords;
        private String keywordsNextLink;
        private String name;
        private DeviceManagementConfigurationSettingOccurrence occurrence;
        private String offsetUri;
        private List<DeviceManagementConfigurationReferredSettingInformation> referredSettingInformationList;
        private String referredSettingInformationListNextLink;
        private String rootDefinitionId;
        private DeviceManagementConfigurationSettingUsage settingUsage;
        private DeviceManagementConfigurationControlType uxBehavior;
        private String version;
        private DeviceManagementConfigurationSettingVisibility visibility;
        private String defaultOptionId;
        private List<DeviceManagementConfigurationOptionDefinition> options;
        private String optionsNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder accessTypes(DeviceManagementConfigurationSettingAccessTypes accessTypes) {
            this.accessTypes = accessTypes;
            this.changedFields = changedFields.add("accessTypes");
            return this;
        }

        public Builder applicability(DeviceManagementConfigurationSettingApplicability applicability) {
            this.applicability = applicability;
            this.changedFields = changedFields.add("applicability");
            return this;
        }

        public Builder baseUri(String baseUri) {
            this.baseUri = baseUri;
            this.changedFields = changedFields.add("baseUri");
            return this;
        }

        public Builder categoryId(String categoryId) {
            this.categoryId = categoryId;
            this.changedFields = changedFields.add("categoryId");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder helpText(String helpText) {
            this.helpText = helpText;
            this.changedFields = changedFields.add("helpText");
            return this;
        }

        public Builder infoUrls(List<String> infoUrls) {
            this.infoUrls = infoUrls;
            this.changedFields = changedFields.add("infoUrls");
            return this;
        }

        public Builder infoUrls(String... infoUrls) {
            return infoUrls(Arrays.asList(infoUrls));
        }

        public Builder infoUrlsNextLink(String infoUrlsNextLink) {
            this.infoUrlsNextLink = infoUrlsNextLink;
            this.changedFields = changedFields.add("infoUrls");
            return this;
        }

        public Builder keywords(List<String> keywords) {
            this.keywords = keywords;
            this.changedFields = changedFields.add("keywords");
            return this;
        }

        public Builder keywords(String... keywords) {
            return keywords(Arrays.asList(keywords));
        }

        public Builder keywordsNextLink(String keywordsNextLink) {
            this.keywordsNextLink = keywordsNextLink;
            this.changedFields = changedFields.add("keywords");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder occurrence(DeviceManagementConfigurationSettingOccurrence occurrence) {
            this.occurrence = occurrence;
            this.changedFields = changedFields.add("occurrence");
            return this;
        }

        public Builder offsetUri(String offsetUri) {
            this.offsetUri = offsetUri;
            this.changedFields = changedFields.add("offsetUri");
            return this;
        }

        public Builder referredSettingInformationList(List<DeviceManagementConfigurationReferredSettingInformation> referredSettingInformationList) {
            this.referredSettingInformationList = referredSettingInformationList;
            this.changedFields = changedFields.add("referredSettingInformationList");
            return this;
        }

        public Builder referredSettingInformationList(DeviceManagementConfigurationReferredSettingInformation... referredSettingInformationList) {
            return referredSettingInformationList(Arrays.asList(referredSettingInformationList));
        }

        public Builder referredSettingInformationListNextLink(String referredSettingInformationListNextLink) {
            this.referredSettingInformationListNextLink = referredSettingInformationListNextLink;
            this.changedFields = changedFields.add("referredSettingInformationList");
            return this;
        }

        public Builder rootDefinitionId(String rootDefinitionId) {
            this.rootDefinitionId = rootDefinitionId;
            this.changedFields = changedFields.add("rootDefinitionId");
            return this;
        }

        public Builder settingUsage(DeviceManagementConfigurationSettingUsage settingUsage) {
            this.settingUsage = settingUsage;
            this.changedFields = changedFields.add("settingUsage");
            return this;
        }

        public Builder uxBehavior(DeviceManagementConfigurationControlType uxBehavior) {
            this.uxBehavior = uxBehavior;
            this.changedFields = changedFields.add("uxBehavior");
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public Builder visibility(DeviceManagementConfigurationSettingVisibility visibility) {
            this.visibility = visibility;
            this.changedFields = changedFields.add("visibility");
            return this;
        }

        /**
         * <i>“Default option for choice setting”</i>
         * 
         * @param defaultOptionId
         *            value of {@code defaultOptionId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defaultOptionId(String defaultOptionId) {
            this.defaultOptionId = defaultOptionId;
            this.changedFields = changedFields.add("defaultOptionId");
            return this;
        }

        /**
         * <i>“Options for the setting that can be selected”</i>
         * 
         * @param options
         *            value of {@code options} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder options(List<DeviceManagementConfigurationOptionDefinition> options) {
            this.options = options;
            this.changedFields = changedFields.add("options");
            return this;
        }

        /**
         * <i>“Options for the setting that can be selected”</i>
         * 
         * @param options
         *            value of {@code options} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder options(DeviceManagementConfigurationOptionDefinition... options) {
            return options(Arrays.asList(options));
        }

        /**
         * <i>“Options for the setting that can be selected”</i>
         * 
         * @param optionsNextLink
         *            value of {@code options@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder optionsNextLink(String optionsNextLink) {
            this.optionsNextLink = optionsNextLink;
            this.changedFields = changedFields.add("options");
            return this;
        }

        public DeviceManagementConfigurationChoiceSettingDefinition build() {
            DeviceManagementConfigurationChoiceSettingDefinition _x = new DeviceManagementConfigurationChoiceSettingDefinition();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceManagementConfigurationChoiceSettingDefinition";
            _x.id = id;
            _x.accessTypes = accessTypes;
            _x.applicability = applicability;
            _x.baseUri = baseUri;
            _x.categoryId = categoryId;
            _x.description = description;
            _x.displayName = displayName;
            _x.helpText = helpText;
            _x.infoUrls = infoUrls;
            _x.infoUrlsNextLink = infoUrlsNextLink;
            _x.keywords = keywords;
            _x.keywordsNextLink = keywordsNextLink;
            _x.name = name;
            _x.occurrence = occurrence;
            _x.offsetUri = offsetUri;
            _x.referredSettingInformationList = referredSettingInformationList;
            _x.referredSettingInformationListNextLink = referredSettingInformationListNextLink;
            _x.rootDefinitionId = rootDefinitionId;
            _x.settingUsage = settingUsage;
            _x.uxBehavior = uxBehavior;
            _x.version = version;
            _x.visibility = visibility;
            _x.defaultOptionId = defaultOptionId;
            _x.options = options;
            _x.optionsNextLink = optionsNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Default option for choice setting”</i>
     * 
     * @return property defaultOptionId
     */
    @Property(name="defaultOptionId")
    @JsonIgnore
    public Optional<String> getDefaultOptionId() {
        return Optional.ofNullable(defaultOptionId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code defaultOptionId}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Default option for choice setting”</i>
     * 
     * @param defaultOptionId
     *            new value of {@code defaultOptionId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defaultOptionId} field changed
     */
    public DeviceManagementConfigurationChoiceSettingDefinition withDefaultOptionId(String defaultOptionId) {
        DeviceManagementConfigurationChoiceSettingDefinition _x = _copy();
        _x.changedFields = changedFields.add("defaultOptionId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationChoiceSettingDefinition");
        _x.defaultOptionId = defaultOptionId;
        return _x;
    }

    /**
     * <i>“Options for the setting that can be selected”</i>
     * 
     * @return property options
     */
    @Property(name="options")
    @JsonIgnore
    public CollectionPage<DeviceManagementConfigurationOptionDefinition> getOptions() {
        return new CollectionPage<DeviceManagementConfigurationOptionDefinition>(contextPath, DeviceManagementConfigurationOptionDefinition.class, this.options, Optional.ofNullable(optionsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code options} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Options for the setting that can be selected”</i>
     * 
     * @param options
     *            new value of {@code options} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code options} field changed
     */
    public DeviceManagementConfigurationChoiceSettingDefinition withOptions(List<DeviceManagementConfigurationOptionDefinition> options) {
        DeviceManagementConfigurationChoiceSettingDefinition _x = _copy();
        _x.changedFields = changedFields.add("options");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationChoiceSettingDefinition");
        _x.options = options;
        return _x;
    }

    /**
     * <i>“Options for the setting that can be selected”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property options
     */
    @Property(name="options")
    @JsonIgnore
    public CollectionPage<DeviceManagementConfigurationOptionDefinition> getOptions(HttpRequestOptions options) {
        return new CollectionPage<DeviceManagementConfigurationOptionDefinition>(contextPath, DeviceManagementConfigurationOptionDefinition.class, this.options, Optional.ofNullable(optionsNextLink), Collections.emptyList(), options);
    }

    public DeviceManagementConfigurationChoiceSettingDefinition withUnmappedField(String name, Object value) {
        DeviceManagementConfigurationChoiceSettingDefinition _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementConfigurationChoiceSettingDefinition patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementConfigurationChoiceSettingDefinition _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementConfigurationChoiceSettingDefinition put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementConfigurationChoiceSettingDefinition _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceManagementConfigurationChoiceSettingDefinition _copy() {
        DeviceManagementConfigurationChoiceSettingDefinition _x = new DeviceManagementConfigurationChoiceSettingDefinition();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.accessTypes = accessTypes;
        _x.applicability = applicability;
        _x.baseUri = baseUri;
        _x.categoryId = categoryId;
        _x.description = description;
        _x.displayName = displayName;
        _x.helpText = helpText;
        _x.infoUrls = infoUrls;
        _x.keywords = keywords;
        _x.name = name;
        _x.occurrence = occurrence;
        _x.offsetUri = offsetUri;
        _x.referredSettingInformationList = referredSettingInformationList;
        _x.rootDefinitionId = rootDefinitionId;
        _x.settingUsage = settingUsage;
        _x.uxBehavior = uxBehavior;
        _x.version = version;
        _x.visibility = visibility;
        _x.defaultOptionId = defaultOptionId;
        _x.options = options;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementConfigurationChoiceSettingDefinition[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("accessTypes=");
        b.append(this.accessTypes);
        b.append(", ");
        b.append("applicability=");
        b.append(this.applicability);
        b.append(", ");
        b.append("baseUri=");
        b.append(this.baseUri);
        b.append(", ");
        b.append("categoryId=");
        b.append(this.categoryId);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("helpText=");
        b.append(this.helpText);
        b.append(", ");
        b.append("infoUrls=");
        b.append(this.infoUrls);
        b.append(", ");
        b.append("keywords=");
        b.append(this.keywords);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("occurrence=");
        b.append(this.occurrence);
        b.append(", ");
        b.append("offsetUri=");
        b.append(this.offsetUri);
        b.append(", ");
        b.append("referredSettingInformationList=");
        b.append(this.referredSettingInformationList);
        b.append(", ");
        b.append("rootDefinitionId=");
        b.append(this.rootDefinitionId);
        b.append(", ");
        b.append("settingUsage=");
        b.append(this.settingUsage);
        b.append(", ");
        b.append("uxBehavior=");
        b.append(this.uxBehavior);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("visibility=");
        b.append(this.visibility);
        b.append(", ");
        b.append("defaultOptionId=");
        b.append(this.defaultOptionId);
        b.append(", ");
        b.append("options=");
        b.append(this.options);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
