package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.DeviceManagementConfigurationPlatforms;
import odata.msgraph.client.beta.enums.DeviceManagementConfigurationSettingUsage;
import odata.msgraph.client.beta.enums.DeviceManagementConfigurationTechnologies;


/**
 * <i>“Device Management Configuration Policy”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "categoryDescription", 
    "childCategoryIds", 
    "description", 
    "displayName", 
    "helpText", 
    "name", 
    "parentCategoryId", 
    "platforms", 
    "rootCategoryId", 
    "settingUsage", 
    "technologies"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementConfigurationCategory extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementConfigurationCategory";
    }

    @JsonProperty("categoryDescription")
    protected String categoryDescription;

    @JsonProperty("childCategoryIds")
    protected List<String> childCategoryIds;

    @JsonProperty("childCategoryIds@nextLink")
    protected String childCategoryIdsNextLink;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("helpText")
    protected String helpText;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("parentCategoryId")
    protected String parentCategoryId;

    @JsonProperty("platforms")
    protected DeviceManagementConfigurationPlatforms platforms;

    @JsonProperty("rootCategoryId")
    protected String rootCategoryId;

    @JsonProperty("settingUsage")
    protected DeviceManagementConfigurationSettingUsage settingUsage;

    @JsonProperty("technologies")
    protected DeviceManagementConfigurationTechnologies technologies;

    protected DeviceManagementConfigurationCategory() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceManagementConfigurationCategory() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String categoryDescription;
        private List<String> childCategoryIds;
        private String childCategoryIdsNextLink;
        private String description;
        private String displayName;
        private String helpText;
        private String name;
        private String parentCategoryId;
        private DeviceManagementConfigurationPlatforms platforms;
        private String rootCategoryId;
        private DeviceManagementConfigurationSettingUsage settingUsage;
        private DeviceManagementConfigurationTechnologies technologies;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Description of the category header”</i>
         * 
         * @param categoryDescription
         *            value of {@code categoryDescription} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder categoryDescription(String categoryDescription) {
            this.categoryDescription = categoryDescription;
            this.changedFields = changedFields.add("categoryDescription");
            return this;
        }

        /**
         * <i>“List of child ids of the category.”</i>
         * 
         * @param childCategoryIds
         *            value of {@code childCategoryIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder childCategoryIds(List<String> childCategoryIds) {
            this.childCategoryIds = childCategoryIds;
            this.changedFields = changedFields.add("childCategoryIds");
            return this;
        }

        /**
         * <i>“List of child ids of the category.”</i>
         * 
         * @param childCategoryIds
         *            value of {@code childCategoryIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder childCategoryIds(String... childCategoryIds) {
            return childCategoryIds(Arrays.asList(childCategoryIds));
        }

        /**
         * <i>“List of child ids of the category.”</i>
         * 
         * @param childCategoryIdsNextLink
         *            value of {@code childCategoryIds@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder childCategoryIdsNextLink(String childCategoryIdsNextLink) {
            this.childCategoryIdsNextLink = childCategoryIdsNextLink;
            this.changedFields = changedFields.add("childCategoryIds");
            return this;
        }

        /**
         * <i>“Description of the item”</i>
         * 
         * @param description
         *            value of {@code description} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        /**
         * <i>“Display name of the item”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“Help text of the item”</i>
         * 
         * @param helpText
         *            value of {@code helpText} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder helpText(String helpText) {
            this.helpText = helpText;
            this.changedFields = changedFields.add("helpText");
            return this;
        }

        /**
         * <i>“Name of the item”</i>
         * 
         * @param name
         *            value of {@code name} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        /**
         * <i>“Parent id of the category.”</i>
         * 
         * @param parentCategoryId
         *            value of {@code parentCategoryId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder parentCategoryId(String parentCategoryId) {
            this.parentCategoryId = parentCategoryId;
            this.changedFields = changedFields.add("parentCategoryId");
            return this;
        }

        /**
         * <i>“Platforms types, which settings in the category have.”</i>
         * 
         * @param platforms
         *            value of {@code platforms} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder platforms(DeviceManagementConfigurationPlatforms platforms) {
            this.platforms = platforms;
            this.changedFields = changedFields.add("platforms");
            return this;
        }

        /**
         * <i>“Root id of the category.”</i>
         * 
         * @param rootCategoryId
         *            value of {@code rootCategoryId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder rootCategoryId(String rootCategoryId) {
            this.rootCategoryId = rootCategoryId;
            this.changedFields = changedFields.add("rootCategoryId");
            return this;
        }

        /**
         * <i>“Indicates that the category contains settings that are used for Compliance or
         * Configuration.”</i>
         * 
         * @param settingUsage
         *            value of {@code settingUsage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settingUsage(DeviceManagementConfigurationSettingUsage settingUsage) {
            this.settingUsage = settingUsage;
            this.changedFields = changedFields.add("settingUsage");
            return this;
        }

        /**
         * <i>“Technologies types, which settings in the category have.”</i>
         * 
         * @param technologies
         *            value of {@code technologies} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder technologies(DeviceManagementConfigurationTechnologies technologies) {
            this.technologies = technologies;
            this.changedFields = changedFields.add("technologies");
            return this;
        }

        public DeviceManagementConfigurationCategory build() {
            DeviceManagementConfigurationCategory _x = new DeviceManagementConfigurationCategory();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceManagementConfigurationCategory";
            _x.id = id;
            _x.categoryDescription = categoryDescription;
            _x.childCategoryIds = childCategoryIds;
            _x.childCategoryIdsNextLink = childCategoryIdsNextLink;
            _x.description = description;
            _x.displayName = displayName;
            _x.helpText = helpText;
            _x.name = name;
            _x.parentCategoryId = parentCategoryId;
            _x.platforms = platforms;
            _x.rootCategoryId = rootCategoryId;
            _x.settingUsage = settingUsage;
            _x.technologies = technologies;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Description of the category header”</i>
     * 
     * @return property categoryDescription
     */
    @Property(name="categoryDescription")
    @JsonIgnore
    public Optional<String> getCategoryDescription() {
        return Optional.ofNullable(categoryDescription);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * categoryDescription} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Description of the category header”</i>
     * 
     * @param categoryDescription
     *            new value of {@code categoryDescription} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code categoryDescription} field changed
     */
    public DeviceManagementConfigurationCategory withCategoryDescription(String categoryDescription) {
        DeviceManagementConfigurationCategory _x = _copy();
        _x.changedFields = changedFields.add("categoryDescription");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationCategory");
        _x.categoryDescription = categoryDescription;
        return _x;
    }

    /**
     * <i>“List of child ids of the category.”</i>
     * 
     * @return property childCategoryIds
     */
    @Property(name="childCategoryIds")
    @JsonIgnore
    public CollectionPage<String> getChildCategoryIds() {
        return new CollectionPage<String>(contextPath, String.class, this.childCategoryIds, Optional.ofNullable(childCategoryIdsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code childCategoryIds}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“List of child ids of the category.”</i>
     * 
     * @param childCategoryIds
     *            new value of {@code childCategoryIds} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code childCategoryIds} field changed
     */
    public DeviceManagementConfigurationCategory withChildCategoryIds(List<String> childCategoryIds) {
        DeviceManagementConfigurationCategory _x = _copy();
        _x.changedFields = changedFields.add("childCategoryIds");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationCategory");
        _x.childCategoryIds = childCategoryIds;
        return _x;
    }

    /**
     * <i>“List of child ids of the category.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property childCategoryIds
     */
    @Property(name="childCategoryIds")
    @JsonIgnore
    public CollectionPage<String> getChildCategoryIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.childCategoryIds, Optional.ofNullable(childCategoryIdsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Description of the item”</i>
     * 
     * @return property description
     */
    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code description}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Description of the item”</i>
     * 
     * @param description
     *            new value of {@code description} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code description} field changed
     */
    public DeviceManagementConfigurationCategory withDescription(String description) {
        DeviceManagementConfigurationCategory _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationCategory");
        _x.description = description;
        return _x;
    }

    /**
     * <i>“Display name of the item”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Display name of the item”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public DeviceManagementConfigurationCategory withDisplayName(String displayName) {
        DeviceManagementConfigurationCategory _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationCategory");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“Help text of the item”</i>
     * 
     * @return property helpText
     */
    @Property(name="helpText")
    @JsonIgnore
    public Optional<String> getHelpText() {
        return Optional.ofNullable(helpText);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code helpText} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Help text of the item”</i>
     * 
     * @param helpText
     *            new value of {@code helpText} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code helpText} field changed
     */
    public DeviceManagementConfigurationCategory withHelpText(String helpText) {
        DeviceManagementConfigurationCategory _x = _copy();
        _x.changedFields = changedFields.add("helpText");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationCategory");
        _x.helpText = helpText;
        return _x;
    }

    /**
     * <i>“Name of the item”</i>
     * 
     * @return property name
     */
    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code name} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Name of the item”</i>
     * 
     * @param name
     *            new value of {@code name} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code name} field changed
     */
    public DeviceManagementConfigurationCategory withName(String name) {
        DeviceManagementConfigurationCategory _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationCategory");
        _x.name = name;
        return _x;
    }

    /**
     * <i>“Parent id of the category.”</i>
     * 
     * @return property parentCategoryId
     */
    @Property(name="parentCategoryId")
    @JsonIgnore
    public Optional<String> getParentCategoryId() {
        return Optional.ofNullable(parentCategoryId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code parentCategoryId}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Parent id of the category.”</i>
     * 
     * @param parentCategoryId
     *            new value of {@code parentCategoryId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code parentCategoryId} field changed
     */
    public DeviceManagementConfigurationCategory withParentCategoryId(String parentCategoryId) {
        DeviceManagementConfigurationCategory _x = _copy();
        _x.changedFields = changedFields.add("parentCategoryId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationCategory");
        _x.parentCategoryId = parentCategoryId;
        return _x;
    }

    /**
     * <i>“Platforms types, which settings in the category have.”</i>
     * 
     * @return property platforms
     */
    @Property(name="platforms")
    @JsonIgnore
    public Optional<DeviceManagementConfigurationPlatforms> getPlatforms() {
        return Optional.ofNullable(platforms);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code platforms} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Platforms types, which settings in the category have.”</i>
     * 
     * @param platforms
     *            new value of {@code platforms} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code platforms} field changed
     */
    public DeviceManagementConfigurationCategory withPlatforms(DeviceManagementConfigurationPlatforms platforms) {
        DeviceManagementConfigurationCategory _x = _copy();
        _x.changedFields = changedFields.add("platforms");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationCategory");
        _x.platforms = platforms;
        return _x;
    }

    /**
     * <i>“Root id of the category.”</i>
     * 
     * @return property rootCategoryId
     */
    @Property(name="rootCategoryId")
    @JsonIgnore
    public Optional<String> getRootCategoryId() {
        return Optional.ofNullable(rootCategoryId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code rootCategoryId}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Root id of the category.”</i>
     * 
     * @param rootCategoryId
     *            new value of {@code rootCategoryId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code rootCategoryId} field changed
     */
    public DeviceManagementConfigurationCategory withRootCategoryId(String rootCategoryId) {
        DeviceManagementConfigurationCategory _x = _copy();
        _x.changedFields = changedFields.add("rootCategoryId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationCategory");
        _x.rootCategoryId = rootCategoryId;
        return _x;
    }

    /**
     * <i>“Indicates that the category contains settings that are used for Compliance or
     * Configuration.”</i>
     * 
     * @return property settingUsage
     */
    @Property(name="settingUsage")
    @JsonIgnore
    public Optional<DeviceManagementConfigurationSettingUsage> getSettingUsage() {
        return Optional.ofNullable(settingUsage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code settingUsage}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates that the category contains settings that are used for Compliance or
     * Configuration.”</i>
     * 
     * @param settingUsage
     *            new value of {@code settingUsage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code settingUsage} field changed
     */
    public DeviceManagementConfigurationCategory withSettingUsage(DeviceManagementConfigurationSettingUsage settingUsage) {
        DeviceManagementConfigurationCategory _x = _copy();
        _x.changedFields = changedFields.add("settingUsage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationCategory");
        _x.settingUsage = settingUsage;
        return _x;
    }

    /**
     * <i>“Technologies types, which settings in the category have.”</i>
     * 
     * @return property technologies
     */
    @Property(name="technologies")
    @JsonIgnore
    public Optional<DeviceManagementConfigurationTechnologies> getTechnologies() {
        return Optional.ofNullable(technologies);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code technologies}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Technologies types, which settings in the category have.”</i>
     * 
     * @param technologies
     *            new value of {@code technologies} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code technologies} field changed
     */
    public DeviceManagementConfigurationCategory withTechnologies(DeviceManagementConfigurationTechnologies technologies) {
        DeviceManagementConfigurationCategory _x = _copy();
        _x.changedFields = changedFields.add("technologies");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementConfigurationCategory");
        _x.technologies = technologies;
        return _x;
    }

    public DeviceManagementConfigurationCategory withUnmappedField(String name, Object value) {
        DeviceManagementConfigurationCategory _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementConfigurationCategory patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementConfigurationCategory _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementConfigurationCategory put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementConfigurationCategory _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceManagementConfigurationCategory _copy() {
        DeviceManagementConfigurationCategory _x = new DeviceManagementConfigurationCategory();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.categoryDescription = categoryDescription;
        _x.childCategoryIds = childCategoryIds;
        _x.description = description;
        _x.displayName = displayName;
        _x.helpText = helpText;
        _x.name = name;
        _x.parentCategoryId = parentCategoryId;
        _x.platforms = platforms;
        _x.rootCategoryId = rootCategoryId;
        _x.settingUsage = settingUsage;
        _x.technologies = technologies;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementConfigurationCategory[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("categoryDescription=");
        b.append(this.categoryDescription);
        b.append(", ");
        b.append("childCategoryIds=");
        b.append(this.childCategoryIds);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("helpText=");
        b.append(this.helpText);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("parentCategoryId=");
        b.append(this.parentCategoryId);
        b.append(", ");
        b.append("platforms=");
        b.append(this.platforms);
        b.append(", ");
        b.append("rootCategoryId=");
        b.append(this.rootCategoryId);
        b.append(", ");
        b.append("settingUsage=");
        b.append(this.settingUsage);
        b.append(", ");
        b.append("technologies=");
        b.append(this.technologies);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
