package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.DeviceManagementAutopilotPolicyComplianceStatus;
import odata.msgraph.client.beta.enums.DeviceManagementAutopilotPolicyType;


/**
 * <i>“Policy status detail item contained by an autopilot event.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "complianceStatus", 
    "displayName", 
    "errorCode", 
    "lastReportedDateTime", 
    "policyType", 
    "trackedOnEnrollmentStatus"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementAutopilotPolicyStatusDetail extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementAutopilotPolicyStatusDetail";
    }

    @JsonProperty("complianceStatus")
    protected DeviceManagementAutopilotPolicyComplianceStatus complianceStatus;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("errorCode")
    protected Integer errorCode;

    @JsonProperty("lastReportedDateTime")
    protected OffsetDateTime lastReportedDateTime;

    @JsonProperty("policyType")
    protected DeviceManagementAutopilotPolicyType policyType;

    @JsonProperty("trackedOnEnrollmentStatus")
    protected Boolean trackedOnEnrollmentStatus;

    protected DeviceManagementAutopilotPolicyStatusDetail() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceManagementAutopilotPolicyStatusDetail() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private DeviceManagementAutopilotPolicyComplianceStatus complianceStatus;
        private String displayName;
        private Integer errorCode;
        private OffsetDateTime lastReportedDateTime;
        private DeviceManagementAutopilotPolicyType policyType;
        private Boolean trackedOnEnrollmentStatus;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The policy compliance status.”</i>
         * 
         * @param complianceStatus
         *            value of {@code complianceStatus} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder complianceStatus(DeviceManagementAutopilotPolicyComplianceStatus complianceStatus) {
            this.complianceStatus = complianceStatus;
            this.changedFields = changedFields.add("complianceStatus");
            return this;
        }

        /**
         * <i>“The friendly name of the policy.”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“The errorode associated with the compliance or enforcement status of the policy.
         * Error code for enforcement status takes precedence if it exists.”</i>
         * 
         * @param errorCode
         *            value of {@code errorCode} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder errorCode(Integer errorCode) {
            this.errorCode = errorCode;
            this.changedFields = changedFields.add("errorCode");
            return this;
        }

        /**
         * <i>“Timestamp of the reported policy status”</i>
         * 
         * @param lastReportedDateTime
         *            value of {@code lastReportedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastReportedDateTime(OffsetDateTime lastReportedDateTime) {
            this.lastReportedDateTime = lastReportedDateTime;
            this.changedFields = changedFields.add("lastReportedDateTime");
            return this;
        }

        /**
         * <i>“The type of policy.”</i>
         * 
         * @param policyType
         *            value of {@code policyType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder policyType(DeviceManagementAutopilotPolicyType policyType) {
            this.policyType = policyType;
            this.changedFields = changedFields.add("policyType");
            return this;
        }

        /**
         * <i>“Indicates if this prolicy was tracked as part of the autopilot bootstrap
         * enrollment sync session”</i>
         * 
         * @param trackedOnEnrollmentStatus
         *            value of {@code trackedOnEnrollmentStatus} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder trackedOnEnrollmentStatus(Boolean trackedOnEnrollmentStatus) {
            this.trackedOnEnrollmentStatus = trackedOnEnrollmentStatus;
            this.changedFields = changedFields.add("trackedOnEnrollmentStatus");
            return this;
        }

        public DeviceManagementAutopilotPolicyStatusDetail build() {
            DeviceManagementAutopilotPolicyStatusDetail _x = new DeviceManagementAutopilotPolicyStatusDetail();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceManagementAutopilotPolicyStatusDetail";
            _x.id = id;
            _x.complianceStatus = complianceStatus;
            _x.displayName = displayName;
            _x.errorCode = errorCode;
            _x.lastReportedDateTime = lastReportedDateTime;
            _x.policyType = policyType;
            _x.trackedOnEnrollmentStatus = trackedOnEnrollmentStatus;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The policy compliance status.”</i>
     * 
     * @return property complianceStatus
     */
    @Property(name="complianceStatus")
    @JsonIgnore
    public Optional<DeviceManagementAutopilotPolicyComplianceStatus> getComplianceStatus() {
        return Optional.ofNullable(complianceStatus);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code complianceStatus}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The policy compliance status.”</i>
     * 
     * @param complianceStatus
     *            new value of {@code complianceStatus} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code complianceStatus} field changed
     */
    public DeviceManagementAutopilotPolicyStatusDetail withComplianceStatus(DeviceManagementAutopilotPolicyComplianceStatus complianceStatus) {
        DeviceManagementAutopilotPolicyStatusDetail _x = _copy();
        _x.changedFields = changedFields.add("complianceStatus");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementAutopilotPolicyStatusDetail");
        _x.complianceStatus = complianceStatus;
        return _x;
    }

    /**
     * <i>“The friendly name of the policy.”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The friendly name of the policy.”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public DeviceManagementAutopilotPolicyStatusDetail withDisplayName(String displayName) {
        DeviceManagementAutopilotPolicyStatusDetail _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementAutopilotPolicyStatusDetail");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“The errorode associated with the compliance or enforcement status of the policy.
     * Error code for enforcement status takes precedence if it exists.”</i>
     * 
     * @return property errorCode
     */
    @Property(name="errorCode")
    @JsonIgnore
    public Optional<Integer> getErrorCode() {
        return Optional.ofNullable(errorCode);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code errorCode} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The errorode associated with the compliance or enforcement status of the policy.
     * Error code for enforcement status takes precedence if it exists.”</i>
     * 
     * @param errorCode
     *            new value of {@code errorCode} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code errorCode} field changed
     */
    public DeviceManagementAutopilotPolicyStatusDetail withErrorCode(Integer errorCode) {
        DeviceManagementAutopilotPolicyStatusDetail _x = _copy();
        _x.changedFields = changedFields.add("errorCode");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementAutopilotPolicyStatusDetail");
        _x.errorCode = errorCode;
        return _x;
    }

    /**
     * <i>“Timestamp of the reported policy status”</i>
     * 
     * @return property lastReportedDateTime
     */
    @Property(name="lastReportedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastReportedDateTime() {
        return Optional.ofNullable(lastReportedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastReportedDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Timestamp of the reported policy status”</i>
     * 
     * @param lastReportedDateTime
     *            new value of {@code lastReportedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastReportedDateTime} field changed
     */
    public DeviceManagementAutopilotPolicyStatusDetail withLastReportedDateTime(OffsetDateTime lastReportedDateTime) {
        DeviceManagementAutopilotPolicyStatusDetail _x = _copy();
        _x.changedFields = changedFields.add("lastReportedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementAutopilotPolicyStatusDetail");
        _x.lastReportedDateTime = lastReportedDateTime;
        return _x;
    }

    /**
     * <i>“The type of policy.”</i>
     * 
     * @return property policyType
     */
    @Property(name="policyType")
    @JsonIgnore
    public Optional<DeviceManagementAutopilotPolicyType> getPolicyType() {
        return Optional.ofNullable(policyType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code policyType} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The type of policy.”</i>
     * 
     * @param policyType
     *            new value of {@code policyType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code policyType} field changed
     */
    public DeviceManagementAutopilotPolicyStatusDetail withPolicyType(DeviceManagementAutopilotPolicyType policyType) {
        DeviceManagementAutopilotPolicyStatusDetail _x = _copy();
        _x.changedFields = changedFields.add("policyType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementAutopilotPolicyStatusDetail");
        _x.policyType = policyType;
        return _x;
    }

    /**
     * <i>“Indicates if this prolicy was tracked as part of the autopilot bootstrap
     * enrollment sync session”</i>
     * 
     * @return property trackedOnEnrollmentStatus
     */
    @Property(name="trackedOnEnrollmentStatus")
    @JsonIgnore
    public Optional<Boolean> getTrackedOnEnrollmentStatus() {
        return Optional.ofNullable(trackedOnEnrollmentStatus);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * trackedOnEnrollmentStatus} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates if this prolicy was tracked as part of the autopilot bootstrap
     * enrollment sync session”</i>
     * 
     * @param trackedOnEnrollmentStatus
     *            new value of {@code trackedOnEnrollmentStatus} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code trackedOnEnrollmentStatus} field changed
     */
    public DeviceManagementAutopilotPolicyStatusDetail withTrackedOnEnrollmentStatus(Boolean trackedOnEnrollmentStatus) {
        DeviceManagementAutopilotPolicyStatusDetail _x = _copy();
        _x.changedFields = changedFields.add("trackedOnEnrollmentStatus");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementAutopilotPolicyStatusDetail");
        _x.trackedOnEnrollmentStatus = trackedOnEnrollmentStatus;
        return _x;
    }

    public DeviceManagementAutopilotPolicyStatusDetail withUnmappedField(String name, Object value) {
        DeviceManagementAutopilotPolicyStatusDetail _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementAutopilotPolicyStatusDetail patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementAutopilotPolicyStatusDetail _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementAutopilotPolicyStatusDetail put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementAutopilotPolicyStatusDetail _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceManagementAutopilotPolicyStatusDetail _copy() {
        DeviceManagementAutopilotPolicyStatusDetail _x = new DeviceManagementAutopilotPolicyStatusDetail();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.complianceStatus = complianceStatus;
        _x.displayName = displayName;
        _x.errorCode = errorCode;
        _x.lastReportedDateTime = lastReportedDateTime;
        _x.policyType = policyType;
        _x.trackedOnEnrollmentStatus = trackedOnEnrollmentStatus;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementAutopilotPolicyStatusDetail[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("complianceStatus=");
        b.append(this.complianceStatus);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("errorCode=");
        b.append(this.errorCode);
        b.append(", ");
        b.append("lastReportedDateTime=");
        b.append(this.lastReportedDateTime);
        b.append(", ");
        b.append("policyType=");
        b.append(this.policyType);
        b.append(", ");
        b.append("trackedOnEnrollmentStatus=");
        b.append(this.trackedOnEnrollmentStatus);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
