package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.DeviceManagementSettingInstanceCollectionRequest;


/**
 * <i>“A setting instance representing a complex value for an abstract setting”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "implementationId"})
@JsonInclude(Include.NON_NULL)
public class DeviceManagementAbstractComplexSettingInstance extends DeviceManagementSettingInstance implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceManagementAbstractComplexSettingInstance";
    }

    @JsonProperty("implementationId")
    protected String implementationId;

    protected DeviceManagementAbstractComplexSettingInstance() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceManagementAbstractComplexSettingInstance() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String definitionId;
        private String valueJson;
        private String implementationId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder definitionId(String definitionId) {
            this.definitionId = definitionId;
            this.changedFields = changedFields.add("definitionId");
            return this;
        }

        public Builder valueJson(String valueJson) {
            this.valueJson = valueJson;
            this.changedFields = changedFields.add("valueJson");
            return this;
        }

        /**
         * <i>“The definition ID for the chosen implementation of this complex setting”</i>
         * 
         * @param implementationId
         *            value of {@code implementationId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder implementationId(String implementationId) {
            this.implementationId = implementationId;
            this.changedFields = changedFields.add("implementationId");
            return this;
        }

        public DeviceManagementAbstractComplexSettingInstance build() {
            DeviceManagementAbstractComplexSettingInstance _x = new DeviceManagementAbstractComplexSettingInstance();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceManagementAbstractComplexSettingInstance";
            _x.id = id;
            _x.definitionId = definitionId;
            _x.valueJson = valueJson;
            _x.implementationId = implementationId;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The definition ID for the chosen implementation of this complex setting”</i>
     * 
     * @return property implementationId
     */
    @Property(name="implementationId")
    @JsonIgnore
    public Optional<String> getImplementationId() {
        return Optional.ofNullable(implementationId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code implementationId}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The definition ID for the chosen implementation of this complex setting”</i>
     * 
     * @param implementationId
     *            new value of {@code implementationId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code implementationId} field changed
     */
    public DeviceManagementAbstractComplexSettingInstance withImplementationId(String implementationId) {
        DeviceManagementAbstractComplexSettingInstance _x = _copy();
        _x.changedFields = changedFields.add("implementationId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceManagementAbstractComplexSettingInstance");
        _x.implementationId = implementationId;
        return _x;
    }

    public DeviceManagementAbstractComplexSettingInstance withUnmappedField(String name, Object value) {
        DeviceManagementAbstractComplexSettingInstance _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“The values that make up the complex setting”</i>
     * 
     * @return navigational property value
     */
    @NavigationProperty(name="value")
    @JsonIgnore
    public DeviceManagementSettingInstanceCollectionRequest getValue() {
        return new DeviceManagementSettingInstanceCollectionRequest(
                        contextPath.addSegment("value"), RequestHelper.getValue(unmappedFields, "value"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementAbstractComplexSettingInstance patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementAbstractComplexSettingInstance _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceManagementAbstractComplexSettingInstance put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceManagementAbstractComplexSettingInstance _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceManagementAbstractComplexSettingInstance _copy() {
        DeviceManagementAbstractComplexSettingInstance _x = new DeviceManagementAbstractComplexSettingInstance();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.definitionId = definitionId;
        _x.valueJson = valueJson;
        _x.implementationId = implementationId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceManagementAbstractComplexSettingInstance[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("definitionId=");
        b.append(this.definitionId);
        b.append(", ");
        b.append("valueJson=");
        b.append(this.valueJson);
        b.append(", ");
        b.append("implementationId=");
        b.append(this.implementationId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
