package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;


/**
 * <i>“Contains properties for the run summary of a device management script.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "detectionScriptErrorDeviceCount", 
    "detectionScriptNotApplicableDeviceCount", 
    "detectionScriptPendingDeviceCount", 
    "issueDetectedDeviceCount", 
    "issueRemediatedCumulativeDeviceCount", 
    "issueRemediatedDeviceCount", 
    "issueReoccurredDeviceCount", 
    "lastScriptRunDateTime", 
    "noIssueDetectedDeviceCount", 
    "remediationScriptErrorDeviceCount", 
    "remediationSkippedDeviceCount"})
@JsonInclude(Include.NON_NULL)
public class DeviceHealthScriptRunSummary extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceHealthScriptRunSummary";
    }

    @JsonProperty("detectionScriptErrorDeviceCount")
    protected Integer detectionScriptErrorDeviceCount;

    @JsonProperty("detectionScriptNotApplicableDeviceCount")
    protected Integer detectionScriptNotApplicableDeviceCount;

    @JsonProperty("detectionScriptPendingDeviceCount")
    protected Integer detectionScriptPendingDeviceCount;

    @JsonProperty("issueDetectedDeviceCount")
    protected Integer issueDetectedDeviceCount;

    @JsonProperty("issueRemediatedCumulativeDeviceCount")
    protected Integer issueRemediatedCumulativeDeviceCount;

    @JsonProperty("issueRemediatedDeviceCount")
    protected Integer issueRemediatedDeviceCount;

    @JsonProperty("issueReoccurredDeviceCount")
    protected Integer issueReoccurredDeviceCount;

    @JsonProperty("lastScriptRunDateTime")
    protected OffsetDateTime lastScriptRunDateTime;

    @JsonProperty("noIssueDetectedDeviceCount")
    protected Integer noIssueDetectedDeviceCount;

    @JsonProperty("remediationScriptErrorDeviceCount")
    protected Integer remediationScriptErrorDeviceCount;

    @JsonProperty("remediationSkippedDeviceCount")
    protected Integer remediationSkippedDeviceCount;

    protected DeviceHealthScriptRunSummary() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceHealthScriptRunSummary() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Integer detectionScriptErrorDeviceCount;
        private Integer detectionScriptNotApplicableDeviceCount;
        private Integer detectionScriptPendingDeviceCount;
        private Integer issueDetectedDeviceCount;
        private Integer issueRemediatedCumulativeDeviceCount;
        private Integer issueRemediatedDeviceCount;
        private Integer issueReoccurredDeviceCount;
        private OffsetDateTime lastScriptRunDateTime;
        private Integer noIssueDetectedDeviceCount;
        private Integer remediationScriptErrorDeviceCount;
        private Integer remediationSkippedDeviceCount;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Number of devices on which the detection script execution encountered an error
         * and did not complete”</i>
         * 
         * @param detectionScriptErrorDeviceCount
         *            value of {@code detectionScriptErrorDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder detectionScriptErrorDeviceCount(Integer detectionScriptErrorDeviceCount) {
            this.detectionScriptErrorDeviceCount = detectionScriptErrorDeviceCount;
            this.changedFields = changedFields.add("detectionScriptErrorDeviceCount");
            return this;
        }

        /**
         * <i>“Number of devices for which the detection script was not applicable”</i>
         * 
         * @param detectionScriptNotApplicableDeviceCount
         *            value of {@code detectionScriptNotApplicableDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder detectionScriptNotApplicableDeviceCount(Integer detectionScriptNotApplicableDeviceCount) {
            this.detectionScriptNotApplicableDeviceCount = detectionScriptNotApplicableDeviceCount;
            this.changedFields = changedFields.add("detectionScriptNotApplicableDeviceCount");
            return this;
        }

        /**
         * <i>“Number of devices which have not yet run the latest version of the device health
         * script”</i>
         * 
         * @param detectionScriptPendingDeviceCount
         *            value of {@code detectionScriptPendingDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder detectionScriptPendingDeviceCount(Integer detectionScriptPendingDeviceCount) {
            this.detectionScriptPendingDeviceCount = detectionScriptPendingDeviceCount;
            this.changedFields = changedFields.add("detectionScriptPendingDeviceCount");
            return this;
        }

        /**
         * <i>“Number of devices for which the detection script found an issue”</i>
         * 
         * @param issueDetectedDeviceCount
         *            value of {@code issueDetectedDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder issueDetectedDeviceCount(Integer issueDetectedDeviceCount) {
            this.issueDetectedDeviceCount = issueDetectedDeviceCount;
            this.changedFields = changedFields.add("issueDetectedDeviceCount");
            return this;
        }

        /**
         * <i>“Number of devices that were remediated over the last 30 days”</i>
         * 
         * @param issueRemediatedCumulativeDeviceCount
         *            value of {@code issueRemediatedCumulativeDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder issueRemediatedCumulativeDeviceCount(Integer issueRemediatedCumulativeDeviceCount) {
            this.issueRemediatedCumulativeDeviceCount = issueRemediatedCumulativeDeviceCount;
            this.changedFields = changedFields.add("issueRemediatedCumulativeDeviceCount");
            return this;
        }

        /**
         * <i>“Number of devices for which the remediation script was able to resolve the
         * detected issue”</i>
         * 
         * @param issueRemediatedDeviceCount
         *            value of {@code issueRemediatedDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder issueRemediatedDeviceCount(Integer issueRemediatedDeviceCount) {
            this.issueRemediatedDeviceCount = issueRemediatedDeviceCount;
            this.changedFields = changedFields.add("issueRemediatedDeviceCount");
            return this;
        }

        /**
         * <i>“Number of devices for which the remediation script executed successfully but
         * failed to resolve the detected issue”</i>
         * 
         * @param issueReoccurredDeviceCount
         *            value of {@code issueReoccurredDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder issueReoccurredDeviceCount(Integer issueReoccurredDeviceCount) {
            this.issueReoccurredDeviceCount = issueReoccurredDeviceCount;
            this.changedFields = changedFields.add("issueReoccurredDeviceCount");
            return this;
        }

        /**
         * <i>“Last run time for the script across all devices”</i>
         * 
         * @param lastScriptRunDateTime
         *            value of {@code lastScriptRunDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastScriptRunDateTime(OffsetDateTime lastScriptRunDateTime) {
            this.lastScriptRunDateTime = lastScriptRunDateTime;
            this.changedFields = changedFields.add("lastScriptRunDateTime");
            return this;
        }

        /**
         * <i>“Number of devices for which the detection script did not find an issue and the
         * device is healthy”</i>
         * 
         * @param noIssueDetectedDeviceCount
         *            value of {@code noIssueDetectedDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder noIssueDetectedDeviceCount(Integer noIssueDetectedDeviceCount) {
            this.noIssueDetectedDeviceCount = noIssueDetectedDeviceCount;
            this.changedFields = changedFields.add("noIssueDetectedDeviceCount");
            return this;
        }

        /**
         * <i>“Number of devices for which the remediation script execution encountered an
         * error and did not complete”</i>
         * 
         * @param remediationScriptErrorDeviceCount
         *            value of {@code remediationScriptErrorDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder remediationScriptErrorDeviceCount(Integer remediationScriptErrorDeviceCount) {
            this.remediationScriptErrorDeviceCount = remediationScriptErrorDeviceCount;
            this.changedFields = changedFields.add("remediationScriptErrorDeviceCount");
            return this;
        }

        /**
         * <i>“Number of devices for which remediation was skipped”</i>
         * 
         * @param remediationSkippedDeviceCount
         *            value of {@code remediationSkippedDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder remediationSkippedDeviceCount(Integer remediationSkippedDeviceCount) {
            this.remediationSkippedDeviceCount = remediationSkippedDeviceCount;
            this.changedFields = changedFields.add("remediationSkippedDeviceCount");
            return this;
        }

        public DeviceHealthScriptRunSummary build() {
            DeviceHealthScriptRunSummary _x = new DeviceHealthScriptRunSummary();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceHealthScriptRunSummary";
            _x.id = id;
            _x.detectionScriptErrorDeviceCount = detectionScriptErrorDeviceCount;
            _x.detectionScriptNotApplicableDeviceCount = detectionScriptNotApplicableDeviceCount;
            _x.detectionScriptPendingDeviceCount = detectionScriptPendingDeviceCount;
            _x.issueDetectedDeviceCount = issueDetectedDeviceCount;
            _x.issueRemediatedCumulativeDeviceCount = issueRemediatedCumulativeDeviceCount;
            _x.issueRemediatedDeviceCount = issueRemediatedDeviceCount;
            _x.issueReoccurredDeviceCount = issueReoccurredDeviceCount;
            _x.lastScriptRunDateTime = lastScriptRunDateTime;
            _x.noIssueDetectedDeviceCount = noIssueDetectedDeviceCount;
            _x.remediationScriptErrorDeviceCount = remediationScriptErrorDeviceCount;
            _x.remediationSkippedDeviceCount = remediationSkippedDeviceCount;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Number of devices on which the detection script execution encountered an error
     * and did not complete”</i>
     * 
     * @return property detectionScriptErrorDeviceCount
     */
    @Property(name="detectionScriptErrorDeviceCount")
    @JsonIgnore
    public Optional<Integer> getDetectionScriptErrorDeviceCount() {
        return Optional.ofNullable(detectionScriptErrorDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * detectionScriptErrorDeviceCount} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Number of devices on which the detection script execution encountered an error
     * and did not complete”</i>
     * 
     * @param detectionScriptErrorDeviceCount
     *            new value of {@code detectionScriptErrorDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code detectionScriptErrorDeviceCount} field changed
     */
    public DeviceHealthScriptRunSummary withDetectionScriptErrorDeviceCount(Integer detectionScriptErrorDeviceCount) {
        DeviceHealthScriptRunSummary _x = _copy();
        _x.changedFields = changedFields.add("detectionScriptErrorDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthScriptRunSummary");
        _x.detectionScriptErrorDeviceCount = detectionScriptErrorDeviceCount;
        return _x;
    }

    /**
     * <i>“Number of devices for which the detection script was not applicable”</i>
     * 
     * @return property detectionScriptNotApplicableDeviceCount
     */
    @Property(name="detectionScriptNotApplicableDeviceCount")
    @JsonIgnore
    public Optional<Integer> getDetectionScriptNotApplicableDeviceCount() {
        return Optional.ofNullable(detectionScriptNotApplicableDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * detectionScriptNotApplicableDeviceCount} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Number of devices for which the detection script was not applicable”</i>
     * 
     * @param detectionScriptNotApplicableDeviceCount
     *            new value of {@code detectionScriptNotApplicableDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code detectionScriptNotApplicableDeviceCount} field changed
     */
    public DeviceHealthScriptRunSummary withDetectionScriptNotApplicableDeviceCount(Integer detectionScriptNotApplicableDeviceCount) {
        DeviceHealthScriptRunSummary _x = _copy();
        _x.changedFields = changedFields.add("detectionScriptNotApplicableDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthScriptRunSummary");
        _x.detectionScriptNotApplicableDeviceCount = detectionScriptNotApplicableDeviceCount;
        return _x;
    }

    /**
     * <i>“Number of devices which have not yet run the latest version of the device health
     * script”</i>
     * 
     * @return property detectionScriptPendingDeviceCount
     */
    @Property(name="detectionScriptPendingDeviceCount")
    @JsonIgnore
    public Optional<Integer> getDetectionScriptPendingDeviceCount() {
        return Optional.ofNullable(detectionScriptPendingDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * detectionScriptPendingDeviceCount} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Number of devices which have not yet run the latest version of the device health
     * script”</i>
     * 
     * @param detectionScriptPendingDeviceCount
     *            new value of {@code detectionScriptPendingDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code detectionScriptPendingDeviceCount} field changed
     */
    public DeviceHealthScriptRunSummary withDetectionScriptPendingDeviceCount(Integer detectionScriptPendingDeviceCount) {
        DeviceHealthScriptRunSummary _x = _copy();
        _x.changedFields = changedFields.add("detectionScriptPendingDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthScriptRunSummary");
        _x.detectionScriptPendingDeviceCount = detectionScriptPendingDeviceCount;
        return _x;
    }

    /**
     * <i>“Number of devices for which the detection script found an issue”</i>
     * 
     * @return property issueDetectedDeviceCount
     */
    @Property(name="issueDetectedDeviceCount")
    @JsonIgnore
    public Optional<Integer> getIssueDetectedDeviceCount() {
        return Optional.ofNullable(issueDetectedDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * issueDetectedDeviceCount} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Number of devices for which the detection script found an issue”</i>
     * 
     * @param issueDetectedDeviceCount
     *            new value of {@code issueDetectedDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code issueDetectedDeviceCount} field changed
     */
    public DeviceHealthScriptRunSummary withIssueDetectedDeviceCount(Integer issueDetectedDeviceCount) {
        DeviceHealthScriptRunSummary _x = _copy();
        _x.changedFields = changedFields.add("issueDetectedDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthScriptRunSummary");
        _x.issueDetectedDeviceCount = issueDetectedDeviceCount;
        return _x;
    }

    /**
     * <i>“Number of devices that were remediated over the last 30 days”</i>
     * 
     * @return property issueRemediatedCumulativeDeviceCount
     */
    @Property(name="issueRemediatedCumulativeDeviceCount")
    @JsonIgnore
    public Optional<Integer> getIssueRemediatedCumulativeDeviceCount() {
        return Optional.ofNullable(issueRemediatedCumulativeDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * issueRemediatedCumulativeDeviceCount} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Number of devices that were remediated over the last 30 days”</i>
     * 
     * @param issueRemediatedCumulativeDeviceCount
     *            new value of {@code issueRemediatedCumulativeDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code issueRemediatedCumulativeDeviceCount} field changed
     */
    public DeviceHealthScriptRunSummary withIssueRemediatedCumulativeDeviceCount(Integer issueRemediatedCumulativeDeviceCount) {
        DeviceHealthScriptRunSummary _x = _copy();
        _x.changedFields = changedFields.add("issueRemediatedCumulativeDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthScriptRunSummary");
        _x.issueRemediatedCumulativeDeviceCount = issueRemediatedCumulativeDeviceCount;
        return _x;
    }

    /**
     * <i>“Number of devices for which the remediation script was able to resolve the
     * detected issue”</i>
     * 
     * @return property issueRemediatedDeviceCount
     */
    @Property(name="issueRemediatedDeviceCount")
    @JsonIgnore
    public Optional<Integer> getIssueRemediatedDeviceCount() {
        return Optional.ofNullable(issueRemediatedDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * issueRemediatedDeviceCount} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Number of devices for which the remediation script was able to resolve the
     * detected issue”</i>
     * 
     * @param issueRemediatedDeviceCount
     *            new value of {@code issueRemediatedDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code issueRemediatedDeviceCount} field changed
     */
    public DeviceHealthScriptRunSummary withIssueRemediatedDeviceCount(Integer issueRemediatedDeviceCount) {
        DeviceHealthScriptRunSummary _x = _copy();
        _x.changedFields = changedFields.add("issueRemediatedDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthScriptRunSummary");
        _x.issueRemediatedDeviceCount = issueRemediatedDeviceCount;
        return _x;
    }

    /**
     * <i>“Number of devices for which the remediation script executed successfully but
     * failed to resolve the detected issue”</i>
     * 
     * @return property issueReoccurredDeviceCount
     */
    @Property(name="issueReoccurredDeviceCount")
    @JsonIgnore
    public Optional<Integer> getIssueReoccurredDeviceCount() {
        return Optional.ofNullable(issueReoccurredDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * issueReoccurredDeviceCount} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Number of devices for which the remediation script executed successfully but
     * failed to resolve the detected issue”</i>
     * 
     * @param issueReoccurredDeviceCount
     *            new value of {@code issueReoccurredDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code issueReoccurredDeviceCount} field changed
     */
    public DeviceHealthScriptRunSummary withIssueReoccurredDeviceCount(Integer issueReoccurredDeviceCount) {
        DeviceHealthScriptRunSummary _x = _copy();
        _x.changedFields = changedFields.add("issueReoccurredDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthScriptRunSummary");
        _x.issueReoccurredDeviceCount = issueReoccurredDeviceCount;
        return _x;
    }

    /**
     * <i>“Last run time for the script across all devices”</i>
     * 
     * @return property lastScriptRunDateTime
     */
    @Property(name="lastScriptRunDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastScriptRunDateTime() {
        return Optional.ofNullable(lastScriptRunDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastScriptRunDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Last run time for the script across all devices”</i>
     * 
     * @param lastScriptRunDateTime
     *            new value of {@code lastScriptRunDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastScriptRunDateTime} field changed
     */
    public DeviceHealthScriptRunSummary withLastScriptRunDateTime(OffsetDateTime lastScriptRunDateTime) {
        DeviceHealthScriptRunSummary _x = _copy();
        _x.changedFields = changedFields.add("lastScriptRunDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthScriptRunSummary");
        _x.lastScriptRunDateTime = lastScriptRunDateTime;
        return _x;
    }

    /**
     * <i>“Number of devices for which the detection script did not find an issue and the
     * device is healthy”</i>
     * 
     * @return property noIssueDetectedDeviceCount
     */
    @Property(name="noIssueDetectedDeviceCount")
    @JsonIgnore
    public Optional<Integer> getNoIssueDetectedDeviceCount() {
        return Optional.ofNullable(noIssueDetectedDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * noIssueDetectedDeviceCount} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Number of devices for which the detection script did not find an issue and the
     * device is healthy”</i>
     * 
     * @param noIssueDetectedDeviceCount
     *            new value of {@code noIssueDetectedDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code noIssueDetectedDeviceCount} field changed
     */
    public DeviceHealthScriptRunSummary withNoIssueDetectedDeviceCount(Integer noIssueDetectedDeviceCount) {
        DeviceHealthScriptRunSummary _x = _copy();
        _x.changedFields = changedFields.add("noIssueDetectedDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthScriptRunSummary");
        _x.noIssueDetectedDeviceCount = noIssueDetectedDeviceCount;
        return _x;
    }

    /**
     * <i>“Number of devices for which the remediation script execution encountered an
     * error and did not complete”</i>
     * 
     * @return property remediationScriptErrorDeviceCount
     */
    @Property(name="remediationScriptErrorDeviceCount")
    @JsonIgnore
    public Optional<Integer> getRemediationScriptErrorDeviceCount() {
        return Optional.ofNullable(remediationScriptErrorDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * remediationScriptErrorDeviceCount} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Number of devices for which the remediation script execution encountered an
     * error and did not complete”</i>
     * 
     * @param remediationScriptErrorDeviceCount
     *            new value of {@code remediationScriptErrorDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code remediationScriptErrorDeviceCount} field changed
     */
    public DeviceHealthScriptRunSummary withRemediationScriptErrorDeviceCount(Integer remediationScriptErrorDeviceCount) {
        DeviceHealthScriptRunSummary _x = _copy();
        _x.changedFields = changedFields.add("remediationScriptErrorDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthScriptRunSummary");
        _x.remediationScriptErrorDeviceCount = remediationScriptErrorDeviceCount;
        return _x;
    }

    /**
     * <i>“Number of devices for which remediation was skipped”</i>
     * 
     * @return property remediationSkippedDeviceCount
     */
    @Property(name="remediationSkippedDeviceCount")
    @JsonIgnore
    public Optional<Integer> getRemediationSkippedDeviceCount() {
        return Optional.ofNullable(remediationSkippedDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * remediationSkippedDeviceCount} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Number of devices for which remediation was skipped”</i>
     * 
     * @param remediationSkippedDeviceCount
     *            new value of {@code remediationSkippedDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code remediationSkippedDeviceCount} field changed
     */
    public DeviceHealthScriptRunSummary withRemediationSkippedDeviceCount(Integer remediationSkippedDeviceCount) {
        DeviceHealthScriptRunSummary _x = _copy();
        _x.changedFields = changedFields.add("remediationSkippedDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthScriptRunSummary");
        _x.remediationSkippedDeviceCount = remediationSkippedDeviceCount;
        return _x;
    }

    public DeviceHealthScriptRunSummary withUnmappedField(String name, Object value) {
        DeviceHealthScriptRunSummary _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceHealthScriptRunSummary patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceHealthScriptRunSummary _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceHealthScriptRunSummary put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceHealthScriptRunSummary _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceHealthScriptRunSummary _copy() {
        DeviceHealthScriptRunSummary _x = new DeviceHealthScriptRunSummary();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.detectionScriptErrorDeviceCount = detectionScriptErrorDeviceCount;
        _x.detectionScriptNotApplicableDeviceCount = detectionScriptNotApplicableDeviceCount;
        _x.detectionScriptPendingDeviceCount = detectionScriptPendingDeviceCount;
        _x.issueDetectedDeviceCount = issueDetectedDeviceCount;
        _x.issueRemediatedCumulativeDeviceCount = issueRemediatedCumulativeDeviceCount;
        _x.issueRemediatedDeviceCount = issueRemediatedDeviceCount;
        _x.issueReoccurredDeviceCount = issueReoccurredDeviceCount;
        _x.lastScriptRunDateTime = lastScriptRunDateTime;
        _x.noIssueDetectedDeviceCount = noIssueDetectedDeviceCount;
        _x.remediationScriptErrorDeviceCount = remediationScriptErrorDeviceCount;
        _x.remediationSkippedDeviceCount = remediationSkippedDeviceCount;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceHealthScriptRunSummary[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("detectionScriptErrorDeviceCount=");
        b.append(this.detectionScriptErrorDeviceCount);
        b.append(", ");
        b.append("detectionScriptNotApplicableDeviceCount=");
        b.append(this.detectionScriptNotApplicableDeviceCount);
        b.append(", ");
        b.append("detectionScriptPendingDeviceCount=");
        b.append(this.detectionScriptPendingDeviceCount);
        b.append(", ");
        b.append("issueDetectedDeviceCount=");
        b.append(this.issueDetectedDeviceCount);
        b.append(", ");
        b.append("issueRemediatedCumulativeDeviceCount=");
        b.append(this.issueRemediatedCumulativeDeviceCount);
        b.append(", ");
        b.append("issueRemediatedDeviceCount=");
        b.append(this.issueRemediatedDeviceCount);
        b.append(", ");
        b.append("issueReoccurredDeviceCount=");
        b.append(this.issueReoccurredDeviceCount);
        b.append(", ");
        b.append("lastScriptRunDateTime=");
        b.append(this.lastScriptRunDateTime);
        b.append(", ");
        b.append("noIssueDetectedDeviceCount=");
        b.append(this.noIssueDetectedDeviceCount);
        b.append(", ");
        b.append("remediationScriptErrorDeviceCount=");
        b.append(this.remediationScriptErrorDeviceCount);
        b.append(", ");
        b.append("remediationSkippedDeviceCount=");
        b.append(this.remediationSkippedDeviceCount);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
