package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DeviceHealthScriptParameter;
import odata.msgraph.client.beta.complex.DeviceHealthScriptRemediationHistory;
import odata.msgraph.client.beta.entity.collection.request.DeviceHealthScriptAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceHealthScriptDeviceStateCollectionRequest;
import odata.msgraph.client.beta.entity.request.DeviceHealthScriptRunSummaryRequest;
import odata.msgraph.client.beta.enums.RunAsAccountType;


/**
 * <i>“Intune will provide customer the ability to run their Powershell Health scripts
 * (remediation + detection) on the enrolled windows 10 Azure Active Directory
 * joined devices.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "createdDateTime", 
    "description", 
    "detectionScriptContent", 
    "detectionScriptParameters", 
    "displayName", 
    "enforceSignatureCheck", 
    "highestAvailableVersion", 
    "isGlobalScript", 
    "lastModifiedDateTime", 
    "publisher", 
    "remediationScriptContent", 
    "remediationScriptParameters", 
    "roleScopeTagIds", 
    "runAs32Bit", 
    "runAsAccount", 
    "version", 
    "assignments", 
    "deviceRunStates", 
    "runSummary"})
@JsonInclude(Include.NON_NULL)
public class DeviceHealthScript extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceHealthScript";
    }

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("detectionScriptContent")
    protected byte[] detectionScriptContent;

    @JsonProperty("detectionScriptParameters")
    protected List<DeviceHealthScriptParameter> detectionScriptParameters;

    @JsonProperty("detectionScriptParameters@nextLink")
    protected String detectionScriptParametersNextLink;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("enforceSignatureCheck")
    protected Boolean enforceSignatureCheck;

    @JsonProperty("highestAvailableVersion")
    protected String highestAvailableVersion;

    @JsonProperty("isGlobalScript")
    protected Boolean isGlobalScript;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("publisher")
    protected String publisher;

    @JsonProperty("remediationScriptContent")
    protected byte[] remediationScriptContent;

    @JsonProperty("remediationScriptParameters")
    protected List<DeviceHealthScriptParameter> remediationScriptParameters;

    @JsonProperty("remediationScriptParameters@nextLink")
    protected String remediationScriptParametersNextLink;

    @JsonProperty("roleScopeTagIds")
    protected List<String> roleScopeTagIds;

    @JsonProperty("roleScopeTagIds@nextLink")
    protected String roleScopeTagIdsNextLink;

    @JsonProperty("runAs32Bit")
    protected Boolean runAs32Bit;

    @JsonProperty("runAsAccount")
    protected RunAsAccountType runAsAccount;

    @JsonProperty("version")
    protected String version;

    @JsonProperty("assignments")
    protected List<DeviceHealthScriptAssignment> assignments;

    @JsonProperty("deviceRunStates")
    protected List<DeviceHealthScriptDeviceState> deviceRunStates;

    @JsonProperty("runSummary")
    protected DeviceHealthScriptRunSummary runSummary;

    protected DeviceHealthScript() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceHealthScript() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private String description;
        private byte[] detectionScriptContent;
        private List<DeviceHealthScriptParameter> detectionScriptParameters;
        private String detectionScriptParametersNextLink;
        private String displayName;
        private Boolean enforceSignatureCheck;
        private String highestAvailableVersion;
        private Boolean isGlobalScript;
        private OffsetDateTime lastModifiedDateTime;
        private String publisher;
        private byte[] remediationScriptContent;
        private List<DeviceHealthScriptParameter> remediationScriptParameters;
        private String remediationScriptParametersNextLink;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Boolean runAs32Bit;
        private RunAsAccountType runAsAccount;
        private String version;
        private List<DeviceHealthScriptAssignment> assignments;
        private List<DeviceHealthScriptDeviceState> deviceRunStates;
        private DeviceHealthScriptRunSummary runSummary;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The timestamp of when the device health script was created. This property is
         * read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param createdDateTime
         *            value of {@code createdDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        /**
         * <i>“Description of the device health script”</i>
         * 
         * @param description
         *            value of {@code description} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        /**
         * <i>“The entire content of the detection powershell script”</i>
         * 
         * @param detectionScriptContent
         *            value of {@code detectionScriptContent} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder detectionScriptContent(byte[] detectionScriptContent) {
            this.detectionScriptContent = detectionScriptContent;
            this.changedFields = changedFields.add("detectionScriptContent");
            return this;
        }

        /**
         * <i>“List of ComplexType DetectionScriptParameters objects.”</i>
         * 
         * @param detectionScriptParameters
         *            value of {@code detectionScriptParameters} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder detectionScriptParameters(List<DeviceHealthScriptParameter> detectionScriptParameters) {
            this.detectionScriptParameters = detectionScriptParameters;
            this.changedFields = changedFields.add("detectionScriptParameters");
            return this;
        }

        /**
         * <i>“List of ComplexType DetectionScriptParameters objects.”</i>
         * 
         * @param detectionScriptParameters
         *            value of {@code detectionScriptParameters} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder detectionScriptParameters(DeviceHealthScriptParameter... detectionScriptParameters) {
            return detectionScriptParameters(Arrays.asList(detectionScriptParameters));
        }

        /**
         * <i>“List of ComplexType DetectionScriptParameters objects.”</i>
         * 
         * @param detectionScriptParametersNextLink
         *            value of {@code detectionScriptParameters@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder detectionScriptParametersNextLink(String detectionScriptParametersNextLink) {
            this.detectionScriptParametersNextLink = detectionScriptParametersNextLink;
            this.changedFields = changedFields.add("detectionScriptParameters");
            return this;
        }

        /**
         * <i>“Name of the device health script”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“Indicate whether the script signature needs be checked”</i>
         * 
         * @param enforceSignatureCheck
         *            value of {@code enforceSignatureCheck} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enforceSignatureCheck(Boolean enforceSignatureCheck) {
            this.enforceSignatureCheck = enforceSignatureCheck;
            this.changedFields = changedFields.add("enforceSignatureCheck");
            return this;
        }

        /**
         * <i>“Highest available version for a Microsoft Proprietary script”</i>
         * 
         * @param highestAvailableVersion
         *            value of {@code highestAvailableVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder highestAvailableVersion(String highestAvailableVersion) {
            this.highestAvailableVersion = highestAvailableVersion;
            this.changedFields = changedFields.add("highestAvailableVersion");
            return this;
        }

        /**
         * <i>“Determines if this is Microsoft Proprietary Script. Proprietary scripts are read
         * -only”</i>
         * 
         * @param isGlobalScript
         *            value of {@code isGlobalScript} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder isGlobalScript(Boolean isGlobalScript) {
            this.isGlobalScript = isGlobalScript;
            this.changedFields = changedFields.add("isGlobalScript");
            return this;
        }

        /**
         * <i>“The timestamp of when the device health script was modified. This property is
         * read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param lastModifiedDateTime
         *            value of {@code lastModifiedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        /**
         * <i>“Name of the device health script publisher”</i>
         * 
         * @param publisher
         *            value of {@code publisher} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder publisher(String publisher) {
            this.publisher = publisher;
            this.changedFields = changedFields.add("publisher");
            return this;
        }

        /**
         * <i>“The entire content of the remediation powershell script”</i>
         * 
         * @param remediationScriptContent
         *            value of {@code remediationScriptContent} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder remediationScriptContent(byte[] remediationScriptContent) {
            this.remediationScriptContent = remediationScriptContent;
            this.changedFields = changedFields.add("remediationScriptContent");
            return this;
        }

        /**
         * <i>“List of ComplexType RemediationScriptParameters objects.”</i>
         * 
         * @param remediationScriptParameters
         *            value of {@code remediationScriptParameters} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder remediationScriptParameters(List<DeviceHealthScriptParameter> remediationScriptParameters) {
            this.remediationScriptParameters = remediationScriptParameters;
            this.changedFields = changedFields.add("remediationScriptParameters");
            return this;
        }

        /**
         * <i>“List of ComplexType RemediationScriptParameters objects.”</i>
         * 
         * @param remediationScriptParameters
         *            value of {@code remediationScriptParameters} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder remediationScriptParameters(DeviceHealthScriptParameter... remediationScriptParameters) {
            return remediationScriptParameters(Arrays.asList(remediationScriptParameters));
        }

        /**
         * <i>“List of ComplexType RemediationScriptParameters objects.”</i>
         * 
         * @param remediationScriptParametersNextLink
         *            value of {@code remediationScriptParameters@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder remediationScriptParametersNextLink(String remediationScriptParametersNextLink) {
            this.remediationScriptParametersNextLink = remediationScriptParametersNextLink;
            this.changedFields = changedFields.add("remediationScriptParameters");
            return this;
        }

        /**
         * <i>“List of Scope Tag IDs for the device health script”</i>
         * 
         * @param roleScopeTagIds
         *            value of {@code roleScopeTagIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        /**
         * <i>“List of Scope Tag IDs for the device health script”</i>
         * 
         * @param roleScopeTagIds
         *            value of {@code roleScopeTagIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        /**
         * <i>“List of Scope Tag IDs for the device health script”</i>
         * 
         * @param roleScopeTagIdsNextLink
         *            value of {@code roleScopeTagIds@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        /**
         * <i>“Indicate whether PowerShell script(s) should run as 32-bit”</i>
         * 
         * @param runAs32Bit
         *            value of {@code runAs32Bit} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder runAs32Bit(Boolean runAs32Bit) {
            this.runAs32Bit = runAs32Bit;
            this.changedFields = changedFields.add("runAs32Bit");
            return this;
        }

        /**
         * <i>“Indicates the type of execution context”</i>
         * 
         * @param runAsAccount
         *            value of {@code runAsAccount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder runAsAccount(RunAsAccountType runAsAccount) {
            this.runAsAccount = runAsAccount;
            this.changedFields = changedFields.add("runAsAccount");
            return this;
        }

        /**
         * <i>“Version of the device health script”</i>
         * 
         * @param version
         *            value of {@code version} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder version(String version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        /**
         * <i>“The list of group assignments for the device health script”</i>
         * 
         * @param assignments
         *            value of {@code assignments} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder assignments(List<DeviceHealthScriptAssignment> assignments) {
            this.assignments = assignments;
            this.changedFields = changedFields.add("assignments");
            return this;
        }

        /**
         * <i>“The list of group assignments for the device health script”</i>
         * 
         * @param assignments
         *            value of {@code assignments} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder assignments(DeviceHealthScriptAssignment... assignments) {
            return assignments(Arrays.asList(assignments));
        }

        /**
         * <i>“List of run states for the device health script across all devices”</i>
         * 
         * @param deviceRunStates
         *            value of {@code deviceRunStates} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceRunStates(List<DeviceHealthScriptDeviceState> deviceRunStates) {
            this.deviceRunStates = deviceRunStates;
            this.changedFields = changedFields.add("deviceRunStates");
            return this;
        }

        /**
         * <i>“List of run states for the device health script across all devices”</i>
         * 
         * @param deviceRunStates
         *            value of {@code deviceRunStates} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceRunStates(DeviceHealthScriptDeviceState... deviceRunStates) {
            return deviceRunStates(Arrays.asList(deviceRunStates));
        }

        /**
         * <i>“High level run summary for device health script.”</i>
         * 
         * @param runSummary
         *            value of {@code runSummary} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder runSummary(DeviceHealthScriptRunSummary runSummary) {
            this.runSummary = runSummary;
            this.changedFields = changedFields.add("runSummary");
            return this;
        }

        public DeviceHealthScript build() {
            DeviceHealthScript _x = new DeviceHealthScript();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceHealthScript";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.detectionScriptContent = detectionScriptContent;
            _x.detectionScriptParameters = detectionScriptParameters;
            _x.detectionScriptParametersNextLink = detectionScriptParametersNextLink;
            _x.displayName = displayName;
            _x.enforceSignatureCheck = enforceSignatureCheck;
            _x.highestAvailableVersion = highestAvailableVersion;
            _x.isGlobalScript = isGlobalScript;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.publisher = publisher;
            _x.remediationScriptContent = remediationScriptContent;
            _x.remediationScriptParameters = remediationScriptParameters;
            _x.remediationScriptParametersNextLink = remediationScriptParametersNextLink;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.runAs32Bit = runAs32Bit;
            _x.runAsAccount = runAsAccount;
            _x.version = version;
            _x.assignments = assignments;
            _x.deviceRunStates = deviceRunStates;
            _x.runSummary = runSummary;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The timestamp of when the device health script was created. This property is
     * read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property createdDateTime
     */
    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code createdDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The timestamp of when the device health script was created. This property is
     * read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param createdDateTime
     *            new value of {@code createdDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code createdDateTime} field changed
     */
    public DeviceHealthScript withCreatedDateTime(OffsetDateTime createdDateTime) {
        DeviceHealthScript _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthScript");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    /**
     * <i>“Description of the device health script”</i>
     * 
     * @return property description
     */
    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code description}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Description of the device health script”</i>
     * 
     * @param description
     *            new value of {@code description} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code description} field changed
     */
    public DeviceHealthScript withDescription(String description) {
        DeviceHealthScript _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthScript");
        _x.description = description;
        return _x;
    }

    /**
     * <i>“The entire content of the detection powershell script”</i>
     * 
     * @return property detectionScriptContent
     */
    @Property(name="detectionScriptContent")
    @JsonIgnore
    public Optional<byte[]> getDetectionScriptContent() {
        return Optional.ofNullable(detectionScriptContent);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * detectionScriptContent} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The entire content of the detection powershell script”</i>
     * 
     * @param detectionScriptContent
     *            new value of {@code detectionScriptContent} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code detectionScriptContent} field changed
     */
    public DeviceHealthScript withDetectionScriptContent(byte[] detectionScriptContent) {
        DeviceHealthScript _x = _copy();
        _x.changedFields = changedFields.add("detectionScriptContent");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthScript");
        _x.detectionScriptContent = detectionScriptContent;
        return _x;
    }

    /**
     * <i>“List of ComplexType DetectionScriptParameters objects.”</i>
     * 
     * @return property detectionScriptParameters
     */
    @Property(name="detectionScriptParameters")
    @JsonIgnore
    public CollectionPage<DeviceHealthScriptParameter> getDetectionScriptParameters() {
        return new CollectionPage<DeviceHealthScriptParameter>(contextPath, DeviceHealthScriptParameter.class, this.detectionScriptParameters, Optional.ofNullable(detectionScriptParametersNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * detectionScriptParameters} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“List of ComplexType DetectionScriptParameters objects.”</i>
     * 
     * @param detectionScriptParameters
     *            new value of {@code detectionScriptParameters} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code detectionScriptParameters} field changed
     */
    public DeviceHealthScript withDetectionScriptParameters(List<DeviceHealthScriptParameter> detectionScriptParameters) {
        DeviceHealthScript _x = _copy();
        _x.changedFields = changedFields.add("detectionScriptParameters");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthScript");
        _x.detectionScriptParameters = detectionScriptParameters;
        return _x;
    }

    /**
     * <i>“List of ComplexType DetectionScriptParameters objects.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property detectionScriptParameters
     */
    @Property(name="detectionScriptParameters")
    @JsonIgnore
    public CollectionPage<DeviceHealthScriptParameter> getDetectionScriptParameters(HttpRequestOptions options) {
        return new CollectionPage<DeviceHealthScriptParameter>(contextPath, DeviceHealthScriptParameter.class, this.detectionScriptParameters, Optional.ofNullable(detectionScriptParametersNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Name of the device health script”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Name of the device health script”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public DeviceHealthScript withDisplayName(String displayName) {
        DeviceHealthScript _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthScript");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“Indicate whether the script signature needs be checked”</i>
     * 
     * @return property enforceSignatureCheck
     */
    @Property(name="enforceSignatureCheck")
    @JsonIgnore
    public Optional<Boolean> getEnforceSignatureCheck() {
        return Optional.ofNullable(enforceSignatureCheck);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * enforceSignatureCheck} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicate whether the script signature needs be checked”</i>
     * 
     * @param enforceSignatureCheck
     *            new value of {@code enforceSignatureCheck} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enforceSignatureCheck} field changed
     */
    public DeviceHealthScript withEnforceSignatureCheck(Boolean enforceSignatureCheck) {
        DeviceHealthScript _x = _copy();
        _x.changedFields = changedFields.add("enforceSignatureCheck");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthScript");
        _x.enforceSignatureCheck = enforceSignatureCheck;
        return _x;
    }

    /**
     * <i>“Highest available version for a Microsoft Proprietary script”</i>
     * 
     * @return property highestAvailableVersion
     */
    @Property(name="highestAvailableVersion")
    @JsonIgnore
    public Optional<String> getHighestAvailableVersion() {
        return Optional.ofNullable(highestAvailableVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * highestAvailableVersion} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Highest available version for a Microsoft Proprietary script”</i>
     * 
     * @param highestAvailableVersion
     *            new value of {@code highestAvailableVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code highestAvailableVersion} field changed
     */
    public DeviceHealthScript withHighestAvailableVersion(String highestAvailableVersion) {
        DeviceHealthScript _x = _copy();
        _x.changedFields = changedFields.add("highestAvailableVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthScript");
        _x.highestAvailableVersion = highestAvailableVersion;
        return _x;
    }

    /**
     * <i>“Determines if this is Microsoft Proprietary Script. Proprietary scripts are read
     * -only”</i>
     * 
     * @return property isGlobalScript
     */
    @Property(name="isGlobalScript")
    @JsonIgnore
    public Optional<Boolean> getIsGlobalScript() {
        return Optional.ofNullable(isGlobalScript);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code isGlobalScript}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Determines if this is Microsoft Proprietary Script. Proprietary scripts are read
     * -only”</i>
     * 
     * @param isGlobalScript
     *            new value of {@code isGlobalScript} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code isGlobalScript} field changed
     */
    public DeviceHealthScript withIsGlobalScript(Boolean isGlobalScript) {
        DeviceHealthScript _x = _copy();
        _x.changedFields = changedFields.add("isGlobalScript");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthScript");
        _x.isGlobalScript = isGlobalScript;
        return _x;
    }

    /**
     * <i>“The timestamp of when the device health script was modified. This property is
     * read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property lastModifiedDateTime
     */
    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastModifiedDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The timestamp of when the device health script was modified. This property is
     * read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param lastModifiedDateTime
     *            new value of {@code lastModifiedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastModifiedDateTime} field changed
     */
    public DeviceHealthScript withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        DeviceHealthScript _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthScript");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    /**
     * <i>“Name of the device health script publisher”</i>
     * 
     * @return property publisher
     */
    @Property(name="publisher")
    @JsonIgnore
    public Optional<String> getPublisher() {
        return Optional.ofNullable(publisher);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code publisher} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Name of the device health script publisher”</i>
     * 
     * @param publisher
     *            new value of {@code publisher} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code publisher} field changed
     */
    public DeviceHealthScript withPublisher(String publisher) {
        DeviceHealthScript _x = _copy();
        _x.changedFields = changedFields.add("publisher");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthScript");
        _x.publisher = publisher;
        return _x;
    }

    /**
     * <i>“The entire content of the remediation powershell script”</i>
     * 
     * @return property remediationScriptContent
     */
    @Property(name="remediationScriptContent")
    @JsonIgnore
    public Optional<byte[]> getRemediationScriptContent() {
        return Optional.ofNullable(remediationScriptContent);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * remediationScriptContent} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The entire content of the remediation powershell script”</i>
     * 
     * @param remediationScriptContent
     *            new value of {@code remediationScriptContent} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code remediationScriptContent} field changed
     */
    public DeviceHealthScript withRemediationScriptContent(byte[] remediationScriptContent) {
        DeviceHealthScript _x = _copy();
        _x.changedFields = changedFields.add("remediationScriptContent");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthScript");
        _x.remediationScriptContent = remediationScriptContent;
        return _x;
    }

    /**
     * <i>“List of ComplexType RemediationScriptParameters objects.”</i>
     * 
     * @return property remediationScriptParameters
     */
    @Property(name="remediationScriptParameters")
    @JsonIgnore
    public CollectionPage<DeviceHealthScriptParameter> getRemediationScriptParameters() {
        return new CollectionPage<DeviceHealthScriptParameter>(contextPath, DeviceHealthScriptParameter.class, this.remediationScriptParameters, Optional.ofNullable(remediationScriptParametersNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * remediationScriptParameters} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“List of ComplexType RemediationScriptParameters objects.”</i>
     * 
     * @param remediationScriptParameters
     *            new value of {@code remediationScriptParameters} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code remediationScriptParameters} field changed
     */
    public DeviceHealthScript withRemediationScriptParameters(List<DeviceHealthScriptParameter> remediationScriptParameters) {
        DeviceHealthScript _x = _copy();
        _x.changedFields = changedFields.add("remediationScriptParameters");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthScript");
        _x.remediationScriptParameters = remediationScriptParameters;
        return _x;
    }

    /**
     * <i>“List of ComplexType RemediationScriptParameters objects.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property remediationScriptParameters
     */
    @Property(name="remediationScriptParameters")
    @JsonIgnore
    public CollectionPage<DeviceHealthScriptParameter> getRemediationScriptParameters(HttpRequestOptions options) {
        return new CollectionPage<DeviceHealthScriptParameter>(contextPath, DeviceHealthScriptParameter.class, this.remediationScriptParameters, Optional.ofNullable(remediationScriptParametersNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“List of Scope Tag IDs for the device health script”</i>
     * 
     * @return property roleScopeTagIds
     */
    @Property(name="roleScopeTagIds")
    @JsonIgnore
    public CollectionPage<String> getRoleScopeTagIds() {
        return new CollectionPage<String>(contextPath, String.class, this.roleScopeTagIds, Optional.ofNullable(roleScopeTagIdsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code roleScopeTagIds}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“List of Scope Tag IDs for the device health script”</i>
     * 
     * @param roleScopeTagIds
     *            new value of {@code roleScopeTagIds} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code roleScopeTagIds} field changed
     */
    public DeviceHealthScript withRoleScopeTagIds(List<String> roleScopeTagIds) {
        DeviceHealthScript _x = _copy();
        _x.changedFields = changedFields.add("roleScopeTagIds");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthScript");
        _x.roleScopeTagIds = roleScopeTagIds;
        return _x;
    }

    /**
     * <i>“List of Scope Tag IDs for the device health script”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property roleScopeTagIds
     */
    @Property(name="roleScopeTagIds")
    @JsonIgnore
    public CollectionPage<String> getRoleScopeTagIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.roleScopeTagIds, Optional.ofNullable(roleScopeTagIdsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Indicate whether PowerShell script(s) should run as 32-bit”</i>
     * 
     * @return property runAs32Bit
     */
    @Property(name="runAs32Bit")
    @JsonIgnore
    public Optional<Boolean> getRunAs32Bit() {
        return Optional.ofNullable(runAs32Bit);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code runAs32Bit} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Indicate whether PowerShell script(s) should run as 32-bit”</i>
     * 
     * @param runAs32Bit
     *            new value of {@code runAs32Bit} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code runAs32Bit} field changed
     */
    public DeviceHealthScript withRunAs32Bit(Boolean runAs32Bit) {
        DeviceHealthScript _x = _copy();
        _x.changedFields = changedFields.add("runAs32Bit");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthScript");
        _x.runAs32Bit = runAs32Bit;
        return _x;
    }

    /**
     * <i>“Indicates the type of execution context”</i>
     * 
     * @return property runAsAccount
     */
    @Property(name="runAsAccount")
    @JsonIgnore
    public Optional<RunAsAccountType> getRunAsAccount() {
        return Optional.ofNullable(runAsAccount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code runAsAccount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates the type of execution context”</i>
     * 
     * @param runAsAccount
     *            new value of {@code runAsAccount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code runAsAccount} field changed
     */
    public DeviceHealthScript withRunAsAccount(RunAsAccountType runAsAccount) {
        DeviceHealthScript _x = _copy();
        _x.changedFields = changedFields.add("runAsAccount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthScript");
        _x.runAsAccount = runAsAccount;
        return _x;
    }

    /**
     * <i>“Version of the device health script”</i>
     * 
     * @return property version
     */
    @Property(name="version")
    @JsonIgnore
    public Optional<String> getVersion() {
        return Optional.ofNullable(version);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code version} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Version of the device health script”</i>
     * 
     * @param version
     *            new value of {@code version} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code version} field changed
     */
    public DeviceHealthScript withVersion(String version) {
        DeviceHealthScript _x = _copy();
        _x.changedFields = changedFields.add("version");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthScript");
        _x.version = version;
        return _x;
    }

    public DeviceHealthScript withUnmappedField(String name, Object value) {
        DeviceHealthScript _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“The list of group assignments for the device health script”</i>
     * 
     * @return navigational property assignments
     */
    @NavigationProperty(name="assignments")
    @JsonIgnore
    public DeviceHealthScriptAssignmentCollectionRequest getAssignments() {
        return new DeviceHealthScriptAssignmentCollectionRequest(
                        contextPath.addSegment("assignments"), Optional.ofNullable(assignments));
    }

    /**
     * <i>“List of run states for the device health script across all devices”</i>
     * 
     * @return navigational property deviceRunStates
     */
    @NavigationProperty(name="deviceRunStates")
    @JsonIgnore
    public DeviceHealthScriptDeviceStateCollectionRequest getDeviceRunStates() {
        return new DeviceHealthScriptDeviceStateCollectionRequest(
                        contextPath.addSegment("deviceRunStates"), Optional.ofNullable(deviceRunStates));
    }

    /**
     * <i>“High level run summary for device health script.”</i>
     * 
     * @return navigational property runSummary
     */
    @NavigationProperty(name="runSummary")
    @JsonIgnore
    public DeviceHealthScriptRunSummaryRequest getRunSummary() {
        return new DeviceHealthScriptRunSummaryRequest(contextPath.addSegment("runSummary"), Optional.ofNullable(runSummary));
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code assignments}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The list of group assignments for the device health script”</i>
     * 
     * @param assignments
     *            new value of {@code assignments} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code assignments} field changed
     */
    public DeviceHealthScript withAssignments(List<DeviceHealthScriptAssignment> assignments) {
        DeviceHealthScript _x = _copy();
        _x.changedFields = changedFields.add("assignments");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthScript");
        _x.assignments = assignments;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceRunStates}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“List of run states for the device health script across all devices”</i>
     * 
     * @param deviceRunStates
     *            new value of {@code deviceRunStates} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceRunStates} field changed
     */
    public DeviceHealthScript withDeviceRunStates(List<DeviceHealthScriptDeviceState> deviceRunStates) {
        DeviceHealthScript _x = _copy();
        _x.changedFields = changedFields.add("deviceRunStates");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthScript");
        _x.deviceRunStates = deviceRunStates;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code runSummary} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“High level run summary for device health script.”</i>
     * 
     * @param runSummary
     *            new value of {@code runSummary} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code runSummary} field changed
     */
    public DeviceHealthScript withRunSummary(DeviceHealthScriptRunSummary runSummary) {
        DeviceHealthScript _x = _copy();
        _x.changedFields = changedFields.add("runSummary");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceHealthScript");
        _x.runSummary = runSummary;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceHealthScript patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceHealthScript _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceHealthScript put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceHealthScript _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceHealthScript _copy() {
        DeviceHealthScript _x = new DeviceHealthScript();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.detectionScriptContent = detectionScriptContent;
        _x.detectionScriptParameters = detectionScriptParameters;
        _x.displayName = displayName;
        _x.enforceSignatureCheck = enforceSignatureCheck;
        _x.highestAvailableVersion = highestAvailableVersion;
        _x.isGlobalScript = isGlobalScript;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.publisher = publisher;
        _x.remediationScriptContent = remediationScriptContent;
        _x.remediationScriptParameters = remediationScriptParameters;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.runAs32Bit = runAs32Bit;
        _x.runAsAccount = runAsAccount;
        _x.version = version;
        _x.assignments = assignments;
        _x.deviceRunStates = deviceRunStates;
        _x.runSummary = runSummary;
        return _x;
    }

    @Action(name = "assign")
    @JsonIgnore
    public ActionRequestNoReturn assign(List<DeviceHealthScriptAssignment> deviceHealthScriptAssignments) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("deviceHealthScriptAssignments", "Collection(microsoft.graph.deviceHealthScriptAssignment)", deviceHealthScriptAssignments)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.assign"), _parameters);
    }

    @Action(name = "getGlobalScriptHighestAvailableVersion")
    @JsonIgnore
    public ActionRequestReturningNonCollection<String> getGlobalScriptHighestAvailableVersion() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollection<String>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getGlobalScriptHighestAvailableVersion"), String.class, _parameters);
    }

    @Action(name = "updateGlobalScript")
    @JsonIgnore
    public ActionRequestReturningNonCollection<String> updateGlobalScript(String version) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("version", "Edm.String", Checks.checkIsAscii(version))
            .build();
        return new ActionRequestReturningNonCollection<String>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.updateGlobalScript"), String.class, _parameters);
    }

    @Function(name = "getRemediationHistory")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<DeviceHealthScriptRemediationHistory> getRemediationHistory() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<DeviceHealthScriptRemediationHistory>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getRemediationHistory"), DeviceHealthScriptRemediationHistory.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceHealthScript[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("detectionScriptContent=");
        b.append(this.detectionScriptContent);
        b.append(", ");
        b.append("detectionScriptParameters=");
        b.append(this.detectionScriptParameters);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("enforceSignatureCheck=");
        b.append(this.enforceSignatureCheck);
        b.append(", ");
        b.append("highestAvailableVersion=");
        b.append(this.highestAvailableVersion);
        b.append(", ");
        b.append("isGlobalScript=");
        b.append(this.isGlobalScript);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("publisher=");
        b.append(this.publisher);
        b.append(", ");
        b.append("remediationScriptContent=");
        b.append(this.remediationScriptContent);
        b.append(", ");
        b.append("remediationScriptParameters=");
        b.append(this.remediationScriptParameters);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("runAs32Bit=");
        b.append(this.runAs32Bit);
        b.append(", ");
        b.append("runAsAccount=");
        b.append(this.runAsAccount);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("assignments=");
        b.append(this.assignments);
        b.append(", ");
        b.append("deviceRunStates=");
        b.append(this.deviceRunStates);
        b.append(", ");
        b.append("runSummary=");
        b.append(this.runSummary);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
