package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DeviceEnrollmentPlatformRestriction;
import odata.msgraph.client.beta.enums.DeviceEnrollmentConfigurationType;
import odata.msgraph.client.beta.enums.EnrollmentRestrictionPlatformType;


/**
 * <i>“Device Enrollment Configuration that restricts the types of devices a user can
 * enroll for a single platform”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "platformRestriction", 
    "platformType"})
@JsonInclude(Include.NON_NULL)
public class DeviceEnrollmentPlatformRestrictionConfiguration extends DeviceEnrollmentConfiguration implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceEnrollmentPlatformRestrictionConfiguration";
    }

    @JsonProperty("platformRestriction")
    protected DeviceEnrollmentPlatformRestriction platformRestriction;

    @JsonProperty("platformType")
    protected EnrollmentRestrictionPlatformType platformType;

    protected DeviceEnrollmentPlatformRestrictionConfiguration() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceEnrollmentPlatformRestrictionConfiguration() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private String description;
        private DeviceEnrollmentConfigurationType deviceEnrollmentConfigurationType;
        private String displayName;
        private OffsetDateTime lastModifiedDateTime;
        private Integer priority;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Integer version;
        private List<EnrollmentConfigurationAssignment> assignments;
        private DeviceEnrollmentPlatformRestriction platformRestriction;
        private EnrollmentRestrictionPlatformType platformType;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder deviceEnrollmentConfigurationType(DeviceEnrollmentConfigurationType deviceEnrollmentConfigurationType) {
            this.deviceEnrollmentConfigurationType = deviceEnrollmentConfigurationType;
            this.changedFields = changedFields.add("deviceEnrollmentConfigurationType");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder priority(Integer priority) {
            this.priority = priority;
            this.changedFields = changedFields.add("priority");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public Builder assignments(List<EnrollmentConfigurationAssignment> assignments) {
            this.assignments = assignments;
            this.changedFields = changedFields.add("assignments");
            return this;
        }

        public Builder assignments(EnrollmentConfigurationAssignment... assignments) {
            return assignments(Arrays.asList(assignments));
        }

        /**
         * <i>“Restrictions based on platform, platform operating system version, and device
         * ownership”</i>
         * 
         * @param platformRestriction
         *            value of {@code platformRestriction} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder platformRestriction(DeviceEnrollmentPlatformRestriction platformRestriction) {
            this.platformRestriction = platformRestriction;
            this.changedFields = changedFields.add("platformRestriction");
            return this;
        }

        /**
         * <i>“Type of platform for which this restriction applies.”</i>
         * 
         * @param platformType
         *            value of {@code platformType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder platformType(EnrollmentRestrictionPlatformType platformType) {
            this.platformType = platformType;
            this.changedFields = changedFields.add("platformType");
            return this;
        }

        public DeviceEnrollmentPlatformRestrictionConfiguration build() {
            DeviceEnrollmentPlatformRestrictionConfiguration _x = new DeviceEnrollmentPlatformRestrictionConfiguration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceEnrollmentPlatformRestrictionConfiguration";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.deviceEnrollmentConfigurationType = deviceEnrollmentConfigurationType;
            _x.displayName = displayName;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.priority = priority;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.version = version;
            _x.assignments = assignments;
            _x.platformRestriction = platformRestriction;
            _x.platformType = platformType;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Restrictions based on platform, platform operating system version, and device
     * ownership”</i>
     * 
     * @return property platformRestriction
     */
    @Property(name="platformRestriction")
    @JsonIgnore
    public Optional<DeviceEnrollmentPlatformRestriction> getPlatformRestriction() {
        return Optional.ofNullable(platformRestriction);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * platformRestriction} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Restrictions based on platform, platform operating system version, and device
     * ownership”</i>
     * 
     * @param platformRestriction
     *            new value of {@code platformRestriction} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code platformRestriction} field changed
     */
    public DeviceEnrollmentPlatformRestrictionConfiguration withPlatformRestriction(DeviceEnrollmentPlatformRestriction platformRestriction) {
        DeviceEnrollmentPlatformRestrictionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("platformRestriction");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceEnrollmentPlatformRestrictionConfiguration");
        _x.platformRestriction = platformRestriction;
        return _x;
    }

    /**
     * <i>“Type of platform for which this restriction applies.”</i>
     * 
     * @return property platformType
     */
    @Property(name="platformType")
    @JsonIgnore
    public Optional<EnrollmentRestrictionPlatformType> getPlatformType() {
        return Optional.ofNullable(platformType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code platformType}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Type of platform for which this restriction applies.”</i>
     * 
     * @param platformType
     *            new value of {@code platformType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code platformType} field changed
     */
    public DeviceEnrollmentPlatformRestrictionConfiguration withPlatformType(EnrollmentRestrictionPlatformType platformType) {
        DeviceEnrollmentPlatformRestrictionConfiguration _x = _copy();
        _x.changedFields = changedFields.add("platformType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceEnrollmentPlatformRestrictionConfiguration");
        _x.platformType = platformType;
        return _x;
    }

    public DeviceEnrollmentPlatformRestrictionConfiguration withUnmappedField(String name, Object value) {
        DeviceEnrollmentPlatformRestrictionConfiguration _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceEnrollmentPlatformRestrictionConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceEnrollmentPlatformRestrictionConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceEnrollmentPlatformRestrictionConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceEnrollmentPlatformRestrictionConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceEnrollmentPlatformRestrictionConfiguration _copy() {
        DeviceEnrollmentPlatformRestrictionConfiguration _x = new DeviceEnrollmentPlatformRestrictionConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.deviceEnrollmentConfigurationType = deviceEnrollmentConfigurationType;
        _x.displayName = displayName;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.priority = priority;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.version = version;
        _x.assignments = assignments;
        _x.platformRestriction = platformRestriction;
        _x.platformType = platformType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceEnrollmentPlatformRestrictionConfiguration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("deviceEnrollmentConfigurationType=");
        b.append(this.deviceEnrollmentConfigurationType);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("priority=");
        b.append(this.priority);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("assignments=");
        b.append(this.assignments);
        b.append(", ");
        b.append("platformRestriction=");
        b.append(this.platformRestriction);
        b.append(", ");
        b.append("platformType=");
        b.append(this.platformType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
