package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleDeviceMode;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsEdition;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsVersion;
import odata.msgraph.client.beta.entity.collection.request.DeviceConfigurationAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceConfigurationDeviceStatusCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceConfigurationGroupAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceConfigurationUserStatusCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SettingStateDeviceSummaryCollectionRequest;
import odata.msgraph.client.beta.entity.request.DeviceConfigurationDeviceOverviewRequest;
import odata.msgraph.client.beta.entity.request.DeviceConfigurationUserOverviewRequest;


/**
 * <i>“Device Configuration.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "createdDateTime", 
    "description", 
    "deviceManagementApplicabilityRuleDeviceMode", 
    "deviceManagementApplicabilityRuleOsEdition", 
    "deviceManagementApplicabilityRuleOsVersion", 
    "displayName", 
    "lastModifiedDateTime", 
    "roleScopeTagIds", 
    "supportsScopeTags", 
    "version", 
    "assignments", 
    "deviceSettingStateSummaries", 
    "deviceStatuses", 
    "deviceStatusOverview", 
    "groupAssignments", 
    "userStatuses", 
    "userStatusOverview"})
@JsonInclude(Include.NON_NULL)
public class DeviceConfiguration extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceConfiguration";
    }

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("deviceManagementApplicabilityRuleDeviceMode")
    protected DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode;

    @JsonProperty("deviceManagementApplicabilityRuleOsEdition")
    protected DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition;

    @JsonProperty("deviceManagementApplicabilityRuleOsVersion")
    protected DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("roleScopeTagIds")
    protected List<String> roleScopeTagIds;

    @JsonProperty("roleScopeTagIds@nextLink")
    protected String roleScopeTagIdsNextLink;

    @JsonProperty("supportsScopeTags")
    protected Boolean supportsScopeTags;

    @JsonProperty("version")
    protected Integer version;

    @JsonProperty("assignments")
    protected List<DeviceConfigurationAssignment> assignments;

    @JsonProperty("deviceSettingStateSummaries")
    protected List<SettingStateDeviceSummary> deviceSettingStateSummaries;

    @JsonProperty("deviceStatuses")
    protected List<DeviceConfigurationDeviceStatus> deviceStatuses;

    @JsonProperty("deviceStatusOverview")
    protected DeviceConfigurationDeviceOverview deviceStatusOverview;

    @JsonProperty("groupAssignments")
    protected List<DeviceConfigurationGroupAssignment> groupAssignments;

    @JsonProperty("userStatuses")
    protected List<DeviceConfigurationUserStatus> userStatuses;

    @JsonProperty("userStatusOverview")
    protected DeviceConfigurationUserOverview userStatusOverview;

    protected DeviceConfiguration() {
        super();
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“DateTime the object was created.”</i>
     * 
     * @return property createdDateTime
     */
    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code createdDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“DateTime the object was created.”</i>
     * 
     * @param createdDateTime
     *            new value of {@code createdDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code createdDateTime} field changed
     */
    public DeviceConfiguration withCreatedDateTime(OffsetDateTime createdDateTime) {
        DeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceConfiguration");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    /**
     * <i>“Admin provided description of the Device Configuration.”</i>
     * 
     * @return property description
     */
    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code description}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Admin provided description of the Device Configuration.”</i>
     * 
     * @param description
     *            new value of {@code description} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code description} field changed
     */
    public DeviceConfiguration withDescription(String description) {
        DeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceConfiguration");
        _x.description = description;
        return _x;
    }

    /**
     * <i>“The device mode applicability rule for this Policy.”</i>
     * 
     * @return property deviceManagementApplicabilityRuleDeviceMode
     */
    @Property(name="deviceManagementApplicabilityRuleDeviceMode")
    @JsonIgnore
    public Optional<DeviceManagementApplicabilityRuleDeviceMode> getDeviceManagementApplicabilityRuleDeviceMode() {
        return Optional.ofNullable(deviceManagementApplicabilityRuleDeviceMode);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceManagementApplicabilityRuleDeviceMode} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“The device mode applicability rule for this Policy.”</i>
     * 
     * @param deviceManagementApplicabilityRuleDeviceMode
     *            new value of {@code deviceManagementApplicabilityRuleDeviceMode} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceManagementApplicabilityRuleDeviceMode} field changed
     */
    public DeviceConfiguration withDeviceManagementApplicabilityRuleDeviceMode(DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode) {
        DeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("deviceManagementApplicabilityRuleDeviceMode");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceConfiguration");
        _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
        return _x;
    }

    /**
     * <i>“The OS edition applicability for this Policy.”</i>
     * 
     * @return property deviceManagementApplicabilityRuleOsEdition
     */
    @Property(name="deviceManagementApplicabilityRuleOsEdition")
    @JsonIgnore
    public Optional<DeviceManagementApplicabilityRuleOsEdition> getDeviceManagementApplicabilityRuleOsEdition() {
        return Optional.ofNullable(deviceManagementApplicabilityRuleOsEdition);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceManagementApplicabilityRuleOsEdition} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“The OS edition applicability for this Policy.”</i>
     * 
     * @param deviceManagementApplicabilityRuleOsEdition
     *            new value of {@code deviceManagementApplicabilityRuleOsEdition} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceManagementApplicabilityRuleOsEdition} field changed
     */
    public DeviceConfiguration withDeviceManagementApplicabilityRuleOsEdition(DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition) {
        DeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsEdition");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceConfiguration");
        _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
        return _x;
    }

    /**
     * <i>“The OS version applicability rule for this Policy.”</i>
     * 
     * @return property deviceManagementApplicabilityRuleOsVersion
     */
    @Property(name="deviceManagementApplicabilityRuleOsVersion")
    @JsonIgnore
    public Optional<DeviceManagementApplicabilityRuleOsVersion> getDeviceManagementApplicabilityRuleOsVersion() {
        return Optional.ofNullable(deviceManagementApplicabilityRuleOsVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceManagementApplicabilityRuleOsVersion} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“The OS version applicability rule for this Policy.”</i>
     * 
     * @param deviceManagementApplicabilityRuleOsVersion
     *            new value of {@code deviceManagementApplicabilityRuleOsVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceManagementApplicabilityRuleOsVersion} field changed
     */
    public DeviceConfiguration withDeviceManagementApplicabilityRuleOsVersion(DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion) {
        DeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceConfiguration");
        _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
        return _x;
    }

    /**
     * <i>“Admin provided name of the device configuration.”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Admin provided name of the device configuration.”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public DeviceConfiguration withDisplayName(String displayName) {
        DeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceConfiguration");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“DateTime the object was last modified.”</i>
     * 
     * @return property lastModifiedDateTime
     */
    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastModifiedDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“DateTime the object was last modified.”</i>
     * 
     * @param lastModifiedDateTime
     *            new value of {@code lastModifiedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastModifiedDateTime} field changed
     */
    public DeviceConfiguration withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        DeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceConfiguration");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    /**
     * <i>“List of Scope Tags for this Entity instance.”</i>
     * 
     * @return property roleScopeTagIds
     */
    @Property(name="roleScopeTagIds")
    @JsonIgnore
    public CollectionPage<String> getRoleScopeTagIds() {
        return new CollectionPage<String>(contextPath, String.class, this.roleScopeTagIds, Optional.ofNullable(roleScopeTagIdsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code roleScopeTagIds}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“List of Scope Tags for this Entity instance.”</i>
     * 
     * @param roleScopeTagIds
     *            new value of {@code roleScopeTagIds} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code roleScopeTagIds} field changed
     */
    public DeviceConfiguration withRoleScopeTagIds(List<String> roleScopeTagIds) {
        DeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("roleScopeTagIds");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceConfiguration");
        _x.roleScopeTagIds = roleScopeTagIds;
        return _x;
    }

    /**
     * <i>“List of Scope Tags for this Entity instance.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property roleScopeTagIds
     */
    @Property(name="roleScopeTagIds")
    @JsonIgnore
    public CollectionPage<String> getRoleScopeTagIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.roleScopeTagIds, Optional.ofNullable(roleScopeTagIdsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Indicates whether or not the underlying Device Configuration supports the
     * assignment of scope tags. Assigning to the ScopeTags property is not allowed
     * when this value is false and entities will not be visible to scoped users. This
     * occurs for Legacy policies created in Silverlight and can be resolved by
     * deleting and recreating the policy in the Azure Portal. This property is read-
     * only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property supportsScopeTags
     */
    @Property(name="supportsScopeTags")
    @JsonIgnore
    public Optional<Boolean> getSupportsScopeTags() {
        return Optional.ofNullable(supportsScopeTags);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code supportsScopeTags
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates whether or not the underlying Device Configuration supports the
     * assignment of scope tags. Assigning to the ScopeTags property is not allowed
     * when this value is false and entities will not be visible to scoped users. This
     * occurs for Legacy policies created in Silverlight and can be resolved by
     * deleting and recreating the policy in the Azure Portal. This property is read-
     * only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param supportsScopeTags
     *            new value of {@code supportsScopeTags} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code supportsScopeTags} field changed
     */
    public DeviceConfiguration withSupportsScopeTags(Boolean supportsScopeTags) {
        DeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("supportsScopeTags");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceConfiguration");
        _x.supportsScopeTags = supportsScopeTags;
        return _x;
    }

    /**
     * <i>“Version of the device configuration.”</i>
     * 
     * @return property version
     */
    @Property(name="version")
    @JsonIgnore
    public Optional<Integer> getVersion() {
        return Optional.ofNullable(version);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code version} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Version of the device configuration.”</i>
     * 
     * @param version
     *            new value of {@code version} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code version} field changed
     */
    public DeviceConfiguration withVersion(Integer version) {
        DeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("version");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceConfiguration");
        _x.version = version;
        return _x;
    }

    public DeviceConfiguration withUnmappedField(String name, Object value) {
        DeviceConfiguration _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“The list of assignments for the device configuration profile.”</i>
     * 
     * @return navigational property assignments
     */
    @NavigationProperty(name="assignments")
    @JsonIgnore
    public DeviceConfigurationAssignmentCollectionRequest getAssignments() {
        return new DeviceConfigurationAssignmentCollectionRequest(
                        contextPath.addSegment("assignments"), Optional.ofNullable(assignments));
    }

    /**
     * <i>“Device Configuration Setting State Device Summary”</i>
     * 
     * @return navigational property deviceSettingStateSummaries
     */
    @NavigationProperty(name="deviceSettingStateSummaries")
    @JsonIgnore
    public SettingStateDeviceSummaryCollectionRequest getDeviceSettingStateSummaries() {
        return new SettingStateDeviceSummaryCollectionRequest(
                        contextPath.addSegment("deviceSettingStateSummaries"), Optional.ofNullable(deviceSettingStateSummaries));
    }

    /**
     * <i>“Device configuration installation status by device.”</i>
     * 
     * @return navigational property deviceStatuses
     */
    @NavigationProperty(name="deviceStatuses")
    @JsonIgnore
    public DeviceConfigurationDeviceStatusCollectionRequest getDeviceStatuses() {
        return new DeviceConfigurationDeviceStatusCollectionRequest(
                        contextPath.addSegment("deviceStatuses"), Optional.ofNullable(deviceStatuses));
    }

    /**
     * <i>“Device Configuration devices status overview”</i>
     * 
     * @return navigational property deviceStatusOverview
     */
    @NavigationProperty(name="deviceStatusOverview")
    @JsonIgnore
    public DeviceConfigurationDeviceOverviewRequest getDeviceStatusOverview() {
        return new DeviceConfigurationDeviceOverviewRequest(contextPath.addSegment("deviceStatusOverview"), Optional.ofNullable(deviceStatusOverview));
    }

    /**
     * <i>“The list of group assignments for the device configuration profile.”</i>
     * 
     * @return navigational property groupAssignments
     */
    @NavigationProperty(name="groupAssignments")
    @JsonIgnore
    public DeviceConfigurationGroupAssignmentCollectionRequest getGroupAssignments() {
        return new DeviceConfigurationGroupAssignmentCollectionRequest(
                        contextPath.addSegment("groupAssignments"), Optional.ofNullable(groupAssignments));
    }

    /**
     * <i>“Device configuration installation status by user.”</i>
     * 
     * @return navigational property userStatuses
     */
    @NavigationProperty(name="userStatuses")
    @JsonIgnore
    public DeviceConfigurationUserStatusCollectionRequest getUserStatuses() {
        return new DeviceConfigurationUserStatusCollectionRequest(
                        contextPath.addSegment("userStatuses"), Optional.ofNullable(userStatuses));
    }

    /**
     * <i>“Device Configuration users status overview”</i>
     * 
     * @return navigational property userStatusOverview
     */
    @NavigationProperty(name="userStatusOverview")
    @JsonIgnore
    public DeviceConfigurationUserOverviewRequest getUserStatusOverview() {
        return new DeviceConfigurationUserOverviewRequest(contextPath.addSegment("userStatusOverview"), Optional.ofNullable(userStatusOverview));
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code assignments}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The list of assignments for the device configuration profile.”</i>
     * 
     * @param assignments
     *            new value of {@code assignments} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code assignments} field changed
     */
    public DeviceConfiguration withAssignments(List<DeviceConfigurationAssignment> assignments) {
        DeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("assignments");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceConfiguration");
        _x.assignments = assignments;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceSettingStateSummaries} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Device Configuration Setting State Device Summary”</i>
     * 
     * @param deviceSettingStateSummaries
     *            new value of {@code deviceSettingStateSummaries} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceSettingStateSummaries} field changed
     */
    public DeviceConfiguration withDeviceSettingStateSummaries(List<SettingStateDeviceSummary> deviceSettingStateSummaries) {
        DeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("deviceSettingStateSummaries");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceConfiguration");
        _x.deviceSettingStateSummaries = deviceSettingStateSummaries;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceStatuses}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Device configuration installation status by device.”</i>
     * 
     * @param deviceStatuses
     *            new value of {@code deviceStatuses} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceStatuses} field changed
     */
    public DeviceConfiguration withDeviceStatuses(List<DeviceConfigurationDeviceStatus> deviceStatuses) {
        DeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("deviceStatuses");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceConfiguration");
        _x.deviceStatuses = deviceStatuses;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceStatusOverview} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Device Configuration devices status overview”</i>
     * 
     * @param deviceStatusOverview
     *            new value of {@code deviceStatusOverview} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceStatusOverview} field changed
     */
    public DeviceConfiguration withDeviceStatusOverview(DeviceConfigurationDeviceOverview deviceStatusOverview) {
        DeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("deviceStatusOverview");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceConfiguration");
        _x.deviceStatusOverview = deviceStatusOverview;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code groupAssignments}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The list of group assignments for the device configuration profile.”</i>
     * 
     * @param groupAssignments
     *            new value of {@code groupAssignments} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code groupAssignments} field changed
     */
    public DeviceConfiguration withGroupAssignments(List<DeviceConfigurationGroupAssignment> groupAssignments) {
        DeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("groupAssignments");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceConfiguration");
        _x.groupAssignments = groupAssignments;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userStatuses}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Device configuration installation status by user.”</i>
     * 
     * @param userStatuses
     *            new value of {@code userStatuses} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userStatuses} field changed
     */
    public DeviceConfiguration withUserStatuses(List<DeviceConfigurationUserStatus> userStatuses) {
        DeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("userStatuses");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceConfiguration");
        _x.userStatuses = userStatuses;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userStatusOverview} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Device Configuration users status overview”</i>
     * 
     * @param userStatusOverview
     *            new value of {@code userStatusOverview} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userStatusOverview} field changed
     */
    public DeviceConfiguration withUserStatusOverview(DeviceConfigurationUserOverview userStatusOverview) {
        DeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("userStatusOverview");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceConfiguration");
        _x.userStatusOverview = userStatusOverview;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceConfiguration _copy() {
        DeviceConfiguration _x = new DeviceConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
        _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
        _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
        _x.displayName = displayName;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.supportsScopeTags = supportsScopeTags;
        _x.version = version;
        _x.assignments = assignments;
        _x.deviceSettingStateSummaries = deviceSettingStateSummaries;
        _x.deviceStatuses = deviceStatuses;
        _x.deviceStatusOverview = deviceStatusOverview;
        _x.groupAssignments = groupAssignments;
        _x.userStatuses = userStatuses;
        _x.userStatusOverview = userStatusOverview;
        return _x;
    }

    @Action(name = "assign")
    @JsonIgnore
    public CollectionPageNonEntityRequest<DeviceConfigurationAssignment> assign(List<DeviceConfigurationGroupAssignment> deviceConfigurationGroupAssignments, List<DeviceConfigurationAssignment> assignments) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("deviceConfigurationGroupAssignments", "Collection(microsoft.graph.deviceConfigurationGroupAssignment)", deviceConfigurationGroupAssignments)
            .put("assignments", "Collection(microsoft.graph.deviceConfigurationAssignment)", assignments)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.assign"), DeviceConfigurationAssignment.class, _parameters);
    }

    @Action(name = "assignedAccessMultiModeProfiles")
    @JsonIgnore
    public ActionRequestNoReturn assignedAccessMultiModeProfiles(List<WindowsAssignedAccessProfile> assignedAccessMultiModeProfiles) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("assignedAccessMultiModeProfiles", "Collection(microsoft.graph.windowsAssignedAccessProfile)", assignedAccessMultiModeProfiles)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.assignedAccessMultiModeProfiles"), _parameters);
    }

    @Action(name = "windowsPrivacyAccessControls")
    @JsonIgnore
    public ActionRequestNoReturn windowsPrivacyAccessControls(List<WindowsPrivacyDataAccessControlItem> windowsPrivacyAccessControls) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("windowsPrivacyAccessControls", "Collection(microsoft.graph.windowsPrivacyDataAccessControlItem)", windowsPrivacyAccessControls)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.windowsPrivacyAccessControls"), _parameters);
    }

    @Function(name = "getOmaSettingPlainTextValue")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<String> getOmaSettingPlainTextValue(String secretReferenceValueId) {
        Preconditions.checkNotNull(secretReferenceValueId, "secretReferenceValueId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("secretReferenceValueId", "Edm.String", Checks.checkIsAscii(secretReferenceValueId))
            .build();
        return new FunctionRequestReturningNonCollection<String>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getOmaSettingPlainTextValue"), String.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceConfiguration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleDeviceMode=");
        b.append(this.deviceManagementApplicabilityRuleDeviceMode);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsEdition=");
        b.append(this.deviceManagementApplicabilityRuleOsEdition);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsVersion=");
        b.append(this.deviceManagementApplicabilityRuleOsVersion);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("supportsScopeTags=");
        b.append(this.supportsScopeTags);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("assignments=");
        b.append(this.assignments);
        b.append(", ");
        b.append("deviceSettingStateSummaries=");
        b.append(this.deviceSettingStateSummaries);
        b.append(", ");
        b.append("deviceStatuses=");
        b.append(this.deviceStatuses);
        b.append(", ");
        b.append("deviceStatusOverview=");
        b.append(this.deviceStatusOverview);
        b.append(", ");
        b.append("groupAssignments=");
        b.append(this.groupAssignments);
        b.append(", ");
        b.append("userStatuses=");
        b.append(this.userStatuses);
        b.append(", ");
        b.append("userStatusOverview=");
        b.append(this.userStatusOverview);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
