package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;


/**
 * <i>“Contains properties for the run summary of a device management script.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "detectionScriptErrorDeviceCount", 
    "detectionScriptPendingDeviceCount", 
    "issueDetectedDeviceCount", 
    "lastScriptRunDateTime", 
    "noIssueDetectedDeviceCount"})
@JsonInclude(Include.NON_NULL)
public class DeviceComplianceScriptRunSummary extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceComplianceScriptRunSummary";
    }

    @JsonProperty("detectionScriptErrorDeviceCount")
    protected Integer detectionScriptErrorDeviceCount;

    @JsonProperty("detectionScriptPendingDeviceCount")
    protected Integer detectionScriptPendingDeviceCount;

    @JsonProperty("issueDetectedDeviceCount")
    protected Integer issueDetectedDeviceCount;

    @JsonProperty("lastScriptRunDateTime")
    protected OffsetDateTime lastScriptRunDateTime;

    @JsonProperty("noIssueDetectedDeviceCount")
    protected Integer noIssueDetectedDeviceCount;

    protected DeviceComplianceScriptRunSummary() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceComplianceScriptRunSummary() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Integer detectionScriptErrorDeviceCount;
        private Integer detectionScriptPendingDeviceCount;
        private Integer issueDetectedDeviceCount;
        private OffsetDateTime lastScriptRunDateTime;
        private Integer noIssueDetectedDeviceCount;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Number of devices on which the detection script execution encountered an error
         * and did not complete. Valid values -2147483648 to 2147483647”</i>
         * 
         * @param detectionScriptErrorDeviceCount
         *            value of {@code detectionScriptErrorDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder detectionScriptErrorDeviceCount(Integer detectionScriptErrorDeviceCount) {
            this.detectionScriptErrorDeviceCount = detectionScriptErrorDeviceCount;
            this.changedFields = changedFields.add("detectionScriptErrorDeviceCount");
            return this;
        }

        /**
         * <i>“Number of devices which have not yet run the latest version of the device
         * compliance script. Valid values -2147483648 to 2147483647”</i>
         * 
         * @param detectionScriptPendingDeviceCount
         *            value of {@code detectionScriptPendingDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder detectionScriptPendingDeviceCount(Integer detectionScriptPendingDeviceCount) {
            this.detectionScriptPendingDeviceCount = detectionScriptPendingDeviceCount;
            this.changedFields = changedFields.add("detectionScriptPendingDeviceCount");
            return this;
        }

        /**
         * <i>“Number of devices for which the detection script found an issue. Valid values -
         * 2147483648 to 2147483647”</i>
         * 
         * @param issueDetectedDeviceCount
         *            value of {@code issueDetectedDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder issueDetectedDeviceCount(Integer issueDetectedDeviceCount) {
            this.issueDetectedDeviceCount = issueDetectedDeviceCount;
            this.changedFields = changedFields.add("issueDetectedDeviceCount");
            return this;
        }

        /**
         * <i>“Last run time for the script across all devices”</i>
         * 
         * @param lastScriptRunDateTime
         *            value of {@code lastScriptRunDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastScriptRunDateTime(OffsetDateTime lastScriptRunDateTime) {
            this.lastScriptRunDateTime = lastScriptRunDateTime;
            this.changedFields = changedFields.add("lastScriptRunDateTime");
            return this;
        }

        /**
         * <i>“Number of devices for which the detection script did not find an issue and the
         * device is healthy. Valid values -2147483648 to 2147483647”</i>
         * 
         * @param noIssueDetectedDeviceCount
         *            value of {@code noIssueDetectedDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder noIssueDetectedDeviceCount(Integer noIssueDetectedDeviceCount) {
            this.noIssueDetectedDeviceCount = noIssueDetectedDeviceCount;
            this.changedFields = changedFields.add("noIssueDetectedDeviceCount");
            return this;
        }

        public DeviceComplianceScriptRunSummary build() {
            DeviceComplianceScriptRunSummary _x = new DeviceComplianceScriptRunSummary();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceComplianceScriptRunSummary";
            _x.id = id;
            _x.detectionScriptErrorDeviceCount = detectionScriptErrorDeviceCount;
            _x.detectionScriptPendingDeviceCount = detectionScriptPendingDeviceCount;
            _x.issueDetectedDeviceCount = issueDetectedDeviceCount;
            _x.lastScriptRunDateTime = lastScriptRunDateTime;
            _x.noIssueDetectedDeviceCount = noIssueDetectedDeviceCount;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Number of devices on which the detection script execution encountered an error
     * and did not complete. Valid values -2147483648 to 2147483647”</i>
     * 
     * @return property detectionScriptErrorDeviceCount
     */
    @Property(name="detectionScriptErrorDeviceCount")
    @JsonIgnore
    public Optional<Integer> getDetectionScriptErrorDeviceCount() {
        return Optional.ofNullable(detectionScriptErrorDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * detectionScriptErrorDeviceCount} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Number of devices on which the detection script execution encountered an error
     * and did not complete. Valid values -2147483648 to 2147483647”</i>
     * 
     * @param detectionScriptErrorDeviceCount
     *            new value of {@code detectionScriptErrorDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code detectionScriptErrorDeviceCount} field changed
     */
    public DeviceComplianceScriptRunSummary withDetectionScriptErrorDeviceCount(Integer detectionScriptErrorDeviceCount) {
        DeviceComplianceScriptRunSummary _x = _copy();
        _x.changedFields = changedFields.add("detectionScriptErrorDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceComplianceScriptRunSummary");
        _x.detectionScriptErrorDeviceCount = detectionScriptErrorDeviceCount;
        return _x;
    }

    /**
     * <i>“Number of devices which have not yet run the latest version of the device
     * compliance script. Valid values -2147483648 to 2147483647”</i>
     * 
     * @return property detectionScriptPendingDeviceCount
     */
    @Property(name="detectionScriptPendingDeviceCount")
    @JsonIgnore
    public Optional<Integer> getDetectionScriptPendingDeviceCount() {
        return Optional.ofNullable(detectionScriptPendingDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * detectionScriptPendingDeviceCount} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Number of devices which have not yet run the latest version of the device
     * compliance script. Valid values -2147483648 to 2147483647”</i>
     * 
     * @param detectionScriptPendingDeviceCount
     *            new value of {@code detectionScriptPendingDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code detectionScriptPendingDeviceCount} field changed
     */
    public DeviceComplianceScriptRunSummary withDetectionScriptPendingDeviceCount(Integer detectionScriptPendingDeviceCount) {
        DeviceComplianceScriptRunSummary _x = _copy();
        _x.changedFields = changedFields.add("detectionScriptPendingDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceComplianceScriptRunSummary");
        _x.detectionScriptPendingDeviceCount = detectionScriptPendingDeviceCount;
        return _x;
    }

    /**
     * <i>“Number of devices for which the detection script found an issue. Valid values -
     * 2147483648 to 2147483647”</i>
     * 
     * @return property issueDetectedDeviceCount
     */
    @Property(name="issueDetectedDeviceCount")
    @JsonIgnore
    public Optional<Integer> getIssueDetectedDeviceCount() {
        return Optional.ofNullable(issueDetectedDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * issueDetectedDeviceCount} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Number of devices for which the detection script found an issue. Valid values -
     * 2147483648 to 2147483647”</i>
     * 
     * @param issueDetectedDeviceCount
     *            new value of {@code issueDetectedDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code issueDetectedDeviceCount} field changed
     */
    public DeviceComplianceScriptRunSummary withIssueDetectedDeviceCount(Integer issueDetectedDeviceCount) {
        DeviceComplianceScriptRunSummary _x = _copy();
        _x.changedFields = changedFields.add("issueDetectedDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceComplianceScriptRunSummary");
        _x.issueDetectedDeviceCount = issueDetectedDeviceCount;
        return _x;
    }

    /**
     * <i>“Last run time for the script across all devices”</i>
     * 
     * @return property lastScriptRunDateTime
     */
    @Property(name="lastScriptRunDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastScriptRunDateTime() {
        return Optional.ofNullable(lastScriptRunDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastScriptRunDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Last run time for the script across all devices”</i>
     * 
     * @param lastScriptRunDateTime
     *            new value of {@code lastScriptRunDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastScriptRunDateTime} field changed
     */
    public DeviceComplianceScriptRunSummary withLastScriptRunDateTime(OffsetDateTime lastScriptRunDateTime) {
        DeviceComplianceScriptRunSummary _x = _copy();
        _x.changedFields = changedFields.add("lastScriptRunDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceComplianceScriptRunSummary");
        _x.lastScriptRunDateTime = lastScriptRunDateTime;
        return _x;
    }

    /**
     * <i>“Number of devices for which the detection script did not find an issue and the
     * device is healthy. Valid values -2147483648 to 2147483647”</i>
     * 
     * @return property noIssueDetectedDeviceCount
     */
    @Property(name="noIssueDetectedDeviceCount")
    @JsonIgnore
    public Optional<Integer> getNoIssueDetectedDeviceCount() {
        return Optional.ofNullable(noIssueDetectedDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * noIssueDetectedDeviceCount} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Number of devices for which the detection script did not find an issue and the
     * device is healthy. Valid values -2147483648 to 2147483647”</i>
     * 
     * @param noIssueDetectedDeviceCount
     *            new value of {@code noIssueDetectedDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code noIssueDetectedDeviceCount} field changed
     */
    public DeviceComplianceScriptRunSummary withNoIssueDetectedDeviceCount(Integer noIssueDetectedDeviceCount) {
        DeviceComplianceScriptRunSummary _x = _copy();
        _x.changedFields = changedFields.add("noIssueDetectedDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceComplianceScriptRunSummary");
        _x.noIssueDetectedDeviceCount = noIssueDetectedDeviceCount;
        return _x;
    }

    public DeviceComplianceScriptRunSummary withUnmappedField(String name, Object value) {
        DeviceComplianceScriptRunSummary _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceComplianceScriptRunSummary patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceComplianceScriptRunSummary _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceComplianceScriptRunSummary put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceComplianceScriptRunSummary _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceComplianceScriptRunSummary _copy() {
        DeviceComplianceScriptRunSummary _x = new DeviceComplianceScriptRunSummary();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.detectionScriptErrorDeviceCount = detectionScriptErrorDeviceCount;
        _x.detectionScriptPendingDeviceCount = detectionScriptPendingDeviceCount;
        _x.issueDetectedDeviceCount = issueDetectedDeviceCount;
        _x.lastScriptRunDateTime = lastScriptRunDateTime;
        _x.noIssueDetectedDeviceCount = noIssueDetectedDeviceCount;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceComplianceScriptRunSummary[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("detectionScriptErrorDeviceCount=");
        b.append(this.detectionScriptErrorDeviceCount);
        b.append(", ");
        b.append("detectionScriptPendingDeviceCount=");
        b.append(this.detectionScriptPendingDeviceCount);
        b.append(", ");
        b.append("issueDetectedDeviceCount=");
        b.append(this.issueDetectedDeviceCount);
        b.append(", ");
        b.append("lastScriptRunDateTime=");
        b.append(this.lastScriptRunDateTime);
        b.append(", ");
        b.append("noIssueDetectedDeviceCount=");
        b.append(this.noIssueDetectedDeviceCount);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
