package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.entity.request.DeviceCompliancePolicyRequest;


/**
 * <i>“Device compliance policy group assignment.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "excludeGroup", 
    "targetGroupId"})
@JsonInclude(Include.NON_NULL)
public class DeviceCompliancePolicyGroupAssignment extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceCompliancePolicyGroupAssignment";
    }

    @JsonProperty("excludeGroup")
    protected Boolean excludeGroup;

    @JsonProperty("targetGroupId")
    protected String targetGroupId;

    protected DeviceCompliancePolicyGroupAssignment() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceCompliancePolicyGroupAssignment() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Boolean excludeGroup;
        private String targetGroupId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Indicates if this group is should be excluded. Defaults that the group should be
         * included”</i>
         * 
         * @param excludeGroup
         *            value of {@code excludeGroup} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder excludeGroup(Boolean excludeGroup) {
            this.excludeGroup = excludeGroup;
            this.changedFields = changedFields.add("excludeGroup");
            return this;
        }

        /**
         * <i>“The Id of the AAD group we are targeting the device compliance policy to.”</i>
         * 
         * @param targetGroupId
         *            value of {@code targetGroupId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder targetGroupId(String targetGroupId) {
            this.targetGroupId = targetGroupId;
            this.changedFields = changedFields.add("targetGroupId");
            return this;
        }

        public DeviceCompliancePolicyGroupAssignment build() {
            DeviceCompliancePolicyGroupAssignment _x = new DeviceCompliancePolicyGroupAssignment();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceCompliancePolicyGroupAssignment";
            _x.id = id;
            _x.excludeGroup = excludeGroup;
            _x.targetGroupId = targetGroupId;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Indicates if this group is should be excluded. Defaults that the group should be
     * included”</i>
     * 
     * @return property excludeGroup
     */
    @Property(name="excludeGroup")
    @JsonIgnore
    public Optional<Boolean> getExcludeGroup() {
        return Optional.ofNullable(excludeGroup);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code excludeGroup}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates if this group is should be excluded. Defaults that the group should be
     * included”</i>
     * 
     * @param excludeGroup
     *            new value of {@code excludeGroup} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code excludeGroup} field changed
     */
    public DeviceCompliancePolicyGroupAssignment withExcludeGroup(Boolean excludeGroup) {
        DeviceCompliancePolicyGroupAssignment _x = _copy();
        _x.changedFields = changedFields.add("excludeGroup");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceCompliancePolicyGroupAssignment");
        _x.excludeGroup = excludeGroup;
        return _x;
    }

    /**
     * <i>“The Id of the AAD group we are targeting the device compliance policy to.”</i>
     * 
     * @return property targetGroupId
     */
    @Property(name="targetGroupId")
    @JsonIgnore
    public Optional<String> getTargetGroupId() {
        return Optional.ofNullable(targetGroupId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code targetGroupId}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The Id of the AAD group we are targeting the device compliance policy to.”</i>
     * 
     * @param targetGroupId
     *            new value of {@code targetGroupId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code targetGroupId} field changed
     */
    public DeviceCompliancePolicyGroupAssignment withTargetGroupId(String targetGroupId) {
        DeviceCompliancePolicyGroupAssignment _x = _copy();
        _x.changedFields = changedFields.add("targetGroupId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceCompliancePolicyGroupAssignment");
        _x.targetGroupId = targetGroupId;
        return _x;
    }

    public DeviceCompliancePolicyGroupAssignment withUnmappedField(String name, Object value) {
        DeviceCompliancePolicyGroupAssignment _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“The navigation link to the  device compliance polic targeted.”</i>
     * 
     * @return navigational property deviceCompliancePolicy
     */
    @NavigationProperty(name="deviceCompliancePolicy")
    @JsonIgnore
    public DeviceCompliancePolicyRequest getDeviceCompliancePolicy() {
        return new DeviceCompliancePolicyRequest(contextPath.addSegment("deviceCompliancePolicy"), RequestHelper.getValue(unmappedFields, "deviceCompliancePolicy"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceCompliancePolicyGroupAssignment patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceCompliancePolicyGroupAssignment _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceCompliancePolicyGroupAssignment put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceCompliancePolicyGroupAssignment _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceCompliancePolicyGroupAssignment _copy() {
        DeviceCompliancePolicyGroupAssignment _x = new DeviceCompliancePolicyGroupAssignment();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.excludeGroup = excludeGroup;
        _x.targetGroupId = targetGroupId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceCompliancePolicyGroupAssignment[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("excludeGroup=");
        b.append(this.excludeGroup);
        b.append(", ");
        b.append("targetGroupId=");
        b.append(this.targetGroupId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
