package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;


/**
 * <i>“Device categories provides a way to organize your devices. Using device
 * categories, company administrators can define their own categories that make
 * sense to their company. These categories can then be applied to a device in the
 * Intune Azure console or selected by a user during device enrollment. You can
 * filter reports and create dynamic Azure Active Directory device groups based on
 * device categories.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "description", 
    "displayName", 
    "roleScopeTagIds"})
@JsonInclude(Include.NON_NULL)
public class DeviceCategory extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceCategory";
    }

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("roleScopeTagIds")
    protected List<String> roleScopeTagIds;

    @JsonProperty("roleScopeTagIds@nextLink")
    protected String roleScopeTagIdsNextLink;

    protected DeviceCategory() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceCategory() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String description;
        private String displayName;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Optional description for the device category.”</i>
         * 
         * @param description
         *            value of {@code description} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        /**
         * <i>“Display name for the device category.”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“Optional role scope tags for the device category.”</i>
         * 
         * @param roleScopeTagIds
         *            value of {@code roleScopeTagIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        /**
         * <i>“Optional role scope tags for the device category.”</i>
         * 
         * @param roleScopeTagIds
         *            value of {@code roleScopeTagIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        /**
         * <i>“Optional role scope tags for the device category.”</i>
         * 
         * @param roleScopeTagIdsNextLink
         *            value of {@code roleScopeTagIds@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public DeviceCategory build() {
            DeviceCategory _x = new DeviceCategory();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceCategory";
            _x.id = id;
            _x.description = description;
            _x.displayName = displayName;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Optional description for the device category.”</i>
     * 
     * @return property description
     */
    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code description}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Optional description for the device category.”</i>
     * 
     * @param description
     *            new value of {@code description} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code description} field changed
     */
    public DeviceCategory withDescription(String description) {
        DeviceCategory _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceCategory");
        _x.description = description;
        return _x;
    }

    /**
     * <i>“Display name for the device category.”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Display name for the device category.”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public DeviceCategory withDisplayName(String displayName) {
        DeviceCategory _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceCategory");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“Optional role scope tags for the device category.”</i>
     * 
     * @return property roleScopeTagIds
     */
    @Property(name="roleScopeTagIds")
    @JsonIgnore
    public CollectionPage<String> getRoleScopeTagIds() {
        return new CollectionPage<String>(contextPath, String.class, this.roleScopeTagIds, Optional.ofNullable(roleScopeTagIdsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code roleScopeTagIds}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Optional role scope tags for the device category.”</i>
     * 
     * @param roleScopeTagIds
     *            new value of {@code roleScopeTagIds} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code roleScopeTagIds} field changed
     */
    public DeviceCategory withRoleScopeTagIds(List<String> roleScopeTagIds) {
        DeviceCategory _x = _copy();
        _x.changedFields = changedFields.add("roleScopeTagIds");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceCategory");
        _x.roleScopeTagIds = roleScopeTagIds;
        return _x;
    }

    /**
     * <i>“Optional role scope tags for the device category.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property roleScopeTagIds
     */
    @Property(name="roleScopeTagIds")
    @JsonIgnore
    public CollectionPage<String> getRoleScopeTagIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.roleScopeTagIds, Optional.ofNullable(roleScopeTagIdsNextLink), Collections.emptyList(), options);
    }

    public DeviceCategory withUnmappedField(String name, Object value) {
        DeviceCategory _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceCategory patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceCategory _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceCategory put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceCategory _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceCategory _copy() {
        DeviceCategory _x = new DeviceCategory();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.description = description;
        _x.displayName = displayName;
        _x.roleScopeTagIds = roleScopeTagIds;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceCategory[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
