package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.AndroidManagedAppProtectionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DefaultManagedAppProtectionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceAppManagementTaskCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EnterpriseCodeSigningCertificateCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.IosLobAppProvisioningConfigurationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.IosManagedAppProtectionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ManagedAppPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ManagedAppRegistrationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ManagedAppStatusCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ManagedDeviceMobileAppConfigurationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ManagedEBookCategoryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ManagedEBookCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MdmWindowsInformationProtectionPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MobileAppCategoryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MobileAppCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PolicySetCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SideLoadingKeyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TargetedManagedAppConfigurationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.VppTokenCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WindowsDefenderApplicationControlSupplementalPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WindowsInformationProtectionDeviceRegistrationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WindowsInformationProtectionPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WindowsInformationProtectionWipeActionCollectionRequest;
import odata.msgraph.client.beta.entity.request.SymantecCodeSigningCertificateRequest;
import odata.msgraph.client.beta.entity.request.WindowsManagementAppRequest;
import odata.msgraph.client.beta.enums.MicrosoftStoreForBusinessPortalSelectionOptions;


/**
 * <i>“Singleton entity that acts as a container for all device app management
 * functionality.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "isEnabledForMicrosoftStoreForBusiness", 
    "microsoftStoreForBusinessLanguage", 
    "microsoftStoreForBusinessLastCompletedApplicationSyncTime", 
    "microsoftStoreForBusinessLastSuccessfulSyncDateTime", 
    "microsoftStoreForBusinessPortalSelection", 
    "managedEBookCategories", 
    "enterpriseCodeSigningCertificates", 
    "iosLobAppProvisioningConfigurations", 
    "mobileAppCategories", 
    "mobileAppConfigurations", 
    "mobileApps", 
    "symantecCodeSigningCertificate", 
    "managedEBooks", 
    "policySets", 
    "sideLoadingKeys", 
    "vppTokens", 
    "androidManagedAppProtections", 
    "defaultManagedAppProtections", 
    "iosManagedAppProtections", 
    "managedAppPolicies", 
    "managedAppRegistrations", 
    "managedAppStatuses", 
    "mdmWindowsInformationProtectionPolicies", 
    "targetedManagedAppConfigurations", 
    "windowsInformationProtectionDeviceRegistrations", 
    "windowsInformationProtectionPolicies", 
    "windowsInformationProtectionWipeActions", 
    "deviceAppManagementTasks", 
    "wdacSupplementalPolicies"})
@JsonInclude(Include.NON_NULL)
public class DeviceAppManagement extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceAppManagement";
    }

    @JsonProperty("isEnabledForMicrosoftStoreForBusiness")
    protected Boolean isEnabledForMicrosoftStoreForBusiness;

    @JsonProperty("microsoftStoreForBusinessLanguage")
    protected String microsoftStoreForBusinessLanguage;

    @JsonProperty("microsoftStoreForBusinessLastCompletedApplicationSyncTime")
    protected OffsetDateTime microsoftStoreForBusinessLastCompletedApplicationSyncTime;

    @JsonProperty("microsoftStoreForBusinessLastSuccessfulSyncDateTime")
    protected OffsetDateTime microsoftStoreForBusinessLastSuccessfulSyncDateTime;

    @JsonProperty("microsoftStoreForBusinessPortalSelection")
    protected MicrosoftStoreForBusinessPortalSelectionOptions microsoftStoreForBusinessPortalSelection;

    @JsonProperty("managedEBookCategories")
    protected List<ManagedEBookCategory> managedEBookCategories;

    @JsonProperty("enterpriseCodeSigningCertificates")
    protected List<EnterpriseCodeSigningCertificate> enterpriseCodeSigningCertificates;

    @JsonProperty("iosLobAppProvisioningConfigurations")
    protected List<IosLobAppProvisioningConfiguration> iosLobAppProvisioningConfigurations;

    @JsonProperty("mobileAppCategories")
    protected List<MobileAppCategory> mobileAppCategories;

    @JsonProperty("mobileAppConfigurations")
    protected List<ManagedDeviceMobileAppConfiguration> mobileAppConfigurations;

    @JsonProperty("mobileApps")
    protected List<MobileApp> mobileApps;

    @JsonProperty("symantecCodeSigningCertificate")
    protected SymantecCodeSigningCertificate symantecCodeSigningCertificate;

    @JsonProperty("managedEBooks")
    protected List<ManagedEBook> managedEBooks;

    @JsonProperty("policySets")
    protected List<PolicySet> policySets;

    @JsonProperty("sideLoadingKeys")
    protected List<SideLoadingKey> sideLoadingKeys;

    @JsonProperty("vppTokens")
    protected List<VppToken> vppTokens;

    @JsonProperty("androidManagedAppProtections")
    protected List<AndroidManagedAppProtection> androidManagedAppProtections;

    @JsonProperty("defaultManagedAppProtections")
    protected List<DefaultManagedAppProtection> defaultManagedAppProtections;

    @JsonProperty("iosManagedAppProtections")
    protected List<IosManagedAppProtection> iosManagedAppProtections;

    @JsonProperty("managedAppPolicies")
    protected List<ManagedAppPolicy> managedAppPolicies;

    @JsonProperty("managedAppRegistrations")
    protected List<ManagedAppRegistration> managedAppRegistrations;

    @JsonProperty("managedAppStatuses")
    protected List<ManagedAppStatus> managedAppStatuses;

    @JsonProperty("mdmWindowsInformationProtectionPolicies")
    protected List<MdmWindowsInformationProtectionPolicy> mdmWindowsInformationProtectionPolicies;

    @JsonProperty("targetedManagedAppConfigurations")
    protected List<TargetedManagedAppConfiguration> targetedManagedAppConfigurations;

    @JsonProperty("windowsInformationProtectionDeviceRegistrations")
    protected List<WindowsInformationProtectionDeviceRegistration> windowsInformationProtectionDeviceRegistrations;

    @JsonProperty("windowsInformationProtectionPolicies")
    protected List<WindowsInformationProtectionPolicy> windowsInformationProtectionPolicies;

    @JsonProperty("windowsInformationProtectionWipeActions")
    protected List<WindowsInformationProtectionWipeAction> windowsInformationProtectionWipeActions;

    @JsonProperty("deviceAppManagementTasks")
    protected List<DeviceAppManagementTask> deviceAppManagementTasks;

    @JsonProperty("wdacSupplementalPolicies")
    protected List<WindowsDefenderApplicationControlSupplementalPolicy> wdacSupplementalPolicies;

    protected DeviceAppManagement() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceAppManagement() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Boolean isEnabledForMicrosoftStoreForBusiness;
        private String microsoftStoreForBusinessLanguage;
        private OffsetDateTime microsoftStoreForBusinessLastCompletedApplicationSyncTime;
        private OffsetDateTime microsoftStoreForBusinessLastSuccessfulSyncDateTime;
        private MicrosoftStoreForBusinessPortalSelectionOptions microsoftStoreForBusinessPortalSelection;
        private List<ManagedEBookCategory> managedEBookCategories;
        private List<EnterpriseCodeSigningCertificate> enterpriseCodeSigningCertificates;
        private List<IosLobAppProvisioningConfiguration> iosLobAppProvisioningConfigurations;
        private List<MobileAppCategory> mobileAppCategories;
        private List<ManagedDeviceMobileAppConfiguration> mobileAppConfigurations;
        private List<MobileApp> mobileApps;
        private SymantecCodeSigningCertificate symantecCodeSigningCertificate;
        private List<ManagedEBook> managedEBooks;
        private List<PolicySet> policySets;
        private List<SideLoadingKey> sideLoadingKeys;
        private List<VppToken> vppTokens;
        private List<AndroidManagedAppProtection> androidManagedAppProtections;
        private List<DefaultManagedAppProtection> defaultManagedAppProtections;
        private List<IosManagedAppProtection> iosManagedAppProtections;
        private List<ManagedAppPolicy> managedAppPolicies;
        private List<ManagedAppRegistration> managedAppRegistrations;
        private List<ManagedAppStatus> managedAppStatuses;
        private List<MdmWindowsInformationProtectionPolicy> mdmWindowsInformationProtectionPolicies;
        private List<TargetedManagedAppConfiguration> targetedManagedAppConfigurations;
        private List<WindowsInformationProtectionDeviceRegistration> windowsInformationProtectionDeviceRegistrations;
        private List<WindowsInformationProtectionPolicy> windowsInformationProtectionPolicies;
        private List<WindowsInformationProtectionWipeAction> windowsInformationProtectionWipeActions;
        private List<DeviceAppManagementTask> deviceAppManagementTasks;
        private List<WindowsDefenderApplicationControlSupplementalPolicy> wdacSupplementalPolicies;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Whether the account is enabled for syncing applications from the Microsoft Store
         * for Business.”</i>
         * 
         * @param isEnabledForMicrosoftStoreForBusiness
         *            value of {@code isEnabledForMicrosoftStoreForBusiness} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder isEnabledForMicrosoftStoreForBusiness(Boolean isEnabledForMicrosoftStoreForBusiness) {
            this.isEnabledForMicrosoftStoreForBusiness = isEnabledForMicrosoftStoreForBusiness;
            this.changedFields = changedFields.add("isEnabledForMicrosoftStoreForBusiness");
            return this;
        }

        /**
         * <i>“The locale information used to sync applications from the Microsoft Store for
         * Business. Cultures that are specific to a country/region. The names of these
         * cultures follow RFC 4646 (Windows Vista and later). The format is &amp;lt;languagecode2
         * &amp;gt;-&amp;lt;country/regioncode2&amp;gt;, where &amp;lt;languagecode2&amp;gt; is a lowercase two-letter code
         * derived from ISO 639-1 and &amp;lt;country/regioncode2&amp;gt; is an uppercase two-letter code
         * derived from ISO 3166. For example, en-US for English (United States) is a
         * specific culture.”</i>
         * 
         * @param microsoftStoreForBusinessLanguage
         *            value of {@code microsoftStoreForBusinessLanguage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder microsoftStoreForBusinessLanguage(String microsoftStoreForBusinessLanguage) {
            this.microsoftStoreForBusinessLanguage = microsoftStoreForBusinessLanguage;
            this.changedFields = changedFields.add("microsoftStoreForBusinessLanguage");
            return this;
        }

        /**
         * <i>“The last time an application sync from the Microsoft Store for Business was
         * completed.”</i>
         * 
         * @param microsoftStoreForBusinessLastCompletedApplicationSyncTime
         *            value of {@code microsoftStoreForBusinessLastCompletedApplicationSyncTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder microsoftStoreForBusinessLastCompletedApplicationSyncTime(OffsetDateTime microsoftStoreForBusinessLastCompletedApplicationSyncTime) {
            this.microsoftStoreForBusinessLastCompletedApplicationSyncTime = microsoftStoreForBusinessLastCompletedApplicationSyncTime;
            this.changedFields = changedFields.add("microsoftStoreForBusinessLastCompletedApplicationSyncTime");
            return this;
        }

        /**
         * <i>“The last time the apps from the Microsoft Store for Business were synced
         * successfully for the account.”</i>
         * 
         * @param microsoftStoreForBusinessLastSuccessfulSyncDateTime
         *            value of {@code microsoftStoreForBusinessLastSuccessfulSyncDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder microsoftStoreForBusinessLastSuccessfulSyncDateTime(OffsetDateTime microsoftStoreForBusinessLastSuccessfulSyncDateTime) {
            this.microsoftStoreForBusinessLastSuccessfulSyncDateTime = microsoftStoreForBusinessLastSuccessfulSyncDateTime;
            this.changedFields = changedFields.add("microsoftStoreForBusinessLastSuccessfulSyncDateTime");
            return this;
        }

        /**
         * <i>“The end user portal information is used to sync applications from the Microsoft
         * Store for Business to Intune Company Portal. There are three options to pick
         * from ['Company portal only', 'Company portal and private store', 'Private store
         * only']”</i>
         * 
         * @param microsoftStoreForBusinessPortalSelection
         *            value of {@code microsoftStoreForBusinessPortalSelection} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder microsoftStoreForBusinessPortalSelection(MicrosoftStoreForBusinessPortalSelectionOptions microsoftStoreForBusinessPortalSelection) {
            this.microsoftStoreForBusinessPortalSelection = microsoftStoreForBusinessPortalSelection;
            this.changedFields = changedFields.add("microsoftStoreForBusinessPortalSelection");
            return this;
        }

        /**
         * <i>“The mobile eBook categories.”</i>
         * 
         * @param managedEBookCategories
         *            value of {@code managedEBookCategories} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder managedEBookCategories(List<ManagedEBookCategory> managedEBookCategories) {
            this.managedEBookCategories = managedEBookCategories;
            this.changedFields = changedFields.add("managedEBookCategories");
            return this;
        }

        /**
         * <i>“The mobile eBook categories.”</i>
         * 
         * @param managedEBookCategories
         *            value of {@code managedEBookCategories} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder managedEBookCategories(ManagedEBookCategory... managedEBookCategories) {
            return managedEBookCategories(Arrays.asList(managedEBookCategories));
        }

        /**
         * <i>“The Windows Enterprise Code Signing Certificate.”</i>
         * 
         * @param enterpriseCodeSigningCertificates
         *            value of {@code enterpriseCodeSigningCertificates} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enterpriseCodeSigningCertificates(List<EnterpriseCodeSigningCertificate> enterpriseCodeSigningCertificates) {
            this.enterpriseCodeSigningCertificates = enterpriseCodeSigningCertificates;
            this.changedFields = changedFields.add("enterpriseCodeSigningCertificates");
            return this;
        }

        /**
         * <i>“The Windows Enterprise Code Signing Certificate.”</i>
         * 
         * @param enterpriseCodeSigningCertificates
         *            value of {@code enterpriseCodeSigningCertificates} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enterpriseCodeSigningCertificates(EnterpriseCodeSigningCertificate... enterpriseCodeSigningCertificates) {
            return enterpriseCodeSigningCertificates(Arrays.asList(enterpriseCodeSigningCertificates));
        }

        /**
         * <i>“The IOS Lob App Provisioning Configurations.”</i>
         * 
         * @param iosLobAppProvisioningConfigurations
         *            value of {@code iosLobAppProvisioningConfigurations} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder iosLobAppProvisioningConfigurations(List<IosLobAppProvisioningConfiguration> iosLobAppProvisioningConfigurations) {
            this.iosLobAppProvisioningConfigurations = iosLobAppProvisioningConfigurations;
            this.changedFields = changedFields.add("iosLobAppProvisioningConfigurations");
            return this;
        }

        /**
         * <i>“The IOS Lob App Provisioning Configurations.”</i>
         * 
         * @param iosLobAppProvisioningConfigurations
         *            value of {@code iosLobAppProvisioningConfigurations} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder iosLobAppProvisioningConfigurations(IosLobAppProvisioningConfiguration... iosLobAppProvisioningConfigurations) {
            return iosLobAppProvisioningConfigurations(Arrays.asList(iosLobAppProvisioningConfigurations));
        }

        /**
         * <i>“The mobile app categories.”</i>
         * 
         * @param mobileAppCategories
         *            value of {@code mobileAppCategories} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder mobileAppCategories(List<MobileAppCategory> mobileAppCategories) {
            this.mobileAppCategories = mobileAppCategories;
            this.changedFields = changedFields.add("mobileAppCategories");
            return this;
        }

        /**
         * <i>“The mobile app categories.”</i>
         * 
         * @param mobileAppCategories
         *            value of {@code mobileAppCategories} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder mobileAppCategories(MobileAppCategory... mobileAppCategories) {
            return mobileAppCategories(Arrays.asList(mobileAppCategories));
        }

        /**
         * <i>“The Managed Device Mobile Application Configurations.”</i>
         * 
         * @param mobileAppConfigurations
         *            value of {@code mobileAppConfigurations} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder mobileAppConfigurations(List<ManagedDeviceMobileAppConfiguration> mobileAppConfigurations) {
            this.mobileAppConfigurations = mobileAppConfigurations;
            this.changedFields = changedFields.add("mobileAppConfigurations");
            return this;
        }

        /**
         * <i>“The Managed Device Mobile Application Configurations.”</i>
         * 
         * @param mobileAppConfigurations
         *            value of {@code mobileAppConfigurations} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder mobileAppConfigurations(ManagedDeviceMobileAppConfiguration... mobileAppConfigurations) {
            return mobileAppConfigurations(Arrays.asList(mobileAppConfigurations));
        }

        /**
         * <i>“The mobile apps.”</i>
         * 
         * @param mobileApps
         *            value of {@code mobileApps} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder mobileApps(List<MobileApp> mobileApps) {
            this.mobileApps = mobileApps;
            this.changedFields = changedFields.add("mobileApps");
            return this;
        }

        /**
         * <i>“The mobile apps.”</i>
         * 
         * @param mobileApps
         *            value of {@code mobileApps} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder mobileApps(MobileApp... mobileApps) {
            return mobileApps(Arrays.asList(mobileApps));
        }

        /**
         * <i>“The WinPhone Symantec Code Signing Certificate.”</i>
         * 
         * @param symantecCodeSigningCertificate
         *            value of {@code symantecCodeSigningCertificate} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder symantecCodeSigningCertificate(SymantecCodeSigningCertificate symantecCodeSigningCertificate) {
            this.symantecCodeSigningCertificate = symantecCodeSigningCertificate;
            this.changedFields = changedFields.add("symantecCodeSigningCertificate");
            return this;
        }

        /**
         * <i>“The Managed eBook.”</i>
         * 
         * @param managedEBooks
         *            value of {@code managedEBooks} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder managedEBooks(List<ManagedEBook> managedEBooks) {
            this.managedEBooks = managedEBooks;
            this.changedFields = changedFields.add("managedEBooks");
            return this;
        }

        /**
         * <i>“The Managed eBook.”</i>
         * 
         * @param managedEBooks
         *            value of {@code managedEBooks} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder managedEBooks(ManagedEBook... managedEBooks) {
            return managedEBooks(Arrays.asList(managedEBooks));
        }

        /**
         * <i>“The PolicySet of Policies and Applications”</i>
         * 
         * @param policySets
         *            value of {@code policySets} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder policySets(List<PolicySet> policySets) {
            this.policySets = policySets;
            this.changedFields = changedFields.add("policySets");
            return this;
        }

        /**
         * <i>“The PolicySet of Policies and Applications”</i>
         * 
         * @param policySets
         *            value of {@code policySets} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder policySets(PolicySet... policySets) {
            return policySets(Arrays.asList(policySets));
        }

        /**
         * <i>“Side Loading Keys that are required for the Windows 8 and 8.1 Apps installation.”</i>
         * 
         * @param sideLoadingKeys
         *            value of {@code sideLoadingKeys} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder sideLoadingKeys(List<SideLoadingKey> sideLoadingKeys) {
            this.sideLoadingKeys = sideLoadingKeys;
            this.changedFields = changedFields.add("sideLoadingKeys");
            return this;
        }

        /**
         * <i>“Side Loading Keys that are required for the Windows 8 and 8.1 Apps installation.”</i>
         * 
         * @param sideLoadingKeys
         *            value of {@code sideLoadingKeys} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder sideLoadingKeys(SideLoadingKey... sideLoadingKeys) {
            return sideLoadingKeys(Arrays.asList(sideLoadingKeys));
        }

        /**
         * <i>“List of Vpp tokens for this organization.”</i>
         * 
         * @param vppTokens
         *            value of {@code vppTokens} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder vppTokens(List<VppToken> vppTokens) {
            this.vppTokens = vppTokens;
            this.changedFields = changedFields.add("vppTokens");
            return this;
        }

        /**
         * <i>“List of Vpp tokens for this organization.”</i>
         * 
         * @param vppTokens
         *            value of {@code vppTokens} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder vppTokens(VppToken... vppTokens) {
            return vppTokens(Arrays.asList(vppTokens));
        }

        /**
         * <i>“Android managed app policies.”</i>
         * 
         * @param androidManagedAppProtections
         *            value of {@code androidManagedAppProtections} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder androidManagedAppProtections(List<AndroidManagedAppProtection> androidManagedAppProtections) {
            this.androidManagedAppProtections = androidManagedAppProtections;
            this.changedFields = changedFields.add("androidManagedAppProtections");
            return this;
        }

        /**
         * <i>“Android managed app policies.”</i>
         * 
         * @param androidManagedAppProtections
         *            value of {@code androidManagedAppProtections} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder androidManagedAppProtections(AndroidManagedAppProtection... androidManagedAppProtections) {
            return androidManagedAppProtections(Arrays.asList(androidManagedAppProtections));
        }

        /**
         * <i>“Default managed app policies.”</i>
         * 
         * @param defaultManagedAppProtections
         *            value of {@code defaultManagedAppProtections} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defaultManagedAppProtections(List<DefaultManagedAppProtection> defaultManagedAppProtections) {
            this.defaultManagedAppProtections = defaultManagedAppProtections;
            this.changedFields = changedFields.add("defaultManagedAppProtections");
            return this;
        }

        /**
         * <i>“Default managed app policies.”</i>
         * 
         * @param defaultManagedAppProtections
         *            value of {@code defaultManagedAppProtections} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defaultManagedAppProtections(DefaultManagedAppProtection... defaultManagedAppProtections) {
            return defaultManagedAppProtections(Arrays.asList(defaultManagedAppProtections));
        }

        /**
         * <i>“iOS managed app policies.”</i>
         * 
         * @param iosManagedAppProtections
         *            value of {@code iosManagedAppProtections} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder iosManagedAppProtections(List<IosManagedAppProtection> iosManagedAppProtections) {
            this.iosManagedAppProtections = iosManagedAppProtections;
            this.changedFields = changedFields.add("iosManagedAppProtections");
            return this;
        }

        /**
         * <i>“iOS managed app policies.”</i>
         * 
         * @param iosManagedAppProtections
         *            value of {@code iosManagedAppProtections} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder iosManagedAppProtections(IosManagedAppProtection... iosManagedAppProtections) {
            return iosManagedAppProtections(Arrays.asList(iosManagedAppProtections));
        }

        /**
         * <i>“Managed app policies.”</i>
         * 
         * @param managedAppPolicies
         *            value of {@code managedAppPolicies} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder managedAppPolicies(List<ManagedAppPolicy> managedAppPolicies) {
            this.managedAppPolicies = managedAppPolicies;
            this.changedFields = changedFields.add("managedAppPolicies");
            return this;
        }

        /**
         * <i>“Managed app policies.”</i>
         * 
         * @param managedAppPolicies
         *            value of {@code managedAppPolicies} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder managedAppPolicies(ManagedAppPolicy... managedAppPolicies) {
            return managedAppPolicies(Arrays.asList(managedAppPolicies));
        }

        /**
         * <i>“The managed app registrations.”</i>
         * 
         * @param managedAppRegistrations
         *            value of {@code managedAppRegistrations} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder managedAppRegistrations(List<ManagedAppRegistration> managedAppRegistrations) {
            this.managedAppRegistrations = managedAppRegistrations;
            this.changedFields = changedFields.add("managedAppRegistrations");
            return this;
        }

        /**
         * <i>“The managed app registrations.”</i>
         * 
         * @param managedAppRegistrations
         *            value of {@code managedAppRegistrations} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder managedAppRegistrations(ManagedAppRegistration... managedAppRegistrations) {
            return managedAppRegistrations(Arrays.asList(managedAppRegistrations));
        }

        /**
         * <i>“The managed app statuses.”</i>
         * 
         * @param managedAppStatuses
         *            value of {@code managedAppStatuses} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder managedAppStatuses(List<ManagedAppStatus> managedAppStatuses) {
            this.managedAppStatuses = managedAppStatuses;
            this.changedFields = changedFields.add("managedAppStatuses");
            return this;
        }

        /**
         * <i>“The managed app statuses.”</i>
         * 
         * @param managedAppStatuses
         *            value of {@code managedAppStatuses} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder managedAppStatuses(ManagedAppStatus... managedAppStatuses) {
            return managedAppStatuses(Arrays.asList(managedAppStatuses));
        }

        /**
         * <i>“Windows information protection for apps running on devices which are MDM
         * enrolled.”</i>
         * 
         * @param mdmWindowsInformationProtectionPolicies
         *            value of {@code mdmWindowsInformationProtectionPolicies} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder mdmWindowsInformationProtectionPolicies(List<MdmWindowsInformationProtectionPolicy> mdmWindowsInformationProtectionPolicies) {
            this.mdmWindowsInformationProtectionPolicies = mdmWindowsInformationProtectionPolicies;
            this.changedFields = changedFields.add("mdmWindowsInformationProtectionPolicies");
            return this;
        }

        /**
         * <i>“Windows information protection for apps running on devices which are MDM
         * enrolled.”</i>
         * 
         * @param mdmWindowsInformationProtectionPolicies
         *            value of {@code mdmWindowsInformationProtectionPolicies} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder mdmWindowsInformationProtectionPolicies(MdmWindowsInformationProtectionPolicy... mdmWindowsInformationProtectionPolicies) {
            return mdmWindowsInformationProtectionPolicies(Arrays.asList(mdmWindowsInformationProtectionPolicies));
        }

        /**
         * <i>“Targeted managed app configurations.”</i>
         * 
         * @param targetedManagedAppConfigurations
         *            value of {@code targetedManagedAppConfigurations} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder targetedManagedAppConfigurations(List<TargetedManagedAppConfiguration> targetedManagedAppConfigurations) {
            this.targetedManagedAppConfigurations = targetedManagedAppConfigurations;
            this.changedFields = changedFields.add("targetedManagedAppConfigurations");
            return this;
        }

        /**
         * <i>“Targeted managed app configurations.”</i>
         * 
         * @param targetedManagedAppConfigurations
         *            value of {@code targetedManagedAppConfigurations} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder targetedManagedAppConfigurations(TargetedManagedAppConfiguration... targetedManagedAppConfigurations) {
            return targetedManagedAppConfigurations(Arrays.asList(targetedManagedAppConfigurations));
        }

        /**
         * <i>“Windows information protection device registrations that are not MDM enrolled.”</i>
         * 
         * @param windowsInformationProtectionDeviceRegistrations
         *            value of {@code windowsInformationProtectionDeviceRegistrations} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windowsInformationProtectionDeviceRegistrations(List<WindowsInformationProtectionDeviceRegistration> windowsInformationProtectionDeviceRegistrations) {
            this.windowsInformationProtectionDeviceRegistrations = windowsInformationProtectionDeviceRegistrations;
            this.changedFields = changedFields.add("windowsInformationProtectionDeviceRegistrations");
            return this;
        }

        /**
         * <i>“Windows information protection device registrations that are not MDM enrolled.”</i>
         * 
         * @param windowsInformationProtectionDeviceRegistrations
         *            value of {@code windowsInformationProtectionDeviceRegistrations} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windowsInformationProtectionDeviceRegistrations(WindowsInformationProtectionDeviceRegistration... windowsInformationProtectionDeviceRegistrations) {
            return windowsInformationProtectionDeviceRegistrations(Arrays.asList(windowsInformationProtectionDeviceRegistrations));
        }

        /**
         * <i>“Windows information protection for apps running on devices which are not MDM
         * enrolled.”</i>
         * 
         * @param windowsInformationProtectionPolicies
         *            value of {@code windowsInformationProtectionPolicies} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windowsInformationProtectionPolicies(List<WindowsInformationProtectionPolicy> windowsInformationProtectionPolicies) {
            this.windowsInformationProtectionPolicies = windowsInformationProtectionPolicies;
            this.changedFields = changedFields.add("windowsInformationProtectionPolicies");
            return this;
        }

        /**
         * <i>“Windows information protection for apps running on devices which are not MDM
         * enrolled.”</i>
         * 
         * @param windowsInformationProtectionPolicies
         *            value of {@code windowsInformationProtectionPolicies} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windowsInformationProtectionPolicies(WindowsInformationProtectionPolicy... windowsInformationProtectionPolicies) {
            return windowsInformationProtectionPolicies(Arrays.asList(windowsInformationProtectionPolicies));
        }

        /**
         * <i>“Windows information protection wipe actions.”</i>
         * 
         * @param windowsInformationProtectionWipeActions
         *            value of {@code windowsInformationProtectionWipeActions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windowsInformationProtectionWipeActions(List<WindowsInformationProtectionWipeAction> windowsInformationProtectionWipeActions) {
            this.windowsInformationProtectionWipeActions = windowsInformationProtectionWipeActions;
            this.changedFields = changedFields.add("windowsInformationProtectionWipeActions");
            return this;
        }

        /**
         * <i>“Windows information protection wipe actions.”</i>
         * 
         * @param windowsInformationProtectionWipeActions
         *            value of {@code windowsInformationProtectionWipeActions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windowsInformationProtectionWipeActions(WindowsInformationProtectionWipeAction... windowsInformationProtectionWipeActions) {
            return windowsInformationProtectionWipeActions(Arrays.asList(windowsInformationProtectionWipeActions));
        }

        /**
         * <i>“Device app management tasks.”</i>
         * 
         * @param deviceAppManagementTasks
         *            value of {@code deviceAppManagementTasks} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceAppManagementTasks(List<DeviceAppManagementTask> deviceAppManagementTasks) {
            this.deviceAppManagementTasks = deviceAppManagementTasks;
            this.changedFields = changedFields.add("deviceAppManagementTasks");
            return this;
        }

        /**
         * <i>“Device app management tasks.”</i>
         * 
         * @param deviceAppManagementTasks
         *            value of {@code deviceAppManagementTasks} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceAppManagementTasks(DeviceAppManagementTask... deviceAppManagementTasks) {
            return deviceAppManagementTasks(Arrays.asList(deviceAppManagementTasks));
        }

        /**
         * <i>“The collection of Windows Defender Application Control Supplemental Policies.”</i>
         * 
         * @param wdacSupplementalPolicies
         *            value of {@code wdacSupplementalPolicies} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder wdacSupplementalPolicies(List<WindowsDefenderApplicationControlSupplementalPolicy> wdacSupplementalPolicies) {
            this.wdacSupplementalPolicies = wdacSupplementalPolicies;
            this.changedFields = changedFields.add("wdacSupplementalPolicies");
            return this;
        }

        /**
         * <i>“The collection of Windows Defender Application Control Supplemental Policies.”</i>
         * 
         * @param wdacSupplementalPolicies
         *            value of {@code wdacSupplementalPolicies} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder wdacSupplementalPolicies(WindowsDefenderApplicationControlSupplementalPolicy... wdacSupplementalPolicies) {
            return wdacSupplementalPolicies(Arrays.asList(wdacSupplementalPolicies));
        }

        public DeviceAppManagement build() {
            DeviceAppManagement _x = new DeviceAppManagement();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceAppManagement";
            _x.id = id;
            _x.isEnabledForMicrosoftStoreForBusiness = isEnabledForMicrosoftStoreForBusiness;
            _x.microsoftStoreForBusinessLanguage = microsoftStoreForBusinessLanguage;
            _x.microsoftStoreForBusinessLastCompletedApplicationSyncTime = microsoftStoreForBusinessLastCompletedApplicationSyncTime;
            _x.microsoftStoreForBusinessLastSuccessfulSyncDateTime = microsoftStoreForBusinessLastSuccessfulSyncDateTime;
            _x.microsoftStoreForBusinessPortalSelection = microsoftStoreForBusinessPortalSelection;
            _x.managedEBookCategories = managedEBookCategories;
            _x.enterpriseCodeSigningCertificates = enterpriseCodeSigningCertificates;
            _x.iosLobAppProvisioningConfigurations = iosLobAppProvisioningConfigurations;
            _x.mobileAppCategories = mobileAppCategories;
            _x.mobileAppConfigurations = mobileAppConfigurations;
            _x.mobileApps = mobileApps;
            _x.symantecCodeSigningCertificate = symantecCodeSigningCertificate;
            _x.managedEBooks = managedEBooks;
            _x.policySets = policySets;
            _x.sideLoadingKeys = sideLoadingKeys;
            _x.vppTokens = vppTokens;
            _x.androidManagedAppProtections = androidManagedAppProtections;
            _x.defaultManagedAppProtections = defaultManagedAppProtections;
            _x.iosManagedAppProtections = iosManagedAppProtections;
            _x.managedAppPolicies = managedAppPolicies;
            _x.managedAppRegistrations = managedAppRegistrations;
            _x.managedAppStatuses = managedAppStatuses;
            _x.mdmWindowsInformationProtectionPolicies = mdmWindowsInformationProtectionPolicies;
            _x.targetedManagedAppConfigurations = targetedManagedAppConfigurations;
            _x.windowsInformationProtectionDeviceRegistrations = windowsInformationProtectionDeviceRegistrations;
            _x.windowsInformationProtectionPolicies = windowsInformationProtectionPolicies;
            _x.windowsInformationProtectionWipeActions = windowsInformationProtectionWipeActions;
            _x.deviceAppManagementTasks = deviceAppManagementTasks;
            _x.wdacSupplementalPolicies = wdacSupplementalPolicies;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Whether the account is enabled for syncing applications from the Microsoft Store
     * for Business.”</i>
     * 
     * @return property isEnabledForMicrosoftStoreForBusiness
     */
    @Property(name="isEnabledForMicrosoftStoreForBusiness")
    @JsonIgnore
    public Optional<Boolean> getIsEnabledForMicrosoftStoreForBusiness() {
        return Optional.ofNullable(isEnabledForMicrosoftStoreForBusiness);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * isEnabledForMicrosoftStoreForBusiness} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Whether the account is enabled for syncing applications from the Microsoft Store
     * for Business.”</i>
     * 
     * @param isEnabledForMicrosoftStoreForBusiness
     *            new value of {@code isEnabledForMicrosoftStoreForBusiness} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code isEnabledForMicrosoftStoreForBusiness} field changed
     */
    public DeviceAppManagement withIsEnabledForMicrosoftStoreForBusiness(Boolean isEnabledForMicrosoftStoreForBusiness) {
        DeviceAppManagement _x = _copy();
        _x.changedFields = changedFields.add("isEnabledForMicrosoftStoreForBusiness");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceAppManagement");
        _x.isEnabledForMicrosoftStoreForBusiness = isEnabledForMicrosoftStoreForBusiness;
        return _x;
    }

    /**
     * <i>“The locale information used to sync applications from the Microsoft Store for
     * Business. Cultures that are specific to a country/region. The names of these
     * cultures follow RFC 4646 (Windows Vista and later). The format is &amp;lt;languagecode2
     * &amp;gt;-&amp;lt;country/regioncode2&amp;gt;, where &amp;lt;languagecode2&amp;gt; is a lowercase two-letter code
     * derived from ISO 639-1 and &amp;lt;country/regioncode2&amp;gt; is an uppercase two-letter code
     * derived from ISO 3166. For example, en-US for English (United States) is a
     * specific culture.”</i>
     * 
     * @return property microsoftStoreForBusinessLanguage
     */
    @Property(name="microsoftStoreForBusinessLanguage")
    @JsonIgnore
    public Optional<String> getMicrosoftStoreForBusinessLanguage() {
        return Optional.ofNullable(microsoftStoreForBusinessLanguage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * microsoftStoreForBusinessLanguage} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“The locale information used to sync applications from the Microsoft Store for
     * Business. Cultures that are specific to a country/region. The names of these
     * cultures follow RFC 4646 (Windows Vista and later). The format is &amp;lt;languagecode2
     * &amp;gt;-&amp;lt;country/regioncode2&amp;gt;, where &amp;lt;languagecode2&amp;gt; is a lowercase two-letter code
     * derived from ISO 639-1 and &amp;lt;country/regioncode2&amp;gt; is an uppercase two-letter code
     * derived from ISO 3166. For example, en-US for English (United States) is a
     * specific culture.”</i>
     * 
     * @param microsoftStoreForBusinessLanguage
     *            new value of {@code microsoftStoreForBusinessLanguage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code microsoftStoreForBusinessLanguage} field changed
     */
    public DeviceAppManagement withMicrosoftStoreForBusinessLanguage(String microsoftStoreForBusinessLanguage) {
        DeviceAppManagement _x = _copy();
        _x.changedFields = changedFields.add("microsoftStoreForBusinessLanguage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceAppManagement");
        _x.microsoftStoreForBusinessLanguage = microsoftStoreForBusinessLanguage;
        return _x;
    }

    /**
     * <i>“The last time an application sync from the Microsoft Store for Business was
     * completed.”</i>
     * 
     * @return property microsoftStoreForBusinessLastCompletedApplicationSyncTime
     */
    @Property(name="microsoftStoreForBusinessLastCompletedApplicationSyncTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getMicrosoftStoreForBusinessLastCompletedApplicationSyncTime() {
        return Optional.ofNullable(microsoftStoreForBusinessLastCompletedApplicationSyncTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * microsoftStoreForBusinessLastCompletedApplicationSyncTime} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“The last time an application sync from the Microsoft Store for Business was
     * completed.”</i>
     * 
     * @param microsoftStoreForBusinessLastCompletedApplicationSyncTime
     *            new value of {@code microsoftStoreForBusinessLastCompletedApplicationSyncTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code microsoftStoreForBusinessLastCompletedApplicationSyncTime} field changed
     */
    public DeviceAppManagement withMicrosoftStoreForBusinessLastCompletedApplicationSyncTime(OffsetDateTime microsoftStoreForBusinessLastCompletedApplicationSyncTime) {
        DeviceAppManagement _x = _copy();
        _x.changedFields = changedFields.add("microsoftStoreForBusinessLastCompletedApplicationSyncTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceAppManagement");
        _x.microsoftStoreForBusinessLastCompletedApplicationSyncTime = microsoftStoreForBusinessLastCompletedApplicationSyncTime;
        return _x;
    }

    /**
     * <i>“The last time the apps from the Microsoft Store for Business were synced
     * successfully for the account.”</i>
     * 
     * @return property microsoftStoreForBusinessLastSuccessfulSyncDateTime
     */
    @Property(name="microsoftStoreForBusinessLastSuccessfulSyncDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getMicrosoftStoreForBusinessLastSuccessfulSyncDateTime() {
        return Optional.ofNullable(microsoftStoreForBusinessLastSuccessfulSyncDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * microsoftStoreForBusinessLastSuccessfulSyncDateTime} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“The last time the apps from the Microsoft Store for Business were synced
     * successfully for the account.”</i>
     * 
     * @param microsoftStoreForBusinessLastSuccessfulSyncDateTime
     *            new value of {@code microsoftStoreForBusinessLastSuccessfulSyncDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code microsoftStoreForBusinessLastSuccessfulSyncDateTime} field changed
     */
    public DeviceAppManagement withMicrosoftStoreForBusinessLastSuccessfulSyncDateTime(OffsetDateTime microsoftStoreForBusinessLastSuccessfulSyncDateTime) {
        DeviceAppManagement _x = _copy();
        _x.changedFields = changedFields.add("microsoftStoreForBusinessLastSuccessfulSyncDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceAppManagement");
        _x.microsoftStoreForBusinessLastSuccessfulSyncDateTime = microsoftStoreForBusinessLastSuccessfulSyncDateTime;
        return _x;
    }

    /**
     * <i>“The end user portal information is used to sync applications from the Microsoft
     * Store for Business to Intune Company Portal. There are three options to pick
     * from ['Company portal only', 'Company portal and private store', 'Private store
     * only']”</i>
     * 
     * @return property microsoftStoreForBusinessPortalSelection
     */
    @Property(name="microsoftStoreForBusinessPortalSelection")
    @JsonIgnore
    public Optional<MicrosoftStoreForBusinessPortalSelectionOptions> getMicrosoftStoreForBusinessPortalSelection() {
        return Optional.ofNullable(microsoftStoreForBusinessPortalSelection);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * microsoftStoreForBusinessPortalSelection} field changed. Field description below
     * . The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“The end user portal information is used to sync applications from the Microsoft
     * Store for Business to Intune Company Portal. There are three options to pick
     * from ['Company portal only', 'Company portal and private store', 'Private store
     * only']”</i>
     * 
     * @param microsoftStoreForBusinessPortalSelection
     *            new value of {@code microsoftStoreForBusinessPortalSelection} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code microsoftStoreForBusinessPortalSelection} field changed
     */
    public DeviceAppManagement withMicrosoftStoreForBusinessPortalSelection(MicrosoftStoreForBusinessPortalSelectionOptions microsoftStoreForBusinessPortalSelection) {
        DeviceAppManagement _x = _copy();
        _x.changedFields = changedFields.add("microsoftStoreForBusinessPortalSelection");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceAppManagement");
        _x.microsoftStoreForBusinessPortalSelection = microsoftStoreForBusinessPortalSelection;
        return _x;
    }

    public DeviceAppManagement withUnmappedField(String name, Object value) {
        DeviceAppManagement _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“The mobile eBook categories.”</i>
     * 
     * @return navigational property managedEBookCategories
     */
    @NavigationProperty(name="managedEBookCategories")
    @JsonIgnore
    public ManagedEBookCategoryCollectionRequest getManagedEBookCategories() {
        return new ManagedEBookCategoryCollectionRequest(
                        contextPath.addSegment("managedEBookCategories"), Optional.ofNullable(managedEBookCategories));
    }

    /**
     * <i>“The Windows Enterprise Code Signing Certificate.”</i>
     * 
     * @return navigational property enterpriseCodeSigningCertificates
     */
    @NavigationProperty(name="enterpriseCodeSigningCertificates")
    @JsonIgnore
    public EnterpriseCodeSigningCertificateCollectionRequest getEnterpriseCodeSigningCertificates() {
        return new EnterpriseCodeSigningCertificateCollectionRequest(
                        contextPath.addSegment("enterpriseCodeSigningCertificates"), Optional.ofNullable(enterpriseCodeSigningCertificates));
    }

    /**
     * <i>“The IOS Lob App Provisioning Configurations.”</i>
     * 
     * @return navigational property iosLobAppProvisioningConfigurations
     */
    @NavigationProperty(name="iosLobAppProvisioningConfigurations")
    @JsonIgnore
    public IosLobAppProvisioningConfigurationCollectionRequest getIosLobAppProvisioningConfigurations() {
        return new IosLobAppProvisioningConfigurationCollectionRequest(
                        contextPath.addSegment("iosLobAppProvisioningConfigurations"), Optional.ofNullable(iosLobAppProvisioningConfigurations));
    }

    /**
     * <i>“The mobile app categories.”</i>
     * 
     * @return navigational property mobileAppCategories
     */
    @NavigationProperty(name="mobileAppCategories")
    @JsonIgnore
    public MobileAppCategoryCollectionRequest getMobileAppCategories() {
        return new MobileAppCategoryCollectionRequest(
                        contextPath.addSegment("mobileAppCategories"), Optional.ofNullable(mobileAppCategories));
    }

    /**
     * <i>“The Managed Device Mobile Application Configurations.”</i>
     * 
     * @return navigational property mobileAppConfigurations
     */
    @NavigationProperty(name="mobileAppConfigurations")
    @JsonIgnore
    public ManagedDeviceMobileAppConfigurationCollectionRequest getMobileAppConfigurations() {
        return new ManagedDeviceMobileAppConfigurationCollectionRequest(
                        contextPath.addSegment("mobileAppConfigurations"), Optional.ofNullable(mobileAppConfigurations));
    }

    /**
     * <i>“The mobile apps.”</i>
     * 
     * @return navigational property mobileApps
     */
    @NavigationProperty(name="mobileApps")
    @JsonIgnore
    public MobileAppCollectionRequest getMobileApps() {
        return new MobileAppCollectionRequest(
                        contextPath.addSegment("mobileApps"), Optional.ofNullable(mobileApps));
    }

    /**
     * <i>“The WinPhone Symantec Code Signing Certificate.”</i>
     * 
     * @return navigational property symantecCodeSigningCertificate
     */
    @NavigationProperty(name="symantecCodeSigningCertificate")
    @JsonIgnore
    public SymantecCodeSigningCertificateRequest getSymantecCodeSigningCertificate() {
        return new SymantecCodeSigningCertificateRequest(contextPath.addSegment("symantecCodeSigningCertificate"), Optional.ofNullable(symantecCodeSigningCertificate));
    }

    /**
     * <i>“The Managed eBook.”</i>
     * 
     * @return navigational property managedEBooks
     */
    @NavigationProperty(name="managedEBooks")
    @JsonIgnore
    public ManagedEBookCollectionRequest getManagedEBooks() {
        return new ManagedEBookCollectionRequest(
                        contextPath.addSegment("managedEBooks"), Optional.ofNullable(managedEBooks));
    }

    /**
     * <i>“The PolicySet of Policies and Applications”</i>
     * 
     * @return navigational property policySets
     */
    @NavigationProperty(name="policySets")
    @JsonIgnore
    public PolicySetCollectionRequest getPolicySets() {
        return new PolicySetCollectionRequest(
                        contextPath.addSegment("policySets"), Optional.ofNullable(policySets));
    }

    /**
     * <i>“Side Loading Keys that are required for the Windows 8 and 8.1 Apps installation.”</i>
     * 
     * @return navigational property sideLoadingKeys
     */
    @NavigationProperty(name="sideLoadingKeys")
    @JsonIgnore
    public SideLoadingKeyCollectionRequest getSideLoadingKeys() {
        return new SideLoadingKeyCollectionRequest(
                        contextPath.addSegment("sideLoadingKeys"), Optional.ofNullable(sideLoadingKeys));
    }

    /**
     * <i>“List of Vpp tokens for this organization.”</i>
     * 
     * @return navigational property vppTokens
     */
    @NavigationProperty(name="vppTokens")
    @JsonIgnore
    public VppTokenCollectionRequest getVppTokens() {
        return new VppTokenCollectionRequest(
                        contextPath.addSegment("vppTokens"), Optional.ofNullable(vppTokens));
    }

    /**
     * <i>“Windows management app.”</i>
     * 
     * @return navigational property windowsManagementApp
     */
    @NavigationProperty(name="windowsManagementApp")
    @JsonIgnore
    public WindowsManagementAppRequest getWindowsManagementApp() {
        return new WindowsManagementAppRequest(contextPath.addSegment("windowsManagementApp"), RequestHelper.getValue(unmappedFields, "windowsManagementApp"));
    }

    /**
     * <i>“Android managed app policies.”</i>
     * 
     * @return navigational property androidManagedAppProtections
     */
    @NavigationProperty(name="androidManagedAppProtections")
    @JsonIgnore
    public AndroidManagedAppProtectionCollectionRequest getAndroidManagedAppProtections() {
        return new AndroidManagedAppProtectionCollectionRequest(
                        contextPath.addSegment("androidManagedAppProtections"), Optional.ofNullable(androidManagedAppProtections));
    }

    /**
     * <i>“Default managed app policies.”</i>
     * 
     * @return navigational property defaultManagedAppProtections
     */
    @NavigationProperty(name="defaultManagedAppProtections")
    @JsonIgnore
    public DefaultManagedAppProtectionCollectionRequest getDefaultManagedAppProtections() {
        return new DefaultManagedAppProtectionCollectionRequest(
                        contextPath.addSegment("defaultManagedAppProtections"), Optional.ofNullable(defaultManagedAppProtections));
    }

    /**
     * <i>“iOS managed app policies.”</i>
     * 
     * @return navigational property iosManagedAppProtections
     */
    @NavigationProperty(name="iosManagedAppProtections")
    @JsonIgnore
    public IosManagedAppProtectionCollectionRequest getIosManagedAppProtections() {
        return new IosManagedAppProtectionCollectionRequest(
                        contextPath.addSegment("iosManagedAppProtections"), Optional.ofNullable(iosManagedAppProtections));
    }

    /**
     * <i>“Managed app policies.”</i>
     * 
     * @return navigational property managedAppPolicies
     */
    @NavigationProperty(name="managedAppPolicies")
    @JsonIgnore
    public ManagedAppPolicyCollectionRequest getManagedAppPolicies() {
        return new ManagedAppPolicyCollectionRequest(
                        contextPath.addSegment("managedAppPolicies"), Optional.ofNullable(managedAppPolicies));
    }

    /**
     * <i>“The managed app registrations.”</i>
     * 
     * @return navigational property managedAppRegistrations
     */
    @NavigationProperty(name="managedAppRegistrations")
    @JsonIgnore
    public ManagedAppRegistrationCollectionRequest getManagedAppRegistrations() {
        return new ManagedAppRegistrationCollectionRequest(
                        contextPath.addSegment("managedAppRegistrations"), Optional.ofNullable(managedAppRegistrations));
    }

    /**
     * <i>“The managed app statuses.”</i>
     * 
     * @return navigational property managedAppStatuses
     */
    @NavigationProperty(name="managedAppStatuses")
    @JsonIgnore
    public ManagedAppStatusCollectionRequest getManagedAppStatuses() {
        return new ManagedAppStatusCollectionRequest(
                        contextPath.addSegment("managedAppStatuses"), Optional.ofNullable(managedAppStatuses));
    }

    /**
     * <i>“Windows information protection for apps running on devices which are MDM
     * enrolled.”</i>
     * 
     * @return navigational property mdmWindowsInformationProtectionPolicies
     */
    @NavigationProperty(name="mdmWindowsInformationProtectionPolicies")
    @JsonIgnore
    public MdmWindowsInformationProtectionPolicyCollectionRequest getMdmWindowsInformationProtectionPolicies() {
        return new MdmWindowsInformationProtectionPolicyCollectionRequest(
                        contextPath.addSegment("mdmWindowsInformationProtectionPolicies"), Optional.ofNullable(mdmWindowsInformationProtectionPolicies));
    }

    /**
     * <i>“Targeted managed app configurations.”</i>
     * 
     * @return navigational property targetedManagedAppConfigurations
     */
    @NavigationProperty(name="targetedManagedAppConfigurations")
    @JsonIgnore
    public TargetedManagedAppConfigurationCollectionRequest getTargetedManagedAppConfigurations() {
        return new TargetedManagedAppConfigurationCollectionRequest(
                        contextPath.addSegment("targetedManagedAppConfigurations"), Optional.ofNullable(targetedManagedAppConfigurations));
    }

    /**
     * <i>“Windows information protection device registrations that are not MDM enrolled.”</i>
     * 
     * @return navigational property windowsInformationProtectionDeviceRegistrations
     */
    @NavigationProperty(name="windowsInformationProtectionDeviceRegistrations")
    @JsonIgnore
    public WindowsInformationProtectionDeviceRegistrationCollectionRequest getWindowsInformationProtectionDeviceRegistrations() {
        return new WindowsInformationProtectionDeviceRegistrationCollectionRequest(
                        contextPath.addSegment("windowsInformationProtectionDeviceRegistrations"), Optional.ofNullable(windowsInformationProtectionDeviceRegistrations));
    }

    /**
     * <i>“Windows information protection for apps running on devices which are not MDM
     * enrolled.”</i>
     * 
     * @return navigational property windowsInformationProtectionPolicies
     */
    @NavigationProperty(name="windowsInformationProtectionPolicies")
    @JsonIgnore
    public WindowsInformationProtectionPolicyCollectionRequest getWindowsInformationProtectionPolicies() {
        return new WindowsInformationProtectionPolicyCollectionRequest(
                        contextPath.addSegment("windowsInformationProtectionPolicies"), Optional.ofNullable(windowsInformationProtectionPolicies));
    }

    /**
     * <i>“Windows information protection wipe actions.”</i>
     * 
     * @return navigational property windowsInformationProtectionWipeActions
     */
    @NavigationProperty(name="windowsInformationProtectionWipeActions")
    @JsonIgnore
    public WindowsInformationProtectionWipeActionCollectionRequest getWindowsInformationProtectionWipeActions() {
        return new WindowsInformationProtectionWipeActionCollectionRequest(
                        contextPath.addSegment("windowsInformationProtectionWipeActions"), Optional.ofNullable(windowsInformationProtectionWipeActions));
    }

    /**
     * <i>“Device app management tasks.”</i>
     * 
     * @return navigational property deviceAppManagementTasks
     */
    @NavigationProperty(name="deviceAppManagementTasks")
    @JsonIgnore
    public DeviceAppManagementTaskCollectionRequest getDeviceAppManagementTasks() {
        return new DeviceAppManagementTaskCollectionRequest(
                        contextPath.addSegment("deviceAppManagementTasks"), Optional.ofNullable(deviceAppManagementTasks));
    }

    /**
     * <i>“The collection of Windows Defender Application Control Supplemental Policies.”</i>
     * 
     * @return navigational property wdacSupplementalPolicies
     */
    @NavigationProperty(name="wdacSupplementalPolicies")
    @JsonIgnore
    public WindowsDefenderApplicationControlSupplementalPolicyCollectionRequest getWdacSupplementalPolicies() {
        return new WindowsDefenderApplicationControlSupplementalPolicyCollectionRequest(
                        contextPath.addSegment("wdacSupplementalPolicies"), Optional.ofNullable(wdacSupplementalPolicies));
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * managedEBookCategories} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The mobile eBook categories.”</i>
     * 
     * @param managedEBookCategories
     *            new value of {@code managedEBookCategories} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code managedEBookCategories} field changed
     */
    public DeviceAppManagement withManagedEBookCategories(List<ManagedEBookCategory> managedEBookCategories) {
        DeviceAppManagement _x = _copy();
        _x.changedFields = changedFields.add("managedEBookCategories");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceAppManagement");
        _x.managedEBookCategories = managedEBookCategories;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * enterpriseCodeSigningCertificates} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“The Windows Enterprise Code Signing Certificate.”</i>
     * 
     * @param enterpriseCodeSigningCertificates
     *            new value of {@code enterpriseCodeSigningCertificates} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enterpriseCodeSigningCertificates} field changed
     */
    public DeviceAppManagement withEnterpriseCodeSigningCertificates(List<EnterpriseCodeSigningCertificate> enterpriseCodeSigningCertificates) {
        DeviceAppManagement _x = _copy();
        _x.changedFields = changedFields.add("enterpriseCodeSigningCertificates");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceAppManagement");
        _x.enterpriseCodeSigningCertificates = enterpriseCodeSigningCertificates;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * iosLobAppProvisioningConfigurations} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“The IOS Lob App Provisioning Configurations.”</i>
     * 
     * @param iosLobAppProvisioningConfigurations
     *            new value of {@code iosLobAppProvisioningConfigurations} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code iosLobAppProvisioningConfigurations} field changed
     */
    public DeviceAppManagement withIosLobAppProvisioningConfigurations(List<IosLobAppProvisioningConfiguration> iosLobAppProvisioningConfigurations) {
        DeviceAppManagement _x = _copy();
        _x.changedFields = changedFields.add("iosLobAppProvisioningConfigurations");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceAppManagement");
        _x.iosLobAppProvisioningConfigurations = iosLobAppProvisioningConfigurations;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * mobileAppCategories} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The mobile app categories.”</i>
     * 
     * @param mobileAppCategories
     *            new value of {@code mobileAppCategories} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code mobileAppCategories} field changed
     */
    public DeviceAppManagement withMobileAppCategories(List<MobileAppCategory> mobileAppCategories) {
        DeviceAppManagement _x = _copy();
        _x.changedFields = changedFields.add("mobileAppCategories");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceAppManagement");
        _x.mobileAppCategories = mobileAppCategories;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * mobileAppConfigurations} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The Managed Device Mobile Application Configurations.”</i>
     * 
     * @param mobileAppConfigurations
     *            new value of {@code mobileAppConfigurations} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code mobileAppConfigurations} field changed
     */
    public DeviceAppManagement withMobileAppConfigurations(List<ManagedDeviceMobileAppConfiguration> mobileAppConfigurations) {
        DeviceAppManagement _x = _copy();
        _x.changedFields = changedFields.add("mobileAppConfigurations");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceAppManagement");
        _x.mobileAppConfigurations = mobileAppConfigurations;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code mobileApps} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The mobile apps.”</i>
     * 
     * @param mobileApps
     *            new value of {@code mobileApps} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code mobileApps} field changed
     */
    public DeviceAppManagement withMobileApps(List<MobileApp> mobileApps) {
        DeviceAppManagement _x = _copy();
        _x.changedFields = changedFields.add("mobileApps");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceAppManagement");
        _x.mobileApps = mobileApps;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * symantecCodeSigningCertificate} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“The WinPhone Symantec Code Signing Certificate.”</i>
     * 
     * @param symantecCodeSigningCertificate
     *            new value of {@code symantecCodeSigningCertificate} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code symantecCodeSigningCertificate} field changed
     */
    public DeviceAppManagement withSymantecCodeSigningCertificate(SymantecCodeSigningCertificate symantecCodeSigningCertificate) {
        DeviceAppManagement _x = _copy();
        _x.changedFields = changedFields.add("symantecCodeSigningCertificate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceAppManagement");
        _x.symantecCodeSigningCertificate = symantecCodeSigningCertificate;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code managedEBooks}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The Managed eBook.”</i>
     * 
     * @param managedEBooks
     *            new value of {@code managedEBooks} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code managedEBooks} field changed
     */
    public DeviceAppManagement withManagedEBooks(List<ManagedEBook> managedEBooks) {
        DeviceAppManagement _x = _copy();
        _x.changedFields = changedFields.add("managedEBooks");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceAppManagement");
        _x.managedEBooks = managedEBooks;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code policySets} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The PolicySet of Policies and Applications”</i>
     * 
     * @param policySets
     *            new value of {@code policySets} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code policySets} field changed
     */
    public DeviceAppManagement withPolicySets(List<PolicySet> policySets) {
        DeviceAppManagement _x = _copy();
        _x.changedFields = changedFields.add("policySets");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceAppManagement");
        _x.policySets = policySets;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code sideLoadingKeys}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Side Loading Keys that are required for the Windows 8 and 8.1 Apps installation.”</i>
     * 
     * @param sideLoadingKeys
     *            new value of {@code sideLoadingKeys} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code sideLoadingKeys} field changed
     */
    public DeviceAppManagement withSideLoadingKeys(List<SideLoadingKey> sideLoadingKeys) {
        DeviceAppManagement _x = _copy();
        _x.changedFields = changedFields.add("sideLoadingKeys");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceAppManagement");
        _x.sideLoadingKeys = sideLoadingKeys;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code vppTokens} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“List of Vpp tokens for this organization.”</i>
     * 
     * @param vppTokens
     *            new value of {@code vppTokens} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code vppTokens} field changed
     */
    public DeviceAppManagement withVppTokens(List<VppToken> vppTokens) {
        DeviceAppManagement _x = _copy();
        _x.changedFields = changedFields.add("vppTokens");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceAppManagement");
        _x.vppTokens = vppTokens;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * androidManagedAppProtections} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Android managed app policies.”</i>
     * 
     * @param androidManagedAppProtections
     *            new value of {@code androidManagedAppProtections} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code androidManagedAppProtections} field changed
     */
    public DeviceAppManagement withAndroidManagedAppProtections(List<AndroidManagedAppProtection> androidManagedAppProtections) {
        DeviceAppManagement _x = _copy();
        _x.changedFields = changedFields.add("androidManagedAppProtections");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceAppManagement");
        _x.androidManagedAppProtections = androidManagedAppProtections;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defaultManagedAppProtections} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Default managed app policies.”</i>
     * 
     * @param defaultManagedAppProtections
     *            new value of {@code defaultManagedAppProtections} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defaultManagedAppProtections} field changed
     */
    public DeviceAppManagement withDefaultManagedAppProtections(List<DefaultManagedAppProtection> defaultManagedAppProtections) {
        DeviceAppManagement _x = _copy();
        _x.changedFields = changedFields.add("defaultManagedAppProtections");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceAppManagement");
        _x.defaultManagedAppProtections = defaultManagedAppProtections;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * iosManagedAppProtections} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“iOS managed app policies.”</i>
     * 
     * @param iosManagedAppProtections
     *            new value of {@code iosManagedAppProtections} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code iosManagedAppProtections} field changed
     */
    public DeviceAppManagement withIosManagedAppProtections(List<IosManagedAppProtection> iosManagedAppProtections) {
        DeviceAppManagement _x = _copy();
        _x.changedFields = changedFields.add("iosManagedAppProtections");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceAppManagement");
        _x.iosManagedAppProtections = iosManagedAppProtections;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * managedAppPolicies} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Managed app policies.”</i>
     * 
     * @param managedAppPolicies
     *            new value of {@code managedAppPolicies} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code managedAppPolicies} field changed
     */
    public DeviceAppManagement withManagedAppPolicies(List<ManagedAppPolicy> managedAppPolicies) {
        DeviceAppManagement _x = _copy();
        _x.changedFields = changedFields.add("managedAppPolicies");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceAppManagement");
        _x.managedAppPolicies = managedAppPolicies;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * managedAppRegistrations} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The managed app registrations.”</i>
     * 
     * @param managedAppRegistrations
     *            new value of {@code managedAppRegistrations} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code managedAppRegistrations} field changed
     */
    public DeviceAppManagement withManagedAppRegistrations(List<ManagedAppRegistration> managedAppRegistrations) {
        DeviceAppManagement _x = _copy();
        _x.changedFields = changedFields.add("managedAppRegistrations");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceAppManagement");
        _x.managedAppRegistrations = managedAppRegistrations;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * managedAppStatuses} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The managed app statuses.”</i>
     * 
     * @param managedAppStatuses
     *            new value of {@code managedAppStatuses} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code managedAppStatuses} field changed
     */
    public DeviceAppManagement withManagedAppStatuses(List<ManagedAppStatus> managedAppStatuses) {
        DeviceAppManagement _x = _copy();
        _x.changedFields = changedFields.add("managedAppStatuses");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceAppManagement");
        _x.managedAppStatuses = managedAppStatuses;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * mdmWindowsInformationProtectionPolicies} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Windows information protection for apps running on devices which are MDM
     * enrolled.”</i>
     * 
     * @param mdmWindowsInformationProtectionPolicies
     *            new value of {@code mdmWindowsInformationProtectionPolicies} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code mdmWindowsInformationProtectionPolicies} field changed
     */
    public DeviceAppManagement withMdmWindowsInformationProtectionPolicies(List<MdmWindowsInformationProtectionPolicy> mdmWindowsInformationProtectionPolicies) {
        DeviceAppManagement _x = _copy();
        _x.changedFields = changedFields.add("mdmWindowsInformationProtectionPolicies");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceAppManagement");
        _x.mdmWindowsInformationProtectionPolicies = mdmWindowsInformationProtectionPolicies;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * targetedManagedAppConfigurations} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Targeted managed app configurations.”</i>
     * 
     * @param targetedManagedAppConfigurations
     *            new value of {@code targetedManagedAppConfigurations} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code targetedManagedAppConfigurations} field changed
     */
    public DeviceAppManagement withTargetedManagedAppConfigurations(List<TargetedManagedAppConfiguration> targetedManagedAppConfigurations) {
        DeviceAppManagement _x = _copy();
        _x.changedFields = changedFields.add("targetedManagedAppConfigurations");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceAppManagement");
        _x.targetedManagedAppConfigurations = targetedManagedAppConfigurations;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * windowsInformationProtectionDeviceRegistrations} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“Windows information protection device registrations that are not MDM enrolled.”</i>
     * 
     * @param windowsInformationProtectionDeviceRegistrations
     *            new value of {@code windowsInformationProtectionDeviceRegistrations} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code windowsInformationProtectionDeviceRegistrations} field changed
     */
    public DeviceAppManagement withWindowsInformationProtectionDeviceRegistrations(List<WindowsInformationProtectionDeviceRegistration> windowsInformationProtectionDeviceRegistrations) {
        DeviceAppManagement _x = _copy();
        _x.changedFields = changedFields.add("windowsInformationProtectionDeviceRegistrations");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceAppManagement");
        _x.windowsInformationProtectionDeviceRegistrations = windowsInformationProtectionDeviceRegistrations;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * windowsInformationProtectionPolicies} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Windows information protection for apps running on devices which are not MDM
     * enrolled.”</i>
     * 
     * @param windowsInformationProtectionPolicies
     *            new value of {@code windowsInformationProtectionPolicies} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code windowsInformationProtectionPolicies} field changed
     */
    public DeviceAppManagement withWindowsInformationProtectionPolicies(List<WindowsInformationProtectionPolicy> windowsInformationProtectionPolicies) {
        DeviceAppManagement _x = _copy();
        _x.changedFields = changedFields.add("windowsInformationProtectionPolicies");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceAppManagement");
        _x.windowsInformationProtectionPolicies = windowsInformationProtectionPolicies;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * windowsInformationProtectionWipeActions} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Windows information protection wipe actions.”</i>
     * 
     * @param windowsInformationProtectionWipeActions
     *            new value of {@code windowsInformationProtectionWipeActions} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code windowsInformationProtectionWipeActions} field changed
     */
    public DeviceAppManagement withWindowsInformationProtectionWipeActions(List<WindowsInformationProtectionWipeAction> windowsInformationProtectionWipeActions) {
        DeviceAppManagement _x = _copy();
        _x.changedFields = changedFields.add("windowsInformationProtectionWipeActions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceAppManagement");
        _x.windowsInformationProtectionWipeActions = windowsInformationProtectionWipeActions;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceAppManagementTasks} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Device app management tasks.”</i>
     * 
     * @param deviceAppManagementTasks
     *            new value of {@code deviceAppManagementTasks} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceAppManagementTasks} field changed
     */
    public DeviceAppManagement withDeviceAppManagementTasks(List<DeviceAppManagementTask> deviceAppManagementTasks) {
        DeviceAppManagement _x = _copy();
        _x.changedFields = changedFields.add("deviceAppManagementTasks");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceAppManagement");
        _x.deviceAppManagementTasks = deviceAppManagementTasks;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * wdacSupplementalPolicies} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The collection of Windows Defender Application Control Supplemental Policies.”</i>
     * 
     * @param wdacSupplementalPolicies
     *            new value of {@code wdacSupplementalPolicies} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code wdacSupplementalPolicies} field changed
     */
    public DeviceAppManagement withWdacSupplementalPolicies(List<WindowsDefenderApplicationControlSupplementalPolicy> wdacSupplementalPolicies) {
        DeviceAppManagement _x = _copy();
        _x.changedFields = changedFields.add("wdacSupplementalPolicies");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceAppManagement");
        _x.wdacSupplementalPolicies = wdacSupplementalPolicies;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceAppManagement patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceAppManagement _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceAppManagement put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceAppManagement _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceAppManagement _copy() {
        DeviceAppManagement _x = new DeviceAppManagement();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.isEnabledForMicrosoftStoreForBusiness = isEnabledForMicrosoftStoreForBusiness;
        _x.microsoftStoreForBusinessLanguage = microsoftStoreForBusinessLanguage;
        _x.microsoftStoreForBusinessLastCompletedApplicationSyncTime = microsoftStoreForBusinessLastCompletedApplicationSyncTime;
        _x.microsoftStoreForBusinessLastSuccessfulSyncDateTime = microsoftStoreForBusinessLastSuccessfulSyncDateTime;
        _x.microsoftStoreForBusinessPortalSelection = microsoftStoreForBusinessPortalSelection;
        _x.managedEBookCategories = managedEBookCategories;
        _x.enterpriseCodeSigningCertificates = enterpriseCodeSigningCertificates;
        _x.iosLobAppProvisioningConfigurations = iosLobAppProvisioningConfigurations;
        _x.mobileAppCategories = mobileAppCategories;
        _x.mobileAppConfigurations = mobileAppConfigurations;
        _x.mobileApps = mobileApps;
        _x.symantecCodeSigningCertificate = symantecCodeSigningCertificate;
        _x.managedEBooks = managedEBooks;
        _x.policySets = policySets;
        _x.sideLoadingKeys = sideLoadingKeys;
        _x.vppTokens = vppTokens;
        _x.androidManagedAppProtections = androidManagedAppProtections;
        _x.defaultManagedAppProtections = defaultManagedAppProtections;
        _x.iosManagedAppProtections = iosManagedAppProtections;
        _x.managedAppPolicies = managedAppPolicies;
        _x.managedAppRegistrations = managedAppRegistrations;
        _x.managedAppStatuses = managedAppStatuses;
        _x.mdmWindowsInformationProtectionPolicies = mdmWindowsInformationProtectionPolicies;
        _x.targetedManagedAppConfigurations = targetedManagedAppConfigurations;
        _x.windowsInformationProtectionDeviceRegistrations = windowsInformationProtectionDeviceRegistrations;
        _x.windowsInformationProtectionPolicies = windowsInformationProtectionPolicies;
        _x.windowsInformationProtectionWipeActions = windowsInformationProtectionWipeActions;
        _x.deviceAppManagementTasks = deviceAppManagementTasks;
        _x.wdacSupplementalPolicies = wdacSupplementalPolicies;
        return _x;
    }

    @Action(name = "syncMicrosoftStoreForBusinessApps")
    @JsonIgnore
    public ActionRequestNoReturn syncMicrosoftStoreForBusinessApps() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.syncMicrosoftStoreForBusinessApps"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceAppManagement[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("isEnabledForMicrosoftStoreForBusiness=");
        b.append(this.isEnabledForMicrosoftStoreForBusiness);
        b.append(", ");
        b.append("microsoftStoreForBusinessLanguage=");
        b.append(this.microsoftStoreForBusinessLanguage);
        b.append(", ");
        b.append("microsoftStoreForBusinessLastCompletedApplicationSyncTime=");
        b.append(this.microsoftStoreForBusinessLastCompletedApplicationSyncTime);
        b.append(", ");
        b.append("microsoftStoreForBusinessLastSuccessfulSyncDateTime=");
        b.append(this.microsoftStoreForBusinessLastSuccessfulSyncDateTime);
        b.append(", ");
        b.append("microsoftStoreForBusinessPortalSelection=");
        b.append(this.microsoftStoreForBusinessPortalSelection);
        b.append(", ");
        b.append("managedEBookCategories=");
        b.append(this.managedEBookCategories);
        b.append(", ");
        b.append("enterpriseCodeSigningCertificates=");
        b.append(this.enterpriseCodeSigningCertificates);
        b.append(", ");
        b.append("iosLobAppProvisioningConfigurations=");
        b.append(this.iosLobAppProvisioningConfigurations);
        b.append(", ");
        b.append("mobileAppCategories=");
        b.append(this.mobileAppCategories);
        b.append(", ");
        b.append("mobileAppConfigurations=");
        b.append(this.mobileAppConfigurations);
        b.append(", ");
        b.append("mobileApps=");
        b.append(this.mobileApps);
        b.append(", ");
        b.append("symantecCodeSigningCertificate=");
        b.append(this.symantecCodeSigningCertificate);
        b.append(", ");
        b.append("managedEBooks=");
        b.append(this.managedEBooks);
        b.append(", ");
        b.append("policySets=");
        b.append(this.policySets);
        b.append(", ");
        b.append("sideLoadingKeys=");
        b.append(this.sideLoadingKeys);
        b.append(", ");
        b.append("vppTokens=");
        b.append(this.vppTokens);
        b.append(", ");
        b.append("androidManagedAppProtections=");
        b.append(this.androidManagedAppProtections);
        b.append(", ");
        b.append("defaultManagedAppProtections=");
        b.append(this.defaultManagedAppProtections);
        b.append(", ");
        b.append("iosManagedAppProtections=");
        b.append(this.iosManagedAppProtections);
        b.append(", ");
        b.append("managedAppPolicies=");
        b.append(this.managedAppPolicies);
        b.append(", ");
        b.append("managedAppRegistrations=");
        b.append(this.managedAppRegistrations);
        b.append(", ");
        b.append("managedAppStatuses=");
        b.append(this.managedAppStatuses);
        b.append(", ");
        b.append("mdmWindowsInformationProtectionPolicies=");
        b.append(this.mdmWindowsInformationProtectionPolicies);
        b.append(", ");
        b.append("targetedManagedAppConfigurations=");
        b.append(this.targetedManagedAppConfigurations);
        b.append(", ");
        b.append("windowsInformationProtectionDeviceRegistrations=");
        b.append(this.windowsInformationProtectionDeviceRegistrations);
        b.append(", ");
        b.append("windowsInformationProtectionPolicies=");
        b.append(this.windowsInformationProtectionPolicies);
        b.append(", ");
        b.append("windowsInformationProtectionWipeActions=");
        b.append(this.windowsInformationProtectionWipeActions);
        b.append(", ");
        b.append("deviceAppManagementTasks=");
        b.append(this.deviceAppManagementTasks);
        b.append(", ");
        b.append("wdacSupplementalPolicies=");
        b.append(this.wdacSupplementalPolicies);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
