package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.RoleScopeTagCollectionRequest;
import odata.msgraph.client.beta.enums.RoleAssignmentScopeType;


/**
 * <i>“The Role Assignment resource. Role assignments tie together a role definition
 * with members and scopes. There can be one or more role assignments per role.
 * This applies to custom and built-in roles.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "members"})
@JsonInclude(Include.NON_NULL)
public class DeviceAndAppManagementRoleAssignment extends RoleAssignment implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceAndAppManagementRoleAssignment";
    }

    @JsonProperty("members")
    protected List<String> members;

    @JsonProperty("members@nextLink")
    protected String membersNextLink;

    protected DeviceAndAppManagementRoleAssignment() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceAndAppManagementRoleAssignment() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String description;
        private String displayName;
        private List<String> resourceScopes;
        private String resourceScopesNextLink;
        private List<String> scopeMembers;
        private String scopeMembersNextLink;
        private RoleAssignmentScopeType scopeType;
        private List<String> members;
        private String membersNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder resourceScopes(List<String> resourceScopes) {
            this.resourceScopes = resourceScopes;
            this.changedFields = changedFields.add("resourceScopes");
            return this;
        }

        public Builder resourceScopes(String... resourceScopes) {
            return resourceScopes(Arrays.asList(resourceScopes));
        }

        public Builder resourceScopesNextLink(String resourceScopesNextLink) {
            this.resourceScopesNextLink = resourceScopesNextLink;
            this.changedFields = changedFields.add("resourceScopes");
            return this;
        }

        public Builder scopeMembers(List<String> scopeMembers) {
            this.scopeMembers = scopeMembers;
            this.changedFields = changedFields.add("scopeMembers");
            return this;
        }

        public Builder scopeMembers(String... scopeMembers) {
            return scopeMembers(Arrays.asList(scopeMembers));
        }

        public Builder scopeMembersNextLink(String scopeMembersNextLink) {
            this.scopeMembersNextLink = scopeMembersNextLink;
            this.changedFields = changedFields.add("scopeMembers");
            return this;
        }

        public Builder scopeType(RoleAssignmentScopeType scopeType) {
            this.scopeType = scopeType;
            this.changedFields = changedFields.add("scopeType");
            return this;
        }

        /**
         * <i>“The list of ids of role member security groups. These are IDs from Azure Active
         * Directory.”</i>
         * 
         * @param members
         *            value of {@code members} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder members(List<String> members) {
            this.members = members;
            this.changedFields = changedFields.add("members");
            return this;
        }

        /**
         * <i>“The list of ids of role member security groups. These are IDs from Azure Active
         * Directory.”</i>
         * 
         * @param members
         *            value of {@code members} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder members(String... members) {
            return members(Arrays.asList(members));
        }

        /**
         * <i>“The list of ids of role member security groups. These are IDs from Azure Active
         * Directory.”</i>
         * 
         * @param membersNextLink
         *            value of {@code members@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder membersNextLink(String membersNextLink) {
            this.membersNextLink = membersNextLink;
            this.changedFields = changedFields.add("members");
            return this;
        }

        public DeviceAndAppManagementRoleAssignment build() {
            DeviceAndAppManagementRoleAssignment _x = new DeviceAndAppManagementRoleAssignment();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceAndAppManagementRoleAssignment";
            _x.id = id;
            _x.description = description;
            _x.displayName = displayName;
            _x.resourceScopes = resourceScopes;
            _x.resourceScopesNextLink = resourceScopesNextLink;
            _x.scopeMembers = scopeMembers;
            _x.scopeMembersNextLink = scopeMembersNextLink;
            _x.scopeType = scopeType;
            _x.members = members;
            _x.membersNextLink = membersNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The list of ids of role member security groups. These are IDs from Azure Active
     * Directory.”</i>
     * 
     * @return property members
     */
    @Property(name="members")
    @JsonIgnore
    public CollectionPage<String> getMembers() {
        return new CollectionPage<String>(contextPath, String.class, this.members, Optional.ofNullable(membersNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code members} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The list of ids of role member security groups. These are IDs from Azure Active
     * Directory.”</i>
     * 
     * @param members
     *            new value of {@code members} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code members} field changed
     */
    public DeviceAndAppManagementRoleAssignment withMembers(List<String> members) {
        DeviceAndAppManagementRoleAssignment _x = _copy();
        _x.changedFields = changedFields.add("members");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceAndAppManagementRoleAssignment");
        _x.members = members;
        return _x;
    }

    /**
     * <i>“The list of ids of role member security groups. These are IDs from Azure Active
     * Directory.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property members
     */
    @Property(name="members")
    @JsonIgnore
    public CollectionPage<String> getMembers(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.members, Optional.ofNullable(membersNextLink), Collections.emptyList(), options);
    }

    public DeviceAndAppManagementRoleAssignment withUnmappedField(String name, Object value) {
        DeviceAndAppManagementRoleAssignment _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“The set of Role Scope Tags defined on the Role Assignment.”</i>
     * 
     * @return navigational property roleScopeTags
     */
    @NavigationProperty(name="roleScopeTags")
    @JsonIgnore
    public RoleScopeTagCollectionRequest getRoleScopeTags() {
        return new RoleScopeTagCollectionRequest(
                        contextPath.addSegment("roleScopeTags"), RequestHelper.getValue(unmappedFields, "roleScopeTags"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceAndAppManagementRoleAssignment patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceAndAppManagementRoleAssignment _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceAndAppManagementRoleAssignment put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceAndAppManagementRoleAssignment _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceAndAppManagementRoleAssignment _copy() {
        DeviceAndAppManagementRoleAssignment _x = new DeviceAndAppManagementRoleAssignment();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.description = description;
        _x.displayName = displayName;
        _x.resourceScopes = resourceScopes;
        _x.scopeMembers = scopeMembers;
        _x.scopeType = scopeType;
        _x.members = members;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceAndAppManagementRoleAssignment[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("resourceScopes=");
        b.append(this.resourceScopes);
        b.append(", ");
        b.append("scopeMembers=");
        b.append(this.scopeMembers);
        b.append(", ");
        b.append("scopeType=");
        b.append(this.scopeType);
        b.append(", ");
        b.append("members=");
        b.append(this.members);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
