package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.AssignmentFilterSupportedProperty;
import odata.msgraph.client.beta.enums.DevicePlatformType;


/**
 * <i>“A class containing the properties used for Assignment Filter.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "createdDateTime", 
    "description", 
    "displayName", 
    "lastModifiedDateTime", 
    "platform", 
    "roleScopeTags", 
    "rule"})
@JsonInclude(Include.NON_NULL)
public class DeviceAndAppManagementAssignmentFilter extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceAndAppManagementAssignmentFilter";
    }

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("platform")
    protected DevicePlatformType platform;

    @JsonProperty("roleScopeTags")
    protected List<String> roleScopeTags;

    @JsonProperty("roleScopeTags@nextLink")
    protected String roleScopeTagsNextLink;

    @JsonProperty("rule")
    protected String rule;

    protected DeviceAndAppManagementAssignmentFilter() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceAndAppManagementAssignmentFilter() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private String description;
        private String displayName;
        private OffsetDateTime lastModifiedDateTime;
        private DevicePlatformType platform;
        private List<String> roleScopeTags;
        private String roleScopeTagsNextLink;
        private String rule;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Creation time of the Assignment Filter.”</i>
         * 
         * @param createdDateTime
         *            value of {@code createdDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        /**
         * <i>“Description of the Assignment Filter.”</i>
         * 
         * @param description
         *            value of {@code description} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        /**
         * <i>“DisplayName of the Assignment Filter.”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“Last modified time of the Assignment Filter.”</i>
         * 
         * @param lastModifiedDateTime
         *            value of {@code lastModifiedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        /**
         * <i>“Platform type of the devices on which the Assignment Filter will be applicable.”</i>
         * 
         * @param platform
         *            value of {@code platform} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder platform(DevicePlatformType platform) {
            this.platform = platform;
            this.changedFields = changedFields.add("platform");
            return this;
        }

        /**
         * <i>“RoleScopeTags of the Assignment Filter.”</i>
         * 
         * @param roleScopeTags
         *            value of {@code roleScopeTags} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTags(List<String> roleScopeTags) {
            this.roleScopeTags = roleScopeTags;
            this.changedFields = changedFields.add("roleScopeTags");
            return this;
        }

        /**
         * <i>“RoleScopeTags of the Assignment Filter.”</i>
         * 
         * @param roleScopeTags
         *            value of {@code roleScopeTags} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTags(String... roleScopeTags) {
            return roleScopeTags(Arrays.asList(roleScopeTags));
        }

        /**
         * <i>“RoleScopeTags of the Assignment Filter.”</i>
         * 
         * @param roleScopeTagsNextLink
         *            value of {@code roleScopeTags@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagsNextLink(String roleScopeTagsNextLink) {
            this.roleScopeTagsNextLink = roleScopeTagsNextLink;
            this.changedFields = changedFields.add("roleScopeTags");
            return this;
        }

        /**
         * <i>“Rule definition of the Assignment Filter.”</i>
         * 
         * @param rule
         *            value of {@code rule} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder rule(String rule) {
            this.rule = rule;
            this.changedFields = changedFields.add("rule");
            return this;
        }

        public DeviceAndAppManagementAssignmentFilter build() {
            DeviceAndAppManagementAssignmentFilter _x = new DeviceAndAppManagementAssignmentFilter();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceAndAppManagementAssignmentFilter";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.displayName = displayName;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.platform = platform;
            _x.roleScopeTags = roleScopeTags;
            _x.roleScopeTagsNextLink = roleScopeTagsNextLink;
            _x.rule = rule;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Creation time of the Assignment Filter.”</i>
     * 
     * @return property createdDateTime
     */
    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code createdDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Creation time of the Assignment Filter.”</i>
     * 
     * @param createdDateTime
     *            new value of {@code createdDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code createdDateTime} field changed
     */
    public DeviceAndAppManagementAssignmentFilter withCreatedDateTime(OffsetDateTime createdDateTime) {
        DeviceAndAppManagementAssignmentFilter _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceAndAppManagementAssignmentFilter");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    /**
     * <i>“Description of the Assignment Filter.”</i>
     * 
     * @return property description
     */
    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code description}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Description of the Assignment Filter.”</i>
     * 
     * @param description
     *            new value of {@code description} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code description} field changed
     */
    public DeviceAndAppManagementAssignmentFilter withDescription(String description) {
        DeviceAndAppManagementAssignmentFilter _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceAndAppManagementAssignmentFilter");
        _x.description = description;
        return _x;
    }

    /**
     * <i>“DisplayName of the Assignment Filter.”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“DisplayName of the Assignment Filter.”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public DeviceAndAppManagementAssignmentFilter withDisplayName(String displayName) {
        DeviceAndAppManagementAssignmentFilter _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceAndAppManagementAssignmentFilter");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“Last modified time of the Assignment Filter.”</i>
     * 
     * @return property lastModifiedDateTime
     */
    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastModifiedDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Last modified time of the Assignment Filter.”</i>
     * 
     * @param lastModifiedDateTime
     *            new value of {@code lastModifiedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastModifiedDateTime} field changed
     */
    public DeviceAndAppManagementAssignmentFilter withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        DeviceAndAppManagementAssignmentFilter _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceAndAppManagementAssignmentFilter");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    /**
     * <i>“Platform type of the devices on which the Assignment Filter will be applicable.”</i>
     * 
     * @return property platform
     */
    @Property(name="platform")
    @JsonIgnore
    public Optional<DevicePlatformType> getPlatform() {
        return Optional.ofNullable(platform);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code platform} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Platform type of the devices on which the Assignment Filter will be applicable.”</i>
     * 
     * @param platform
     *            new value of {@code platform} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code platform} field changed
     */
    public DeviceAndAppManagementAssignmentFilter withPlatform(DevicePlatformType platform) {
        DeviceAndAppManagementAssignmentFilter _x = _copy();
        _x.changedFields = changedFields.add("platform");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceAndAppManagementAssignmentFilter");
        _x.platform = platform;
        return _x;
    }

    /**
     * <i>“RoleScopeTags of the Assignment Filter.”</i>
     * 
     * @return property roleScopeTags
     */
    @Property(name="roleScopeTags")
    @JsonIgnore
    public CollectionPage<String> getRoleScopeTags() {
        return new CollectionPage<String>(contextPath, String.class, this.roleScopeTags, Optional.ofNullable(roleScopeTagsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code roleScopeTags}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“RoleScopeTags of the Assignment Filter.”</i>
     * 
     * @param roleScopeTags
     *            new value of {@code roleScopeTags} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code roleScopeTags} field changed
     */
    public DeviceAndAppManagementAssignmentFilter withRoleScopeTags(List<String> roleScopeTags) {
        DeviceAndAppManagementAssignmentFilter _x = _copy();
        _x.changedFields = changedFields.add("roleScopeTags");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceAndAppManagementAssignmentFilter");
        _x.roleScopeTags = roleScopeTags;
        return _x;
    }

    /**
     * <i>“RoleScopeTags of the Assignment Filter.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property roleScopeTags
     */
    @Property(name="roleScopeTags")
    @JsonIgnore
    public CollectionPage<String> getRoleScopeTags(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.roleScopeTags, Optional.ofNullable(roleScopeTagsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Rule definition of the Assignment Filter.”</i>
     * 
     * @return property rule
     */
    @Property(name="rule")
    @JsonIgnore
    public Optional<String> getRule() {
        return Optional.ofNullable(rule);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code rule} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Rule definition of the Assignment Filter.”</i>
     * 
     * @param rule
     *            new value of {@code rule} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code rule} field changed
     */
    public DeviceAndAppManagementAssignmentFilter withRule(String rule) {
        DeviceAndAppManagementAssignmentFilter _x = _copy();
        _x.changedFields = changedFields.add("rule");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceAndAppManagementAssignmentFilter");
        _x.rule = rule;
        return _x;
    }

    public DeviceAndAppManagementAssignmentFilter withUnmappedField(String name, Object value) {
        DeviceAndAppManagementAssignmentFilter _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceAndAppManagementAssignmentFilter patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceAndAppManagementAssignmentFilter _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceAndAppManagementAssignmentFilter put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceAndAppManagementAssignmentFilter _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceAndAppManagementAssignmentFilter _copy() {
        DeviceAndAppManagementAssignmentFilter _x = new DeviceAndAppManagementAssignmentFilter();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.platform = platform;
        _x.roleScopeTags = roleScopeTags;
        _x.rule = rule;
        return _x;
    }

    @Function(name = "getSupportedProperties")
    @JsonIgnore
    public CollectionPageNonEntityRequest<AssignmentFilterSupportedProperty> getSupportedProperties() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSupportedProperties"), AssignmentFilterSupportedProperty.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceAndAppManagementAssignmentFilter[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("platform=");
        b.append(this.platform);
        b.append(", ");
        b.append("roleScopeTags=");
        b.append(this.roleScopeTags);
        b.append(", ");
        b.append("rule=");
        b.append(this.rule);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
