package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“The DepEnrollmentBaseProfile resource represents an Apple Device Enrollment
 * Program (DEP) enrollment profile. This type of profile must be assigned to Apple
 * DEP serial numbers before the corresponding devices can enroll via DEP.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "appleIdDisabled", 
    "applePayDisabled", 
    "configurationWebUrl", 
    "deviceNameTemplate", 
    "diagnosticsDisabled", 
    "displayToneSetupDisabled", 
    "isDefault", 
    "isMandatory", 
    "locationDisabled", 
    "privacyPaneDisabled", 
    "profileRemovalDisabled", 
    "restoreBlocked", 
    "screenTimeScreenDisabled", 
    "siriDisabled", 
    "supervisedModeEnabled", 
    "supportDepartment", 
    "supportPhoneNumber", 
    "termsAndConditionsDisabled", 
    "touchIdDisabled"})
@JsonInclude(Include.NON_NULL)
public class DepEnrollmentBaseProfile extends EnrollmentProfile implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.depEnrollmentBaseProfile";
    }

    @JsonProperty("appleIdDisabled")
    protected Boolean appleIdDisabled;

    @JsonProperty("applePayDisabled")
    protected Boolean applePayDisabled;

    @JsonProperty("configurationWebUrl")
    protected Boolean configurationWebUrl;

    @JsonProperty("deviceNameTemplate")
    protected String deviceNameTemplate;

    @JsonProperty("diagnosticsDisabled")
    protected Boolean diagnosticsDisabled;

    @JsonProperty("displayToneSetupDisabled")
    protected Boolean displayToneSetupDisabled;

    @JsonProperty("isDefault")
    protected Boolean isDefault;

    @JsonProperty("isMandatory")
    protected Boolean isMandatory;

    @JsonProperty("locationDisabled")
    protected Boolean locationDisabled;

    @JsonProperty("privacyPaneDisabled")
    protected Boolean privacyPaneDisabled;

    @JsonProperty("profileRemovalDisabled")
    protected Boolean profileRemovalDisabled;

    @JsonProperty("restoreBlocked")
    protected Boolean restoreBlocked;

    @JsonProperty("screenTimeScreenDisabled")
    protected Boolean screenTimeScreenDisabled;

    @JsonProperty("siriDisabled")
    protected Boolean siriDisabled;

    @JsonProperty("supervisedModeEnabled")
    protected Boolean supervisedModeEnabled;

    @JsonProperty("supportDepartment")
    protected String supportDepartment;

    @JsonProperty("supportPhoneNumber")
    protected String supportPhoneNumber;

    @JsonProperty("termsAndConditionsDisabled")
    protected Boolean termsAndConditionsDisabled;

    @JsonProperty("touchIdDisabled")
    protected Boolean touchIdDisabled;

    protected DepEnrollmentBaseProfile() {
        super();
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Indicates if Apple id setup pane is disabled”</i>
     * 
     * @return property appleIdDisabled
     */
    @Property(name="appleIdDisabled")
    @JsonIgnore
    public Optional<Boolean> getAppleIdDisabled() {
        return Optional.ofNullable(appleIdDisabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code appleIdDisabled}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates if Apple id setup pane is disabled”</i>
     * 
     * @param appleIdDisabled
     *            new value of {@code appleIdDisabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appleIdDisabled} field changed
     */
    public DepEnrollmentBaseProfile withAppleIdDisabled(Boolean appleIdDisabled) {
        DepEnrollmentBaseProfile _x = _copy();
        _x.changedFields = changedFields.add("appleIdDisabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depEnrollmentBaseProfile");
        _x.appleIdDisabled = appleIdDisabled;
        return _x;
    }

    /**
     * <i>“Indicates if Apple pay setup pane is disabled”</i>
     * 
     * @return property applePayDisabled
     */
    @Property(name="applePayDisabled")
    @JsonIgnore
    public Optional<Boolean> getApplePayDisabled() {
        return Optional.ofNullable(applePayDisabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code applePayDisabled}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates if Apple pay setup pane is disabled”</i>
     * 
     * @param applePayDisabled
     *            new value of {@code applePayDisabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code applePayDisabled} field changed
     */
    public DepEnrollmentBaseProfile withApplePayDisabled(Boolean applePayDisabled) {
        DepEnrollmentBaseProfile _x = _copy();
        _x.changedFields = changedFields.add("applePayDisabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depEnrollmentBaseProfile");
        _x.applePayDisabled = applePayDisabled;
        return _x;
    }

    /**
     * <i>“URL for setup assistant login”</i>
     * 
     * @return property configurationWebUrl
     */
    @Property(name="configurationWebUrl")
    @JsonIgnore
    public Optional<Boolean> getConfigurationWebUrl() {
        return Optional.ofNullable(configurationWebUrl);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * configurationWebUrl} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“URL for setup assistant login”</i>
     * 
     * @param configurationWebUrl
     *            new value of {@code configurationWebUrl} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code configurationWebUrl} field changed
     */
    public DepEnrollmentBaseProfile withConfigurationWebUrl(Boolean configurationWebUrl) {
        DepEnrollmentBaseProfile _x = _copy();
        _x.changedFields = changedFields.add("configurationWebUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depEnrollmentBaseProfile");
        _x.configurationWebUrl = configurationWebUrl;
        return _x;
    }

    /**
     * <i>“Sets a literal or name pattern.”</i>
     * 
     * @return property deviceNameTemplate
     */
    @Property(name="deviceNameTemplate")
    @JsonIgnore
    public Optional<String> getDeviceNameTemplate() {
        return Optional.ofNullable(deviceNameTemplate);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceNameTemplate} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Sets a literal or name pattern.”</i>
     * 
     * @param deviceNameTemplate
     *            new value of {@code deviceNameTemplate} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceNameTemplate} field changed
     */
    public DepEnrollmentBaseProfile withDeviceNameTemplate(String deviceNameTemplate) {
        DepEnrollmentBaseProfile _x = _copy();
        _x.changedFields = changedFields.add("deviceNameTemplate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depEnrollmentBaseProfile");
        _x.deviceNameTemplate = deviceNameTemplate;
        return _x;
    }

    /**
     * <i>“Indicates if diagnostics setup pane is disabled”</i>
     * 
     * @return property diagnosticsDisabled
     */
    @Property(name="diagnosticsDisabled")
    @JsonIgnore
    public Optional<Boolean> getDiagnosticsDisabled() {
        return Optional.ofNullable(diagnosticsDisabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * diagnosticsDisabled} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates if diagnostics setup pane is disabled”</i>
     * 
     * @param diagnosticsDisabled
     *            new value of {@code diagnosticsDisabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code diagnosticsDisabled} field changed
     */
    public DepEnrollmentBaseProfile withDiagnosticsDisabled(Boolean diagnosticsDisabled) {
        DepEnrollmentBaseProfile _x = _copy();
        _x.changedFields = changedFields.add("diagnosticsDisabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depEnrollmentBaseProfile");
        _x.diagnosticsDisabled = diagnosticsDisabled;
        return _x;
    }

    /**
     * <i>“Indicates if displaytone setup screen is disabled”</i>
     * 
     * @return property displayToneSetupDisabled
     */
    @Property(name="displayToneSetupDisabled")
    @JsonIgnore
    public Optional<Boolean> getDisplayToneSetupDisabled() {
        return Optional.ofNullable(displayToneSetupDisabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * displayToneSetupDisabled} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates if displaytone setup screen is disabled”</i>
     * 
     * @param displayToneSetupDisabled
     *            new value of {@code displayToneSetupDisabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayToneSetupDisabled} field changed
     */
    public DepEnrollmentBaseProfile withDisplayToneSetupDisabled(Boolean displayToneSetupDisabled) {
        DepEnrollmentBaseProfile _x = _copy();
        _x.changedFields = changedFields.add("displayToneSetupDisabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depEnrollmentBaseProfile");
        _x.displayToneSetupDisabled = displayToneSetupDisabled;
        return _x;
    }

    /**
     * <i>“Indicates if this is the default profile”</i>
     * 
     * @return property isDefault
     */
    @Property(name="isDefault")
    @JsonIgnore
    public Optional<Boolean> getIsDefault() {
        return Optional.ofNullable(isDefault);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code isDefault} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Indicates if this is the default profile”</i>
     * 
     * @param isDefault
     *            new value of {@code isDefault} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code isDefault} field changed
     */
    public DepEnrollmentBaseProfile withIsDefault(Boolean isDefault) {
        DepEnrollmentBaseProfile _x = _copy();
        _x.changedFields = changedFields.add("isDefault");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depEnrollmentBaseProfile");
        _x.isDefault = isDefault;
        return _x;
    }

    /**
     * <i>“Indicates if the profile is mandatory”</i>
     * 
     * @return property isMandatory
     */
    @Property(name="isMandatory")
    @JsonIgnore
    public Optional<Boolean> getIsMandatory() {
        return Optional.ofNullable(isMandatory);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code isMandatory}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates if the profile is mandatory”</i>
     * 
     * @param isMandatory
     *            new value of {@code isMandatory} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code isMandatory} field changed
     */
    public DepEnrollmentBaseProfile withIsMandatory(Boolean isMandatory) {
        DepEnrollmentBaseProfile _x = _copy();
        _x.changedFields = changedFields.add("isMandatory");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depEnrollmentBaseProfile");
        _x.isMandatory = isMandatory;
        return _x;
    }

    /**
     * <i>“Indicates if Location service setup pane is disabled”</i>
     * 
     * @return property locationDisabled
     */
    @Property(name="locationDisabled")
    @JsonIgnore
    public Optional<Boolean> getLocationDisabled() {
        return Optional.ofNullable(locationDisabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code locationDisabled}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates if Location service setup pane is disabled”</i>
     * 
     * @param locationDisabled
     *            new value of {@code locationDisabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code locationDisabled} field changed
     */
    public DepEnrollmentBaseProfile withLocationDisabled(Boolean locationDisabled) {
        DepEnrollmentBaseProfile _x = _copy();
        _x.changedFields = changedFields.add("locationDisabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depEnrollmentBaseProfile");
        _x.locationDisabled = locationDisabled;
        return _x;
    }

    /**
     * <i>“Indicates if privacy screen is disabled”</i>
     * 
     * @return property privacyPaneDisabled
     */
    @Property(name="privacyPaneDisabled")
    @JsonIgnore
    public Optional<Boolean> getPrivacyPaneDisabled() {
        return Optional.ofNullable(privacyPaneDisabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * privacyPaneDisabled} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates if privacy screen is disabled”</i>
     * 
     * @param privacyPaneDisabled
     *            new value of {@code privacyPaneDisabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code privacyPaneDisabled} field changed
     */
    public DepEnrollmentBaseProfile withPrivacyPaneDisabled(Boolean privacyPaneDisabled) {
        DepEnrollmentBaseProfile _x = _copy();
        _x.changedFields = changedFields.add("privacyPaneDisabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depEnrollmentBaseProfile");
        _x.privacyPaneDisabled = privacyPaneDisabled;
        return _x;
    }

    /**
     * <i>“Indicates if the profile removal option is disabled”</i>
     * 
     * @return property profileRemovalDisabled
     */
    @Property(name="profileRemovalDisabled")
    @JsonIgnore
    public Optional<Boolean> getProfileRemovalDisabled() {
        return Optional.ofNullable(profileRemovalDisabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * profileRemovalDisabled} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates if the profile removal option is disabled”</i>
     * 
     * @param profileRemovalDisabled
     *            new value of {@code profileRemovalDisabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code profileRemovalDisabled} field changed
     */
    public DepEnrollmentBaseProfile withProfileRemovalDisabled(Boolean profileRemovalDisabled) {
        DepEnrollmentBaseProfile _x = _copy();
        _x.changedFields = changedFields.add("profileRemovalDisabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depEnrollmentBaseProfile");
        _x.profileRemovalDisabled = profileRemovalDisabled;
        return _x;
    }

    /**
     * <i>“Indicates if Restore setup pane is blocked”</i>
     * 
     * @return property restoreBlocked
     */
    @Property(name="restoreBlocked")
    @JsonIgnore
    public Optional<Boolean> getRestoreBlocked() {
        return Optional.ofNullable(restoreBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code restoreBlocked}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates if Restore setup pane is blocked”</i>
     * 
     * @param restoreBlocked
     *            new value of {@code restoreBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code restoreBlocked} field changed
     */
    public DepEnrollmentBaseProfile withRestoreBlocked(Boolean restoreBlocked) {
        DepEnrollmentBaseProfile _x = _copy();
        _x.changedFields = changedFields.add("restoreBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depEnrollmentBaseProfile");
        _x.restoreBlocked = restoreBlocked;
        return _x;
    }

    /**
     * <i>“Indicates if screen timeout setup is disabled”</i>
     * 
     * @return property screenTimeScreenDisabled
     */
    @Property(name="screenTimeScreenDisabled")
    @JsonIgnore
    public Optional<Boolean> getScreenTimeScreenDisabled() {
        return Optional.ofNullable(screenTimeScreenDisabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * screenTimeScreenDisabled} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates if screen timeout setup is disabled”</i>
     * 
     * @param screenTimeScreenDisabled
     *            new value of {@code screenTimeScreenDisabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code screenTimeScreenDisabled} field changed
     */
    public DepEnrollmentBaseProfile withScreenTimeScreenDisabled(Boolean screenTimeScreenDisabled) {
        DepEnrollmentBaseProfile _x = _copy();
        _x.changedFields = changedFields.add("screenTimeScreenDisabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depEnrollmentBaseProfile");
        _x.screenTimeScreenDisabled = screenTimeScreenDisabled;
        return _x;
    }

    /**
     * <i>“Indicates if siri setup pane is disabled”</i>
     * 
     * @return property siriDisabled
     */
    @Property(name="siriDisabled")
    @JsonIgnore
    public Optional<Boolean> getSiriDisabled() {
        return Optional.ofNullable(siriDisabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code siriDisabled}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates if siri setup pane is disabled”</i>
     * 
     * @param siriDisabled
     *            new value of {@code siriDisabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code siriDisabled} field changed
     */
    public DepEnrollmentBaseProfile withSiriDisabled(Boolean siriDisabled) {
        DepEnrollmentBaseProfile _x = _copy();
        _x.changedFields = changedFields.add("siriDisabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depEnrollmentBaseProfile");
        _x.siriDisabled = siriDisabled;
        return _x;
    }

    /**
     * <i>“Supervised mode, True to enable, false otherwise. See https://docs.microsoft.com
     * /en-us/intune/deploy-use/enroll-devices-in-microsoft-intune for additional
     * information.”</i>
     * 
     * @return property supervisedModeEnabled
     */
    @Property(name="supervisedModeEnabled")
    @JsonIgnore
    public Optional<Boolean> getSupervisedModeEnabled() {
        return Optional.ofNullable(supervisedModeEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * supervisedModeEnabled} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Supervised mode, True to enable, false otherwise. See https://docs.microsoft.com
     * /en-us/intune/deploy-use/enroll-devices-in-microsoft-intune for additional
     * information.”</i>
     * 
     * @param supervisedModeEnabled
     *            new value of {@code supervisedModeEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code supervisedModeEnabled} field changed
     */
    public DepEnrollmentBaseProfile withSupervisedModeEnabled(Boolean supervisedModeEnabled) {
        DepEnrollmentBaseProfile _x = _copy();
        _x.changedFields = changedFields.add("supervisedModeEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depEnrollmentBaseProfile");
        _x.supervisedModeEnabled = supervisedModeEnabled;
        return _x;
    }

    /**
     * <i>“Support department information”</i>
     * 
     * @return property supportDepartment
     */
    @Property(name="supportDepartment")
    @JsonIgnore
    public Optional<String> getSupportDepartment() {
        return Optional.ofNullable(supportDepartment);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code supportDepartment
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Support department information”</i>
     * 
     * @param supportDepartment
     *            new value of {@code supportDepartment} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code supportDepartment} field changed
     */
    public DepEnrollmentBaseProfile withSupportDepartment(String supportDepartment) {
        DepEnrollmentBaseProfile _x = _copy();
        _x.changedFields = changedFields.add("supportDepartment");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depEnrollmentBaseProfile");
        _x.supportDepartment = supportDepartment;
        return _x;
    }

    /**
     * <i>“Support phone number”</i>
     * 
     * @return property supportPhoneNumber
     */
    @Property(name="supportPhoneNumber")
    @JsonIgnore
    public Optional<String> getSupportPhoneNumber() {
        return Optional.ofNullable(supportPhoneNumber);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * supportPhoneNumber} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Support phone number”</i>
     * 
     * @param supportPhoneNumber
     *            new value of {@code supportPhoneNumber} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code supportPhoneNumber} field changed
     */
    public DepEnrollmentBaseProfile withSupportPhoneNumber(String supportPhoneNumber) {
        DepEnrollmentBaseProfile _x = _copy();
        _x.changedFields = changedFields.add("supportPhoneNumber");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depEnrollmentBaseProfile");
        _x.supportPhoneNumber = supportPhoneNumber;
        return _x;
    }

    /**
     * <i>“Indicates if 'Terms and Conditions' setup pane is disabled”</i>
     * 
     * @return property termsAndConditionsDisabled
     */
    @Property(name="termsAndConditionsDisabled")
    @JsonIgnore
    public Optional<Boolean> getTermsAndConditionsDisabled() {
        return Optional.ofNullable(termsAndConditionsDisabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * termsAndConditionsDisabled} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates if 'Terms and Conditions' setup pane is disabled”</i>
     * 
     * @param termsAndConditionsDisabled
     *            new value of {@code termsAndConditionsDisabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code termsAndConditionsDisabled} field changed
     */
    public DepEnrollmentBaseProfile withTermsAndConditionsDisabled(Boolean termsAndConditionsDisabled) {
        DepEnrollmentBaseProfile _x = _copy();
        _x.changedFields = changedFields.add("termsAndConditionsDisabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depEnrollmentBaseProfile");
        _x.termsAndConditionsDisabled = termsAndConditionsDisabled;
        return _x;
    }

    /**
     * <i>“Indicates if touch id setup pane is disabled”</i>
     * 
     * @return property touchIdDisabled
     */
    @Property(name="touchIdDisabled")
    @JsonIgnore
    public Optional<Boolean> getTouchIdDisabled() {
        return Optional.ofNullable(touchIdDisabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code touchIdDisabled}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates if touch id setup pane is disabled”</i>
     * 
     * @param touchIdDisabled
     *            new value of {@code touchIdDisabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code touchIdDisabled} field changed
     */
    public DepEnrollmentBaseProfile withTouchIdDisabled(Boolean touchIdDisabled) {
        DepEnrollmentBaseProfile _x = _copy();
        _x.changedFields = changedFields.add("touchIdDisabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.depEnrollmentBaseProfile");
        _x.touchIdDisabled = touchIdDisabled;
        return _x;
    }

    public DepEnrollmentBaseProfile withUnmappedField(String name, Object value) {
        DepEnrollmentBaseProfile _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DepEnrollmentBaseProfile patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DepEnrollmentBaseProfile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DepEnrollmentBaseProfile put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DepEnrollmentBaseProfile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DepEnrollmentBaseProfile _copy() {
        DepEnrollmentBaseProfile _x = new DepEnrollmentBaseProfile();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.configurationEndpointUrl = configurationEndpointUrl;
        _x.description = description;
        _x.displayName = displayName;
        _x.enableAuthenticationViaCompanyPortal = enableAuthenticationViaCompanyPortal;
        _x.requireCompanyPortalOnSetupAssistantEnrolledDevices = requireCompanyPortalOnSetupAssistantEnrolledDevices;
        _x.requiresUserAuthentication = requiresUserAuthentication;
        _x.appleIdDisabled = appleIdDisabled;
        _x.applePayDisabled = applePayDisabled;
        _x.configurationWebUrl = configurationWebUrl;
        _x.deviceNameTemplate = deviceNameTemplate;
        _x.diagnosticsDisabled = diagnosticsDisabled;
        _x.displayToneSetupDisabled = displayToneSetupDisabled;
        _x.isDefault = isDefault;
        _x.isMandatory = isMandatory;
        _x.locationDisabled = locationDisabled;
        _x.privacyPaneDisabled = privacyPaneDisabled;
        _x.profileRemovalDisabled = profileRemovalDisabled;
        _x.restoreBlocked = restoreBlocked;
        _x.screenTimeScreenDisabled = screenTimeScreenDisabled;
        _x.siriDisabled = siriDisabled;
        _x.supervisedModeEnabled = supervisedModeEnabled;
        _x.supportDepartment = supportDepartment;
        _x.supportPhoneNumber = supportPhoneNumber;
        _x.termsAndConditionsDisabled = termsAndConditionsDisabled;
        _x.touchIdDisabled = touchIdDisabled;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DepEnrollmentBaseProfile[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("configurationEndpointUrl=");
        b.append(this.configurationEndpointUrl);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("enableAuthenticationViaCompanyPortal=");
        b.append(this.enableAuthenticationViaCompanyPortal);
        b.append(", ");
        b.append("requireCompanyPortalOnSetupAssistantEnrolledDevices=");
        b.append(this.requireCompanyPortalOnSetupAssistantEnrolledDevices);
        b.append(", ");
        b.append("requiresUserAuthentication=");
        b.append(this.requiresUserAuthentication);
        b.append(", ");
        b.append("appleIdDisabled=");
        b.append(this.appleIdDisabled);
        b.append(", ");
        b.append("applePayDisabled=");
        b.append(this.applePayDisabled);
        b.append(", ");
        b.append("configurationWebUrl=");
        b.append(this.configurationWebUrl);
        b.append(", ");
        b.append("deviceNameTemplate=");
        b.append(this.deviceNameTemplate);
        b.append(", ");
        b.append("diagnosticsDisabled=");
        b.append(this.diagnosticsDisabled);
        b.append(", ");
        b.append("displayToneSetupDisabled=");
        b.append(this.displayToneSetupDisabled);
        b.append(", ");
        b.append("isDefault=");
        b.append(this.isDefault);
        b.append(", ");
        b.append("isMandatory=");
        b.append(this.isMandatory);
        b.append(", ");
        b.append("locationDisabled=");
        b.append(this.locationDisabled);
        b.append(", ");
        b.append("privacyPaneDisabled=");
        b.append(this.privacyPaneDisabled);
        b.append(", ");
        b.append("profileRemovalDisabled=");
        b.append(this.profileRemovalDisabled);
        b.append(", ");
        b.append("restoreBlocked=");
        b.append(this.restoreBlocked);
        b.append(", ");
        b.append("screenTimeScreenDisabled=");
        b.append(this.screenTimeScreenDisabled);
        b.append(", ");
        b.append("siriDisabled=");
        b.append(this.siriDisabled);
        b.append(", ");
        b.append("supervisedModeEnabled=");
        b.append(this.supervisedModeEnabled);
        b.append(", ");
        b.append("supportDepartment=");
        b.append(this.supportDepartment);
        b.append(", ");
        b.append("supportPhoneNumber=");
        b.append(this.supportPhoneNumber);
        b.append(", ");
        b.append("termsAndConditionsDisabled=");
        b.append(this.termsAndConditionsDisabled);
        b.append(", ");
        b.append("touchIdDisabled=");
        b.append(this.touchIdDisabled);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
