package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "serviceId", 
    "serviceManagementUrl", 
    "serviceName"})
@JsonInclude(Include.NON_NULL)
public class DelegatedAdminServiceManagementDetail extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.delegatedAdminServiceManagementDetail";
    }

    @JsonProperty("serviceId")
    protected String serviceId;

    @JsonProperty("serviceManagementUrl")
    protected String serviceManagementUrl;

    @JsonProperty("serviceName")
    protected String serviceName;

    protected DelegatedAdminServiceManagementDetail() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDelegatedAdminServiceManagementDetail() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String serviceId;
        private String serviceManagementUrl;
        private String serviceName;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder serviceId(String serviceId) {
            this.serviceId = serviceId;
            this.changedFields = changedFields.add("serviceId");
            return this;
        }

        public Builder serviceManagementUrl(String serviceManagementUrl) {
            this.serviceManagementUrl = serviceManagementUrl;
            this.changedFields = changedFields.add("serviceManagementUrl");
            return this;
        }

        public Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            this.changedFields = changedFields.add("serviceName");
            return this;
        }

        public DelegatedAdminServiceManagementDetail build() {
            DelegatedAdminServiceManagementDetail _x = new DelegatedAdminServiceManagementDetail();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.delegatedAdminServiceManagementDetail";
            _x.id = id;
            _x.serviceId = serviceId;
            _x.serviceManagementUrl = serviceManagementUrl;
            _x.serviceName = serviceName;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="serviceId")
    @JsonIgnore
    public Optional<String> getServiceId() {
        return Optional.ofNullable(serviceId);
    }

    public DelegatedAdminServiceManagementDetail withServiceId(String serviceId) {
        DelegatedAdminServiceManagementDetail _x = _copy();
        _x.changedFields = changedFields.add("serviceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.delegatedAdminServiceManagementDetail");
        _x.serviceId = serviceId;
        return _x;
    }

    @Property(name="serviceManagementUrl")
    @JsonIgnore
    public Optional<String> getServiceManagementUrl() {
        return Optional.ofNullable(serviceManagementUrl);
    }

    public DelegatedAdminServiceManagementDetail withServiceManagementUrl(String serviceManagementUrl) {
        DelegatedAdminServiceManagementDetail _x = _copy();
        _x.changedFields = changedFields.add("serviceManagementUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.delegatedAdminServiceManagementDetail");
        _x.serviceManagementUrl = serviceManagementUrl;
        return _x;
    }

    @Property(name="serviceName")
    @JsonIgnore
    public Optional<String> getServiceName() {
        return Optional.ofNullable(serviceName);
    }

    public DelegatedAdminServiceManagementDetail withServiceName(String serviceName) {
        DelegatedAdminServiceManagementDetail _x = _copy();
        _x.changedFields = changedFields.add("serviceName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.delegatedAdminServiceManagementDetail");
        _x.serviceName = serviceName;
        return _x;
    }

    public DelegatedAdminServiceManagementDetail withUnmappedField(String name, Object value) {
        DelegatedAdminServiceManagementDetail _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DelegatedAdminServiceManagementDetail patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DelegatedAdminServiceManagementDetail _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DelegatedAdminServiceManagementDetail put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DelegatedAdminServiceManagementDetail _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DelegatedAdminServiceManagementDetail _copy() {
        DelegatedAdminServiceManagementDetail _x = new DelegatedAdminServiceManagementDetail();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.serviceId = serviceId;
        _x.serviceManagementUrl = serviceManagementUrl;
        _x.serviceName = serviceName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DelegatedAdminServiceManagementDetail[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("serviceId=");
        b.append(this.serviceId);
        b.append(", ");
        b.append("serviceManagementUrl=");
        b.append(this.serviceManagementUrl);
        b.append(", ");
        b.append("serviceName=");
        b.append(this.serviceName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
