package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.DelegatedAdminRelationshipOperationStatus;
import odata.msgraph.client.beta.enums.DelegatedAdminRelationshipOperationType;

@JsonPropertyOrder({
    "@odata.type", 
    "createdDateTime", 
    "data", 
    "lastModifiedDateTime", 
    "operationType", 
    "status"})
@JsonInclude(Include.NON_NULL)
public class DelegatedAdminRelationshipOperation extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.delegatedAdminRelationshipOperation";
    }

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("data")
    protected String data;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("operationType")
    protected DelegatedAdminRelationshipOperationType operationType;

    @JsonProperty("status")
    protected DelegatedAdminRelationshipOperationStatus status;

    protected DelegatedAdminRelationshipOperation() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDelegatedAdminRelationshipOperation() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private String data;
        private OffsetDateTime lastModifiedDateTime;
        private DelegatedAdminRelationshipOperationType operationType;
        private DelegatedAdminRelationshipOperationStatus status;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder data(String data) {
            this.data = data;
            this.changedFields = changedFields.add("data");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder operationType(DelegatedAdminRelationshipOperationType operationType) {
            this.operationType = operationType;
            this.changedFields = changedFields.add("operationType");
            return this;
        }

        public Builder status(DelegatedAdminRelationshipOperationStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public DelegatedAdminRelationshipOperation build() {
            DelegatedAdminRelationshipOperation _x = new DelegatedAdminRelationshipOperation();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.delegatedAdminRelationshipOperation";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.data = data;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.operationType = operationType;
            _x.status = status;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public DelegatedAdminRelationshipOperation withCreatedDateTime(OffsetDateTime createdDateTime) {
        DelegatedAdminRelationshipOperation _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.delegatedAdminRelationshipOperation");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="data")
    @JsonIgnore
    public Optional<String> getData() {
        return Optional.ofNullable(data);
    }

    public DelegatedAdminRelationshipOperation withData(String data) {
        DelegatedAdminRelationshipOperation _x = _copy();
        _x.changedFields = changedFields.add("data");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.delegatedAdminRelationshipOperation");
        _x.data = data;
        return _x;
    }

    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    public DelegatedAdminRelationshipOperation withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        DelegatedAdminRelationshipOperation _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.delegatedAdminRelationshipOperation");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Property(name="operationType")
    @JsonIgnore
    public Optional<DelegatedAdminRelationshipOperationType> getOperationType() {
        return Optional.ofNullable(operationType);
    }

    public DelegatedAdminRelationshipOperation withOperationType(DelegatedAdminRelationshipOperationType operationType) {
        DelegatedAdminRelationshipOperation _x = _copy();
        _x.changedFields = changedFields.add("operationType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.delegatedAdminRelationshipOperation");
        _x.operationType = operationType;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<DelegatedAdminRelationshipOperationStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    public DelegatedAdminRelationshipOperation withStatus(DelegatedAdminRelationshipOperationStatus status) {
        DelegatedAdminRelationshipOperation _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.delegatedAdminRelationshipOperation");
        _x.status = status;
        return _x;
    }

    public DelegatedAdminRelationshipOperation withUnmappedField(String name, Object value) {
        DelegatedAdminRelationshipOperation _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DelegatedAdminRelationshipOperation patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DelegatedAdminRelationshipOperation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DelegatedAdminRelationshipOperation put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DelegatedAdminRelationshipOperation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DelegatedAdminRelationshipOperation _copy() {
        DelegatedAdminRelationshipOperation _x = new DelegatedAdminRelationshipOperation();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.data = data;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.operationType = operationType;
        _x.status = status;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DelegatedAdminRelationshipOperation[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("data=");
        b.append(this.data);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("operationType=");
        b.append(this.operationType);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
