package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;


/**
 * <i>“Data sharing consent information.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "grantDateTime", 
    "granted", 
    "grantedByUpn", 
    "grantedByUserId", 
    "serviceDisplayName", 
    "termsUrl"})
@JsonInclude(Include.NON_NULL)
public class DataSharingConsent extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.dataSharingConsent";
    }

    @JsonProperty("grantDateTime")
    protected OffsetDateTime grantDateTime;

    @JsonProperty("granted")
    protected Boolean granted;

    @JsonProperty("grantedByUpn")
    protected String grantedByUpn;

    @JsonProperty("grantedByUserId")
    protected String grantedByUserId;

    @JsonProperty("serviceDisplayName")
    protected String serviceDisplayName;

    @JsonProperty("termsUrl")
    protected String termsUrl;

    protected DataSharingConsent() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDataSharingConsent() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime grantDateTime;
        private Boolean granted;
        private String grantedByUpn;
        private String grantedByUserId;
        private String serviceDisplayName;
        private String termsUrl;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The time consent was granted for this account”</i>
         * 
         * @param grantDateTime
         *            value of {@code grantDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder grantDateTime(OffsetDateTime grantDateTime) {
            this.grantDateTime = grantDateTime;
            this.changedFields = changedFields.add("grantDateTime");
            return this;
        }

        /**
         * <i>“The granted state for the data sharing consent”</i>
         * 
         * @param granted
         *            value of {@code granted} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder granted(Boolean granted) {
            this.granted = granted;
            this.changedFields = changedFields.add("granted");
            return this;
        }

        /**
         * <i>“The Upn of the user that granted consent for this account”</i>
         * 
         * @param grantedByUpn
         *            value of {@code grantedByUpn} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder grantedByUpn(String grantedByUpn) {
            this.grantedByUpn = grantedByUpn;
            this.changedFields = changedFields.add("grantedByUpn");
            return this;
        }

        /**
         * <i>“The UserId of the user that granted consent for this account”</i>
         * 
         * @param grantedByUserId
         *            value of {@code grantedByUserId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder grantedByUserId(String grantedByUserId) {
            this.grantedByUserId = grantedByUserId;
            this.changedFields = changedFields.add("grantedByUserId");
            return this;
        }

        /**
         * <i>“The display name of the service work flow”</i>
         * 
         * @param serviceDisplayName
         *            value of {@code serviceDisplayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder serviceDisplayName(String serviceDisplayName) {
            this.serviceDisplayName = serviceDisplayName;
            this.changedFields = changedFields.add("serviceDisplayName");
            return this;
        }

        /**
         * <i>“The TermsUrl for the data sharing consent”</i>
         * 
         * @param termsUrl
         *            value of {@code termsUrl} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder termsUrl(String termsUrl) {
            this.termsUrl = termsUrl;
            this.changedFields = changedFields.add("termsUrl");
            return this;
        }

        public DataSharingConsent build() {
            DataSharingConsent _x = new DataSharingConsent();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.dataSharingConsent";
            _x.id = id;
            _x.grantDateTime = grantDateTime;
            _x.granted = granted;
            _x.grantedByUpn = grantedByUpn;
            _x.grantedByUserId = grantedByUserId;
            _x.serviceDisplayName = serviceDisplayName;
            _x.termsUrl = termsUrl;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The time consent was granted for this account”</i>
     * 
     * @return property grantDateTime
     */
    @Property(name="grantDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getGrantDateTime() {
        return Optional.ofNullable(grantDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code grantDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The time consent was granted for this account”</i>
     * 
     * @param grantDateTime
     *            new value of {@code grantDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code grantDateTime} field changed
     */
    public DataSharingConsent withGrantDateTime(OffsetDateTime grantDateTime) {
        DataSharingConsent _x = _copy();
        _x.changedFields = changedFields.add("grantDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.dataSharingConsent");
        _x.grantDateTime = grantDateTime;
        return _x;
    }

    /**
     * <i>“The granted state for the data sharing consent”</i>
     * 
     * @return property granted
     */
    @Property(name="granted")
    @JsonIgnore
    public Optional<Boolean> getGranted() {
        return Optional.ofNullable(granted);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code granted} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The granted state for the data sharing consent”</i>
     * 
     * @param granted
     *            new value of {@code granted} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code granted} field changed
     */
    public DataSharingConsent withGranted(Boolean granted) {
        DataSharingConsent _x = _copy();
        _x.changedFields = changedFields.add("granted");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.dataSharingConsent");
        _x.granted = granted;
        return _x;
    }

    /**
     * <i>“The Upn of the user that granted consent for this account”</i>
     * 
     * @return property grantedByUpn
     */
    @Property(name="grantedByUpn")
    @JsonIgnore
    public Optional<String> getGrantedByUpn() {
        return Optional.ofNullable(grantedByUpn);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code grantedByUpn}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The Upn of the user that granted consent for this account”</i>
     * 
     * @param grantedByUpn
     *            new value of {@code grantedByUpn} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code grantedByUpn} field changed
     */
    public DataSharingConsent withGrantedByUpn(String grantedByUpn) {
        DataSharingConsent _x = _copy();
        _x.changedFields = changedFields.add("grantedByUpn");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.dataSharingConsent");
        _x.grantedByUpn = grantedByUpn;
        return _x;
    }

    /**
     * <i>“The UserId of the user that granted consent for this account”</i>
     * 
     * @return property grantedByUserId
     */
    @Property(name="grantedByUserId")
    @JsonIgnore
    public Optional<String> getGrantedByUserId() {
        return Optional.ofNullable(grantedByUserId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code grantedByUserId}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The UserId of the user that granted consent for this account”</i>
     * 
     * @param grantedByUserId
     *            new value of {@code grantedByUserId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code grantedByUserId} field changed
     */
    public DataSharingConsent withGrantedByUserId(String grantedByUserId) {
        DataSharingConsent _x = _copy();
        _x.changedFields = changedFields.add("grantedByUserId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.dataSharingConsent");
        _x.grantedByUserId = grantedByUserId;
        return _x;
    }

    /**
     * <i>“The display name of the service work flow”</i>
     * 
     * @return property serviceDisplayName
     */
    @Property(name="serviceDisplayName")
    @JsonIgnore
    public Optional<String> getServiceDisplayName() {
        return Optional.ofNullable(serviceDisplayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * serviceDisplayName} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The display name of the service work flow”</i>
     * 
     * @param serviceDisplayName
     *            new value of {@code serviceDisplayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code serviceDisplayName} field changed
     */
    public DataSharingConsent withServiceDisplayName(String serviceDisplayName) {
        DataSharingConsent _x = _copy();
        _x.changedFields = changedFields.add("serviceDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.dataSharingConsent");
        _x.serviceDisplayName = serviceDisplayName;
        return _x;
    }

    /**
     * <i>“The TermsUrl for the data sharing consent”</i>
     * 
     * @return property termsUrl
     */
    @Property(name="termsUrl")
    @JsonIgnore
    public Optional<String> getTermsUrl() {
        return Optional.ofNullable(termsUrl);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code termsUrl} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The TermsUrl for the data sharing consent”</i>
     * 
     * @param termsUrl
     *            new value of {@code termsUrl} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code termsUrl} field changed
     */
    public DataSharingConsent withTermsUrl(String termsUrl) {
        DataSharingConsent _x = _copy();
        _x.changedFields = changedFields.add("termsUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.dataSharingConsent");
        _x.termsUrl = termsUrl;
        return _x;
    }

    public DataSharingConsent withUnmappedField(String name, Object value) {
        DataSharingConsent _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DataSharingConsent patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DataSharingConsent _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DataSharingConsent put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DataSharingConsent _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DataSharingConsent _copy() {
        DataSharingConsent _x = new DataSharingConsent();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.grantDateTime = grantDateTime;
        _x.granted = granted;
        _x.grantedByUpn = grantedByUpn;
        _x.grantedByUserId = grantedByUserId;
        _x.serviceDisplayName = serviceDisplayName;
        _x.termsUrl = termsUrl;
        return _x;
    }

    @Action(name = "consentToDataSharing")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<DataSharingConsent> consentToDataSharing() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<DataSharingConsent>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.consentToDataSharing"), DataSharingConsent.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DataSharingConsent[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("grantDateTime=");
        b.append(this.grantDateTime);
        b.append(", ");
        b.append("granted=");
        b.append(this.granted);
        b.append(", ");
        b.append("grantedByUpn=");
        b.append(this.grantedByUpn);
        b.append(", ");
        b.append("grantedByUserId=");
        b.append(this.grantedByUserId);
        b.append(", ");
        b.append("serviceDisplayName=");
        b.append(this.serviceDisplayName);
        b.append(", ");
        b.append("termsUrl=");
        b.append(this.termsUrl);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
