package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.ContentClassification;
import odata.msgraph.client.beta.complex.ExactMatchClassificationResult;
import odata.msgraph.client.beta.entity.collection.request.ExactMatchDataStoreCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ExactMatchUploadAgentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.JobResponseBaseCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SensitiveTypeCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SensitivityLabelCollectionRequest;
import odata.msgraph.client.beta.enums.MlClassificationMatchTolerance;
import odata.msgraph.client.beta.enums.SensitiveTypeScope;

@JsonPropertyOrder({
    "@odata.type", 
    "exactMatchDataStores", 
    "classifyFileJobs", 
    "classifyTextJobs", 
    "evaluateDlpPoliciesJobs", 
    "evaluateLabelJobs", 
    "jobs", 
    "sensitiveTypes", 
    "sensitivityLabels", 
    "exactMatchUploadAgents"})
@JsonInclude(Include.NON_NULL)
public class DataClassificationService extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.dataClassificationService";
    }

    @JsonProperty("exactMatchDataStores")
    protected List<ExactMatchDataStore> exactMatchDataStores;

    @JsonProperty("classifyFileJobs")
    protected List<JobResponseBase> classifyFileJobs;

    @JsonProperty("classifyTextJobs")
    protected List<JobResponseBase> classifyTextJobs;

    @JsonProperty("evaluateDlpPoliciesJobs")
    protected List<JobResponseBase> evaluateDlpPoliciesJobs;

    @JsonProperty("evaluateLabelJobs")
    protected List<JobResponseBase> evaluateLabelJobs;

    @JsonProperty("jobs")
    protected List<JobResponseBase> jobs;

    @JsonProperty("sensitiveTypes")
    protected List<SensitiveType> sensitiveTypes;

    @JsonProperty("sensitivityLabels")
    protected List<SensitivityLabel> sensitivityLabels;

    @JsonProperty("exactMatchUploadAgents")
    protected List<ExactMatchUploadAgent> exactMatchUploadAgents;

    protected DataClassificationService() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDataClassificationService() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<ExactMatchDataStore> exactMatchDataStores;
        private List<JobResponseBase> classifyFileJobs;
        private List<JobResponseBase> classifyTextJobs;
        private List<JobResponseBase> evaluateDlpPoliciesJobs;
        private List<JobResponseBase> evaluateLabelJobs;
        private List<JobResponseBase> jobs;
        private List<SensitiveType> sensitiveTypes;
        private List<SensitivityLabel> sensitivityLabels;
        private List<ExactMatchUploadAgent> exactMatchUploadAgents;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder exactMatchDataStores(List<ExactMatchDataStore> exactMatchDataStores) {
            this.exactMatchDataStores = exactMatchDataStores;
            this.changedFields = changedFields.add("exactMatchDataStores");
            return this;
        }

        public Builder exactMatchDataStores(ExactMatchDataStore... exactMatchDataStores) {
            return exactMatchDataStores(Arrays.asList(exactMatchDataStores));
        }

        public Builder classifyFileJobs(List<JobResponseBase> classifyFileJobs) {
            this.classifyFileJobs = classifyFileJobs;
            this.changedFields = changedFields.add("classifyFileJobs");
            return this;
        }

        public Builder classifyFileJobs(JobResponseBase... classifyFileJobs) {
            return classifyFileJobs(Arrays.asList(classifyFileJobs));
        }

        public Builder classifyTextJobs(List<JobResponseBase> classifyTextJobs) {
            this.classifyTextJobs = classifyTextJobs;
            this.changedFields = changedFields.add("classifyTextJobs");
            return this;
        }

        public Builder classifyTextJobs(JobResponseBase... classifyTextJobs) {
            return classifyTextJobs(Arrays.asList(classifyTextJobs));
        }

        public Builder evaluateDlpPoliciesJobs(List<JobResponseBase> evaluateDlpPoliciesJobs) {
            this.evaluateDlpPoliciesJobs = evaluateDlpPoliciesJobs;
            this.changedFields = changedFields.add("evaluateDlpPoliciesJobs");
            return this;
        }

        public Builder evaluateDlpPoliciesJobs(JobResponseBase... evaluateDlpPoliciesJobs) {
            return evaluateDlpPoliciesJobs(Arrays.asList(evaluateDlpPoliciesJobs));
        }

        public Builder evaluateLabelJobs(List<JobResponseBase> evaluateLabelJobs) {
            this.evaluateLabelJobs = evaluateLabelJobs;
            this.changedFields = changedFields.add("evaluateLabelJobs");
            return this;
        }

        public Builder evaluateLabelJobs(JobResponseBase... evaluateLabelJobs) {
            return evaluateLabelJobs(Arrays.asList(evaluateLabelJobs));
        }

        public Builder jobs(List<JobResponseBase> jobs) {
            this.jobs = jobs;
            this.changedFields = changedFields.add("jobs");
            return this;
        }

        public Builder jobs(JobResponseBase... jobs) {
            return jobs(Arrays.asList(jobs));
        }

        public Builder sensitiveTypes(List<SensitiveType> sensitiveTypes) {
            this.sensitiveTypes = sensitiveTypes;
            this.changedFields = changedFields.add("sensitiveTypes");
            return this;
        }

        public Builder sensitiveTypes(SensitiveType... sensitiveTypes) {
            return sensitiveTypes(Arrays.asList(sensitiveTypes));
        }

        public Builder sensitivityLabels(List<SensitivityLabel> sensitivityLabels) {
            this.sensitivityLabels = sensitivityLabels;
            this.changedFields = changedFields.add("sensitivityLabels");
            return this;
        }

        public Builder sensitivityLabels(SensitivityLabel... sensitivityLabels) {
            return sensitivityLabels(Arrays.asList(sensitivityLabels));
        }

        public Builder exactMatchUploadAgents(List<ExactMatchUploadAgent> exactMatchUploadAgents) {
            this.exactMatchUploadAgents = exactMatchUploadAgents;
            this.changedFields = changedFields.add("exactMatchUploadAgents");
            return this;
        }

        public Builder exactMatchUploadAgents(ExactMatchUploadAgent... exactMatchUploadAgents) {
            return exactMatchUploadAgents(Arrays.asList(exactMatchUploadAgents));
        }

        public DataClassificationService build() {
            DataClassificationService _x = new DataClassificationService();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.dataClassificationService";
            _x.id = id;
            _x.exactMatchDataStores = exactMatchDataStores;
            _x.classifyFileJobs = classifyFileJobs;
            _x.classifyTextJobs = classifyTextJobs;
            _x.evaluateDlpPoliciesJobs = evaluateDlpPoliciesJobs;
            _x.evaluateLabelJobs = evaluateLabelJobs;
            _x.jobs = jobs;
            _x.sensitiveTypes = sensitiveTypes;
            _x.sensitivityLabels = sensitivityLabels;
            _x.exactMatchUploadAgents = exactMatchUploadAgents;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    public DataClassificationService withUnmappedField(String name, Object value) {
        DataClassificationService _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="exactMatchDataStores")
    @JsonIgnore
    public ExactMatchDataStoreCollectionRequest getExactMatchDataStores() {
        return new ExactMatchDataStoreCollectionRequest(
                        contextPath.addSegment("exactMatchDataStores"), Optional.ofNullable(exactMatchDataStores));
    }

    @NavigationProperty(name="classifyFileJobs")
    @JsonIgnore
    public JobResponseBaseCollectionRequest getClassifyFileJobs() {
        return new JobResponseBaseCollectionRequest(
                        contextPath.addSegment("classifyFileJobs"), Optional.ofNullable(classifyFileJobs));
    }

    @NavigationProperty(name="classifyTextJobs")
    @JsonIgnore
    public JobResponseBaseCollectionRequest getClassifyTextJobs() {
        return new JobResponseBaseCollectionRequest(
                        contextPath.addSegment("classifyTextJobs"), Optional.ofNullable(classifyTextJobs));
    }

    @NavigationProperty(name="evaluateDlpPoliciesJobs")
    @JsonIgnore
    public JobResponseBaseCollectionRequest getEvaluateDlpPoliciesJobs() {
        return new JobResponseBaseCollectionRequest(
                        contextPath.addSegment("evaluateDlpPoliciesJobs"), Optional.ofNullable(evaluateDlpPoliciesJobs));
    }

    @NavigationProperty(name="evaluateLabelJobs")
    @JsonIgnore
    public JobResponseBaseCollectionRequest getEvaluateLabelJobs() {
        return new JobResponseBaseCollectionRequest(
                        contextPath.addSegment("evaluateLabelJobs"), Optional.ofNullable(evaluateLabelJobs));
    }

    @NavigationProperty(name="jobs")
    @JsonIgnore
    public JobResponseBaseCollectionRequest getJobs() {
        return new JobResponseBaseCollectionRequest(
                        contextPath.addSegment("jobs"), Optional.ofNullable(jobs));
    }

    @NavigationProperty(name="sensitiveTypes")
    @JsonIgnore
    public SensitiveTypeCollectionRequest getSensitiveTypes() {
        return new SensitiveTypeCollectionRequest(
                        contextPath.addSegment("sensitiveTypes"), Optional.ofNullable(sensitiveTypes));
    }

    @NavigationProperty(name="sensitivityLabels")
    @JsonIgnore
    public SensitivityLabelCollectionRequest getSensitivityLabels() {
        return new SensitivityLabelCollectionRequest(
                        contextPath.addSegment("sensitivityLabels"), Optional.ofNullable(sensitivityLabels));
    }

    @NavigationProperty(name="exactMatchUploadAgents")
    @JsonIgnore
    public ExactMatchUploadAgentCollectionRequest getExactMatchUploadAgents() {
        return new ExactMatchUploadAgentCollectionRequest(
                        contextPath.addSegment("exactMatchUploadAgents"), Optional.ofNullable(exactMatchUploadAgents));
    }

    public DataClassificationService withExactMatchDataStores(List<ExactMatchDataStore> exactMatchDataStores) {
        DataClassificationService _x = _copy();
        _x.changedFields = changedFields.add("exactMatchDataStores");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.dataClassificationService");
        _x.exactMatchDataStores = exactMatchDataStores;
        return _x;
    }

    public DataClassificationService withClassifyFileJobs(List<JobResponseBase> classifyFileJobs) {
        DataClassificationService _x = _copy();
        _x.changedFields = changedFields.add("classifyFileJobs");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.dataClassificationService");
        _x.classifyFileJobs = classifyFileJobs;
        return _x;
    }

    public DataClassificationService withClassifyTextJobs(List<JobResponseBase> classifyTextJobs) {
        DataClassificationService _x = _copy();
        _x.changedFields = changedFields.add("classifyTextJobs");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.dataClassificationService");
        _x.classifyTextJobs = classifyTextJobs;
        return _x;
    }

    public DataClassificationService withEvaluateDlpPoliciesJobs(List<JobResponseBase> evaluateDlpPoliciesJobs) {
        DataClassificationService _x = _copy();
        _x.changedFields = changedFields.add("evaluateDlpPoliciesJobs");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.dataClassificationService");
        _x.evaluateDlpPoliciesJobs = evaluateDlpPoliciesJobs;
        return _x;
    }

    public DataClassificationService withEvaluateLabelJobs(List<JobResponseBase> evaluateLabelJobs) {
        DataClassificationService _x = _copy();
        _x.changedFields = changedFields.add("evaluateLabelJobs");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.dataClassificationService");
        _x.evaluateLabelJobs = evaluateLabelJobs;
        return _x;
    }

    public DataClassificationService withJobs(List<JobResponseBase> jobs) {
        DataClassificationService _x = _copy();
        _x.changedFields = changedFields.add("jobs");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.dataClassificationService");
        _x.jobs = jobs;
        return _x;
    }

    public DataClassificationService withSensitiveTypes(List<SensitiveType> sensitiveTypes) {
        DataClassificationService _x = _copy();
        _x.changedFields = changedFields.add("sensitiveTypes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.dataClassificationService");
        _x.sensitiveTypes = sensitiveTypes;
        return _x;
    }

    public DataClassificationService withSensitivityLabels(List<SensitivityLabel> sensitivityLabels) {
        DataClassificationService _x = _copy();
        _x.changedFields = changedFields.add("sensitivityLabels");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.dataClassificationService");
        _x.sensitivityLabels = sensitivityLabels;
        return _x;
    }

    public DataClassificationService withExactMatchUploadAgents(List<ExactMatchUploadAgent> exactMatchUploadAgents) {
        DataClassificationService _x = _copy();
        _x.changedFields = changedFields.add("exactMatchUploadAgents");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.dataClassificationService");
        _x.exactMatchUploadAgents = exactMatchUploadAgents;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DataClassificationService patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DataClassificationService _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DataClassificationService put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DataClassificationService _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DataClassificationService _copy() {
        DataClassificationService _x = new DataClassificationService();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.exactMatchDataStores = exactMatchDataStores;
        _x.classifyFileJobs = classifyFileJobs;
        _x.classifyTextJobs = classifyTextJobs;
        _x.evaluateDlpPoliciesJobs = evaluateDlpPoliciesJobs;
        _x.evaluateLabelJobs = evaluateLabelJobs;
        _x.jobs = jobs;
        _x.sensitiveTypes = sensitiveTypes;
        _x.sensitivityLabels = sensitivityLabels;
        _x.exactMatchUploadAgents = exactMatchUploadAgents;
        return _x;
    }

    @Action(name = "classifyFile")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<ClassificationJobResponse> classifyFile(String file, List<String> sensitiveTypeIds) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("file", "Edm.Stream", file)
            .put("sensitiveTypeIds", "Collection(Edm.String)", Checks.checkIsAscii(sensitiveTypeIds))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<ClassificationJobResponse>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.classifyFile"), ClassificationJobResponse.class, _parameters);
    }

    @Action(name = "classifyText")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<ClassificationJobResponse> classifyText(String text, String fileExtension, List<String> sensitiveTypeIds, SensitiveTypeScope scopesToRun, MlClassificationMatchTolerance matchTolerancesToInclude) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("text", "Edm.String", Checks.checkIsAscii(text))
            .put("fileExtension", "Edm.String", Checks.checkIsAscii(fileExtension))
            .put("sensitiveTypeIds", "Collection(Edm.String)", Checks.checkIsAscii(sensitiveTypeIds))
            .put("scopesToRun", "microsoft.graph.sensitiveTypeScope", scopesToRun)
            .put("matchTolerancesToInclude", "microsoft.graph.mlClassificationMatchTolerance", matchTolerancesToInclude)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<ClassificationJobResponse>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.classifyText"), ClassificationJobResponse.class, _parameters);
    }

    @Action(name = "classifyExactMatches")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<ExactMatchClassificationResult> classifyExactMatches(String text, String timeoutInMs, List<String> sensitiveTypeIds, List<ContentClassification> contentClassifications) {
        Preconditions.checkNotNull(contentClassifications, "contentClassifications cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("text", "Edm.String", Checks.checkIsAscii(text))
            .put("timeoutInMs", "Edm.String", Checks.checkIsAscii(timeoutInMs))
            .put("sensitiveTypeIds", "Collection(Edm.String)", Checks.checkIsAscii(sensitiveTypeIds))
            .put("contentClassifications", "Collection(microsoft.graph.contentClassification)", contentClassifications)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<ExactMatchClassificationResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.classifyExactMatches"), ExactMatchClassificationResult.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DataClassificationService[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("exactMatchDataStores=");
        b.append(this.exactMatchDataStores);
        b.append(", ");
        b.append("classifyFileJobs=");
        b.append(this.classifyFileJobs);
        b.append(", ");
        b.append("classifyTextJobs=");
        b.append(this.classifyTextJobs);
        b.append(", ");
        b.append("evaluateDlpPoliciesJobs=");
        b.append(this.evaluateDlpPoliciesJobs);
        b.append(", ");
        b.append("evaluateLabelJobs=");
        b.append(this.evaluateLabelJobs);
        b.append(", ");
        b.append("jobs=");
        b.append(this.jobs);
        b.append(", ");
        b.append("sensitiveTypes=");
        b.append(this.sensitiveTypes);
        b.append(", ");
        b.append("sensitivityLabels=");
        b.append(this.sensitivityLabels);
        b.append(", ");
        b.append("exactMatchUploadAgents=");
        b.append(this.exactMatchUploadAgents);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
