package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

import odata.msgraph.client.beta.entity.collection.request.CustomerPaymentCollectionRequest;
import odata.msgraph.client.beta.entity.request.AccountRequest;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
 * <p>
 * Deletable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
 * <p>
 * Insertable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
 * <p>
 * Updatable = true
 */@JsonPropertyOrder({
    "@odata.type", 
    "balancingAccountId", 
    "balancingAccountNumber", 
    "code", 
    "displayName", 
    "lastModifiedDateTime", 
    "account", 
    "customerPayments"})
@JsonInclude(Include.NON_NULL)
public class CustomerPaymentJournal extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.customerPaymentJournal";
    }

    @JsonProperty("balancingAccountId")
    protected UUID balancingAccountId;

    @JsonProperty("balancingAccountNumber")
    protected String balancingAccountNumber;

    @JsonProperty("code")
    protected String code;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("account")
    protected Account account;

    @JsonProperty("customerPayments")
    protected List<CustomerPayment> customerPayments;

    protected CustomerPaymentJournal() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderCustomerPaymentJournal() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private UUID balancingAccountId;
        private String balancingAccountNumber;
        private String code;
        private String displayName;
        private OffsetDateTime lastModifiedDateTime;
        private Account account;
        private List<CustomerPayment> customerPayments;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder balancingAccountId(UUID balancingAccountId) {
            this.balancingAccountId = balancingAccountId;
            this.changedFields = changedFields.add("balancingAccountId");
            return this;
        }

        public Builder balancingAccountNumber(String balancingAccountNumber) {
            this.balancingAccountNumber = balancingAccountNumber;
            this.changedFields = changedFields.add("balancingAccountNumber");
            return this;
        }

        public Builder code(String code) {
            this.code = code;
            this.changedFields = changedFields.add("code");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder account(Account account) {
            this.account = account;
            this.changedFields = changedFields.add("account");
            return this;
        }

        public Builder customerPayments(List<CustomerPayment> customerPayments) {
            this.customerPayments = customerPayments;
            this.changedFields = changedFields.add("customerPayments");
            return this;
        }

        public Builder customerPayments(CustomerPayment... customerPayments) {
            return customerPayments(Arrays.asList(customerPayments));
        }

        public CustomerPaymentJournal build() {
            CustomerPaymentJournal _x = new CustomerPaymentJournal();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.customerPaymentJournal";
            _x.id = id;
            _x.balancingAccountId = balancingAccountId;
            _x.balancingAccountNumber = balancingAccountNumber;
            _x.code = code;
            _x.displayName = displayName;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.account = account;
            _x.customerPayments = customerPayments;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="balancingAccountId")
    @JsonIgnore
    public Optional<UUID> getBalancingAccountId() {
        return Optional.ofNullable(balancingAccountId);
    }

    public CustomerPaymentJournal withBalancingAccountId(UUID balancingAccountId) {
        CustomerPaymentJournal _x = _copy();
        _x.changedFields = changedFields.add("balancingAccountId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.customerPaymentJournal");
        _x.balancingAccountId = balancingAccountId;
        return _x;
    }

    @Property(name="balancingAccountNumber")
    @JsonIgnore
    public Optional<String> getBalancingAccountNumber() {
        return Optional.ofNullable(balancingAccountNumber);
    }

    public CustomerPaymentJournal withBalancingAccountNumber(String balancingAccountNumber) {
        CustomerPaymentJournal _x = _copy();
        _x.changedFields = changedFields.add("balancingAccountNumber");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.customerPaymentJournal");
        _x.balancingAccountNumber = balancingAccountNumber;
        return _x;
    }

    @Property(name="code")
    @JsonIgnore
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    public CustomerPaymentJournal withCode(String code) {
        CustomerPaymentJournal _x = _copy();
        _x.changedFields = changedFields.add("code");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.customerPaymentJournal");
        _x.code = code;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public CustomerPaymentJournal withDisplayName(String displayName) {
        CustomerPaymentJournal _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.customerPaymentJournal");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    public CustomerPaymentJournal withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        CustomerPaymentJournal _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.customerPaymentJournal");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    public CustomerPaymentJournal withUnmappedField(String name, Object value) {
        CustomerPaymentJournal _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="account")
    @JsonIgnore
    public AccountRequest getAccount() {
        return new AccountRequest(contextPath.addSegment("account"), Optional.ofNullable(account));
    }

    @NavigationProperty(name="customerPayments")
    @JsonIgnore
    public CustomerPaymentCollectionRequest getCustomerPayments() {
        return new CustomerPaymentCollectionRequest(
                        contextPath.addSegment("customerPayments"), Optional.ofNullable(customerPayments));
    }

    public CustomerPaymentJournal withAccount(Account account) {
        CustomerPaymentJournal _x = _copy();
        _x.changedFields = changedFields.add("account");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.customerPaymentJournal");
        _x.account = account;
        return _x;
    }

    public CustomerPaymentJournal withCustomerPayments(List<CustomerPayment> customerPayments) {
        CustomerPaymentJournal _x = _copy();
        _x.changedFields = changedFields.add("customerPayments");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.customerPaymentJournal");
        _x.customerPayments = customerPayments;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CustomerPaymentJournal patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        CustomerPaymentJournal _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CustomerPaymentJournal put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        CustomerPaymentJournal _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private CustomerPaymentJournal _copy() {
        CustomerPaymentJournal _x = new CustomerPaymentJournal();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.balancingAccountId = balancingAccountId;
        _x.balancingAccountNumber = balancingAccountNumber;
        _x.code = code;
        _x.displayName = displayName;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.account = account;
        _x.customerPayments = customerPayments;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CustomerPaymentJournal[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("balancingAccountId=");
        b.append(this.balancingAccountId);
        b.append(", ");
        b.append("balancingAccountNumber=");
        b.append(this.balancingAccountNumber);
        b.append(", ");
        b.append("code=");
        b.append(this.code);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("account=");
        b.append(this.account);
        b.append(", ");
        b.append("customerPayments=");
        b.append(this.customerPayments);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
