package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.complex.CustomExtensionAuthenticationConfiguration;
import odata.msgraph.client.beta.complex.CustomExtensionClientConfiguration;
import odata.msgraph.client.beta.complex.CustomExtensionEndpointConfiguration;

@JsonPropertyOrder({
    "@odata.type", 
    "authenticationConfiguration", 
    "clientConfiguration", 
    "description", 
    "displayName", 
    "endpointConfiguration"})
@JsonInclude(Include.NON_NULL)
public class CustomCalloutExtension extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.customCalloutExtension";
    }

    @JsonProperty("authenticationConfiguration")
    protected CustomExtensionAuthenticationConfiguration authenticationConfiguration;

    @JsonProperty("clientConfiguration")
    protected CustomExtensionClientConfiguration clientConfiguration;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("endpointConfiguration")
    protected CustomExtensionEndpointConfiguration endpointConfiguration;

    protected CustomCalloutExtension() {
        super();
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="authenticationConfiguration")
    @JsonIgnore
    public Optional<CustomExtensionAuthenticationConfiguration> getAuthenticationConfiguration() {
        return Optional.ofNullable(authenticationConfiguration);
    }

    public CustomCalloutExtension withAuthenticationConfiguration(CustomExtensionAuthenticationConfiguration authenticationConfiguration) {
        CustomCalloutExtension _x = _copy();
        _x.changedFields = changedFields.add("authenticationConfiguration");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.customCalloutExtension");
        _x.authenticationConfiguration = authenticationConfiguration;
        return _x;
    }

    @Property(name="clientConfiguration")
    @JsonIgnore
    public Optional<CustomExtensionClientConfiguration> getClientConfiguration() {
        return Optional.ofNullable(clientConfiguration);
    }

    public CustomCalloutExtension withClientConfiguration(CustomExtensionClientConfiguration clientConfiguration) {
        CustomCalloutExtension _x = _copy();
        _x.changedFields = changedFields.add("clientConfiguration");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.customCalloutExtension");
        _x.clientConfiguration = clientConfiguration;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public CustomCalloutExtension withDescription(String description) {
        CustomCalloutExtension _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.customCalloutExtension");
        _x.description = description;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public CustomCalloutExtension withDisplayName(String displayName) {
        CustomCalloutExtension _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.customCalloutExtension");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="endpointConfiguration")
    @JsonIgnore
    public Optional<CustomExtensionEndpointConfiguration> getEndpointConfiguration() {
        return Optional.ofNullable(endpointConfiguration);
    }

    public CustomCalloutExtension withEndpointConfiguration(CustomExtensionEndpointConfiguration endpointConfiguration) {
        CustomCalloutExtension _x = _copy();
        _x.changedFields = changedFields.add("endpointConfiguration");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.customCalloutExtension");
        _x.endpointConfiguration = endpointConfiguration;
        return _x;
    }

    public CustomCalloutExtension withUnmappedField(String name, Object value) {
        CustomCalloutExtension _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CustomCalloutExtension patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        CustomCalloutExtension _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CustomCalloutExtension put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        CustomCalloutExtension _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private CustomCalloutExtension _copy() {
        CustomCalloutExtension _x = new CustomCalloutExtension();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.authenticationConfiguration = authenticationConfiguration;
        _x.clientConfiguration = clientConfiguration;
        _x.description = description;
        _x.displayName = displayName;
        _x.endpointConfiguration = endpointConfiguration;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CustomCalloutExtension[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("authenticationConfiguration=");
        b.append(this.authenticationConfiguration);
        b.append(", ");
        b.append("clientConfiguration=");
        b.append(this.clientConfiguration);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("endpointConfiguration=");
        b.append(this.endpointConfiguration);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
